/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.tools.cmdline;

import com.eibus.tools.cmdline.InvalidCommandLineArgumentException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;

public class CommandLine {
    private final OptionStyle myOptionStyle = new OptionStyle();
    private final ValidOptions myValidOptions = new ValidOptions();
    private final ParseResult myParseResult = new ParseResult();
    public String[] params = null;
    private String[] myCommandLine;

    public CommandLine() {
        this.setCommandLine(null);
    }

    public CommandLine(String[] stringArray) {
        this();
        this.setCommandLine(stringArray);
    }

    public CommandLine(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) throws ParseException {
        this(stringArray, CommandLine.arrayOfStringToVector(stringArray2), CommandLine.arrayOfStringToVector(stringArray3), CommandLine.arrayOfStringToVector(stringArray4));
    }

    public CommandLine(String[] stringArray, String string, String string2) throws ParseException {
        this(stringArray, string, string2, "");
    }

    public CommandLine(String[] stringArray, String string, String string2, String[] stringArray2, String[] stringArray3) throws ParseException {
        this(stringArray, CommandLine.combineOptions(string, stringArray2), CommandLine.combineOptions(string2, stringArray3), new Vector());
    }

    public CommandLine(String[] stringArray, String string, String string2, String string3) throws ParseException {
        this(stringArray, CommandLine.stringToVectorOfString(string), CommandLine.stringToVectorOfString(string2), CommandLine.stringToVectorOfString(string3));
    }

    public CommandLine(String[] stringArray, Vector vector, Vector vector2, Vector vector3) throws ParseException {
        this.setCommandLine(stringArray);
        this.validOptions().allowJust(vector, vector2, vector3);
        this.parse();
    }

    private static Vector arrayOfStringToVector(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        return vector;
    }

    private static Vector stringToVectorOfString(String string) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < string.length()) {
            vector.addElement(string.substring(n, n + 1));
            ++n;
        }
        return vector;
    }

    private static String[] vectorOfStringToArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            String string;
            stringArray[n] = string = (String)enumeration2.nextElement();
            ++n;
        }
        return stringArray;
    }

    private static Vector combineOptions(String string, String[] stringArray) {
        Vector vector = CommandLine.stringToVectorOfString(string);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            vector.addElement(string2);
            ++n;
        }
        return vector;
    }

    public OptionStyle optionStyle() {
        return this.myOptionStyle;
    }

    public ValidOptions validOptions() {
        return this.myValidOptions;
    }

    public ParseResult parseResult() {
        return this.myParseResult;
    }

    public final void setCommandLine(String[] stringArray) {
        if (stringArray != null) {
            stringArray = (String[])stringArray.clone();
        }
        this.myCommandLine = stringArray;
    }

    public String[] getCommandLine() {
        return (String[])this.myCommandLine.clone();
    }

    public String getOption(Character c) {
        return this.getOption(c.toString());
    }

    public String getOption(String string) {
        return this.parseResult().getOptionArgument(string);
    }

    public boolean hasOption(Character c) {
        return this.hasOption(c.toString());
    }

    public boolean hasOption(String string) {
        return this.parseResult().hasOption(string);
    }

    public final void parse() throws ParseException {
        this.parseResult().reset();
        String string = null;
        String[] stringArray = this.myCommandLine;
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string != null && !this.validOptions().mayHaveNoArg(string) && this.optionStyle().isOptionLikeArgumentAllowed()) {
                this.putArgument(string2);
                string = null;
            } else if (string2.equals("--")) {
                ++n;
                while (n < stringArray.length) {
                    this.putParameter(stringArray[n]);
                    ++n;
                }
            } else if (string2.length() > 1 && (string2.charAt(0) == '-' || this.optionStyle().isSlashAllowed() && string2.charAt(0) == '/')) {
                boolean bl;
                String string3;
                boolean bl2;
                if (string != null && !this.validOptions().mayHaveNoArg(string)) {
                    this.parseError("option must have an argument", string);
                }
                Vector vector = this.parseResult().getParameters();
                int n2 = vector.size();
                if (!this.optionStyle().isMixedAllowed() && n2 > 0) {
                    String string4 = (String)vector.elementAt(n2 - 1);
                    this.parseError("parameter inbetween options not allowed", string4);
                }
                if (string2.startsWith("--")) {
                    bl2 = true;
                    string3 = string2.substring(2);
                } else {
                    bl2 = false;
                    string3 = string2.substring(1);
                }
                String string5 = null;
                int n3 = string3.indexOf(61);
                if (n3 != -1) {
                    string5 = string3.substring(n3 + 1);
                    if (string5.equals("")) {
                        this.parseError("nothing after '='", string2);
                    }
                    if ((string3 = string3.substring(0, n3)).equals("")) {
                        this.parseError("nothing before '='", string2);
                    }
                }
                boolean bl3 = !bl2 || this.optionStyle().isDoubleDashShortAllowed();
                boolean bl4 = bl2 || this.optionStyle().isSingleDashLongAllowed();
                int n4 = -9999;
                boolean bl5 = string5 == null ? (n4 = this.validOptions().split(string3, bl3, bl4)) != 0 : this.validOptions().isOption(string3, bl3, bl4);
                boolean bl6 = bl = !bl2 && this.optionStyle().isClumpedAllowed() && this.validOptions().isOptionClump(string3);
                if (bl5 && bl) {
                    this.parseError("ambiguous option", string2);
                } else if (!bl5 && !bl) {
                    this.parseError("unknown option", string2);
                }
                if (bl5) {
                    if (string5 == null && n4 < string3.length()) {
                        string5 = string3.substring(n4);
                        string3 = string3.substring(0, n4);
                    }
                    string = string3;
                    this.parseResult().putOption(string);
                } else {
                    char[] cArray = string3.toCharArray();
                    int n5 = 0;
                    while (n5 < cArray.length) {
                        string = String.valueOf(cArray[n5]);
                        this.parseResult().putOption(string);
                        ++n5;
                    }
                }
                if (string5 != null) {
                    if (bl && !this.optionStyle().isClumpWithArgumentAllowed()) {
                        this.parseError("a clump of options may not have an argument", string2);
                    }
                    if (!this.validOptions().mayHaveAnArg(string)) {
                        this.parseError("option takes no argument", string);
                    }
                    this.putArgument(string5);
                    string = null;
                }
            } else if (string != null && this.validOptions().mayHaveAnArg(string)) {
                this.putArgument(string2);
                string = null;
            } else {
                this.putParameter(string2);
                string = null;
            }
            ++n;
        }
        if (string != null && !this.validOptions().mayHaveNoArg(string)) {
            this.parseError("last option must have an argument", string);
        }
        this.params = CommandLine.vectorOfStringToArray(this.parseResult().getParameters());
    }

    private void putArgument(String string) throws ParseException {
        Enumeration enumeration2 = this.expandResponseFile(string);
        this.parseResult().putArgument(enumeration2);
    }

    private void putParameter(String string) throws ParseException {
        this.parseResult().putParameter(this.expandResponseFile(string));
    }

    private Enumeration expandResponseFile(String string) throws ParseException {
        ResponseFileExpander responseFileExpander = null;
        try {
            responseFileExpander = new ResponseFileExpander(string, true, true, true, "@");
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.parseError("file not found: " + fileNotFoundException.getMessage(), string);
        }
        catch (IOException iOException) {
            this.parseError("file could not be read: " + iOException.getMessage(), string);
        }
        return responseFileExpander;
    }

    private void parseError(String string, String string2) throws ParseException {
        this.parseResult().reset();
        this.params = null;
        throw new ParseException(string2 + ": " + string);
    }

    public static class ResponseFileExpander
    implements Enumeration {
        private Vector myExpansionResult = new Vector();
        private Enumeration myEnumeration = null;
        private boolean myExpandRecursively = false;
        private boolean myTrimLines = false;
        private boolean mySkipEmptyLines = false;
        private String myResponseFileSymbol = "@";

        public ResponseFileExpander(String string, boolean bl, boolean bl2, boolean bl3, String string2) throws FileNotFoundException, IOException {
            this.myExpandRecursively = bl;
            this.myTrimLines = bl2;
            this.mySkipEmptyLines = bl3;
            this.myResponseFileSymbol = string2;
            this.addParameter(string);
            this.myEnumeration = this.myExpansionResult.elements();
        }

        public ResponseFileExpander(String string) throws FileNotFoundException, IOException {
            this(string, true, true, true, "@");
        }

        public boolean hasMoreElements() {
            return this.myEnumeration.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            return this.myEnumeration.nextElement();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addParameter(String string) throws FileNotFoundException, IOException {
            if (string.startsWith(this.myResponseFileSymbol)) {
                String string2;
                String string3 = string.substring(this.myResponseFileSymbol.length());
                File file2 = new File(string3);
                if (!file2.isFile()) {
                    throw new FileNotFoundException("response file \"" + string3 + "\" not found");
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (this.myTrimLines) {
                        string2 = string2.trim();
                    }
                    if (this.mySkipEmptyLines && string2.trim().equals("")) continue;
                    if (this.myExpandRecursively) {
                        Properties properties;
                        Object var10_9;
                        String string4 = new File(file2.getAbsolutePath()).getParent();
                        String string5 = System.getProperty("user.dir");
                        try {
                            Properties properties2 = System.getProperties();
                            ((Hashtable)properties2).put("user.dir", string4);
                            System.setProperties(properties2);
                            this.addParameter(string2);
                            var10_9 = null;
                        }
                        catch (Throwable throwable) {
                            var10_9 = null;
                            properties = System.getProperties();
                            ((Hashtable)properties).put("user.dir", string5);
                            System.setProperties(properties);
                            throw throwable;
                        }
                        properties = System.getProperties();
                        ((Hashtable)properties).put("user.dir", string5);
                        System.setProperties(properties);
                        {
                            continue;
                        }
                    }
                    this.myExpansionResult.addElement(string2);
                }
            } else {
                this.myExpansionResult.addElement(string);
            }
        }
    }

    public static class ParseException
    extends InvalidCommandLineArgumentException {
        public ParseException() {
        }

        public ParseException(String string) {
            super(string);
        }
    }

    public static class ParseResult {
        public static final String NO_ARGUMENT = new String("");
        private Hashtable myOptions;
        private Vector myParameters;
        private String myLastOption;

        ParseResult() {
            this.reset();
        }

        public String getOptionArgument(char c) {
            return this.getOptionArgument(String.valueOf(c));
        }

        public String getOptionArgument(Character c) {
            return this.getOptionArgument(c.toString());
        }

        public String getOptionArgument(String string) {
            String string2 = null;
            Vector vector = (Vector)this.myOptions.get(string);
            if (vector != null) {
                int n = vector.size();
                string2 = (String)vector.elementAt(n - 1);
            }
            return string2;
        }

        public Vector getOptionArguments(String string) {
            return (Vector)((Vector)this.myOptions.get(string)).clone();
        }

        public Hashtable getAllOptions() {
            return (Hashtable)this.myOptions.clone();
        }

        public Vector getParameters() {
            return (Vector)this.myParameters.clone();
        }

        public boolean hasOption(char c) {
            return this.hasOption(String.valueOf(c));
        }

        public boolean hasOption(Character c) {
            return this.hasOption(c.toString());
        }

        public boolean hasOption(String string) {
            return this.myOptions.containsKey(string);
        }

        void putOption(String string) {
            Vector vector;
            if (this.myOptions.containsKey(string)) {
                vector = (Vector)this.myOptions.get(string);
            } else {
                vector = new Vector();
                this.myOptions.put(string, vector);
            }
            vector.addElement(NO_ARGUMENT);
            this.myLastOption = string;
        }

        void putArgument(String string) {
            Vector vector = (Vector)this.myOptions.get(this.myLastOption);
            int n = vector.size() - 1;
            vector.setElementAt(string, n);
        }

        void putArgument(Enumeration enumeration2) {
            String string = this.myLastOption;
            if (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                this.putArgument(string2);
                while (enumeration2.hasMoreElements()) {
                    this.putOption(string);
                    string2 = (String)enumeration2.nextElement();
                    this.putArgument(string2);
                }
                this.myLastOption = null;
            } else {
                Vector vector = (Vector)this.myOptions.get(this.myLastOption);
                int n = vector.size() - 1;
                vector.removeElementAt(n);
                if (vector.size() == 0) {
                    this.myOptions.remove(this.myLastOption);
                }
            }
        }

        void putParameter(String string) throws ParseException {
            this.myParameters.addElement(string);
        }

        void putParameter(Enumeration enumeration2) {
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                this.myParameters.addElement(string);
            }
        }

        void reset() {
            this.myOptions = new Hashtable();
            this.myParameters = new Vector();
            this.myLastOption = null;
        }
    }

    public static class ValidOptions {
        private Hashtable mayHaveAnArgMap;
        private Hashtable mayHaveNoArgMap;
        private boolean unknownMayHaveAnArg = false;
        private boolean unknownMayHaveNoArg = false;

        ValidOptions() {
            this.reset();
        }

        public void allowOption(String string, boolean bl, boolean bl2) {
            this.mayHaveAnArgMap.put(string, new Boolean(bl));
            this.mayHaveNoArgMap.put(string, new Boolean(bl2));
        }

        public void allowArg(String string) {
            this.allowOption(string, true, false);
        }

        public void allowFlag(String string) {
            this.allowOption(string, false, true);
        }

        public void allowFlarg(String string) {
            this.allowOption(string, true, true);
        }

        public final void allow(Vector vector, Vector vector2, Vector vector3) {
            Vector[] vectorArray = new Vector[]{vector, vector2, vector3};
            boolean[] blArray = new boolean[]{false, true, true};
            boolean[] blArray2 = new boolean[]{true, true, false};
            int n = 0;
            while (n < 3) {
                boolean bl = blArray[n];
                boolean bl2 = blArray2[n];
                Enumeration enumeration2 = vectorArray[n].elements();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    this.allowOption(string, bl, bl2);
                }
                ++n;
            }
        }

        public final void allowJust(Vector vector, Vector vector2, Vector vector3) {
            this.disallowAll();
            this.allow(vector, vector2, vector3);
        }

        public void allowUnknown() {
            this.allowUnknown(true, true);
        }

        public void allowUnknown(boolean bl, boolean bl2) {
            this.unknownMayHaveAnArg = bl;
            this.unknownMayHaveNoArg = bl2;
        }

        public void disallow(String string) {
            this.allowOption(string, false, false);
        }

        public void disallowAll() {
            this.mayHaveAnArgMap = new Hashtable();
            this.mayHaveNoArgMap = new Hashtable();
            this.disallowUnknown();
        }

        public void disallowUnknown() {
            this.allowUnknown(false, false);
        }

        public boolean mayHaveAnArg(String string) {
            return !this.mayHaveAnArgMap.containsKey(string) || (Boolean)this.mayHaveAnArgMap.get(string) != false;
        }

        public boolean mayHaveNoArg(String string) {
            return !this.mayHaveNoArgMap.containsKey(string) || (Boolean)this.mayHaveNoArgMap.get(string) != false;
        }

        public void reset() {
            this.disallowAll();
        }

        boolean isOption(String string) {
            boolean bl = this.mayHaveAnArgMap.containsKey(string);
            if (bl) {
                boolean bl2 = (Boolean)this.mayHaveAnArgMap.get(string);
                boolean bl3 = (Boolean)this.mayHaveNoArgMap.get(string);
                return bl2 || bl3;
            }
            return this.isUnknownAllowed();
        }

        boolean isOption(String string, boolean bl, boolean bl2) {
            return this.isOption(string) && (string.length() <= 1 ? bl : bl2);
        }

        boolean isOptionClump(String string) {
            boolean bl = true;
            if (string.length() <= 1) {
                bl = false;
            } else {
                char[] cArray = string.toCharArray();
                int n = 0;
                while (bl && n < cArray.length) {
                    String string2 = String.valueOf(cArray[n]);
                    bl = this.isOption(string2) && (n == cArray.length - 1 || this.mayHaveNoArg(string2));
                    ++n;
                }
            }
            return bl;
        }

        int split(String string, boolean bl, boolean bl2) {
            Enumeration enumeration2 = this.mayHaveAnArgMap.keys();
            int n = 0;
            Enumeration enumeration3 = enumeration2;
            while (enumeration3.hasMoreElements()) {
                String string2 = (String)enumeration3.nextElement();
                if (!(string2.length() <= 1 ? bl : bl2) || !string.startsWith(string2) || string2.length() != string.length() && !this.mayHaveAnArg(string2)) continue;
                if (n == 0) {
                    n = string2.length();
                    continue;
                }
                n = 0;
                break;
            }
            return n;
        }

        private boolean isUnknownAllowed() {
            return this.unknownMayHaveAnArg || this.unknownMayHaveNoArg;
        }
    }

    public class OptionStyle {
        private boolean myIsClumpedAllowed;
        private boolean myIsClumpWithArgumentAllowed;
        private boolean myIsMixedAllowed;
        private boolean myIsSingleDashLongAllowed;
        private boolean myIsDoubleDashShortAllowed;
        private boolean myIsOptionLikeArgumentAllowed;
        private boolean myIsSlashAllowed;

        OptionStyle() {
            this.reset();
        }

        public void reset() {
            this.myIsClumpedAllowed = true;
            this.myIsClumpWithArgumentAllowed = true;
            this.myIsMixedAllowed = true;
            this.myIsSingleDashLongAllowed = true;
            this.myIsDoubleDashShortAllowed = false;
            this.myIsOptionLikeArgumentAllowed = false;
            this.myIsSlashAllowed = false;
        }

        public void allowClumped(boolean bl) {
            this.myIsClumpedAllowed = bl;
        }

        public boolean isClumpedAllowed() {
            return this.myIsClumpedAllowed;
        }

        public void allowClumpWithArgument(boolean bl) {
            this.myIsClumpWithArgumentAllowed = bl;
        }

        public boolean isClumpWithArgumentAllowed() {
            return this.myIsClumpWithArgumentAllowed;
        }

        public void allowMixed(boolean bl) {
            this.myIsMixedAllowed = bl;
        }

        public boolean isMixedAllowed() {
            return this.myIsMixedAllowed;
        }

        public void allowOptionLikeArgument(boolean bl) {
            this.myIsOptionLikeArgumentAllowed = bl;
        }

        public boolean isOptionLikeArgumentAllowed() {
            return this.myIsOptionLikeArgumentAllowed;
        }

        public void allowSlash(boolean bl) {
            this.myIsSlashAllowed = bl;
        }

        public boolean isSlashAllowed() {
            return this.myIsSlashAllowed;
        }

        public void allowSingleDashLong(boolean bl) {
            this.myIsSingleDashLongAllowed = bl;
        }

        public boolean isSingleDashLongAllowed() {
            return this.myIsSingleDashLongAllowed;
        }

        public void allowDoubleDashShort(boolean bl) {
            this.myIsDoubleDashShortAllowed = bl;
        }

        public boolean isDoubleDashShortAllowed() {
            return this.myIsDoubleDashShortAllowed;
        }
    }
}

