/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DiffDetect {
    private static final String COPYRIGHT = "Copyright (c) 2000 Baan Development B.V.";

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        switch (n) {
            case 1: {
                DiffDetect.printSyntax(new PrintWriter(System.err, true));
                if (stringArray[0].equals("-h")) break;
                System.exit(-1);
                break;
            }
            case 2: {
                try {
                    File file2 = new File(stringArray[0]);
                    File file3 = new File(stringArray[1]);
                    Vector vector = new Vector();
                    if (DiffDetect.areDifferent(file2, file3, vector)) {
                        System.out.println("Difference detected:");
                        Enumeration enumeration2 = vector.elements();
                        while (enumeration2.hasMoreElements()) {
                            String string = (String)enumeration2.nextElement();
                            System.out.println(string);
                        }
                        break;
                    }
                    System.out.println("No difference detected");
                }
                catch (IOException iOException) {
                    System.err.println("An error occurred:");
                    iOException.printStackTrace();
                    System.exit(-1);
                }
                break;
            }
            default: {
                DiffDetect.printSyntax(new PrintWriter(System.err, true));
                System.exit(-1);
            }
        }
    }

    private static void printSyntax(PrintWriter printWriter) {
        printWriter.println("Syntax:\n");
        printWriter.println("com.eibus.test.regression.tools.DiffDetect -h");
        printWriter.println("com.eibus.test.regression.tools.DiffDetect <path1> <path2>\n");
        printWriter.println("Where:\n");
        printWriter.println("-h        prints this syntax help");
        printWriter.println("<path1>   is the name of a directory or file");
        printWriter.println("<path2>   is the name of a directory or file");
    }

    public static boolean areDifferent(File file2, File file3, Vector vector) throws IOException {
        if (!file2.exists()) {
            vector.addElement(file2.getAbsolutePath() + " does not exist");
            return true;
        }
        if (!file3.exists()) {
            vector.addElement(file3.getAbsolutePath() + " does not exist");
            return true;
        }
        if (file2.isDirectory()) {
            if (file3.isDirectory()) {
                return DiffDetect.areDifferentDirs(file2, file3, vector);
            }
            vector.addElement(file2.getCanonicalPath() + " is a directory whereas " + file3.getCanonicalPath() + " is not");
            return true;
        }
        if (file3.isDirectory()) {
            vector.addElement(file3.getCanonicalPath() + " is a directory whereas " + file2.getCanonicalPath() + " is not");
            return true;
        }
        return DiffDetect.areDifferentFiles(file2, file3, vector);
    }

    private static boolean areDifferentDirs(File file2, File file3, Vector vector) throws IOException {
        int n;
        boolean bl = false;
        String[] stringArray = file2.list();
        String[] stringArray2 = file3.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            n = 0;
            while (n < stringArray2.length) {
                String string2 = stringArray2[n];
                if (string2 != null && string.equals(string2)) {
                    File file4 = new File(file2, string);
                    File file5 = new File(file3, string2);
                    if (DiffDetect.areDifferent(file4, file5, vector)) {
                        bl = true;
                    }
                    stringArray[n2] = null;
                    stringArray2[n] = null;
                    break;
                }
                ++n;
            }
            ++n2;
        }
        boolean bl2 = false;
        n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                vector.addElement(new File(file3, stringArray[n]).getAbsolutePath() + " does not exist");
                bl2 = true;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < stringArray2.length) {
            if (stringArray2[n3] != null) {
                vector.addElement(new File(file2, stringArray2[n3]).getAbsolutePath() + " does not exist");
                bl2 = true;
            }
            ++n3;
        }
        return bl2 || bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean areDifferentFiles(File file2, File file3, Vector vector) throws IOException {
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        BufferedInputStream bufferedInputStream = null;
        BufferedInputStream bufferedInputStream2 = null;
        try {
            fileInputStream = new FileInputStream(file2);
            fileInputStream2 = new FileInputStream(file3);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            bufferedInputStream2 = new BufferedInputStream(fileInputStream2);
            int n = 0;
            int n2 = 0;
            long l = 0L;
            while ((n = bufferedInputStream.read()) == (n2 = bufferedInputStream2.read())) {
                ++l;
                if (n >= 0 && n2 >= 0) continue;
            }
            if (n >= 0 && n2 < 0) {
                vector.addElement(file2.getCanonicalPath() + " is longer than " + file3.getCanonicalPath());
            } else if (n2 >= 0 && n < 0) {
                vector.addElement(file3.getCanonicalPath() + " is longer than " + file2.getCanonicalPath());
            } else if (n != n2) {
                vector.addElement(file2.getCanonicalPath() + " and " + file3.getCanonicalPath() + " differ at byte offset " + l + "; skipping rest of file");
            } else {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            IOException iOException = null;
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException2) {
                    iOException = iOException2;
                }
            }
            if (fileInputStream2 != null) {
                fileInputStream2.close();
            }
            if (iOException != null) {
                throw iOException;
            }
        }
    }
}

