/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression.metadata;

import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IManagerMetadata;
import com.baan.b3.boi1.metadata.IMemberMetadata;
import com.baan.b3.boi1.metadata.IMethodMetadata;
import com.baan.b3.boi1.metadata.IObjectMetadata;
import com.baan.b3.boi1.metadata.IParameterMetadata;
import com.baan.b3.boi1.metadata.MetadataUtil;
import com.eibus.test.regression.metadata.FileWriterFactory;
import com.eibus.test.regression.metadata.IWriterFactory;
import com.eibus.test.regression.metadata.NullWriterFactory;
import com.eibus.test.regression.metadata.StandardWriterFactory;
import java.io.File;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class Write {
    private static final String COPYRIGHT = "Copyright (c) 2000 Baan Development B.V.";
    private static final char NEWLINE = '\n';

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        try {
            boolean bl = false;
            IWriterFactory iWriterFactory = null;
            String[] stringArray2 = null;
            if (stringArray.length == 0) {
                throw new IllegalArgumentException("No parameters");
            }
            int n = 0;
            while (n < stringArray.length) {
                block18: {
                    int n2;
                    block17: {
                        if (stringArray[n].charAt(0) != '-') break block17;
                        try {
                            n2 = stringArray[n].charAt(1);
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            throw new IllegalArgumentException("Expected flag after '-' in " + Write.ordinal(n + 1) + " token");
                        }
                        switch (n2) {
                            case 104: {
                                Write.printSyntax(new PrintWriter(System.out, true));
                                return;
                            }
                            case 82: {
                                if (bl) {
                                    throw new IllegalArgumentException("'-R' can only be specified once");
                                }
                                bl = true;
                                break block18;
                            }
                            case 100: {
                                if (iWriterFactory != null) {
                                    throw new IllegalArgumentException("'-d' can only be specified once");
                                }
                                if (++n >= stringArray.length) throw new IllegalArgumentException("Expected directory name after '-d' flag in " + Write.ordinal(n) + " token");
                                iWriterFactory = new FileWriterFactory(stringArray[n]);
                                break block18;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown flag: '" + stringArray[n] + "' in " + Write.ordinal(n + 1) + " token");
                            }
                        }
                    }
                    if (iWriterFactory == null) {
                        iWriterFactory = StandardWriterFactory.getInstance();
                    }
                    stringArray2 = new String[stringArray.length - n];
                    n2 = 0;
                    while (n < stringArray.length) {
                        if (stringArray[n].charAt(0) == '-') {
                            throw new IllegalArgumentException("Flag in " + Write.ordinal(n + 1) + " token; expected className");
                        }
                        stringArray2[n2] = stringArray[n];
                        ++n;
                        ++n2;
                    }
                }
                ++n;
            }
            if (stringArray2 == null || stringArray2.length == 0) {
                throw new IllegalArgumentException("No <className>s specified");
            }
            Write.writeMetadata(stringArray2, iWriterFactory, bl);
            iWriterFactory.closeWriters();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Bad input:\n" + illegalArgumentException.getMessage());
            Write.printSyntax(new PrintWriter(System.err, true));
            System.exit(-1);
        }
    }

    private static void printSyntax(PrintWriter printWriter) {
        printWriter.println("Syntax:\n");
        printWriter.println("com.eibus.test.regression.metadata.Write -h");
        printWriter.println("com.eibus.test.regression.metadata.Write [-R] [-d <outputDir>] <className>+\n");
        printWriter.println("Where:\n");
        printWriter.println("-h            prints this syntax help");
        printWriter.println("-R            specifies recursive processing of the classes");
        printWriter.println("<outputDir>   is the name of a directory into which to place individual output files");
        printWriter.println("<className>   is the name of a BusinessObject or BusinessObjectManager class");
    }

    private static String ordinal(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        int n2 = stringBuffer.length();
        if (n2 > 1 && stringBuffer.charAt(n2 - 2) == '1') {
            stringBuffer.append("th");
            return stringBuffer.toString();
        }
        int n3 = n2 - 1;
        char c = stringBuffer.charAt(n3);
        if (c == '1') {
            stringBuffer.append("st");
        } else if (c == '2') {
            stringBuffer.append("nd");
        } else if (c == '3') {
            stringBuffer.append("rd");
        } else {
            stringBuffer.append("th");
        }
        return stringBuffer.toString();
    }

    public static void writeMetadata(String[] stringArray, boolean bl) throws IllegalArgumentException {
        Write.writeMetadata(stringArray, NullWriterFactory.getInstance(), bl);
    }

    public static void writeMetadata(String[] stringArray, File file2, boolean bl) throws IllegalArgumentException {
        FileWriterFactory fileWriterFactory = new FileWriterFactory(file2);
        Write.writeMetadata(stringArray, fileWriterFactory, bl);
        fileWriterFactory.closeWriters();
    }

    private static void writeMetadata(String[] stringArray, IWriterFactory iWriterFactory, boolean bl) throws IllegalArgumentException {
        int n = 0;
        while (n < stringArray.length) {
            IManagerMetadata iManagerMetadata = null;
            IBusinessObjectMetadata iBusinessObjectMetadata = null;
            try {
                iManagerMetadata = MetadataUtil.getManagerMetadata(stringArray[n]);
            }
            catch (RuntimeException runtimeException) {
                try {
                    iBusinessObjectMetadata = MetadataUtil.getBusinessObjectMetadata(stringArray[n]);
                }
                catch (RuntimeException runtimeException2) {
                    throw new IllegalArgumentException("The class \"" + stringArray[n] + "\" does not exist or does not have a retrieveMetadata " + "method that returns an IBusinessObjectMetadata or " + "IManagerMetadata object");
                }
            }
            if (iManagerMetadata != null) {
                Write.writeManagerMetadata(iManagerMetadata, iWriterFactory, bl);
            } else {
                Write.writeBusinessObjectMetadata(iBusinessObjectMetadata, iWriterFactory, bl, new Vector());
            }
            ++n;
        }
    }

    private static void writeManagerMetadata(IManagerMetadata iManagerMetadata, IWriterFactory iWriterFactory, boolean bl) {
        PrintWriter printWriter = iWriterFactory.getPrintWriter(iManagerMetadata.getTypeName());
        printWriter.print(iManagerMetadata.toString());
        printWriter.print('\n');
        if (bl) {
            Vector vector = new Vector();
            IBusinessObjectMetadata[] iBusinessObjectMetadataArray = iManagerMetadata.getManagedObjects();
            int n = 0;
            while (n < iBusinessObjectMetadataArray.length) {
                Write.addDependency(iBusinessObjectMetadataArray[n], vector);
                ++n;
            }
            IMethodMetadata[] iMethodMetadataArray = iManagerMetadata.getMethods();
            Write.collectDependencies(iMethodMetadataArray, vector);
            Vector vector2 = new Vector();
            Write.writeBusinessObjectMetadata(vector, iWriterFactory, vector2);
        }
    }

    private static void writeBusinessObjectMetadata(IBusinessObjectMetadata iBusinessObjectMetadata, IWriterFactory iWriterFactory, boolean bl, Vector vector) {
        if (vector.contains(iBusinessObjectMetadata)) {
            return;
        }
        PrintWriter printWriter = iWriterFactory.getPrintWriter(iBusinessObjectMetadata.getTypeName());
        printWriter.print(iBusinessObjectMetadata.toString());
        printWriter.print('\n');
        vector.addElement(iBusinessObjectMetadata);
        if (bl) {
            Object object;
            Vector vector2 = new Vector();
            IMemberMetadata[] iMemberMetadataArray = iBusinessObjectMetadata.getMembers();
            int n = 0;
            while (n < iMemberMetadataArray.length) {
                object = iMemberMetadataArray[n].getType();
                Write.addDependency((IObjectMetadata)object, vector2);
                ++n;
            }
            object = iBusinessObjectMetadata.getMethods();
            Write.collectDependencies(object, vector2);
            Write.writeBusinessObjectMetadata(vector2, iWriterFactory, vector);
        }
    }

    private static void writeBusinessObjectMetadata(Vector vector, IWriterFactory iWriterFactory, Vector vector2) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            IBusinessObjectMetadata iBusinessObjectMetadata = (IBusinessObjectMetadata)vector.elementAt(n2);
            Write.writeBusinessObjectMetadata(iBusinessObjectMetadata, iWriterFactory, true, vector2);
            ++n2;
        }
    }

    private static void addDependency(IObjectMetadata iObjectMetadata, Vector vector) {
        if (iObjectMetadata instanceof IBusinessObjectMetadata && !vector.contains(iObjectMetadata)) {
            vector.addElement(iObjectMetadata);
        }
    }

    private static void collectDependencies(IMethodMetadata[] iMethodMetadataArray, Vector vector) {
        int n = 0;
        while (n < iMethodMetadataArray.length) {
            IParameterMetadata iParameterMetadata = iMethodMetadataArray[n].getReturnType();
            if (iParameterMetadata != null) {
                Write.addDependency(iParameterMetadata.getType(), vector);
            }
            IParameterMetadata[] iParameterMetadataArray = iMethodMetadataArray[n].getParameters();
            int n2 = 0;
            while (n2 < iParameterMetadataArray.length) {
                Write.addDependency(iParameterMetadataArray[n2].getType(), vector);
                ++n2;
            }
            ++n;
        }
    }
}

