/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression.metadata;

import com.eibus.test.regression.metadata.IWriterFactory;
import com.eibus.test.regression.metadata.NullDeviceWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

class FileWriterFactory
implements IWriterFactory {
    private static final String COPYRIGHT = "Copyright (c) 2000 Baan Development B.V.";
    private final File m_directory;
    private final Vector m_openFiles = new Vector();

    FileWriterFactory(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("p_directory must be non-null");
        }
        this.m_directory = new File(string);
        if (!this.m_directory.exists()) {
            throw new IllegalArgumentException("Directory \"" + string + "\" does not exist");
        }
    }

    FileWriterFactory(File file2) throws IllegalArgumentException {
        if (file2 == null) {
            throw new IllegalArgumentException("p_directory must be non-null");
        }
        this.m_directory = file2;
        if (!this.m_directory.exists()) {
            throw new IllegalArgumentException("Directory \"" + file2 + "\" does not exist");
        }
    }

    public PrintWriter getPrintWriter(String string) {
        String string2 = string + ".mdo";
        try {
            OutputStreamWriter outputStreamWriter;
            File file2 = new File(this.m_directory, string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("Using default encoding for output to file \"" + file2.getCanonicalPath() + "\"");
                outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            }
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            this.m_openFiles.addElement(printWriter);
            return printWriter;
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return new PrintWriter(NullDeviceWriter.getInstance());
        }
    }

    public void closeWriters() {
        int n = this.m_openFiles.size();
        int n2 = 0;
        while (n2 < n) {
            PrintWriter printWriter = (PrintWriter)this.m_openFiles.elementAt(n2);
            printWriter.close();
            ++n2;
        }
        this.m_openFiles.removeAllElements();
    }
}

