/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.baan.b3.boi1.BoiException;
import com.eibus.test.regression.B3test;
import com.eibus.test.regression.Testutils;
import com.eibus.test.regression.typesafe.Streets;
import com.eibus.test.regression.typesafe.StreetsManager;

public class Testcode_Tiger_Wrapper {
    private static StreetsManager manager = null;

    public static void test() {
        try {
            manager = new StreetsManager();
            manager.initialize(B3test.server_comp);
            Testcode_Tiger_Wrapper.testHasMethod();
            Testcode_Tiger_Wrapper.testDefaultValues();
            manager.close();
        }
        catch (BoiException boiException) {
            B3test.failure();
            Testutils.log_PrintLn(boiException.toString());
        }
    }

    public static void testHasMethod() throws BoiException {
        Testutils.log_PrintLn("------------- Tiger Wrapper: has...() method test ------------");
        Streets streets = new Streets();
        streets.setStreetCode(65);
        streets.setStreetName("Fivelingo");
        manager.add(streets);
        manager.synchronize();
        Streets streets2 = manager.show(65);
        if (streets2 == null) {
            Testutils.log_Print("ERROR: Can't show.");
            B3test.failure();
        }
        boolean bl = false;
        if (!streets2.hasStreetCode()) {
            Testutils.log_PrintLn("hasStreetCode() : " + streets2.hasStreetCode());
            bl = true;
        }
        if (streets2.hasZipcode()) {
            Testutils.log_PrintLn("hasZipcode() : " + streets2.hasZipcode());
            bl = true;
        }
        if (bl) {
            B3test.failure();
            Testutils.log_PrintLn("ERROR: has..() method returned unexpected value.");
        } else {
            Testutils.log_PrintLn("OK");
        }
        manager.remove(streets2);
        manager.synchronize();
    }

    public static void testDefaultValues() throws BoiException {
        Testutils.log_PrintLn("------------- Tiger Wrapper: default value test ------------");
        Streets streets = new Streets();
        streets.setStreetCode(65);
        streets.setStreetName("Fivelingo");
        manager.add(streets);
        manager.synchronize();
        Streets streets2 = manager.show(65);
        if (streets2 == null) {
            Testutils.log_Print("ERROR: Can't show.");
            B3test.failure();
        }
        boolean bl = false;
        if (streets2.getStreetNumber() != 0) {
            Testutils.log_PrintLn("getStreetNumber() : " + streets2.getStreetNumber());
            bl = true;
        }
        if (streets2.getZipcode() != "") {
            Testutils.log_PrintLn("getZipcode() : " + streets2.getZipcode());
            bl = true;
        }
        if (bl) {
            B3test.failure();
            Testutils.log_PrintLn("ERROR: has..() method returned unexpected value.");
        } else {
            Testutils.log_PrintLn("OK");
        }
        manager.remove(streets2);
        manager.synchronize();
    }
}

