/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.boi1.IBackend;
import com.baan.b3.boi1.IExceptionDescriptor;
import com.baan.b3.boi1.ISynchronization;
import com.baan.b3.boi1.ISynchronizationExceptionDescriptor;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3.boi1.Iterator;
import com.baan.b3.boi1.dt.SynchronizationActionType;
import com.baan.b3.boi1.metadata.IMetadataFactory;
import com.baan.b3impl.boi1.IteratorImpl;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.Query;
import com.eibus.exception.BusException;
import com.eibus.test.regression.B3test;
import com.eibus.test.regression.Testutils;
import com.eibus.test.regression.typesafe.DataTypes;
import com.eibus.test.regression.typesafe.DataTypesManager;
import com.eibus.test.regression.typesafe.ReadOnlyStreet;
import com.eibus.test.regression.typesafe.ReadOnlyStreetManager;
import com.eibus.test.regression.typesafe.Residents;
import com.eibus.test.regression.typesafe.Streets;
import com.eibus.test.regression.typesafe.StreetsManager;
import com.eibus.test.regression.typesafe.b3TestManager;
import com.eibus.test.regression.typesafe.basicTypeManager;
import com.eibus.test.regression.typesafe.tablesizereturn;
import java.util.Date;

public class Testcode_Query_StreetsResidents
extends Testutils {
    public static final int MAX_RECORDS = 100;
    public static final double P_DOUBLE1 = 1.123;
    public static final String P_STRING1 = "1234567890123";
    public static final int P_LONG2 = 12345;
    public static final double P_DOUBLE2 = 2.345;
    public static final String P_STRING2 = "3210987654321";
    public static final double DOUBLE1 = 1.1234;
    public static final String STRING1 = "String one";
    public static final int LONG2 = 123456789;
    public static final double DOUBLE2 = 2.3456;
    public static final String STRING2 = "String two";
    public static final double DOUBLE1_UPDATE = 2.2468;
    public static final String STRING1_UPDATE = "String one updated";
    public static final int LONG2_UPDATE = 222222222;
    public static final double DOUBLE2_UPDATE = 4.6888;
    public static final String STRING2_UPDATE = "String two updated";

    public static void failure() {
        B3test.failure();
    }

    public static void test_StreetsAndResidents() {
        Testutils.log_PrintLn("-----------Calls for Streets and Residents-----------");
        Testutils.log_PrintLn("");
        try {
            StreetsManager streetsManager = new StreetsManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            streetsManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testcode_Query_StreetsResidents.queryWithoutParameters(streetsManager);
            Testcode_Query_StreetsResidents.queryWithoutResult(streetsManager);
            Testcode_Query_StreetsResidents.initializeTest(b3TestManager2);
            Testcode_Query_StreetsResidents.addStreets(streetsManager);
            Testcode_Query_StreetsResidents.addResidents(b3TestManager2, streetsManager);
            Testcode_Query_StreetsResidents.updateResidents(streetsManager);
            Testcode_Query_StreetsResidents.removeResidentsStreets(b3TestManager2, streetsManager);
            Testcode_Query_StreetsResidents.addStreetsAndResidentsLinked(b3TestManager2, streetsManager);
            ReadOnlyStreetManager readOnlyStreetManager = new ReadOnlyStreetManager();
            readOnlyStreetManager.initialize(B3test.server_comp);
            Testcode_Query_StreetsResidents.readOnlyStreets(readOnlyStreetManager, streetsManager);
            readOnlyStreetManager.close();
            streetsManager.close();
            b3TestManager2.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_StreetsAndResidents");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_StreetsResidents.failure();
        }
    }

    public static void test_MultipleManagers() {
        try {
            b3TestManager b3TestManager2 = new b3TestManager();
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("Creating and initializing managers...  ");
            basicTypeManager basicTypeManager2 = new basicTypeManager();
            basicTypeManager2.initialize(B3test.server_comp);
            if (basicTypeManager2 == null) {
                Testutils.log_PrintLn("Failed to initialize server/simpleTypeManager");
                Testcode_Query_StreetsResidents.failure();
            } else {
                Testutils.log_PrintLn("simpleTypeManager = Ok");
            }
            StreetsManager streetsManager = new StreetsManager();
            streetsManager.initialize(B3test.server_comp);
            if (streetsManager == null) {
                Testutils.log_PrintLn("Failed to initialize server/streetManager");
                Testcode_Query_StreetsResidents.failure();
            } else {
                Testutils.log_PrintLn("streetManager = Ok");
            }
            DataTypesManager dataTypesManager = new DataTypesManager();
            dataTypesManager.initialize(B3test.server_comp);
            if (dataTypesManager == null) {
                Testutils.log_PrintLn("Failed to initialize server/dataTypeManager");
                Testcode_Query_StreetsResidents.failure();
            } else {
                Testutils.log_PrintLn("dataTypeManager = Ok");
            }
            Testcode_Query_StreetsResidents.multipleManagers(b3TestManager2, basicTypeManager2, dataTypesManager, streetsManager);
            basicTypeManager2.close();
            streetsManager.close();
            dataTypesManager.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_MultipleManagers");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_StreetsResidents.failure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeTest(b3TestManager b3TestManager2) {
        Testutils.log_PrintLn("Initializing the test...");
        Testutils.log_PrintLn("");
        Testutils.log_Print("(clearing all the tables)");
        try {
            try {
                b3TestManager2.initializetest();
                Testutils.log_PrintLn("Ok");
                Testutils.log_PrintLn("");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("Failed to initialize SQL test");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var3_2 = null;
                b3TestManager2.releaseAll();
            }
            Object var3_1 = null;
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    public static void test_strAndResGetAggregated() {
        Testutils.log_PrintLn("-----------Get Street And Residents (aggregated)-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Creating managers...");
        try {
            StreetsManager streetsManager = new StreetsManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            streetsManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Ok");
            Testutils.log_PrintLn("Initialize test (clearing tables with dll call)");
            Testcode_Query_StreetsResidents.initializeTest(b3TestManager2);
            Testutils.log_PrintLn("Add records to streets & residents.");
            Testcode_Query_StreetsResidents.addStreetsAndResidentsLinked(b3TestManager2, streetsManager);
            Testutils.log_Print("");
            Testutils.log_Print("Retrieve records streets & residents aggregated....");
            Testutils.log_PrintLn("enable metadata on manager");
            BusinessDocumentManager businessDocumentManager = Hack.getBdm(streetsManager);
            businessDocumentManager.enableMetaData(true);
            Iterator iterator = streetsManager.list_aggregated(1, 3);
            com.eibus.bdf.Iterator iterator2 = IteratorHack.getIterator(iterator);
            Testutils.log_Print(iterator2.getMetaData().toString());
            Testutils.log_PrintLn("   Ok");
            long l = 0L;
            if (iterator != null) {
                while (iterator.hasMoreElements()) {
                    Streets streets = (Streets)iterator.nextElement();
                    if (streets == null) continue;
                    l += (long)streets.sizeResidents();
                    Testutils.log_PrintLn("No of Residents in street " + streets.getStreetName() + " = " + streets.sizeResidents());
                }
                if (l == 4L) {
                    Testutils.log_PrintLn("Getting aggregated data is OK !");
                } else {
                    Testutils.log_PrintLn("Getting aggregated data, ERROR !");
                    Testcode_Query_StreetsResidents.failure();
                }
            }
            streetsManager.close();
            b3TestManager2.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_strAndResGetAggregated");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_StreetsResidents.failure();
        }
        catch (BusException busException) {
            Testutils.log_PrintLn("BusException in test_strAndResGetAggregated");
            Testutils.log_PrintLn(busException.toString());
            Testcode_Query_StreetsResidents.failure();
        }
    }

    public static void test_strAndResGetAssociated() {
        Testutils.log_PrintLn("-----------Get Street And Residents (associated)-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Creating managers...");
        try {
            StreetsManager streetsManager = new StreetsManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            streetsManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Ok");
            Testutils.log_PrintLn("Initialize test (clearing tables with dll call)");
            Testcode_Query_StreetsResidents.initializeTest(b3TestManager2);
            Testutils.log_PrintLn("Add records to streets & residents.");
            Testcode_Query_StreetsResidents.addStreetsAndResidentsLinked(b3TestManager2, streetsManager);
            Testutils.log_Print("");
            Testutils.log_Print("Retrieve records streets & residents associated....");
            Testutils.log_PrintLn("enable metadata on manager");
            BusinessDocumentManager businessDocumentManager = Hack.getBdm(streetsManager);
            businessDocumentManager.enableMetaData(true);
            Iterator iterator = streetsManager.list(1, 3);
            com.eibus.bdf.Iterator iterator2 = IteratorHack.getIterator(iterator);
            Testutils.log_Print(iterator2.getMetaData().toString());
            Testutils.log_PrintLn("   Ok");
            long l = 0L;
            if (iterator != null) {
                while (iterator.hasMoreElements()) {
                    Streets streets = (Streets)iterator.nextElement();
                    if (streets == null) continue;
                    l += (long)streets.sizeResidents();
                    Testutils.log_PrintLn("No of Residents in street " + streets.getStreetName() + " = " + streets.sizeResidents());
                }
                if (l == 4L) {
                    Testutils.log_PrintLn("Getting associated data is OK !");
                } else {
                    Testutils.log_PrintLn("Getting associated data, ERROR !");
                    Testcode_Query_StreetsResidents.failure();
                }
            }
            streetsManager.close();
            b3TestManager2.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_strAndResGetAssociated");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_StreetsResidents.failure();
        }
        catch (BusException busException) {
            Testutils.log_PrintLn("BusException in test_strAndResGetAssociated");
            Testutils.log_PrintLn(busException.toString());
            Testcode_Query_StreetsResidents.failure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMoreRecordsPerformance(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        double d = 0.0;
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("---------------Insert all records in one call-----------");
        Testutils.log_PrintLn("");
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                int n = tablesizereturn2.getTablesize();
                if (n > 0) {
                    b3TestManager2.tableclear("ttmboa120");
                }
                Testutils.log_PrintLn("Filling the data (client)");
                int n2 = 1;
                while (n2 <= 100) {
                    DataTypes dataTypes = new DataTypes();
                    dataTypes.setLong1(n2);
                    dataTypes.setDouble1(1.123);
                    dataTypes.setString1(P_STRING1);
                    dataTypes.setLong2(12345);
                    dataTypes.setDouble2(2.345);
                    dataTypes.setString2(P_STRING2);
                    dataTypesManager.add(dataTypes);
                    Testutils.log_PrintCounter(n2);
                    d = n2;
                    ++n2;
                }
                double d2 = System.currentTimeMillis();
                Testutils.log_PrintLn("Sending it to the server");
                dataTypesManager.synchronize();
                d2 = (double)System.currentTimeMillis() - d2;
                double d3 = d / (d2 / 1000.0);
                Testutils.log_PrintLn(d + " records in one call took " + d2 + " msec to synchronize");
                Testutils.log_PrintLn("This results in " + d3 + " records/sec");
                Testutils.log_PrintLn("no of data Bytes send = 5000 Bytes");
                Testutils.log_PrintLn("This results in " + 5000.0 / d2 + " KBytes/sec");
                Testutils.log_PrintLn("inserted withouterrors");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addMoreRecordsPerformance");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var13_11 = null;
                dataTypesManager.releaseAll();
            }
            Object var13_10 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkTable(b3TestManager b3TestManager2) {
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                int n = tablesizereturn2.getTablesize();
                if (n == 100) {
                    Testutils.log_PrintLn("All records have been inserted");
                } else {
                    Testutils.log_PrintLn("Not all records have been inserted");
                    Testcode_Query_StreetsResidents.failure();
                }
                Testutils.log_PrintLn(n + " records are present in the table");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BusException in checkTable");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var5_4 = null;
                b3TestManager2.releaseAll();
            }
            Object var5_3 = null;
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill_tmboa120(DataTypesManager dataTypesManager) {
        Testutils.log_PrintLn("filling table with 100 records");
        try {
            try {
                dataTypesManager.setTimeOut(0L);
                int n = 1;
                while (n <= 100) {
                    DataTypes dataTypes = new DataTypes();
                    dataTypes.setLong1(n);
                    dataTypes.setDouble1(1.1234);
                    dataTypes.setString1(STRING1);
                    dataTypes.setLong2(123456789);
                    dataTypes.setDouble2(2.3456);
                    dataTypes.setString2(STRING2);
                    dataTypesManager.add(dataTypes);
                    Testutils.log_PrintCounter(n);
                    ++n;
                }
                Testutils.log_PrintLn("");
                Testutils.log_Print("synchronize changes with backend");
                dataTypesManager.synchronize();
                Testutils.log_PrintLn(" Ok");
            }
            catch (BoiException boiException) {
                Testutils.log_Print("BoiException in fill_tmboa120");
                Testutils.log_Print(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var4_5 = null;
                dataTypesManager.releaseAll();
            }
            Object var4_4 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStreets(StreetsManager streetsManager) {
        Testutils.log_PrintLn("-----------Insert new Streets-----------");
        Testutils.log_PrintLn("");
        try {
            try {
                streetsManager.add(Testcode_Query_StreetsResidents.fillStreetFields(streetsManager, 1, "Parklane", 110, "SW19-5NY"));
                streetsManager.add(Testcode_Query_StreetsResidents.fillStreetFields(streetsManager, 2, "Kalverstraat", 220, "1012 MD"));
                streetsManager.add(Testcode_Query_StreetsResidents.fillStreetFields(streetsManager, 3, "Im Hag", 10, "70327"));
                streetsManager.synchronize();
                Testutils.log_PrintLn("Inserted withouterrors");
                streetsManager.releaseAll();
                Testcode_Query_StreetsResidents.checkStreets(streetsManager);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addStreets");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var3_2 = null;
                streetsManager.releaseAll();
            }
            Object var3_1 = null;
            streetsManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            streetsManager.releaseAll();
            throw throwable;
        }
    }

    public static Streets fillStreetFields(StreetsManager streetsManager, int n, String string, int n2, String string2) {
        Streets streets = new Streets();
        streets.setStreetCode(n);
        streets.setStreetName(string);
        streets.setStreetNumber(n2);
        streets.setZipcode(string2);
        return streets;
    }

    public static void checkStreets(StreetsManager streetsManager) {
        Testutils.log_PrintLn("-----------Check insert of Streets-----------");
        Testutils.log_PrintLn("");
        Testcode_Query_StreetsResidents.checkStreet(streetsManager, 1, "Parklane", 110, "SW19-5NY");
        Testcode_Query_StreetsResidents.checkStreet(streetsManager, 2, "Kalverstraat", 220, "1012 MD");
        Testcode_Query_StreetsResidents.checkStreet(streetsManager, 3, "Im Hag", 10, "70327");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkStreet(StreetsManager streetsManager, int n, String string, int n2, String string2) {
        try {
            block7: {
                try {
                    Streets streets = streetsManager.show(n);
                    if (streets != null) {
                        if (streets.getStreetCode() == n && streets.getStreetName().equals(string) && streets.getStreetNumber() == n2 && streets.getZipcode().equals(string2)) {
                            Testutils.log_PrintLn("insert of street " + n + " succeeded");
                        } else {
                            Testutils.log_PrintLn("insert of street " + n + " failed");
                            Testcode_Query_StreetsResidents.failure();
                        }
                        break block7;
                    }
                    Testutils.log_PrintLn("Street " + n + " not found");
                    Testcode_Query_StreetsResidents.failure();
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in checkStreet");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_StreetsResidents.failure();
                    Object var8_7 = null;
                    streetsManager.releaseAll();
                }
            }
            Object var8_6 = null;
            streetsManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            streetsManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResidents(b3TestManager b3TestManager2, StreetsManager streetsManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("----------Add Residents to the Streets-----------");
        Testutils.log_PrintLn("");
        try {
            try {
                Residents residents;
                Testutils.log_PrintLn("Retrieve the street 1");
                Streets streets = streetsManager.show(1);
                if (streets != null) {
                    residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 1, "John", "Dickins", "1972-06-07", 1, "Police Inspector", 3098.5, new Date());
                    streetsManager.add(residents);
                    Testutils.log_PrintLn("Add resident to street 1 (local)");
                    streets.addResidents(residents);
                    residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 1, "Mike", "Rawlins", "1964-05-28", 2, "Accountant", 5156.98, new Date());
                    streetsManager.add(residents);
                    Testutils.log_PrintLn("Add resident to street 1 (local)");
                    streets.addResidents(residents);
                    Testutils.log_PrintLn("Synchronize street 1 & new residents");
                    streetsManager.synchronize();
                    Testutils.log_PrintLn("Added residents to street 1, withouterrors");
                    streetsManager.release(residents);
                }
                Testutils.log_PrintLn("Retrieve the street 2");
                streets = streetsManager.show(2);
                if (streets != null) {
                    residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 2, "Johannes", "Lammers", "1972-06-07", 1, "Police Inspector", 3098.5, new Date());
                    streetsManager.add(residents);
                    Testutils.log_PrintLn("Add resident to street 2 (local)");
                    streets.addResidents(residents);
                    residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 2, "Marc", "Roelofs", "1964-05-28", 2, "Accountant", 5156.98, new Date());
                    streetsManager.add(residents);
                    Testutils.log_PrintLn("Add resident to street 2 (local)");
                    streets.addResidents(residents);
                    Testutils.log_PrintLn("Synchronize street 2 & new residents");
                    streetsManager.synchronize();
                    Testutils.log_PrintLn("Added residents to street 2, withouterrors");
                    streetsManager.release(residents);
                }
                Testutils.log_PrintLn("Retrieve the street 3");
                streets = streetsManager.show(3);
                if (streets != null) {
                    residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 3, "Johan", "Meier", "1972-06-07", 1, "Police Inspector", 3098.5, new Date());
                    streetsManager.add(residents);
                    Testutils.log_PrintLn("Add resident to street 3 (local)");
                    streets.addResidents(residents);
                    residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 3, "Markus", "Bauer", "1964-05-28", 2, "Accountant", 5156.98, new Date());
                    streetsManager.add(residents);
                    Testutils.log_PrintLn("Add resident to street 3 (local)");
                    streets.addResidents(residents);
                    Testutils.log_PrintLn("Synchronize street 3 & new residents");
                    streetsManager.synchronize();
                    Testutils.log_PrintLn("Added residents to street 3, withouterrors");
                    streetsManager.release(residents);
                }
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa100");
                int n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa100 (streets) = " + n);
                tablesizereturn2 = b3TestManager2.tablesize("ttmboa110");
                n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa110 (residents) = " + n);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addResidents");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var7_8 = null;
                streetsManager.releaseAll();
            }
            Object var7_7 = null;
            streetsManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            streetsManager.releaseAll();
            throw throwable;
        }
    }

    public static Residents fillResidentFields(StreetsManager streetsManager, int n, String string, String string2, String string3, int n2, String string4, double d, Date date) {
        Residents residents = new Residents();
        residents.setStreetCode(n);
        residents.setChristianName(string);
        residents.setLastName(string2);
        residents.setBirthDate(string3);
        residents.setStatus(n2);
        residents.setFunction(string4);
        residents.setSalary(d);
        residents.setDate(date);
        return residents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listStreets(StreetsManager streetsManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("-----------Check added Residents to the Streets-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Retrieve all the streets");
        try {
            block6: {
                try {
                    Iterator iterator = streetsManager.list(1, 3);
                    Testutils.log_PrintLn("   Ok");
                    if (iterator != null) {
                        while (iterator.hasMoreElements()) {
                            Testcode_Query_StreetsResidents.checkResidents(streetsManager, (Streets)iterator.nextElement(), false);
                        }
                        break block6;
                    }
                    Testutils.log_PrintLn("No streets were returned");
                    Testcode_Query_StreetsResidents.failure();
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in listStreets");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_StreetsResidents.failure();
                    Object var4_3 = null;
                    streetsManager.releaseAll();
                }
            }
            Object var4_2 = null;
            streetsManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            streetsManager.releaseAll();
            throw throwable;
        }
    }

    public static void checkResidents(StreetsManager streetsManager, Streets streets, boolean bl) {
        int n = streets.sizeResidents();
        if (bl) {
            if (n <= 0) {
                Testutils.log_PrintLn("No residents found while checking update");
            } else {
                int n2 = 0;
                while (n2 < n) {
                    Residents residents = streets.getResidentsAt(n2);
                    Testcode_Query_StreetsResidents.checkResident(residents, "Changed for update");
                    ++n2;
                }
            }
        } else if (n <= 0) {
            Testutils.log_PrintLn("No residents have been inserted");
        } else {
            Testutils.log_PrintLn("Insert residents succeeded.");
        }
    }

    public static void checkResident(Residents residents, String string) {
        if (string.equals(residents.getFunction())) {
            Testutils.log_PrintLn("Update Resident " + residents.getChristianName() + " succeeded.");
        } else {
            Testutils.log_PrintLn("Update Resident " + residents.getChristianName() + " failed.");
            Testcode_Query_StreetsResidents.failure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateResidents(StreetsManager streetsManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("-----------Update Residents-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Retrieve all the streets");
        try {
            block6: {
                try {
                    Iterator iterator = streetsManager.list(1, 3);
                    Testutils.log_PrintLn("   Ok");
                    if (iterator != null) {
                        while (iterator.hasMoreElements()) {
                            Streets streets = (Streets)iterator.nextElement();
                            if (streets == null) continue;
                            Testcode_Query_StreetsResidents.getResidents(streetsManager, streets);
                            Testcode_Query_StreetsResidents.checkResidents(streetsManager, streets, true);
                        }
                        break block6;
                    }
                    Testutils.log_PrintLn("No streets were retrieved");
                    Testcode_Query_StreetsResidents.failure();
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in updateResidents");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_StreetsResidents.failure();
                    Object var5_4 = null;
                    streetsManager.releaseAll();
                }
            }
            Object var5_3 = null;
            streetsManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            streetsManager.releaseAll();
            throw throwable;
        }
    }

    public static void getResidents(StreetsManager streetsManager, Streets streets) {
        long l = streets.sizeResidents();
        if (l <= 0L) {
            Testutils.log_PrintLn("No resdents found for street " + streets.getStreetCode());
        } else {
            int n = 0;
            while ((long)n < l) {
                Testcode_Query_StreetsResidents.updateAResident(streetsManager, streets.getResidentsAt(n));
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAResident(StreetsManager streetsManager, Residents residents) {
        residents.setFunction("Changed for update");
        try {
            try {
                streetsManager.synchronize();
                Testutils.log_PrintLn("Update succeeded withouterrors");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in updateAResident");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var4_3 = null;
                streetsManager.release(residents);
            }
            Object var4_2 = null;
            streetsManager.release(residents);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            streetsManager.release(residents);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeResidentsStreets(b3TestManager b3TestManager2, StreetsManager streetsManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("-----------Remove Residents and Streets-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Retrieve all the streets");
        try {
            block7: {
                try {
                    Iterator iterator = streetsManager.list(1, 3);
                    Testutils.log_PrintLn("   Ok");
                    if (iterator != null) {
                        while (iterator.hasMoreElements()) {
                            Streets streets = (Streets)iterator.nextElement();
                            Testutils.log_PrintLn("loop trough all streets and remove all the residents and then the streets");
                            if (streets == null) continue;
                            streetsManager.remove(streets);
                            int n = streets.sizeResidents();
                            int n2 = 0;
                            while (n2 < n) {
                                streetsManager.remove(streets.getResidentsAt(n2));
                                ++n2;
                            }
                            if (n <= 0) continue;
                            streets.removeAllResidents();
                        }
                        Testutils.log_PrintLn("Do the synchronize and remove residents and streets");
                        streetsManager.synchronize();
                        tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa100");
                        int n = tablesizereturn2.getTablesize();
                        Testutils.log_PrintLn("number of records in table ttmboa100 (streets) = " + n);
                        tablesizereturn2 = b3TestManager2.tablesize("ttmboa110");
                        n = tablesizereturn2.getTablesize();
                        Testutils.log_PrintLn("number of records in table ttmboa110 (residents) = " + n);
                        Testutils.log_PrintLn("Removed Streets withouterrors");
                        break block7;
                    }
                    Testutils.log_PrintLn("No streets retrieved to remove");
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in removeResidentsStreets");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_StreetsResidents.failure();
                    Object var10_10 = null;
                    streetsManager.releaseAll();
                    b3TestManager2.releaseAll();
                }
            }
            Object var10_9 = null;
            streetsManager.releaseAll();
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            streetsManager.releaseAll();
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStreetsAndResidentsLinked(b3TestManager b3TestManager2, StreetsManager streetsManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("-----------Add Residents and Streets linked-----------");
        Testutils.log_PrintLn("");
        try {
            try {
                Testutils.log_Print("making table tmboa100 empty  with DLL call ");
                b3TestManager2.tableclear("ttmboa100");
                Testutils.log_PrintLn(" Ok");
                Testutils.log_Print("making table tmboa110 empty  with DLL call ");
                b3TestManager2.tableclear("ttmboa110");
                Testutils.log_PrintLn(" Ok");
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa100");
                int n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa100 now = " + n);
                tablesizereturn2 = b3TestManager2.tablesize("ttmboa110");
                n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa110 now = " + n);
                Testutils.log_PrintLn("Create a street");
                Streets streets = new Streets();
                streets.setStreetCode(1);
                streets.setStreetName("ParkLane");
                streets.setStreetNumber(110);
                streets.setZipcode("ZW19-5NY");
                Testutils.log_PrintLn("Add the street to the manager (local)");
                streetsManager.add(streets);
                Testutils.log_PrintLn("Create a residents");
                Residents residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 1, "John1", "Dickins", "1972-06-07", 1, "Police Inspector", 3098.5, new Date());
                streetsManager.add(residents);
                streets.addResidents(residents);
                residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 1, "Mike1", "Rawlins", "1964-05-28", 2, "Accountant", 5156.98, new Date());
                Testutils.log_PrintLn("Add the residents to the manager (local)");
                streetsManager.add(residents);
                Testutils.log_PrintLn("Link also this residents to the street (local)");
                streets.addResidents(residents);
                Testutils.log_PrintLn("Create a street");
                streets = new Streets();
                streets.setStreetCode(2);
                streets.setStreetName("ParkLane1");
                streets.setStreetNumber(1101);
                streets.setZipcode("ZW29-5NY");
                Testutils.log_PrintLn("Add the street to the manager (local)");
                streetsManager.add(streets);
                Testutils.log_PrintLn("Create residents");
                residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 2, "John2", "Dickins", "1973-07-06", 1, "Police Inspector", 3098.5, new Date());
                streetsManager.add(residents);
                streets.addResidents(residents);
                residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 2, "Mike2", "Rawlins", "1964-06-23", 2, "Accountant", 5156.98, new Date());
                Testutils.log_PrintLn("Add the residents to the manager (local)");
                streetsManager.add(residents);
                Testutils.log_PrintLn("Link also this residents to the street (local)");
                streets.addResidents(residents);
                Testutils.log_PrintLn("Synchronize the street with the residents to the server");
                streetsManager.synchronize();
                Iterator iterator = streetsManager.list(1, 3);
                if (iterator != null) {
                    streets = (Streets)iterator.nextElement();
                    streets = (Streets)iterator.nextElement();
                }
                tablesizereturn2 = b3TestManager2.tablesize("ttmboa100");
                n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa100 now = " + n);
                tablesizereturn2 = b3TestManager2.tablesize("ttmboa110");
                n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa110 now = " + n);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addStreetsAndResidentsLinked");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_StreetsResidents.failure();
                Object var8_9 = null;
                streetsManager.releaseAll();
                b3TestManager2.releaseAll();
            }
            Object var8_8 = null;
            streetsManager.releaseAll();
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            streetsManager.releaseAll();
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void multipleManagers(b3TestManager b3TestManager2, basicTypeManager basicTypeManager2, DataTypesManager dataTypesManager, StreetsManager streetsManager) {
        try {
            block5: {
                try {
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("---------- Testing Multiple Managers update in one call -----------");
                    Testutils.log_PrintLn(" typeManager & streetmanager ");
                    Testutils.log_PrintLn(" tables:  tmboa100, tmboa110 and tmboa120");
                    Testutils.log_PrintLn("");
                    Testutils.log_Print("making table tmboa100 empty  with DLL call ");
                    b3TestManager2.tableclear("ttmboa100");
                    Testutils.log_PrintLn(" Ok");
                    Testutils.log_Print("making table tmboa110 empty  with DLL call ");
                    b3TestManager2.tableclear("ttmboa110");
                    Testutils.log_PrintLn(" Ok");
                    Testutils.log_Print("making table tmboa120 empty  with DLL call ");
                    b3TestManager2.tableclear("ttmboa120");
                    Testutils.log_PrintLn(" Ok");
                    Testutils.log_PrintLn("filling the managers (local)");
                    Streets streets = new Streets();
                    streets.setStreetCode(2);
                    streets.setStreetName("ParkLane1");
                    streets.setStreetNumber(1101);
                    streets.setZipcode("ZW29-5NY");
                    Testutils.log_PrintLn("Add the street to the manager (local)");
                    streetsManager.add(streets);
                    Testutils.log_PrintLn("Create a resident");
                    Residents residents = Testcode_Query_StreetsResidents.fillResidentFields(streetsManager, 2, "John2", "Dickins", "1973-07-06", 1, "Police Inspector", 3098.5, new Date());
                    Testutils.log_PrintLn("Add the resident to the manager (local)");
                    streetsManager.add(residents);
                    Testutils.log_PrintLn("Link the resident to the street (local)");
                    streets.addResidents(residents);
                    DataTypes dataTypes = new DataTypes();
                    dataTypes.setLong1(1);
                    dataTypes.setDouble1(1.1234);
                    dataTypes.setString1(STRING1);
                    dataTypes.setLong2(123456789);
                    dataTypes.setDouble2(2.3456);
                    dataTypes.setString2(STRING2);
                    dataTypesManager.add(dataTypes);
                    ISynchronization iSynchronization = BoiToolkit.getDefaultToolkit().createSynchronization();
                    iSynchronization.addManager(streetsManager);
                    iSynchronization.addManager(dataTypesManager);
                    iSynchronization.execute();
                    tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa100");
                    int n = tablesizereturn2.getTablesize();
                    Testutils.log_PrintLn("number of records in table ttmboa100 now = " + n);
                    tablesizereturn2 = b3TestManager2.tablesize("ttmboa110");
                    int n2 = tablesizereturn2.getTablesize();
                    Testutils.log_PrintLn("number of records in table ttmboa110 now = " + n2);
                    tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                    int n3 = tablesizereturn2.getTablesize();
                    Testutils.log_PrintLn("number of records in table ttmboa120 now = " + n3);
                    if (n == 1 && n2 == 1 && n3 == 1) {
                        Testutils.log_PrintLn("synchronization on multiple mangers = ok");
                        break block5;
                    }
                    Testutils.log_PrintLn("synchronization on multiple mangers failed !!!!");
                    Testcode_Query_StreetsResidents.failure();
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in addStreetsAndResidentsLinked");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_StreetsResidents.failure();
                    Object var13_14 = null;
                    streetsManager.releaseAll();
                    dataTypesManager.releaseAll();
                    basicTypeManager2.releaseAll();
                    b3TestManager2.releaseAll();
                }
            }
            Object var13_13 = null;
            streetsManager.releaseAll();
            dataTypesManager.releaseAll();
            basicTypeManager2.releaseAll();
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            streetsManager.releaseAll();
            dataTypesManager.releaseAll();
            basicTypeManager2.releaseAll();
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    public static void queryWithoutParameters(StreetsManager streetsManager) {
        Testutils.startTest("Query without Parameters");
        Testcode_Query_StreetsResidents.removeStreets(streetsManager);
        Testcode_Query_StreetsResidents.addStreets(streetsManager);
        try {
            Iterator iterator = streetsManager.listAll();
            if (iterator != null) {
                int n = 0;
                while (iterator.hasMoreElements()) {
                    Streets streets = (Streets)iterator.nextElement();
                    if (streets.getStreetCode() != n + 1) continue;
                    ++n;
                }
                if (n != 3) {
                    Testutils.log_PrintLn("Did not retrieve all streets with listAll(): " + n);
                    Testutils.endTest(false);
                } else {
                    Testutils.endTest(true);
                }
            } else {
                Testutils.log_PrintLn("listAll() failed: null pointer");
                Testutils.endTest(false);
            }
            Testcode_Query_StreetsResidents.removeStreets(streetsManager);
            streetsManager.releaseAll();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in queryWithoutParameters");
            Testutils.log_PrintLn(boiException.toString());
            Testutils.endTest(false);
        }
    }

    public static void queryWithoutResult(StreetsManager streetsManager) {
        block6: {
            Testutils.startTest("Query without Result");
            try {
                Streets streets = streetsManager.show(83920845);
                if (streets != null) {
                    Testutils.log_PrintLn("show() failed: must return null pointer");
                    Testutils.endTest(false);
                    return;
                }
                Iterator iterator = streetsManager.list(83920845, 83920848);
                if (iterator != null) {
                    if (iterator.hasMoreElements()) {
                        Testutils.log_PrintLn("list() failed: iterator should not contain objects");
                        Testutils.endTest(false);
                    } else {
                        Testutils.endTest(true);
                    }
                    break block6;
                }
                Testutils.log_PrintLn("list() failed: null pointer returned");
                Testutils.endTest(false);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in queryWithoutResult");
                Testutils.log_PrintLn(boiException.toString());
                Testutils.endTest(false);
            }
        }
    }

    public static void removeStreets(StreetsManager streetsManager) {
        try {
            Iterator iterator = streetsManager.list(1, 3);
            if (iterator != null) {
                while (iterator.hasMoreElements()) {
                    Streets streets = (Streets)iterator.nextElement();
                    if (streets == null) continue;
                    streetsManager.remove(streets);
                }
                streetsManager.synchronize();
            }
        }
        catch (BoiException boiException) {
            // empty catch block
        }
        streetsManager.releaseAll();
    }

    public static void readOnlyStreets(ReadOnlyStreetManager readOnlyStreetManager, StreetsManager streetsManager) {
        Testutils.startTest("ReadOnly Streets test");
        Testcode_Query_StreetsResidents.removeStreets(streetsManager);
        Testutils.log_Print("Adding a readonly street should throw exception: ");
        ReadOnlyStreet readOnlyStreet = new ReadOnlyStreet();
        readOnlyStreet.setStreetCode(2);
        readOnlyStreet.setStreetName("ParkLane1");
        readOnlyStreet.setStreetNumber(1101);
        readOnlyStreet.setZipcode("ZW29-5NY");
        try {
            streetsManager.add(readOnlyStreet);
            Testutils.endTest(false);
        }
        catch (Exception exception) {
            Testutils.endTest(true);
        }
        streetsManager.releaseAll();
        Testutils.log_Print("Adding 3 streets: ");
        try {
            streetsManager.add(Testcode_Query_StreetsResidents.fillStreetFields(streetsManager, 1, "Parklane", 110, "SW19-5NY"));
            streetsManager.add(Testcode_Query_StreetsResidents.fillStreetFields(streetsManager, 2, "Kalverstraat", 220, "1012 MD"));
            streetsManager.add(Testcode_Query_StreetsResidents.fillStreetFields(streetsManager, 3, "Im Hag", 10, "70327"));
            streetsManager.synchronize();
            Testutils.endTest(true);
        }
        catch (Exception exception) {
            Testutils.endTest(false);
            return;
        }
        Testutils.log_Print("Removing readonly streets should throw exceptions: ");
        try {
            boolean bl = true;
            Iterator iterator = readOnlyStreetManager.listReadOnly();
            if (iterator != null && iterator.hasMoreElements()) {
                while (iterator.hasMoreElements()) {
                    readOnlyStreet = (ReadOnlyStreet)iterator.nextElement();
                    if (readOnlyStreet != null) {
                        try {
                            readOnlyStreetManager.remove(readOnlyStreet);
                            bl = false;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    bl = false;
                }
                Testutils.endTest(bl);
            } else {
                Testutils.endTest(false);
            }
        }
        catch (BoiException boiException) {
            Testutils.endTest(false);
        }
        streetsManager.releaseAll();
        Testcode_Query_StreetsResidents.removeStreets(streetsManager);
    }

    private static abstract class IteratorHack
    extends IteratorImpl {
        private IteratorHack() {
        }

        public static com.eibus.bdf.Iterator getIterator(Iterator iterator) {
            return IteratorImpl.getIteratorImpl((IteratorImpl)iterator);
        }
    }

    private static class Hack
    extends BoiToolkit {
        private static final Hack s_instance = new Hack();

        private Hack() {
        }

        public IBackend createBackend(String string) {
            throw new RuntimeException("Not implemented.");
        }

        public static BusinessDocumentManager getBdm(BusinessObjectManager businessObjectManager) {
            return s_instance.bomToBdm(businessObjectManager);
        }

        public ISynchronization createSynchronization() {
            throw new RuntimeException("Not implemented.");
        }

        public IUserInfo createUserInfo() {
            throw new RuntimeException("Not implemented.");
        }

        public IUserSession createUserSession() {
            throw new RuntimeException("Not implemented.");
        }

        public IUserSession createUserSession(IUserInfo iUserInfo) {
            throw new RuntimeException("Not implemented.");
        }

        protected IExceptionDescriptor createExceptionDescriptor(boolean bl, String[] stringArray) {
            throw new RuntimeException("Not implemented.");
        }

        protected ISynchronizationExceptionDescriptor createSynchronizationExceptionDescriptor(boolean bl, String[] stringArray, String string, String string2, BusinessObject businessObject, SynchronizationActionType synchronizationActionType) {
            throw new RuntimeException("Not implemented.");
        }

        protected Iterator createIterator(Query query, BusinessDocumentManager businessDocumentManager, Class clazz) {
            throw new RuntimeException("Not implemented.");
        }

        protected IMetadataFactory getMetadataFactory() {
            throw new RuntimeException("Not implemented.");
        }
    }
}

