/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiSynchronizationException;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.IExceptionDescriptor;
import com.baan.b3.boi1.ISynchronizationExceptionDescriptor;
import com.baan.b3.boi1.Iterator;
import com.eibus.test.regression.B3test;
import com.eibus.test.regression.Testutils;
import com.eibus.test.regression.typesafe.DataTypes;
import com.eibus.test.regression.typesafe.DataTypesManager;
import com.eibus.test.regression.typesafe.b3TestManager;
import com.eibus.test.regression.typesafe.basicTypeManager;
import com.eibus.test.regression.typesafe.copyshortreturn;
import com.eibus.test.regression.typesafe.tablesizereturn;

public class Testcode_Query_DataTypes {
    public static final int MAX_RECORDS = 100;
    public static final double P_DOUBLE1 = 1.123;
    public static final String P_STRING1 = "1234567890123";
    public static final int P_LONG2 = 12345;
    public static final double P_DOUBLE2 = 2.345;
    public static final String P_STRING2 = "3210987654321";
    public static final double DOUBLE1 = 1.1234;
    public static final String STRING1 = "String one";
    public static final int LONG2 = 123456789;
    public static final double DOUBLE2 = 2.3456;
    public static final String STRING2 = "String two";
    public static final double DOUBLE1_UPDATE = 2.2468;
    public static final String STRING1_UPDATE = "String one updated";
    public static final int LONG2_UPDATE = 222222222;
    public static final double DOUBLE2_UPDATE = 4.6888;
    public static final String STRING2_UPDATE = "String two updated";

    public static void failure() {
        B3test.failure();
    }

    public static void test_DataTypesPerformance() {
        Testutils.log_PrintLn("-----------Performance calls for DataTypes-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Creating and initializing server...");
        try {
            DataTypesManager dataTypesManager = new DataTypesManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            dataTypesManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Ok");
            Testcode_Query_DataTypes.initializeTest(b3TestManager2);
            Testcode_Query_DataTypes.receiveRecordsPerformance(b3TestManager2, dataTypesManager);
            Testcode_Query_DataTypes.addRecordsPerformance(b3TestManager2, dataTypesManager);
            Testcode_Query_DataTypes.addMoreRecordsPerformance(b3TestManager2, dataTypesManager);
            b3TestManager2.close();
            dataTypesManager.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_DataTypesPerformance");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
    }

    public static void test_DataTypes() {
        Testutils.log_PrintLn("-------- 'simple' SQL Queries for DataTypes -----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Creating and initializing server...");
        try {
            DataTypesManager dataTypesManager = new DataTypesManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            dataTypesManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Ok");
            Testcode_Query_DataTypes.initializeTest(b3TestManager2);
            Testcode_Query_DataTypes.addRecordsInOneCall(b3TestManager2, dataTypesManager);
            Testcode_Query_DataTypes.addRecordsInMultipleCalls(b3TestManager2, dataTypesManager);
            Testcode_Query_DataTypes.updateRecords(b3TestManager2, dataTypesManager);
            Testcode_Query_DataTypes.removeRecords(b3TestManager2, dataTypesManager);
            Testcode_Query_DataTypes.updateFailures(b3TestManager2, dataTypesManager);
            b3TestManager2.close();
            dataTypesManager.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_DataTypes");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeTest(b3TestManager b3TestManager2) {
        Testutils.log_PrintLn("Initializing the test...");
        Testutils.log_PrintLn("");
        Testutils.log_Print("(clearing all the tables)");
        try {
            try {
                b3TestManager2.initializetest();
                Testutils.log_PrintLn("Ok");
                Testutils.log_PrintLn("");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("Failed to initialize SQL test");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var3_2 = null;
                b3TestManager2.releaseAll();
            }
            Object var3_1 = null;
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecordsInOneCall(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("----------Insert 100 records in one call-----------");
        Testutils.log_PrintLn("type = (Long,Double,String,Long,Double,String)");
        Testutils.log_PrintLn("");
        Testcode_Query_DataTypes.fill_tmboa120(dataTypesManager);
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                int n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa120 now = " + n);
                Testutils.log_PrintLn("checking data in table ttmboa120");
                Testcode_Query_DataTypes.checkRecords(dataTypesManager, false);
                Testutils.log_Print("making table tmboa120 empty  with DLL call ");
                b3TestManager2.tableclear("ttmboa120");
                Testutils.log_PrintLn(" Ok");
                tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa120 now = " + n);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addRecordsInOneCall");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var5_6 = null;
                b3TestManager2.releaseAll();
            }
            Object var5_5 = null;
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecordsInMultipleCalls(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("--------Insert 100 records in 100 calls -------");
        Testutils.log_PrintLn("type = (Long,Double,String,Long,Double,String)");
        Testutils.log_PrintLn("");
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                int n = tablesizereturn2.getTablesize();
                if (n > 0) {
                    b3TestManager2.tableclear("ttmboa120");
                }
                int n2 = 1;
                while (n2 <= 100) {
                    DataTypes dataTypes = new DataTypes();
                    dataTypes.setLong1(n2);
                    dataTypes.setDouble1(1.1234);
                    dataTypes.setString1(STRING1);
                    dataTypes.setLong2(123456789);
                    dataTypes.setDouble2(2.3456);
                    dataTypes.setString2(STRING2);
                    dataTypesManager.add(dataTypes);
                    Testutils.log_PrintCounter(n2);
                    dataTypesManager.synchronize();
                    ++n2;
                }
                Testutils.log_PrintLn("inserted withouterrors");
                tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa120 now = " + n);
                Testutils.log_PrintLn("checking data in table ttmboa120");
                Testcode_Query_DataTypes.checkRecords(dataTypesManager, false);
                Testutils.log_Print("making table tmboa120 empty with DLL call ");
                b3TestManager2.tableclear("ttmboa120");
                Testutils.log_PrintLn(" Ok");
                tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                n = tablesizereturn2.getTablesize();
                Testutils.log_PrintLn("number of records in table ttmboa120 now = " + n);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addRecordsInmultipleCalls");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var7_8 = null;
                dataTypesManager.releaseAll();
                b3TestManager2.releaseAll();
            }
            Object var7_7 = null;
            dataTypesManager.releaseAll();
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            dataTypesManager.releaseAll();
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRecords(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        int n = 0;
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("----------- Update 100 records -----------");
        Testutils.log_PrintLn("type = (Long,Double,String,Long,Double,String)");
        Testutils.log_PrintLn("");
        Testcode_Query_DataTypes.fill_tmboa120(dataTypesManager);
        Testutils.log_Print("retreiving 100 records ");
        try {
            block6: {
                try {
                    dataTypesManager.setTimeOut(0L);
                    Iterator iterator = dataTypesManager.list(0, 100);
                    Testutils.log_PrintLn(" Ok");
                    Testutils.log_PrintLn("Changing the data (client)");
                    if (iterator != null) {
                        while (iterator.hasMoreElements()) {
                            DataTypes dataTypes = (DataTypes)iterator.nextElement();
                            dataTypes.setDouble1(2.2468);
                            dataTypes.setString1(STRING1_UPDATE);
                            dataTypes.setLong2(222222222);
                            dataTypes.setDouble2(4.6888);
                            dataTypes.setString2(STRING2_UPDATE);
                            Testutils.log_PrintCounter(++n);
                        }
                        Testutils.log_PrintLn("");
                        Testutils.log_Print("Sending the changes to the backend");
                        dataTypesManager.synchronize();
                        Testutils.log_PrintLn(" Ok");
                        Testutils.log_PrintLn("Updated withouterrors");
                        Testutils.log_PrintLn("Checking the date");
                        Testcode_Query_DataTypes.checkRecords(dataTypesManager, true);
                        Testutils.log_Print("making table tmboa120 empty with DLL call ");
                        b3TestManager2.tableclear("ttmboa120");
                        Testutils.log_PrintLn(" Ok");
                        tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                        int n2 = tablesizereturn2.getTablesize();
                        Testutils.log_PrintLn("number of records in table ttmboa120 now = " + n2);
                        break block6;
                    }
                    Testutils.log_PrintLn("No records were retrieved from the server");
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in updateRecords");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_DataTypes.failure();
                    Object var9_8 = null;
                    dataTypesManager.releaseAll();
                    b3TestManager2.releaseAll();
                }
            }
            Object var9_7 = null;
            dataTypesManager.releaseAll();
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            dataTypesManager.releaseAll();
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkRecords(DataTypesManager dataTypesManager, boolean bl) {
        DataTypes dataTypes = new DataTypes();
        boolean bl2 = true;
        Testutils.log_PrintLn("");
        int n = 0;
        try {
            block12: {
                try {
                    Iterator iterator = dataTypesManager.list(0, 100);
                    if (iterator != null) {
                        while (iterator.hasMoreElements()) {
                            dataTypes = (DataTypes)iterator.nextElement();
                            if (bl) {
                                if (dataTypes.getDouble1() != 2.2468 || !dataTypes.getString1().equals(STRING1_UPDATE) || dataTypes.getLong2() != 222222222 || dataTypes.getDouble2() != 4.6888 || !dataTypes.getString2().equals(STRING2_UPDATE)) {
                                    Testutils.log_PrintLn("Not all records were updated properly");
                                    bl2 = false;
                                    break;
                                }
                            } else if (dataTypes.getDouble1() == 1.1234 && dataTypes.getString1().equals(STRING1) && dataTypes.getLong2() == 123456789 && dataTypes.getDouble2() == 2.3456 && dataTypes.getString2().equals(STRING2)) {
                                bl2 = true;
                            } else {
                                Testutils.log_PrintLn("Not all records were inserted properly");
                                bl2 = false;
                                Testcode_Query_DataTypes.failure();
                                break;
                            }
                            Testutils.log_PrintCounter(++n);
                        }
                        if (bl2) {
                            Testutils.log_PrintLn("Insert/update ok");
                        }
                        break block12;
                    }
                    Testutils.log_PrintLn("No records were retreived");
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in checkRecords");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_DataTypes.failure();
                    Object var8_7 = null;
                    dataTypesManager.releaseAll();
                }
            }
            Object var8_6 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRecords(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        int n = 0;
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("----------- Remove 100 records -----------");
        Testutils.log_PrintLn("type = (Long,Double,String,Long,Double,String)");
        Testutils.log_PrintLn("");
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("tmboa120");
                int n2 = tablesizereturn2.getTablesize();
                if (n2 > 0) {
                    b3TestManager2.tableclear("tmboa120");
                }
                Testcode_Query_DataTypes.fill_tmboa120(dataTypesManager);
                Testutils.log_Print("retreiving 100 records ");
                Iterator iterator = dataTypesManager.list(0, 100);
                Testutils.log_PrintLn(" Ok");
                Testutils.log_PrintLn("Deleting the data from the manager (client)");
                if (iterator != null) {
                    while (iterator.hasMoreElements()) {
                        DataTypes dataTypes = (DataTypes)iterator.nextElement();
                        dataTypesManager.remove(dataTypes);
                        Testutils.log_PrintCounter(++n);
                    }
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("synchronize with backend");
                    dataTypesManager.synchronize();
                    Testutils.log_PrintLn("Removed withouterrors");
                } else {
                    Testutils.log_PrintLn("There is nothing to remove");
                }
                dataTypesManager.releaseAll();
                Testcode_Query_DataTypes.checkEmpty(dataTypesManager);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in removeRecords");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var9_8 = null;
                dataTypesManager.releaseAll();
            }
            Object var9_7 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    public static void updateFailures(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("----------- Test failing updates -----------");
        Testutils.log_PrintLn("");
        DataTypes dataTypes = new DataTypes();
        try {
            dataTypes.setLong1(1);
            dataTypes.setDouble1(1.1234);
            dataTypes.setString1(STRING1);
            dataTypes.setLong2(123456789);
            dataTypes.setDouble2(2.3456);
            dataTypes.setString2(STRING2);
            dataTypesManager.add(dataTypes);
            dataTypesManager.synchronize();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("Error: BoiException in updateFailures");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("DataTypes record added, try to add it again");
        DataTypes dataTypes2 = new DataTypes();
        try {
            dataTypes2.setLong1(1);
            dataTypes2.setDouble1(2.3456);
            dataTypes2.setString1(STRING2);
            dataTypes2.setLong2(123456789);
            dataTypes2.setDouble2(1.1234);
            dataTypes2.setString2(STRING1);
            dataTypesManager.add(dataTypes2);
            dataTypesManager.synchronize();
            Testutils.log_PrintLn("Error: No exception received, but it should have failed");
            Testcode_Query_DataTypes.failure();
        }
        catch (BoiSynchronizationException boiSynchronizationException) {
            Testcode_Query_DataTypes.displaySynchronizationException(boiSynchronizationException, dataTypes2);
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("Error: BoiException in updateFailures");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Modify record with DLL call");
        try {
            b3TestManager2.dllupdate();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("Error: BoiException in dllupdate");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Update modified record with synchronize");
        try {
            dataTypes.setDouble1(2.2468);
            dataTypes.setString1(STRING1_UPDATE);
            dataTypes.setLong2(222222222);
            dataTypes.setDouble2(4.6888);
            dataTypes.setString2(STRING2_UPDATE);
            dataTypesManager.add(dataTypes);
            dataTypesManager.synchronize();
            Testutils.log_PrintLn("Error: No exception received, but it should have failed");
            Testcode_Query_DataTypes.failure();
        }
        catch (BoiSynchronizationException boiSynchronizationException) {
            Testcode_Query_DataTypes.displaySynchronizationException(boiSynchronizationException, dataTypes);
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("Error: BoiException in updateFailures");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Clearing table with DLL call");
        try {
            b3TestManager2.tableclear("ttmboa120");
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("Error: BoiException in tableClear");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Update non-existing record with synchronize");
        try {
            dataTypes.setDouble1(2.2468);
            dataTypes.setString1(STRING1_UPDATE);
            dataTypes.setLong2(222222222);
            dataTypes.setDouble2(4.6888);
            dataTypes.setString2(STRING2_UPDATE);
            dataTypesManager.synchronize();
            Testutils.log_PrintLn("Error: No exception received, but it should have failed");
            Testcode_Query_DataTypes.failure();
        }
        catch (BoiSynchronizationException boiSynchronizationException) {
            Testcode_Query_DataTypes.displaySynchronizationException(boiSynchronizationException, dataTypes);
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("Error: BoiException in updateFailures");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Remove non-existing record");
        try {
            dataTypesManager.remove(dataTypes);
            dataTypesManager.synchronize();
            Testutils.log_PrintLn("Error: No exception received, but it should have failed");
            Testcode_Query_DataTypes.failure();
        }
        catch (BoiSynchronizationException boiSynchronizationException) {
            Testcode_Query_DataTypes.displaySynchronizationException(boiSynchronizationException, dataTypes);
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("Error: BoiException in updateFailures");
            Testutils.log_PrintLn(boiException.toString());
            Testcode_Query_DataTypes.failure();
        }
        dataTypesManager.releaseAll();
        b3TestManager2.releaseAll();
    }

    public static void displaySynchronizationException(BoiSynchronizationException boiSynchronizationException, BusinessObject businessObject) {
        Testutils.log_PrintLn("Succeeded: Correctly received exception after synchronize");
        IExceptionDescriptor[] iExceptionDescriptorArray = boiSynchronizationException.getDescriptors();
        int n = 0;
        while (n < iExceptionDescriptorArray.length) {
            if (!(iExceptionDescriptorArray[n] instanceof ISynchronizationExceptionDescriptor)) {
                Testutils.log_PrintLn("Failed: SynchronizationException has non-ISynchronizationExceptionDescriptor");
                Testutils.log_PrintLn(iExceptionDescriptorArray[n].toString());
            } else {
                ISynchronizationExceptionDescriptor iSynchronizationExceptionDescriptor = (ISynchronizationExceptionDescriptor)iExceptionDescriptorArray[n];
                Testutils.log_PrintLn("");
                Testutils.log_PrintLn("   Error: " + n);
                Testutils.log_PrintLn("      FieldName          : " + iSynchronizationExceptionDescriptor.getFieldName());
                Testutils.log_PrintLn("      MessageCode        : " + iSynchronizationExceptionDescriptor.getMessageCode());
                Testutils.log_PrintLn("      MessageDescription : ");
                String[] stringArray = iSynchronizationExceptionDescriptor.getMessage();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    Testutils.log_PrintLn("\t" + stringArray[n2]);
                    ++n2;
                }
                Testutils.log_Print("      BusinessElement    : ");
                if (iSynchronizationExceptionDescriptor.getBusinessObject() == businessObject) {
                    Testutils.log_PrintLn("Ok");
                } else {
                    Testutils.log_PrintLn("Failed: has wrong business element attached");
                    Testcode_Query_DataTypes.failure();
                }
            }
            ++n;
        }
        Testutils.log_PrintLn(boiSynchronizationException.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkEmpty(DataTypesManager dataTypesManager) {
        Testutils.log_PrintLn("Check if the table is empty (with a list)");
        try {
            block5: {
                try {
                    Iterator iterator = dataTypesManager.list(0, 100);
                    if (iterator != null && iterator.hasMoreElements()) {
                        Testutils.log_PrintLn("or, The table is not empty");
                        break block5;
                    }
                    Testutils.log_PrintLn("Ok, Table is empty");
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in checkEmpty");
                    Testutils.log_PrintLn(boiException.toString());
                    Testcode_Query_DataTypes.failure();
                    Object var4_3 = null;
                    dataTypesManager.releaseAll();
                }
            }
            Object var4_2 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveRecordsPerformance(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        double d = 0.0;
        try {
            try {
                Testutils.log_PrintLn("-----Performance test on receiving records to table tmboa120 DataTypes-----");
                Testutils.log_PrintLn("    (long, double, string, long, double, string) -> 50 bytes");
                Testutils.log_PrintLn("");
                Testutils.log_Print("Clearing table tmboa120 (function) . . ");
                b3TestManager2.tableclear("ttmboa120");
                Testutils.log_PrintLn("OK.");
                Testutils.log_Print("Filling table tmboa120 with 1000 records (function) . . ");
                b3TestManager2.fillTabletmboa120(1000);
                Testutils.log_PrintLn("OK.");
                Testutils.log_PrintLn("");
                Testutils.log_PrintLn("");
                Testutils.log_PrintLn("- - - - - - - - - - - - - - - - - - - - - -");
                Testutils.log_Print("Receiving 1000 records with Data Model . . ");
                double d2 = System.currentTimeMillis();
                Iterator iterator = dataTypesManager.list(1, 1000);
                while (iterator.hasMoreElements()) {
                    iterator.nextElement();
                }
                d2 = (double)System.currentTimeMillis() - d2;
                double d3 = 1000.0 / (d2 / 1000.0);
                Testutils.log_PrintLn(" this took " + d2 + " msec");
                Testutils.log_PrintLn("This results in " + d3 + " records/sec");
                Testutils.log_PrintLn("no of data Bytes send = 50000 Bytes");
                Testutils.log_PrintLn("This results in " + 50000.0 / d2 + " KBytes/sec");
                Testutils.log_PrintLn("");
                Testutils.log_PrintLn("- - - - - - - - - - - - - - - - - - - - - -");
                Testutils.log_Print("Receiving & accessing 1000 records with Data Model . . ");
                d2 = System.currentTimeMillis();
                iterator = dataTypesManager.list(1, 1000);
                while (iterator.hasMoreElements()) {
                    DataTypes dataTypes = (DataTypes)iterator.nextElement();
                    double d4 = dataTypes.getDouble1();
                    d4 = dataTypes.getDouble2();
                    long l = dataTypes.getLong1();
                    l = dataTypes.getLong2();
                    String string = dataTypes.getString1();
                    string = dataTypes.getString2();
                }
                d2 = (double)System.currentTimeMillis() - d2;
                d3 = 1000.0 / (d2 / 1000.0);
                Testutils.log_PrintLn(" this took " + d2 + " msec");
                Testutils.log_PrintLn("This results in " + d3 + " records/sec");
                Testutils.log_PrintLn("no of data Bytes send = 50000 Bytes");
                Testutils.log_PrintLn("This results in " + 50000.0 / d2 + " KBytes/sec");
                Testutils.log_PrintLn("");
                Testutils.log_PrintLn("");
                Testutils.log_PrintLn("");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addRecordsPerformance");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var16_12 = null;
                dataTypesManager.releaseAll();
            }
            Object var16_11 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var16_13 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRecordsPerformance(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        double d = 0.0;
        Testutils.log_PrintLn("-----Performance test on adding records to table tmboa120 DataTypes-----");
        Testutils.log_PrintLn("    (long, double, string, long, double, string) -> 50 bytes");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("---------------Insert one record at a time-----------");
        Testutils.log_PrintLn("");
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                int n = tablesizereturn2.getTablesize();
                if (n > 0) {
                    b3TestManager2.tableclear("ttmboa120");
                }
                double d2 = System.currentTimeMillis();
                int n2 = 1;
                while (n2 <= 100) {
                    DataTypes dataTypes = new DataTypes();
                    dataTypes.setLong1(n2);
                    dataTypes.setDouble1(1.123);
                    dataTypes.setString1(P_STRING1);
                    dataTypes.setLong2(12345);
                    dataTypes.setDouble2(2.345);
                    dataTypes.setString2(P_STRING2);
                    dataTypesManager.add(dataTypes);
                    dataTypesManager.synchronize();
                    Testutils.log_PrintCounter(n2);
                    d += 1.0;
                    ++n2;
                }
                dataTypesManager.releaseAll();
                d2 = (double)System.currentTimeMillis() - d2;
                double d3 = d / (d2 / 1000.0);
                Testutils.log_PrintLn(d + " query calls took " + d2 + " msec");
                Testutils.log_PrintLn("This results in " + d3 + " calls/sec");
                Testutils.log_PrintLn("no of data Bytes send = 5000 Bytes");
                Testutils.log_PrintLn("This results in " + 5000.0 / d2 + " KBytes/sec");
                Testutils.log_PrintLn("inserted withouterrors");
                Testcode_Query_DataTypes.checkTable(b3TestManager2);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addRecordsPerformance");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var13_11 = null;
                dataTypesManager.releaseAll();
            }
            Object var13_10 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMoreRecordsPerformance(b3TestManager b3TestManager2, DataTypesManager dataTypesManager) {
        double d = 0.0;
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("---------------Insert all records in one call-----------");
        Testutils.log_PrintLn("");
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                int n = tablesizereturn2.getTablesize();
                if (n > 0) {
                    b3TestManager2.tableclear("ttmboa120");
                }
                Testutils.log_PrintLn("Filling the data (client)");
                int n2 = 1;
                while (n2 <= 100) {
                    DataTypes dataTypes = new DataTypes();
                    dataTypes.setLong1(n2);
                    dataTypes.setDouble1(1.123);
                    dataTypes.setString1(P_STRING1);
                    dataTypes.setLong2(12345);
                    dataTypes.setDouble2(2.345);
                    dataTypes.setString2(P_STRING2);
                    dataTypesManager.add(dataTypes);
                    Testutils.log_PrintCounter(n2);
                    d = n2;
                    ++n2;
                }
                double d2 = System.currentTimeMillis();
                Testutils.log_PrintLn("Sending it to the server");
                dataTypesManager.synchronize();
                d2 = (double)System.currentTimeMillis() - d2;
                double d3 = d / (d2 / 1000.0);
                Testutils.log_PrintLn(d + " records in one call took " + d2 + " msec to synchronize");
                Testutils.log_PrintLn("This results in " + d3 + " records/sec");
                Testutils.log_PrintLn("no of data Bytes send = 5000 Bytes");
                Testutils.log_PrintLn("This results in " + 5000.0 / d2 + " KBytes/sec");
                Testutils.log_PrintLn("inserted withouterrors");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in addMoreRecordsPerformance");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var13_11 = null;
                dataTypesManager.releaseAll();
            }
            Object var13_10 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkTable(b3TestManager b3TestManager2) {
        try {
            try {
                tablesizereturn tablesizereturn2 = b3TestManager2.tablesize("ttmboa120");
                int n = tablesizereturn2.getTablesize();
                if (n == 100) {
                    Testutils.log_PrintLn("All records have been inserted");
                } else {
                    Testutils.log_PrintLn("Not all records have been inserted");
                    Testcode_Query_DataTypes.failure();
                }
                Testutils.log_PrintLn(n + " records are present in the table");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("BoiException in checkTable");
                Testutils.log_PrintLn(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var5_4 = null;
                b3TestManager2.releaseAll();
            }
            Object var5_3 = null;
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fill_tmboa120(DataTypesManager dataTypesManager) {
        Testutils.log_PrintLn("filling table with 100 records");
        try {
            try {
                dataTypesManager.setTimeOut(0L);
                int n = 1;
                while (n <= 100) {
                    DataTypes dataTypes = new DataTypes();
                    dataTypes.setLong1(n);
                    dataTypes.setDouble1(1.1234);
                    dataTypes.setString1(STRING1);
                    dataTypes.setLong2(123456789);
                    dataTypes.setDouble2(2.3456);
                    dataTypes.setString2(STRING2);
                    dataTypesManager.add(dataTypes);
                    Testutils.log_PrintCounter(n);
                    ++n;
                }
                Testutils.log_PrintLn("");
                Testutils.log_Print("synchronize changes with backend");
                dataTypesManager.synchronize();
                Testutils.log_PrintLn(" Ok");
            }
            catch (BoiException boiException) {
                Testutils.log_Print("BoiException in fill_tmboa120");
                Testutils.log_Print(boiException.toString());
                Testcode_Query_DataTypes.failure();
                Object var4_5 = null;
                dataTypesManager.releaseAll();
            }
            Object var4_4 = null;
            dataTypesManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            dataTypesManager.releaseAll();
            throw throwable;
        }
    }

    public static void fill_tmboa120_ByDLL(basicTypeManager basicTypeManager2) {
        try {
            short s = 1234;
            short s2 = 0;
            copyshortreturn copyshortreturn2 = basicTypeManager2.copyshort(s);
            s2 = copyshortreturn2.getShort2();
            long l = copyshortreturn2.getCopyshort();
            if (l == 0L & s == s2) {
                Testutils.log_Print("copyshort data = ok,  ");
            } else {
                Testcode_Query_DataTypes.failure();
                Testutils.log_Print("copyshort dataerror,   ");
            }
            Testutils.log_PrintLn("no bus/B3errors");
        }
        catch (BoiException boiException) {
            Testcode_Query_DataTypes.failure();
            Testutils.log_Print("BoiException in copyshort");
            Testutils.log_Print(boiException.toString());
        }
    }
}

