/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.Iterator;
import com.eibus.test.regression.B3test;
import com.eibus.test.regression.Testutils;
import com.eibus.test.regression.typesafe.DataTypes;
import com.eibus.test.regression.typesafe.QueryByDLLManager;
import com.eibus.test.regression.typesafe.Residents;
import com.eibus.test.regression.typesafe.Streets;

public class Testcode_QueryByDLL {
    public static final int MAX_RECORDS = 50;

    public static void failure() {
        B3test.failure();
    }

    public static void test_QueryByDLL_functionality() {
        Testcode_QueryByDLL.test_QueryByDLL_DataTypes_List();
        Testcode_QueryByDLL.test_QueryByDLL_DataTypes_Show();
        Testcode_QueryByDLL.test_QueryByDLL_StreetsAndResidents_List();
        Testcode_QueryByDLL.test_QueryByDLL_StreetsAndResidents_Show();
    }

    public static void test_QueryByDLL_DataTypes_Show() {
        Testutils.log_PrintLn("------------- Query By DLL DataTypes Show ------------");
        Testutils.log_PrintLn("creating & initialize manager");
        try {
            QueryByDLLManager queryByDLLManager = new QueryByDLLManager();
            queryByDLLManager.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Doing QueryByDLL Call, getting datatype");
            DataTypes dataTypes = queryByDLLManager.QueryByDLLDataTypes_Show(50);
            if (dataTypes != null) {
                if (dataTypes.getLong1() != 49 || dataTypes.getLong2() != 49) {
                    Testutils.log_Print("Data Error in QueryByDLL");
                    Testcode_QueryByDLL.failure();
                } else {
                    Testutils.log_PrintLn("Record received correctly = OK");
                }
            } else {
                Testutils.log_Print("Error in QueryByDLL");
                Testcode_QueryByDLL.failure();
            }
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("");
        }
        catch (BoiException boiException) {
            Testcode_QueryByDLL.failure();
            Testutils.log_PrintLn(boiException.toString());
        }
    }

    public static void test_QueryByDLL_DataTypes_List() {
        Testutils.log_PrintLn("------------- Query By DLL DataTypes List ------------");
        Testutils.log_PrintLn("creating & initialize manager");
        try {
            QueryByDLLManager queryByDLLManager = new QueryByDLLManager();
            int n = 0;
            boolean bl = false;
            queryByDLLManager.initialize(B3test.server_comp);
            if (queryByDLLManager != null) {
                Testutils.log_PrintLn("Doing QueryByDLL Call, getting iterator");
                Iterator iterator = queryByDLLManager.QueryByDLLDataTypes_List(50);
                while (iterator.hasMoreElements()) {
                    DataTypes dataTypes = (DataTypes)iterator.nextElement();
                    if (dataTypes.getLong1() != n || dataTypes.getLong2() != n) {
                        Testutils.log_Print("Data Error in QueryByDLL");
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    Testutils.log_PrintLn("Error in test");
                    Testcode_QueryByDLL.failure();
                }
                if (n == 50) {
                    Testutils.log_PrintLn("Number of records (datatypes) received = " + n + ", = OK");
                } else {
                    Testutils.log_PrintLn("Error: Number records received =" + n + " should be " + 50);
                    Testcode_QueryByDLL.failure();
                }
            } else {
                Testutils.log_Print("Error : No iterator returned by queryByDLLManager.QueryByDLLDataTypes_list");
            }
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("");
        }
        catch (BoiException boiException) {
            Testcode_QueryByDLL.failure();
            Testutils.log_PrintLn(boiException.toString());
        }
    }

    public static void test_QueryByDLL_StreetsAndResidents_List() {
        Testutils.log_PrintLn("------------- Query By DLL Streets,Residents List ------------");
        Testutils.log_PrintLn("creating & initialize manager");
        try {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            QueryByDLLManager queryByDLLManager = new QueryByDLLManager();
            queryByDLLManager.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Doing QueryByDLL Call, getting iterator");
            Iterator iterator = queryByDLLManager.QueryByDLLStreets_List(50);
            while (iterator.hasMoreElements()) {
                Streets streets = (Streets)iterator.nextElement();
                int n3 = streets.sizeResidents();
                n2 += n3;
                ++n;
                int n4 = streets.getStreetCode();
                Residents residents = streets.getResidentsAt(0);
                Residents residents2 = streets.getResidentsAt(1);
                if (residents != null && n4 != residents.getStreetCode()) {
                    bl = true;
                    Testutils.log_PrintLn("Streetcodes do not match");
                }
                if (residents2 == null || n4 == residents2.getStreetCode()) continue;
                bl = true;
                Testutils.log_PrintLn("Streetcodes do not match");
            }
            if (n != 50 || n2 != 100) {
                Testutils.log_PrintLn("Number of streets / residents incorrect, no. streets =" + n + " no. resindents = " + n2);
                Testcode_QueryByDLL.failure();
            } else if (bl) {
                Testutils.log_PrintLn("one or more streetcodes do not match");
                Testcode_QueryByDLL.failure();
            } else {
                Testutils.log_Print("no. records (streets) = " + n + " no. records (residents) = " + n2);
                Testutils.log_PrintLn(" = OK ");
            }
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("");
        }
        catch (BoiException boiException) {
            Testcode_QueryByDLL.failure();
            Testutils.log_PrintLn(boiException.toString());
        }
    }

    public static void test_QueryByDLL_StreetsAndResidents_Show() {
        Testutils.log_PrintLn("-------------  Query By DLL Streets,Residents Show ------------");
        Testutils.log_PrintLn("creating & initialize manager");
        try {
            QueryByDLLManager queryByDLLManager = new QueryByDLLManager();
            queryByDLLManager.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Doing QueryByDLL Call, getting street & associated residents");
            Streets streets = queryByDLLManager.QueryByDLLStreets_Show(50);
            if (streets != null) {
                if (streets.getStreetCode() == 49) {
                    Residents residents = streets.getResidentsAt(0);
                    Residents residents2 = streets.getResidentsAt(1);
                    if (residents != null && residents2 != null) {
                        if (residents.getStreetCode() == 49 && residents2.getStreetCode() == 49) {
                            Testutils.log_PrintLn("Records received correctly = OK");
                        }
                    } else {
                        Testutils.log_PrintLn("Error, no associated records received");
                        Testcode_QueryByDLL.failure();
                    }
                } else {
                    Testutils.log_PrintLn("Error, wrong record received");
                    Testcode_QueryByDLL.failure();
                }
            } else {
                Testutils.log_Print("Error in QueryByDLL");
                Testcode_QueryByDLL.failure();
            }
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("");
        }
        catch (BoiException boiException) {
            Testcode_QueryByDLL.failure();
            Testutils.log_PrintLn(boiException.toString());
        }
    }
}

