/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.baan.b3.boi1.BoiApplicationException;
import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BusinessObject;
import com.eibus.test.regression.B3test;
import com.eibus.test.regression.Testutils;
import com.eibus.test.regression.typesafe._struct;
import com.eibus.test.regression.typesafe.arr_struct1;
import com.eibus.test.regression.typesafe.arr_struct2;
import com.eibus.test.regression.typesafe.arr_struct_in;
import com.eibus.test.regression.typesafe.basicTypeManager;
import com.eibus.test.regression.typesafe.booleanreturninoutreturn;
import com.eibus.test.regression.typesafe.bytereturninoutreturn;
import com.eibus.test.regression.typesafe.charreturninoutreturn;
import com.eibus.test.regression.typesafe.copyarraystructreturn;
import com.eibus.test.regression.typesafe.copybooleanreturn;
import com.eibus.test.regression.typesafe.copybytereturn;
import com.eibus.test.regression.typesafe.copycharreturn;
import com.eibus.test.regression.typesafe.copydatereturn;
import com.eibus.test.regression.typesafe.copydatetimereturn;
import com.eibus.test.regression.typesafe.copydoublereturn;
import com.eibus.test.regression.typesafe.copyfloatreturn;
import com.eibus.test.regression.typesafe.copyintreturn;
import com.eibus.test.regression.typesafe.copylongreturn;
import com.eibus.test.regression.typesafe.copyshortreturn;
import com.eibus.test.regression.typesafe.copystringreturn;
import com.eibus.test.regression.typesafe.datatypestest;
import com.eibus.test.regression.typesafe.datatypestest2;
import com.eibus.test.regression.typesafe.datatypestestinoutreturn;
import com.eibus.test.regression.typesafe.datereturninoutreturn;
import com.eibus.test.regression.typesafe.datetimereturninoutreturn;
import com.eibus.test.regression.typesafe.doublereturninoutreturn;
import com.eibus.test.regression.typesafe.floatreturninoutreturn;
import com.eibus.test.regression.typesafe.intreturninoutreturn;
import com.eibus.test.regression.typesafe.longreturninoutreturn;
import com.eibus.test.regression.typesafe.noargsreturn;
import com.eibus.test.regression.typesafe.objectreturninout;
import com.eibus.test.regression.typesafe.objectreturninoutreturn;
import com.eibus.test.regression.typesafe.receivingarraystructreturn;
import com.eibus.test.regression.typesafe.sendingarraystructreturn;
import com.eibus.test.regression.typesafe.shortreturninoutreturn;
import com.eibus.test.regression.typesafe.stringreturninoutreturn;
import com.eibus.test.regression.typesafe.testobject;
import java.util.Date;

public class Testcode_Function
extends Testutils {
    public static void test_DLLcall_functionality() {
        block3: {
            Testutils.log_PrintLn("------ DLL calls with all kinds of parameters--------");
            Testutils.log_PrintLn("");
            Testutils.log_Print(" - creating & initialize manager");
            try {
                basicTypeManager basicTypeManager2 = new basicTypeManager();
                basicTypeManager2.initialize(B3test.server_comp);
                if (basicTypeManager2 != null) {
                    Testutils.log_PrintLn(" Ok");
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("  -------------------");
                    Testutils.log_PrintLn("  in & out parameters");
                    Testutils.log_PrintLn("  -------------------");
                    Testutils.log_PrintLn("");
                    Testcode_Function.test_copyboolean(basicTypeManager2);
                    Testcode_Function.test_copybyte(basicTypeManager2);
                    Testcode_Function.test_copychar(basicTypeManager2);
                    Testcode_Function.test_copyshort(basicTypeManager2);
                    Testcode_Function.test_copylong(basicTypeManager2);
                    Testcode_Function.test_copyint(basicTypeManager2);
                    Testcode_Function.test_copyfloat(basicTypeManager2);
                    Testcode_Function.test_copydouble(basicTypeManager2);
                    Testcode_Function.test_copystring(basicTypeManager2);
                    Testcode_Function.test_copystring_extendedAscii(basicTypeManager2);
                    Testcode_Function.test_copystring_preservewhitespace(basicTypeManager2);
                    Testcode_Function.test_copydate(basicTypeManager2);
                    Testcode_Function.test_copydatetime(basicTypeManager2);
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("  -------------------------");
                    Testutils.log_PrintLn("  inout & return parameters");
                    Testutils.log_PrintLn("  -------------------------");
                    Testutils.log_PrintLn("");
                    Testcode_Function.test_booleanreturninout(basicTypeManager2);
                    Testcode_Function.test_bytereturninout(basicTypeManager2);
                    Testcode_Function.test_charreturninout(basicTypeManager2);
                    Testcode_Function.test_shortreturninout(basicTypeManager2);
                    Testcode_Function.test_longreturninout(basicTypeManager2);
                    Testcode_Function.test_intreturninout(basicTypeManager2);
                    Testcode_Function.test_floatreturninout(basicTypeManager2);
                    Testcode_Function.test_doublereturninout(basicTypeManager2);
                    Testcode_Function.test_stringreturninout(basicTypeManager2);
                    Testcode_Function.test_datereturninout(basicTypeManager2);
                    Testcode_Function.test_datetimereturninout(basicTypeManager2);
                    Testcode_Function.test_objectreturninout(basicTypeManager2);
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("  --------------------");
                    Testutils.log_PrintLn("  structured parameter");
                    Testutils.log_PrintLn("  --------------------");
                    Testutils.log_PrintLn("");
                    Testcode_Function.test_copyarraystruct(basicTypeManager2);
                    Testcode_Function.test_datatypetest(basicTypeManager2);
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("  -----------------");
                    Testutils.log_PrintLn("  Unusual DLL calls");
                    Testutils.log_PrintLn("  -----------------");
                    Testutils.log_PrintLn("");
                    Testcode_Function.test_dllerrors(basicTypeManager2);
                    Testcode_Function.test_dllargsreturn(basicTypeManager2);
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn(" - closing this manager");
                    Testutils.log_PrintLn("");
                    basicTypeManager2.close();
                    break block3;
                }
                Testutils.log_PrintLn(" failed !");
                B3test.failure();
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn(boiException.toString());
                B3test.failure();
            }
        }
    }

    public static void test_DLLcall_bytes_perf() {
        block5: {
            Testutils.startTest("DLL Performance");
            Testutils.log_Print("creating & initialize manager");
            try {
                basicTypeManager basicTypeManager2 = new basicTypeManager();
                basicTypeManager2.initialize(B3test.server_comp);
                if (basicTypeManager2 != null) {
                    Testutils.log_PrintLn(" Ok");
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("sending data to server");
                    int n = 1;
                    while (n <= 10) {
                        Testcode_Function.test_arraystructinPerf(basicTypeManager2, n * 50);
                        ++n;
                    }
                    Testutils.log_PrintLn(" Ok");
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("receiving data from server");
                    n = 1;
                    while (n <= 10) {
                        Testcode_Function.test_arraystructOutPerf(basicTypeManager2, n * 50);
                        ++n;
                    }
                    Testutils.log_PrintLn("");
                    Testutils.log_PrintLn("closing this manager");
                    Testutils.log_PrintLn("");
                    basicTypeManager2.close();
                    break block5;
                }
                Testutils.log_PrintLn(" failed !");
                Testutils.endTest(false);
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn(boiException.toString());
                Testutils.endTest(false);
            }
        }
    }

    public static void test_DLLcall_calls_perf() {
        Testutils.log_PrintLn("------------- DLL call performance --------------------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("creating & initialize manager");
        try {
            basicTypeManager basicTypeManager2 = new basicTypeManager();
            basicTypeManager2.initialize(B3test.server_comp);
            if (basicTypeManager2 != null) {
                Testutils.log_PrintLn(" Ok");
                Testutils.log_PrintLn("");
                long l = 0L;
                long l2 = new Date().getTime();
                long l3 = 1L;
                while (l3 <= 25L) {
                    copylongreturn copylongreturn2 = basicTypeManager2.copylong(100);
                    Testutils.log_PrintCounter(++l);
                    copydoublereturn copydoublereturn2 = basicTypeManager2.copydouble(111.111);
                    Testutils.log_PrintCounter(++l);
                    copystringreturn copystringreturn2 = basicTypeManager2.copystring("just a string");
                    Testutils.log_PrintCounter(++l);
                    copydatereturn copydatereturn2 = basicTypeManager2.copydate("1999-06-07");
                    Testutils.log_PrintCounter(++l);
                    copydatetimereturn copydatetimereturn2 = basicTypeManager2.copydatetime(new Date());
                    Testutils.log_PrintCounter(++l);
                    longreturninoutreturn longreturninoutreturn2 = basicTypeManager2.longreturninout(200);
                    Testutils.log_PrintCounter(++l);
                    doublereturninoutreturn doublereturninoutreturn2 = basicTypeManager2.doublereturninout(222.222);
                    Testutils.log_PrintCounter(++l);
                    stringreturninoutreturn stringreturninoutreturn2 = basicTypeManager2.stringreturninout("just another string");
                    Testutils.log_PrintCounter(++l);
                    datereturninoutreturn datereturninoutreturn2 = basicTypeManager2.datereturninout("1992-02-30");
                    Testutils.log_PrintCounter(++l);
                    datetimereturninoutreturn datetimereturninoutreturn2 = basicTypeManager2.datetimereturninout(new Date());
                    Testutils.log_PrintCounter(++l);
                    ++l3;
                }
                l2 = new Date().getTime() - l2;
                double d = l2;
                d = 250.0 / (d / 1000.0);
                Testutils.log_PrintLn("250 simple dll calls took " + l2 + " msec");
                Testutils.log_PrintLn("This results in " + d + " calls/sec");
            }
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("closing this manager");
            Testutils.log_PrintLn("");
            basicTypeManager2.close();
        }
        catch (BoiException boiException) {
            Testutils.log_Print("BoiException in datetimereturninout");
            Testutils.log_Print(boiException.toString());
            Testutils.endTest(false);
        }
    }

    public static void test_copyboolean(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with boolean in, out");
            try {
                boolean bl = true;
                boolean bl2 = false;
                copybooleanreturn copybooleanreturn2 = basicTypeManager2.copyboolean(bl);
                bl2 = copybooleanreturn2.getBoolean2();
                long l = copybooleanreturn2.getCopyboolean();
                if (l == 0L & bl == bl2) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.log_PrintLn("Data error.");
                Testutils.endTest(false);
            }
            catch (BoiException boiException) {
                Testutils.log_Print(boiException.toString());
                Testutils.endTest(false);
            }
        }
    }

    public static void test_copybyte(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with byte in, out");
            try {
                byte by = 100;
                byte by2 = 0;
                copybytereturn copybytereturn2 = basicTypeManager2.copybyte(by);
                by2 = copybytereturn2.getByte2();
                long l = copybytereturn2.getCopybyte();
                if (l == 0L & by == by2) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.log_Print("Data error.");
                Testutils.endTest(false);
            }
            catch (BoiException boiException) {
                Testutils.log_Print("BoiException in copybyte");
                Testutils.log_Print(boiException.toString());
                Testutils.endTest(false);
            }
        }
    }

    public static void test_copychar(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with char in, out");
            try {
                char c = 'A';
                int n = 66;
                copycharreturn copycharreturn2 = basicTypeManager2.copychar(c);
                n = copycharreturn2.getChar2();
                long l = copycharreturn2.getCopychar();
                if (l == 0L & c == n) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.log_Print("Data error.");
                Testutils.endTest(false);
            }
            catch (BoiException boiException) {
                Testutils.log_Print("BoiException in copychar");
                Testutils.log_Print(boiException.toString());
                Testutils.endTest(false);
            }
        }
    }

    public static void test_copyshort(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with short in, out");
            try {
                short s = 1234;
                short s2 = 0;
                copyshortreturn copyshortreturn2 = basicTypeManager2.copyshort(s);
                s2 = copyshortreturn2.getShort2();
                long l = copyshortreturn2.getCopyshort();
                if (l == 0L & s == s2) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.log_Print("copyshort data error,   ");
                Testutils.endTest(false);
            }
            catch (BoiException boiException) {
                Testutils.log_Print("BoiException in copyshort");
                Testutils.log_Print(boiException.toString());
                Testutils.endTest(false);
            }
        }
    }

    public static void test_copylong(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with long in, out");
            try {
                long l = 1234L;
                long l2 = 0L;
                copylongreturn copylongreturn2 = basicTypeManager2.copylong((int)l);
                l2 = copylongreturn2.getLong2();
                long l3 = copylongreturn2.getCopylong();
                if (l3 == 0L & l == l2) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.log_Print("Data error");
                Testutils.endTest(false);
            }
            catch (BoiException boiException) {
                Testutils.log_Print(boiException.toString());
                Testutils.endTest(false);
            }
        }
    }

    public static void test_copyint(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with int in, out");
            try {
                int n = 1234;
                int n2 = 0;
                copyintreturn copyintreturn2 = basicTypeManager2.copyint(n);
                n2 = copyintreturn2.getInt2();
                int n3 = copyintreturn2.getCopyint();
                if (n3 == 0 & n == n2) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("copyint data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copyint");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_copyfloat(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with float in, out");
            try {
                float f = 12.1f;
                float f2 = 0.0f;
                copyfloatreturn copyfloatreturn2 = basicTypeManager2.copyfloat(f);
                f2 = copyfloatreturn2.getFloat2();
                long l = copyfloatreturn2.getCopyfloat();
                if (l == 0L & f == f2) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("copyfloat data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copyfloat");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_copydouble(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with double in, out");
            try {
                double d = 12345.1234;
                double d2 = 0.0;
                copydoublereturn copydoublereturn2 = basicTypeManager2.copydouble(d);
                d2 = copydoublereturn2.getDouble2();
                long l = copydoublereturn2.getCopydouble();
                if (l == 0L & d == d2) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("copydouble data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copydouble");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_copystring(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with string in, out");
            try {
                String string = "This is a test string - Baan Development B.V. All rights reserved";
                String string2 = "";
                copystringreturn copystringreturn2 = basicTypeManager2.copystring(string);
                string2 = copystringreturn2.getString2();
                long l = copystringreturn2.getCopystring();
                if (l == 0L & string.equals(string2)) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("copystring data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copystring");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_copystring_extendedAscii(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with extended string in, out");
            try {
                String string = "\u00a9\u00ae\u00a5\u00b6\u00bc\u00bd\u00d0\u00de Baan Development B.V. All rights reserved";
                String string2 = "";
                copystringreturn copystringreturn2 = basicTypeManager2.copystring(string);
                string2 = copystringreturn2.getString2();
                long l = copystringreturn2.getCopystring();
                if (l == 0L & string.equals(string2)) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_PrintLn("copystring extended ASCII data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copystringextendedAscii");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_copystring_preservewhitespace(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with string with whitespaces in, out");
            try {
                Character c = new Character('\r');
                Character c2 = new Character('\n');
                Character c3 = new Character('\t');
                String string = "A " + c + " String " + c3 + " with " + c + " some whitespace return:" + c + " linefeed:" + c2 + " tab:" + c3 + ".";
                String string2 = "A " + c + " String " + c3 + " with " + c + " some whitespace return:" + c + " linefeed:" + c + " tab:" + c3 + ".";
                String string3 = "";
                copystringreturn copystringreturn2 = basicTypeManager2.copystring(string);
                string3 = copystringreturn2.getString2();
                long l = copystringreturn2.getCopystring();
                if (l == 0L & string2.equals(string2)) {
                    Testutils.endTest(true);
                    break block3;
                }
                System.out.println("String send:");
                System.out.println(Testcode_Function.printBytes(string));
                System.out.println("String received:");
                System.out.println(Testcode_Function.printBytes(string3));
                System.out.println("String to compare with:");
                System.out.println(Testcode_Function.printBytes(string2));
                Testutils.endTest(false);
                Testutils.log_PrintLn("copystring preserve whitespace data error.   ");
                Testutils.log_PrintLn("   hint: Check portingset version (7.1c02, 6.1c06.03) and BaanERP dump version (2.4 and up).");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copystringextendedAscii");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    private static String printBytes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("length = " + string.length() + ", ");
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            Character c = byArray[n] < 20 ? new Character('?') : new Character((char)byArray[n]);
            String string2 = Integer.toHexString(byArray[n]);
            string2 = string2.length() == 1 ? "0x0" + string2 : "0x" + string2;
            stringBuffer.append(c + "(" + string2 + ") ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void test_copydate(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with date in, out");
            try {
                String string = "1997-07-06";
                copydatereturn copydatereturn2 = basicTypeManager2.copydate(string);
                String string2 = copydatereturn2.getDate2();
                int n = copydatereturn2.getCopydate();
                if (n == 0 & string.equals(string2)) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_PrintLn("copydate data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copydate");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_copydatetime(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with datetime in, out");
            try {
                Date date = new Date();
                copydatetimereturn copydatetimereturn2 = basicTypeManager2.copydatetime(date);
                Date date2 = copydatetimereturn2.getDatetime2();
                int n = copydatetimereturn2.getCopydatetime();
                if (n == 0 & date.toString().equals(date2.toString())) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_PrintLn("copydatetime data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in copydatetime");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_booleanreturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with boolean inout & return");
            try {
                boolean bl = false;
                boolean bl2 = false;
                booleanreturninoutreturn booleanreturninoutreturn2 = basicTypeManager2.booleanreturninout(bl);
                bl = booleanreturninoutreturn2.get_boolean();
                bl2 = booleanreturninoutreturn2.getBooleanreturninout();
                if (bl2 & bl) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_PrintLn("booleanreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in booleanreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_bytereturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with byte inout & return");
            try {
                byte by = 50;
                bytereturninoutreturn bytereturninoutreturn2 = basicTypeManager2.bytereturninout(by);
                by = bytereturninoutreturn2.get_byte();
                byte by2 = bytereturninoutreturn2.getBytereturninout();
                if (by2 == 100 & by == 100) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("bytereturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in bytereturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_charreturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with char inout & return");
            try {
                char c = 'A';
                charreturninoutreturn charreturninoutreturn2 = basicTypeManager2.charreturninout(c);
                c = charreturninoutreturn2.get_char();
                char c2 = charreturninoutreturn2.getCharreturninout();
                if (c2 == 'B' & c == 'B') {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("charreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in charreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_shortreturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with short inout & return");
            try {
                short s = 1234;
                shortreturninoutreturn shortreturninoutreturn2 = basicTypeManager2.shortreturninout(s);
                s = shortreturninoutreturn2.get_short();
                short s2 = shortreturninoutreturn2.getShortreturninout();
                if (s2 == 2468 & s == 2468) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("shortreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in shortreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_longreturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with long inout & return");
            try {
                int n = 1234;
                longreturninoutreturn longreturninoutreturn2 = basicTypeManager2.longreturninout(n);
                n = longreturninoutreturn2.get_long();
                int n2 = longreturninoutreturn2.getLongreturninout();
                if (n2 == 2468 & n == 2468) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("longreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in longreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_intreturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with int inout & return");
            try {
                int n = 1234;
                intreturninoutreturn intreturninoutreturn2 = basicTypeManager2.intreturninout(n);
                n = intreturninoutreturn2.get_int();
                int n2 = intreturninoutreturn2.getIntreturninout();
                if (n2 == 2468 & n == 2468) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("intreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in intreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_doublereturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with double inout & return");
            try {
                double d = 12.1234;
                doublereturninoutreturn doublereturninoutreturn2 = basicTypeManager2.doublereturninout(d);
                d = doublereturninoutreturn2.get_double();
                double d2 = doublereturninoutreturn2.getDoublereturninout();
                if (d2 == 24.2468 & d == 24.2468) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("doublereturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in doublereturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_floatreturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with float inout & return");
            try {
                float f = 1.12f;
                floatreturninoutreturn floatreturninoutreturn2 = basicTypeManager2.floatreturninout(f);
                f = floatreturninoutreturn2.get_float();
                float f2 = floatreturninoutreturn2.getFloatreturninout();
                if (f2 == 2.24f & f == 2.24f) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("floatreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in floatreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_stringreturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with string inout & return");
            try {
                String string = "the string set in the client";
                stringreturninoutreturn stringreturninoutreturn2 = basicTypeManager2.stringreturninout(string);
                string = stringreturninoutreturn2.get_string();
                String string2 = stringreturninoutreturn2.getStringreturninout();
                if (string2.equals(string)) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("stringreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in stringreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_datereturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with date inout & return");
            try {
                String string = "1997-01-02";
                datereturninoutreturn datereturninoutreturn2 = basicTypeManager2.datereturninout(string);
                string = datereturninoutreturn2.get_date();
                String string2 = datereturninoutreturn2.getDatereturninout();
                if (string2.equals(string)) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("datereturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in datereturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_datetimereturninout(basicTypeManager basicTypeManager2) {
        block3: {
            Testutils.startTest("DLL call with datetime inout & return");
            try {
                Date date = new Date();
                datetimereturninoutreturn datetimereturninoutreturn2 = basicTypeManager2.datetimereturninout(date);
                date = datetimereturninoutreturn2.get_datetime();
                Date date2 = datetimereturninoutreturn2.getDatetimereturninout();
                if (date2.toString().equals(date.toString())) {
                    Testutils.endTest(true);
                    break block3;
                }
                Testutils.endTest(false);
                Testutils.log_Print("datetimereturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in datetimereturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_objectreturninout(basicTypeManager basicTypeManager2) {
        block4: {
            Testutils.startTest("DLL call with object inout & return");
            try {
                testobject testobject2 = new testobject();
                testobject2.setName("ferrari");
                testobject2.setValue(300000);
                objectreturninoutreturn objectreturninoutreturn2 = basicTypeManager2.objectreturninout(testobject2);
                testobject testobject3 = objectreturninoutreturn2.getTestobject();
                objectreturninout objectreturninout2 = objectreturninoutreturn2.getObjectreturninout();
                testobject testobject4 = objectreturninout2.getTestobject();
                if (testobject3 == null || testobject4 == null) {
                    Testutils.endTest(false);
                    Testutils.log_Print("objectreturninout data error, bo = null   ");
                    return;
                }
                String string = testobject2.getName();
                String string2 = testobject3.getName();
                String string3 = testobject4.getName();
                int n = testobject2.getValue();
                int n2 = testobject3.getValue();
                int n3 = testobject4.getValue();
                if (testobject3.getName().equals(testobject2.getName()) && testobject3.getValue() == 2 * testobject2.getValue() && testobject4.getName().equals("copy of " + testobject2.getName()) && testobject4.getValue() == testobject2.getValue()) {
                    Testutils.endTest(true);
                    break block4;
                }
                Testutils.endTest(false);
                Testutils.log_Print("objectreturninout data error,   ");
            }
            catch (BoiException boiException) {
                Testutils.endTest(false);
                Testutils.log_Print("BoiException in objectreturninout");
                Testutils.log_Print(boiException.toString());
            }
        }
    }

    public static void test_copyarraystruct(basicTypeManager basicTypeManager2) {
        Testutils.startTest("DLL call with an in & out of an arraystruct");
        try {
            BusinessObject businessObject;
            arr_struct1 arr_struct12 = new arr_struct1();
            int n = 0;
            while (n < 10) {
                businessObject = new _struct();
                ((_struct)businessObject).set_long1_(n);
                ((_struct)businessObject).set_double1_(Double.valueOf("" + n));
                ((_struct)businessObject).set_string1_("" + n);
                ((_struct)businessObject).set_date1_(new Date(n).toString());
                ((_struct)businessObject).set_datetime1_(new Date(n));
                ((_struct)businessObject).set_long2_(n);
                ((_struct)businessObject).set_double2_(Double.valueOf("" + n));
                ((_struct)businessObject).set_string2_("" + n);
                ((_struct)businessObject).set_date2_(new Date(n).toString());
                ((_struct)businessObject).set_datetime2_(new Date(n));
                arr_struct12.add_struct((_struct)businessObject);
                ++n;
            }
            businessObject = basicTypeManager2.copyarraystruct(arr_struct12);
            arr_struct2 arr_struct22 = ((copyarraystructreturn)businessObject).getArr_struct2();
            int n2 = ((copyarraystructreturn)businessObject).getCopyarraystruct();
            n = 0;
            while (n < 10) {
                String string;
                String string2;
                _struct _struct2 = arr_struct12.get_structAt(n);
                _struct _struct3 = arr_struct22.get_structAt(n);
                if (_struct3 == null) {
                    Testutils.endTest(false);
                    Testutils.log_Print("struct2 data error, bo = null   ");
                    return;
                }
                if (_struct2.get_long1_() != _struct3.get_long1_()) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error long1");
                }
                if (_struct2.get_double1_() != _struct3.get_double1_()) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error double1");
                }
                if (!(string2 = _struct2.get_string1_()).equals(string = _struct3.get_string1_())) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error string1");
                }
                if (!_struct2.get_date1_().equals(_struct3.get_date1_())) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error date1");
                }
                if (!_struct2.get_datetime1_().equals(_struct3.get_datetime1_())) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error datetime1");
                }
                if (_struct2.get_long2_() != _struct3.get_long2_()) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error long2");
                }
                if (_struct2.get_double2_() != _struct3.get_double2_()) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error double2");
                }
                if (!(string2 = _struct2.get_string2_()).equals(string = _struct3.get_string2_())) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error string2");
                }
                if (!_struct2.get_date2_().equals(_struct3.get_date2_())) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error date2");
                }
                if (!_struct2.get_datetime2_().equals(_struct3.get_datetime2_())) {
                    Testutils.endTest(false);
                    Testutils.log_PrintLn("data error datetime2");
                }
                ++n;
            }
            Testutils.endTest(true);
        }
        catch (BoiException boiException) {
            Testutils.endTest(false);
            Testutils.log_Print("BoiException in test_copyarraystruct()");
            Testutils.log_Print(boiException.toString());
        }
    }

    public static void test_arraystructinPerf(basicTypeManager basicTypeManager2, long l) {
        try {
            arr_struct_in arr_struct_in2 = new arr_struct_in();
            int n = 1;
            while ((long)n <= l) {
                _struct _struct2 = new _struct();
                _struct2.set_long1_(n);
                _struct2.set_double1_(Double.valueOf(n + n + "." + n + n));
                _struct2.set_string1_("123456789012345678901234567890");
                _struct2.set_date1_(n + "-09-01");
                _struct2.set_datetime1_(new Date());
                _struct2.set_long2_(n);
                _struct2.set_double2_(Double.valueOf(n + n + "." + n + n));
                _struct2.set_string2_("123456789012345678901234567890");
                _struct2.set_date2_(n + "-09-01");
                _struct2.set_datetime2_(new Date());
                arr_struct_in2.add_struct(_struct2);
                ++n;
            }
            long l2 = new Date().getTime();
            sendingarraystructreturn sendingarraystructreturn2 = basicTypeManager2.sendingarraystruct(arr_struct_in2);
            l2 = new Date().getTime() - l2;
            double d = l2;
            Testutils.log_PrintLn("sending " + l * 100L + " bytes with dll calls took " + l2 + " msec");
            Testutils.log_PrintLn("This results in " + (double)(l / 10L) / (d / 1000.0) + " Kbytes/sec");
            long l3 = sendingarraystructreturn2.getSendingarraystruct();
        }
        catch (BoiException boiException) {
            Testutils.endTest(false);
            Testutils.log_Print("BoiException in test_arraystructinPerf");
            Testutils.log_Print(boiException.toString());
        }
    }

    public static void test_arraystructOutPerf(basicTypeManager basicTypeManager2, int n) {
        try {
            long l = new Date().getTime();
            receivingarraystructreturn receivingarraystructreturn2 = basicTypeManager2.receivingarraystruct(n);
            l = new Date().getTime() - l;
            double d = l;
            Testutils.log_PrintLn("sending " + n * 100 + " bytes with dll calls took " + l + " msec");
            Testutils.log_PrintLn("This results in " + (double)(n / 10) / (d / 1000.0) + " Kbytes/sec");
        }
        catch (BoiException boiException) {
            Testutils.endTest(false);
            Testutils.log_Print("BoiException in test_arraystructOutPerf()");
            Testutils.log_Print(boiException.toString());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static void test_dllerrors(basicTypeManager var0) {
        block8: {
            Testutils.startTest("Invoke a non existing DLL function");
            try {
                var1_1 /* !! */  = var0.nofunc();
                Testutils.log_PrintLn("No exception thrown.");
                Testutils.endTest(false);
            }
            catch (BoiApplicationException var1_2) {
                var2_4 = var1_2.getDescriptors();
                var3_7 = 0;
                ** while (var3_7 < var2_4.length)
            }
lbl-1000:
            // 1 sources

            {
                var4_8 = var2_4[var3_7].getMessage();
                var5_9 = 0;
                while (var5_9 < var4_8.length) {
                    Testutils.log_PrintLn(var4_8[var5_9]);
                    ++var5_9;
                }
                ++var3_7;
                continue;
            }
lbl19:
            // 1 sources

            Testutils.endTest(true);
            break block8;
            catch (BoiException var2_5) {
                Testutils.log_PrintLn("BoiException instead of BusApplicationException, test result : failed");
                Testutils.endTest(false);
            }
        }
        Testutils.startTest("Call a DLL function that results in a fatal exit of the xml handler");
        try {
            var1_1 /* !! */  = var0.dllexit();
            Testutils.log_PrintLn("No exception thrown.");
            Testutils.endTest(false);
        }
        catch (BoiApplicationException var1_3) {
            Testutils.log_PrintLn("BoiApplicationException instead of BoiException, test result : failed");
            Testutils.endTest(false);
        }
        catch (BoiException var2_6) {
            Testutils.log_PrintLn("" + var2_6);
            Testutils.endTest(true);
        }
        Testcode_Function.test_copybyte(var0);
        Testcode_Function.test_copylong(var0);
    }

    public static void test_datatypetest(basicTypeManager basicTypeManager2) {
        Testutils.startTest("DLL func with a BO that has elements and attributes of all types");
        try {
            boolean bl;
            datatypestest2 datatypestest22;
            datatypestest datatypestest3 = new datatypestest();
            datatypestest3.set_string_test("mystringelement");
            datatypestest3.set_string_attribute("mystringattribute");
            datatypestestinoutreturn datatypestestinoutreturn2 = basicTypeManager2.datatypestestinout(datatypestest3);
            if (datatypestestinoutreturn2 == null) {
                Testutils.log_PrintLn("Return struct is null");
                Testutils.endTest(false);
            }
            if (datatypestestinoutreturn2.getDatatypestestinout() != 1) {
                Testutils.log_PrintLn("Return value is not 1");
                Testutils.endTest(false);
            }
            if ((datatypestest22 = datatypestestinoutreturn2.getDatatypestest2()) == null) {
                Testutils.log_PrintLn("Data error: no output argument");
                Testutils.endTest(false);
            }
            datatypestest22.get_i4_attribute();
            boolean bl2 = datatypestest22.has_i4_attribute();
            if (bl2) {
                Testutils.log_PrintLn("Error in return value of has_i4_attribute(). Expected[false]Obtained[true]");
                Testutils.endTest(false);
            }
            if (!(bl = datatypestest22.has_string_attribute())) {
                Testutils.log_PrintLn("Error in return value of has_string_attribute(). Expected[true]Obtained[false]");
                Testutils.endTest(false);
            }
            if (!datatypestest22.get_string_attribute().equals(datatypestest3.get_string_attribute())) {
                Testutils.log_PrintLn("Data error in 'string attribute' Expected[" + datatypestest3.get_string_attribute() + "]" + "Obtained[" + datatypestest22.get_string_attribute() + "]");
                Testutils.endTest(false);
            }
            if (!datatypestest22.get_string_test().equals(datatypestest3.get_string_test())) {
                Testutils.log_PrintLn("Data error in 'string element' Expected[" + datatypestest3.get_string_test() + "]" + "Obtained[" + datatypestest22.get_string_test() + "]");
                Testutils.endTest(false);
            }
        }
        catch (BoiApplicationException boiApplicationException) {
            Testutils.log_Print(boiApplicationException.toString());
            Testutils.log_PrintLn("BoiApplicationException");
            Testutils.endTest(false);
        }
        catch (BoiException boiException) {
            Testutils.log_Print(boiException.toString());
            Testutils.log_PrintLn("BoiException");
            Testutils.endTest(false);
        }
        Testutils.endTest(true);
    }

    public static void test_dllargsreturn(basicTypeManager basicTypeManager2) {
        Testutils.startTest("Invoke a DLL function with no arguments");
        try {
            noargsreturn noargsreturn2 = basicTypeManager2.noargs();
        }
        catch (BoiApplicationException boiApplicationException) {
            Testutils.log_Print(boiApplicationException.toString());
            Testutils.log_PrintLn("BoiApplicationException");
            Testutils.endTest(false);
        }
        catch (BoiException boiException) {
            Testutils.log_Print(boiException.toString());
            Testutils.log_PrintLn("BoiException");
            Testutils.endTest(false);
        }
        Testutils.endTest(true);
        Testutils.startTest("DLL function where parameters do not have the Scope attribute");
        try {
            int n = 1234;
            int n2 = 0;
            copyintreturn copyintreturn2 = basicTypeManager2.copyIntWithoutScope(n);
            n2 = copyintreturn2.getInt2();
            int n3 = copyintreturn2.getCopyint();
            if (n3 != 0 | n != n2) {
                Testutils.endTest(false);
            }
        }
        catch (BoiApplicationException boiApplicationException) {
            Testutils.log_Print(boiApplicationException.toString());
            Testutils.endTest(false);
        }
        catch (BoiException boiException) {
            Testutils.log_Print(boiException.toString());
            Testutils.endTest(false);
        }
        Testutils.endTest(true);
    }
}

