/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.baan.ow.b3.database.DatabaseException;
import com.baan.ow.b3.database.IConnection;
import com.baan.ow.b3.database.IDatabaseInformation;
import com.baan.ow.b3.database.IDatabaseMetaData;
import com.baan.ow.b3.database.IParameterMetaData;
import com.baan.ow.b3.database.IPreparedStatement;
import com.baan.ow.b3.database.IResultSet;
import com.baan.ow.b3.database.IResultSetMetaData;
import com.baan.ow.b3.database.IStatement;
import com.baan.owimpl.b3.database.Connection;
import com.eibus.test.regression.B3test;
import com.eibus.test.regression.Testutils;
import com.eibus.test.regression.ThreadingTest;

public class Testcode_Database {
    public static void testDBConnection() {
        Testutils.log_PrintLn("-----------| Database Connections Test |-----------");
        Testutils.log_PrintLn("");
        try {
            Testutils.log_PrintLn("Create and close one connection");
            Testutils.setPrefix("      -");
            IConnection iConnection = Testcode_Database.create_connection(-1);
            Testcode_Database.close_connection(iConnection);
            Testutils.setPrefix("  ");
            Testutils.log_PrintLn("Create and close few connections");
            Testutils.setPrefix("      -");
            IConnection iConnection2 = Testcode_Database.create_connection(-1);
            IConnection iConnection3 = Testcode_Database.create_connection(-1);
            IConnection iConnection4 = Testcode_Database.create_connection(-1);
            Testcode_Database.close_connection(iConnection4);
            Testcode_Database.close_connection(iConnection2);
            IConnection iConnection5 = Testcode_Database.create_connection(-1);
            Testcode_Database.close_connection(iConnection3);
            Testcode_Database.close_connection(iConnection5);
            Testutils.setPrefix("  ");
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static IConnection create_connection(int n) throws DatabaseException {
        return Testcode_Database.create_connection("COMPNR=" + n);
    }

    public static IConnection create_connection(String string) throws DatabaseException {
        int n = 1;
        String string2 = System.getProperty("API");
        if (string2 == null) {
            string2 = "";
        }
        if (string2.equalsIgnoreCase("ODBC2")) {
            n = 0;
            Testutils.log_PrintLn("Client API type is set to " + string2);
        } else if (string2.equalsIgnoreCase("ODBC3")) {
            n = 0;
            Testutils.log_PrintLn("Client API type is set to " + string2);
        } else if (string2.equalsIgnoreCase("JDBC")) {
            n = 2;
            Testutils.log_PrintLn("Client API type is set to " + string2);
        } else {
            Testutils.log_PrintLn("Client API TYPE is not set, defaulting to ODBC3");
        }
        IConnection iConnection = null;
        Testutils.log_PrintLn("Create Connection ('" + B3test.server_comp + "', options = " + string + ") ...");
        iConnection = Connection.createConnection(B3test.server_comp, null, null, string, n);
        Testutils.log_PrintLn("DatabaseProductName    = '" + iConnection.getDatabaseProductName() + "'");
        Testutils.log_PrintLn("DatabaseProductVersion = '" + iConnection.getDatabaseProductVersion() + "'");
        return iConnection;
    }

    public static void close_connection(IConnection iConnection) throws DatabaseException {
        if (iConnection != null) {
            Testutils.log_PrintLn("Close Database Connection");
            iConnection.close();
        }
    }

    public static void printDatabaseException(DatabaseException databaseException) {
        Testutils.log_PrintLn("Database Exception occured");
        Testutils.log_PrintLn("Message = '" + databaseException.getMessage() + "'");
        Testutils.log_PrintLn("Code    = '" + databaseException.getErrorCode() + "'");
        Testutils.log_PrintLn("SQLState= '" + databaseException.getSQLState() + "'");
    }

    public static void testLabels() {
        Testutils.log_PrintLn("-----------| Label Testing |-----------");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Enter first part of table name");
        Testutils.log_Print(" >> ");
        String string = Testutils.ReadLine();
        IConnection iConnection = null;
        try {
            iConnection = Testcode_Database.create_connection(-1);
            IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
            IResultSet iResultSet = iDatabaseMetaData.getTables(string + "%", "TABLE");
            while (iResultSet.next()) {
                Testutils.log_PrintLn("");
                Testutils.log_PrintLn("TABLE  " + iResultSet.getRawData(3) + " - " + iResultSet.getRawData(5));
                IResultSet iResultSet2 = iDatabaseMetaData.getColumns(iResultSet.getRawData(3), null);
                while (iResultSet2.next()) {
                    Testutils.log_PrintLn("COLUMN " + iResultSet2.getRawData(3) + "." + iResultSet2.getRawData(4) + " - " + iResultSet2.getRawData(12));
                }
                iResultSet2.close();
            }
            iResultSet.close();
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            Testcode_Database.close_connection(iConnection);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static void testDatabaseInformation() {
        Testutils.log_PrintLn("-----------| Show Database Information |-----------");
        IConnection iConnection = null;
        try {
            iConnection = Testcode_Database.create_connection(-1);
            String string = iConnection.getDatabaseProductName();
            String string2 = iConnection.getDatabaseProductVersion();
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("Backend properties:");
            Testutils.setPrefix("     ");
            Testutils.log_PrintLn("Name    = " + string);
            Testutils.log_PrintLn("Version = " + string2);
            Testutils.log_PrintLn("");
            Testutils.setPrefix("");
            IDatabaseInformation iDatabaseInformation = iConnection.getInformation();
            Testutils.log_PrintLn(iDatabaseInformation.toString());
            Testutils.setPrefix("  ");
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            Testcode_Database.close_connection(iConnection);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static void testExecuteQuery(String string) {
        Object object;
        String string2;
        Testutils.log_PrintLn("-----------| Database Execute Query Test |-----------");
        int n = -1;
        if (string == null) {
            Testutils.log_PrintLn("Enter the query to execute");
            Testutils.log_Print("query  = ");
            string2 = Testutils.ReadLine();
            Testutils.log_PrintLn("Enter the company number (optional)");
            Testutils.log_Print("compnr = ");
            object = Testutils.ReadLine();
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {}
        } else {
            string2 = string;
            Testutils.log_PrintLn("query  = " + string2);
            n = -1;
        }
        object = null;
        IStatement iStatement = null;
        Testutils.log_PrintLn("");
        try {
            object = Testcode_Database.create_connection(n);
            long l = System.currentTimeMillis();
            Testutils.log_PrintLn("Create statement");
            iStatement = object.createStatement();
            Testutils.log_PrintLn("Fetch Size    = " + iStatement.getFetchSize());
            Testutils.log_PrintLn("Query Timeout = " + iStatement.getQueryTimeout());
            Testutils.log_PrintLn("Execute query...");
            IResultSet iResultSet = iStatement.executeQuery(string2);
            Testutils.log_PrintLn("print resultset");
            Testcode_Database.displayResultSet(iResultSet);
            long l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            if (iStatement != null) {
                iStatement.close();
            }
            Testcode_Database.close_connection((IConnection)object);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static void testExecuteQuery(String string, String string2) {
        Testutils.log_PrintLn("-----| Database Execute Query Test With Options |----");
        String string3 = string;
        String string4 = string2;
        if (string3 == null) {
            Testutils.log_PrintLn("Enter the query to execute");
            Testutils.log_Print("query = ");
            string3 = Testutils.ReadLine();
        }
        Testutils.log_PrintLn("query = " + string3);
        if (string4 == null) {
            Testutils.log_PrintLn("Enter the options (odbc connection string)");
            Testutils.log_Print("options = ");
            string4 = Testutils.ReadLine();
        }
        Testutils.log_PrintLn("options = " + string4);
        IConnection iConnection = null;
        IStatement iStatement = null;
        Testutils.log_PrintLn("");
        try {
            iConnection = Testcode_Database.create_connection(string4);
            long l = System.currentTimeMillis();
            Testutils.log_PrintLn("Create statement");
            iStatement = iConnection.createStatement();
            Testutils.log_PrintLn("Fetch Size    = " + iStatement.getFetchSize());
            Testutils.log_PrintLn("Query Timeout = " + iStatement.getQueryTimeout());
            Testutils.log_PrintLn("Execute query...");
            IResultSet iResultSet = iStatement.executeQuery(string3);
            Testutils.log_PrintLn("print resultset");
            Testcode_Database.displayResultSet(iResultSet);
            long l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            if (iStatement != null) {
                iStatement.close();
            }
            Testcode_Database.close_connection(iConnection);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static void testExecuteQueryParams(String string, String string2) {
        Testutils.log_PrintLn("-----| Database Execute Query Test With Options |----");
        String string3 = string;
        String string4 = string2;
        if (string3 == null) {
            Testutils.log_PrintLn("Enter the query to execute");
            Testutils.log_Print("query = ");
            string3 = Testutils.ReadLine();
        }
        Testutils.log_PrintLn("query = " + string3);
        if (string4 == null) {
            Testutils.log_PrintLn("Enter the options (odbc connection string)");
            Testutils.log_Print("options = ");
            string4 = Testutils.ReadLine();
        }
        Testutils.log_PrintLn("options = " + string4);
        IConnection iConnection = null;
        Object var5_5 = null;
        Testutils.log_PrintLn("");
        try {
            Object object;
            int n;
            Object object2;
            iConnection = Testcode_Database.create_connection(string4);
            long l = System.currentTimeMillis();
            Testutils.log_Print("Prepare statement...");
            IPreparedStatement iPreparedStatement = iConnection.prepareStatement(string3);
            Testutils.log_PrintLn("Ok");
            Testutils.log_PrintLn("");
            Testutils.log_Print("Get parameter Metadata...");
            IParameterMetaData iParameterMetaData = iPreparedStatement.getParameterMetaData();
            int n2 = iParameterMetaData.getParameterCount();
            Testutils.log_PrintLn("Ok, found " + n2 + " parameters");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("Please enter all the parameters (as String)...");
            int n3 = 1;
            while (n3 < n2 + 1) {
                object2 = iParameterMetaData.getParameterTypeName(n3);
                n = iParameterMetaData.getParameterType(n3);
                Testutils.log_PrintLn("Get parameter " + n3 + " ( " + (String)object2 + " ( " + n + " ) )");
                Testutils.log_Print("value = ");
                object = Testutils.ReadLine();
                iPreparedStatement.setParameter(n3, (String)object);
                ++n3;
            }
            Testutils.log_PrintLn("Execute query...");
            Testutils.log_PrintLn("Fetch Size    = " + iPreparedStatement.getFetchSize());
            Testutils.log_PrintLn("Query Timeout = " + iPreparedStatement.getQueryTimeout());
            object2 = iPreparedStatement.executeQuery();
            Testutils.log_PrintLn("print resultset");
            Testcode_Database.displayResultSet((IResultSet)object2);
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("Nog een keertje...");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("clearParameters");
            iPreparedStatement.clearParameters();
            n = 1;
            while (n < n2 + 1) {
                object = iParameterMetaData.getParameterTypeName(n);
                int n4 = iParameterMetaData.getParameterType(n);
                Testutils.log_PrintLn("Get parameter " + n + " ( " + (String)object + " ( " + n4 + " ) )");
                Testutils.log_Print("value = ");
                String string5 = Testutils.ReadLine();
                iPreparedStatement.setParameter(n, string5);
                ++n;
            }
            Testutils.log_PrintLn("Execute query...");
            Testutils.log_PrintLn("Fetch Size    = " + iPreparedStatement.getFetchSize());
            Testutils.log_PrintLn("Query Timeout = " + iPreparedStatement.getQueryTimeout());
            object = iPreparedStatement.executeQuery();
            Testutils.log_PrintLn("print resultset");
            Testcode_Database.displayResultSet((IResultSet)object);
            iPreparedStatement.close();
            long l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            Testcode_Database.close_connection(iConnection);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static void testMetaDataTable() {
        Testutils.log_PrintLn("-----------| Database Metadata Test |-----------");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Enter the table name");
        Testutils.log_Print("table = ");
        String string = Testutils.ReadLine();
        Testutils.log_PrintLn("Enter the second table name for crossref (optional)");
        String string2 = "";
        Testutils.log_Print("table = ");
        string2 = Testutils.ReadLine();
        IConnection iConnection = null;
        try {
            iConnection = Testcode_Database.create_connection(-1);
            Testutils.log_PrintLn("get DatabaseMetadata");
            IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
            Testutils.log_PrintLn("get table '" + string + "' (TABLE)");
            long l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getTables(string, "TABLE"));
            long l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get table '" + string + "' (SYSTEM TABLE)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getTables(string, "SYSTEM TABLE"));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get columns ('" + string + "')");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getColumns(string, null));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get columns ('" + string + "')");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getSpecialColumns(string, 0, 0, 0));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Primary Keys ('" + string + "')");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getPrimaryKeys(string));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Index Info ('" + string + "')");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getIndexInfo(string, true, true));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Exported Keys ('" + string + "')");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getExportedKeys(string));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Imported Keys ('" + string + "')");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getImportedKeys(string));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            if (string2.length() > 0) {
                Testutils.log_PrintLn("get CrossReference ('" + string + "' & '" + string2 + "')");
                l = System.currentTimeMillis();
                Testcode_Database.displayResultSet(iDatabaseMetaData.getCrossReference(string, string2));
                l2 = System.currentTimeMillis();
                Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
                Testutils.log_PrintLn("");
            }
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            Testcode_Database.close_connection(iConnection);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static void testDBConnectionThreads() {
        Testutils.log_PrintLn("-----------| Database Threading test multiple Connection |-----------");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Enter the number of threads/connections (default=10)");
        Testutils.log_Print("threads = ");
        String string = Testutils.ReadLine();
        int n = 10;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ThreadingTest[] threadingTestArray = new ThreadingTest[n];
            int n2 = 0;
            while (n2 < n) {
                threadingTestArray[n2] = new ThreadingTest(null, false);
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                threadingTestArray[n3].start();
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                try {
                    threadingTestArray[n4].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n4;
            }
        }
        catch (Exception exception) {}
    }

    public static void testThreadingMultipleConnection() {
        Testutils.log_PrintLn("-----------| Database Threading test multiple Connection |-----------");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("    Try to get 100 users from usertable simultaneously");
        Testutils.log_PrintLn("    from different threads, using multiple connections");
        Testutils.log_PrintLn("    (select * from ttaad200 as set with 100 rows)");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Enter the number of threads (default=10)");
        Testutils.log_Print("threads = ");
        String string = Testutils.ReadLine();
        int n = 10;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ThreadingTest[] threadingTestArray = new ThreadingTest[n];
            int n2 = 0;
            while (n2 < n) {
                threadingTestArray[n2] = new ThreadingTest(null, true);
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                threadingTestArray[n3].start();
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                try {
                    threadingTestArray[n4].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n4;
            }
        }
        catch (Exception exception) {}
    }

    public static void testThreadingOneConnection() {
        Testutils.log_PrintLn("-----------| Database Threading test one Connection |-----------");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("    Try to get 100 users from usertable simultaneously");
        Testutils.log_PrintLn("    from different threads, using one connection");
        Testutils.log_PrintLn("    (select * from ttaad200 as set with 100 rows)");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("Enter the number of threads (default=10)");
        Testutils.log_Print("threads = ");
        String string = Testutils.ReadLine();
        int n = 10;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IConnection iConnection = null;
        try {
            iConnection = Testcode_Database.create_connection(0);
            ThreadingTest[] threadingTestArray = new ThreadingTest[n];
            int n2 = 0;
            while (n2 < n) {
                threadingTestArray[n2] = new ThreadingTest(iConnection, true);
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                threadingTestArray[n3].start();
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                try {
                    threadingTestArray[n4].join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n4;
            }
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            Testcode_Database.close_connection(iConnection);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static void testMetaData() {
        Testutils.log_PrintLn("-----------| Database Metadata Test |-----------");
        Testutils.log_PrintLn("");
        IConnection iConnection = null;
        try {
            iConnection = Testcode_Database.create_connection(-1);
            Testutils.log_PrintLn("get DatabaseMetadata");
            IDatabaseMetaData iDatabaseMetaData = iConnection.getDatabaseMetaData();
            Testutils.log_PrintLn("get all types");
            long l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getTypeInfo(0));
            long l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get all tables (TABLE)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getTables(null, "TABLE"));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get all tables (SYSTEM TABLE)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getTables(null, "SYSTEM TABLE"));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get columns (tmboa120)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getColumns("tmboa120", null));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Primary Keys (tmboa100)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getPrimaryKeys("tmboa100"));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Exported Keys (tmboa100)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getExportedKeys("tmboa100"));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Imported Keys (tmboa110)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getImportedKeys("tmboa110"));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Cross Reference (tmboa100, tmboa110)");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getCrossReference("tmboa100", "tmboa110"));
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
            Testutils.log_PrintLn("get Table Types");
            l = System.currentTimeMillis();
            Testcode_Database.displayResultSet(iDatabaseMetaData.getTableTypes());
            l2 = System.currentTimeMillis();
            Testutils.log_PrintLn("query and display took " + (l2 - l) + " ms.");
            Testutils.log_PrintLn("");
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
        try {
            Testcode_Database.close_connection(iConnection);
        }
        catch (DatabaseException databaseException) {
            Testcode_Database.printDatabaseException(databaseException);
        }
    }

    public static String format(String string) {
        String string2 = "                      ";
        string = " " + string + string2;
        return string.substring(0, 20);
    }

    public static void loopResultSet(IResultSet iResultSet) {
        long l = System.currentTimeMillis();
        try {
            IResultSetMetaData iResultSetMetaData;
            try {
                iResultSetMetaData = iResultSet.getMetaData();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return;
            }
            Testutils.log_PrintLn("");
            int n = iResultSetMetaData.getColumnCount();
            while (iResultSet.next()) {
                int n2 = 0;
                while (n2 < n) {
                    iResultSet.getRawData(n2 + 1);
                    ++n2;
                }
            }
            long l2 = System.currentTimeMillis();
            System.out.println("loop took " + (l2 - l) + " ms.");
            System.out.println("");
        }
        catch (DatabaseException databaseException) {
            System.out.print("ERROR " + databaseException.getMessage());
        }
    }

    public static void displayResultSet(IResultSet iResultSet) {
        try {
            IResultSetMetaData iResultSetMetaData;
            try {
                iResultSetMetaData = iResultSet.getMetaData();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return;
            }
            int n = iResultSetMetaData.getColumnCount();
            System.out.print("          ");
            System.out.print("|");
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print(iResultSetMetaData.getColumnLabel(n2 + 1), iResultSetMetaData.getColumnDisplaySize(n2 + 1)));
                ++n2;
            }
            System.out.print("|");
            System.out.println(" (ColumnLabels)");
            System.out.print("          ");
            System.out.print("|");
            int n3 = 0;
            while (n3 < n) {
                if (n3 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print(iResultSetMetaData.getColumnName(n3 + 1), iResultSetMetaData.getColumnDisplaySize(n3 + 1)));
                ++n3;
            }
            System.out.print("|");
            System.out.println(" (ColumnNames)");
            System.out.print("          ");
            System.out.print("|");
            int n4 = 0;
            while (n4 < n) {
                if (n4 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print("" + iResultSetMetaData.getColumnType(n4 + 1), iResultSetMetaData.getColumnDisplaySize(n4 + 1)));
                ++n4;
            }
            System.out.print("|");
            System.out.println(" (ColumnType)");
            System.out.print("          ");
            System.out.print("|");
            int n5 = 0;
            while (n5 < n) {
                if (n5 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print("" + iResultSetMetaData.getColumnTypeName(n5 + 1), iResultSetMetaData.getColumnDisplaySize(n5 + 1)));
                ++n5;
            }
            System.out.print("|");
            System.out.println(" (ColumnTypeName)");
            System.out.print("          ");
            System.out.print("|");
            int n6 = 0;
            while (n6 < n) {
                if (n6 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print("" + iResultSetMetaData.getColumnDisplaySize(n6 + 1), iResultSetMetaData.getColumnDisplaySize(n6 + 1)));
                ++n6;
            }
            System.out.print("|");
            System.out.println(" (ColumnDisplaySize)");
            System.out.print("          ");
            System.out.print("|");
            int n7 = 0;
            while (n7 < n) {
                if (n7 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print("" + iResultSetMetaData.getPrecision(n7 + 1), iResultSetMetaData.getColumnDisplaySize(n7 + 1)));
                ++n7;
            }
            System.out.print("|");
            System.out.println(" (Precision)");
            System.out.print("          ");
            System.out.print("|");
            int n8 = 0;
            while (n8 < n) {
                if (n8 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print("" + iResultSetMetaData.getTableName(n8 + 1), iResultSetMetaData.getColumnDisplaySize(n8 + 1)));
                ++n8;
            }
            System.out.print("|");
            System.out.println(" (TableName)");
            System.out.print("      BFLA");
            System.out.print("|");
            int n9 = 0;
            while (n9 < n) {
                if (n9 > 0) {
                    System.out.print("|");
                }
                System.out.print(Testcode_Database.print("---------------------", iResultSetMetaData.getColumnDisplaySize(n9 + 1)));
                ++n9;
            }
            System.out.print("|");
            System.out.println("");
            System.out.print(Testcode_Database.printNr(iResultSet.getRow()));
            System.out.print("|");
            System.out.print(Testcode_Database.printBool(iResultSet.isBeforeFirst()));
            System.out.print(Testcode_Database.printBool(iResultSet.isFirst()));
            System.out.print(Testcode_Database.printBool(iResultSet.isLast()));
            System.out.print(Testcode_Database.printBool(iResultSet.isAfterLast()));
            System.out.print("|");
            System.out.println("");
            while (iResultSet.next()) {
                System.out.print(Testcode_Database.printNr(iResultSet.getRow()));
                System.out.print("|");
                System.out.print(Testcode_Database.printBool(iResultSet.isBeforeFirst()));
                System.out.print(Testcode_Database.printBool(iResultSet.isFirst()));
                System.out.print(Testcode_Database.printBool(iResultSet.isLast()));
                System.out.print(Testcode_Database.printBool(iResultSet.isAfterLast()));
                System.out.print("|");
                int n10 = 0;
                while (n10 < n) {
                    int n11;
                    if (n10 > 0) {
                        System.out.print("|");
                    }
                    if ((n11 = iResultSetMetaData.getColumnType(n10 + 1)) == 91) {
                        System.out.print(Testcode_Database.print(iResultSet.getRawData(n10 + 1).substring(4), iResultSetMetaData.getColumnDisplaySize(n10 + 1)));
                    } else if (n11 == 93) {
                        System.out.print(Testcode_Database.print(iResultSet.getRawData(n10 + 1).substring(5), iResultSetMetaData.getColumnDisplaySize(n10 + 1)));
                    } else {
                        System.out.print(Testcode_Database.print(iResultSet.getRawData(n10 + 1), iResultSetMetaData.getColumnDisplaySize(n10 + 1)));
                    }
                    ++n10;
                }
                System.out.print("|");
                System.out.println("");
            }
            System.out.print(Testcode_Database.printNr(iResultSet.getRow()));
            System.out.print("|");
            System.out.print(Testcode_Database.printBool(iResultSet.isBeforeFirst()));
            System.out.print(Testcode_Database.printBool(iResultSet.isFirst()));
            System.out.print(Testcode_Database.printBool(iResultSet.isLast()));
            System.out.print(Testcode_Database.printBool(iResultSet.isAfterLast()));
            System.out.print("|");
            System.out.println("");
            System.out.println("Close the ResultSet");
            iResultSet.close();
            System.out.println("");
        }
        catch (DatabaseException databaseException) {
            System.out.print("ERROR " + databaseException.getMessage());
        }
    }

    private static String print(String string) {
        String string2 = "                      ";
        string = " " + string + string2;
        return string.substring(0, 20);
    }

    private static String print(String string, int n) {
        if (n > 20) {
            n = 20;
        }
        String string2 = "                      ";
        string = " " + string + string2;
        return string.substring(0, n + 1);
    }

    private static String printNr(int n) {
        String string = "     ";
        String string2 = " " + n + string;
        return string2.substring(0, 5);
    }

    private static String printBool(boolean bl) {
        if (bl) {
            return "1";
        }
        return "0";
    }
}

