/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.BusinessObjectManager;
import com.baan.b3.boi1.IBackend;
import com.baan.b3.boi1.IExceptionDescriptor;
import com.baan.b3.boi1.ISynchronization;
import com.baan.b3.boi1.ISynchronizationExceptionDescriptor;
import com.baan.b3.boi1.IUserInfo;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3.boi1.Iterator;
import com.baan.b3.boi1.dt.SynchronizationActionType;
import com.baan.b3.boi1.metadata.IMetadataFactory;
import com.baan.b3impl.boi1.IteratorImpl;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.MetaData;
import com.eibus.co.Query;
import com.eibus.exception.BusException;
import com.eibus.test.regression.B3test;
import com.eibus.test.regression.Testutils;
import com.eibus.test.regression.typesafe.Residents;
import com.eibus.test.regression.typesafe.Streets;
import com.eibus.test.regression.typesafe.StreetsManager;
import com.eibus.test.regression.typesafe.b3TestManager;

public class Readonly_Testcode_Query_StreetsResidents {
    public static final int MAX_STREETS = 10;

    public static void failure() {
        B3test.failure();
    }

    public static void test_StreetsAndResidents() {
        Testutils.log_PrintLn("-----------Calls for Streets and Residents-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Creating and initializing server...");
        try {
            StreetsManager streetsManager = new StreetsManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            streetsManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Ok");
            Readonly_Testcode_Query_StreetsResidents.initializeTest(b3TestManager2);
            b3TestManager2.fillTabletmboa100_110(10);
            Readonly_Testcode_Query_StreetsResidents.checkStreets(streetsManager);
            streetsManager.close();
            b3TestManager2.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_StreetsAndResidents");
            Testutils.log_PrintLn(boiException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeTest(b3TestManager b3TestManager2) {
        Testutils.log_PrintLn("Initializing the test...");
        Testutils.log_PrintLn("");
        Testutils.log_Print("(clearing all the tables)");
        try {
            try {
                b3TestManager2.initializetest();
                Testutils.log_PrintLn("Ok");
                Testutils.log_PrintLn("");
            }
            catch (BoiException boiException) {
                Testutils.log_PrintLn("Failed to initialize SQL test");
                Testutils.log_PrintLn(boiException.toString());
                Object var3_2 = null;
                b3TestManager2.releaseAll();
            }
            Object var3_1 = null;
            b3TestManager2.releaseAll();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            b3TestManager2.releaseAll();
            throw throwable;
        }
    }

    public static void checkStreets(StreetsManager streetsManager) {
        Testutils.log_PrintLn("-----------Check Streets-----------");
        Testutils.log_PrintLn("");
        int n = 1;
        while (n <= 10) {
            int n2 = n;
            String string = "street " + Integer.toString(n2);
            int n3 = n++;
            String string2 = "AAAA" + Integer.toString(n2);
            Readonly_Testcode_Query_StreetsResidents.checkStreet(streetsManager, n2, string, n3, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkStreet(StreetsManager streetsManager, int n, String string, int n2, String string2) {
        try {
            block7: {
                try {
                    Streets streets = streetsManager.show(n);
                    if (streets != null) {
                        if (streets.getStreetCode() == n && streets.getStreetName().equals(string) && streets.getStreetNumber() == n2 && streets.getZipcode().equals(string2)) {
                            Testutils.log_PrintLn("insert of street " + n + " succeeded");
                        } else {
                            Testutils.log_PrintLn("insert of street " + n + " failed");
                            Readonly_Testcode_Query_StreetsResidents.failure();
                        }
                        Readonly_Testcode_Query_StreetsResidents.checkResidents(streetsManager, streets);
                        break block7;
                    }
                    Testutils.log_PrintLn("Street " + n + " not found");
                    Readonly_Testcode_Query_StreetsResidents.failure();
                }
                catch (BoiException boiException) {
                    Testutils.log_PrintLn("BoiException in checkStreet");
                    Testutils.log_PrintLn(boiException.toString());
                    Readonly_Testcode_Query_StreetsResidents.failure();
                    Object var8_7 = null;
                    streetsManager.releaseAll();
                }
            }
            Object var8_6 = null;
            streetsManager.releaseAll();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            streetsManager.releaseAll();
            throw throwable;
        }
    }

    public static void checkResidents(StreetsManager streetsManager, Streets streets) {
        int n = streets.getStreetCode();
        int n2 = streets.sizeResidents();
        if (n2 != 3) {
            Testutils.log_PrintLn("Wrong no of residents");
            Readonly_Testcode_Query_StreetsResidents.failure();
        } else {
            Testutils.log_PrintLn("Insert residents succeeded.");
            int n3 = 0;
            while (n3 < n2) {
                Residents residents = streets.getResidentsAt(n3);
                Readonly_Testcode_Query_StreetsResidents.checkResident(residents);
                ++n3;
            }
        }
    }

    public static void checkResident(Residents residents) {
        String string = residents.getChristianName();
        String string2 = residents.getLastName();
        Testutils.log_PrintLn(string + "," + string2);
    }

    public static void test_strAndResGetAggregated() {
        Testutils.log_PrintLn("-----------Get Street And Residents (aggregated)-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Creating managers...");
        try {
            StreetsManager streetsManager = new StreetsManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            streetsManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Ok");
            Testutils.log_PrintLn("Initialize test (clearing tables with dll call)");
            Readonly_Testcode_Query_StreetsResidents.initializeTest(b3TestManager2);
            Testutils.log_PrintLn("Add records to streets & residents.");
            b3TestManager2.fillTabletmboa100_110(10);
            Testutils.log_Print("");
            Testutils.log_Print("Retreive records streets & residents aggregated....");
            Testutils.log_PrintLn("enable metadata on manager");
            BusinessDocumentManager businessDocumentManager = Hack.getBdm(streetsManager);
            businessDocumentManager.enableMetaData(true);
            Iterator iterator = streetsManager.list_aggregated(1, 10);
            com.eibus.bdf.Iterator iterator2 = IteratorHack.getIterator(iterator);
            MetaData metaData = iterator2.getMetaData();
            if (metaData == null) {
                Testutils.log_PrintLn("No metadata!!!");
                Readonly_Testcode_Query_StreetsResidents.failure();
            } else {
                Testutils.log_Print(metaData.toString());
                Testutils.log_PrintLn("   Ok");
            }
            long l = 0L;
            if (iterator != null) {
                while (iterator.hasMoreElements()) {
                    Streets streets = (Streets)iterator.nextElement();
                    if (streets == null) continue;
                    l += (long)streets.sizeResidents();
                    Testutils.log_PrintLn("No of Residents in street " + streets.getStreetName() + " = " + streets.sizeResidents());
                }
                if (l == 30L) {
                    Testutils.log_PrintLn("Getting aggregated data is OK !");
                } else {
                    Testutils.log_PrintLn("Getting aggregated data, ERROR !");
                    Readonly_Testcode_Query_StreetsResidents.failure();
                }
            }
            streetsManager.close();
            b3TestManager2.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_strAndResGetAggregated");
            Testutils.log_PrintLn(boiException.toString());
            Readonly_Testcode_Query_StreetsResidents.failure();
        }
        catch (BusException busException) {
            Testutils.log_PrintLn("BusException in test_strAndResGetAggregated");
            Testutils.log_PrintLn(busException.toString());
            Readonly_Testcode_Query_StreetsResidents.failure();
        }
    }

    public static void test_strAndResGetAssociated() {
        Testutils.log_PrintLn("-----------Get Street And Residents (associated)-----------");
        Testutils.log_PrintLn("");
        Testutils.log_Print("Creating managers...");
        try {
            StreetsManager streetsManager = new StreetsManager();
            b3TestManager b3TestManager2 = new b3TestManager();
            streetsManager.initialize(B3test.server_comp);
            b3TestManager2.initialize(B3test.server_comp);
            Testutils.log_PrintLn("Ok");
            Testutils.log_PrintLn("Initialize test (clearing tables with dll call)");
            Readonly_Testcode_Query_StreetsResidents.initializeTest(b3TestManager2);
            Testutils.log_PrintLn("Add records to streets & residents.");
            b3TestManager2.fillTabletmboa100_110(10);
            Testutils.log_Print("");
            Testutils.log_Print("Retreive records streets & residents associated....");
            Testutils.log_PrintLn("enable metadata on manager");
            BusinessDocumentManager businessDocumentManager = Hack.getBdm(streetsManager);
            businessDocumentManager.enableMetaData(true);
            Iterator iterator = streetsManager.list(1, 10);
            com.eibus.bdf.Iterator iterator2 = IteratorHack.getIterator(iterator);
            MetaData metaData = iterator2.getMetaData();
            if (metaData == null) {
                Testutils.log_PrintLn("No metadata!!!");
                Readonly_Testcode_Query_StreetsResidents.failure();
            } else {
                Testutils.log_Print(metaData.toString());
                Testutils.log_PrintLn("   Ok");
            }
            long l = 0L;
            if (iterator != null) {
                while (iterator.hasMoreElements()) {
                    Streets streets = (Streets)iterator.nextElement();
                    if (streets == null) continue;
                    l += (long)streets.sizeResidents();
                    Testutils.log_PrintLn("No of Residents in street " + streets.getStreetName() + " = " + streets.sizeResidents());
                }
                if (l == 30L) {
                    Testutils.log_PrintLn("Getting associated data is OK !");
                } else {
                    Testutils.log_PrintLn("Getting associated data, ERROR !");
                    Readonly_Testcode_Query_StreetsResidents.failure();
                }
            }
            streetsManager.close();
            b3TestManager2.close();
        }
        catch (BoiException boiException) {
            Testutils.log_PrintLn("BoiException in test_strAndResGetAssociated");
            Testutils.log_PrintLn(boiException.toString());
            Readonly_Testcode_Query_StreetsResidents.failure();
        }
        catch (BusException busException) {
            Testutils.log_PrintLn("BusException in test_strAndResGetAssociated");
            Testutils.log_PrintLn(busException.toString());
            Readonly_Testcode_Query_StreetsResidents.failure();
        }
    }

    private static abstract class IteratorHack
    extends IteratorImpl {
        private IteratorHack() {
        }

        public static com.eibus.bdf.Iterator getIterator(Iterator iterator) {
            return IteratorImpl.getIteratorImpl((IteratorImpl)iterator);
        }
    }

    private static class Hack
    extends BoiToolkit {
        private static final Hack s_instance = new Hack();

        private Hack() {
        }

        public IBackend createBackend(String string) {
            throw new RuntimeException("Not implemented.");
        }

        public static BusinessDocumentManager getBdm(BusinessObjectManager businessObjectManager) {
            return s_instance.bomToBdm(businessObjectManager);
        }

        public ISynchronization createSynchronization() {
            throw new RuntimeException("Not implemented.");
        }

        public IUserInfo createUserInfo() {
            throw new RuntimeException("Not implemented.");
        }

        public IUserSession createUserSession() {
            throw new RuntimeException("Not implemented.");
        }

        public IUserSession createUserSession(IUserInfo iUserInfo) {
            throw new RuntimeException("Not implemented.");
        }

        protected IExceptionDescriptor createExceptionDescriptor(boolean bl, String[] stringArray) {
            throw new RuntimeException("Not implemented.");
        }

        protected ISynchronizationExceptionDescriptor createSynchronizationExceptionDescriptor(boolean bl, String[] stringArray, String string, String string2, BusinessObject businessObject, SynchronizationActionType synchronizationActionType) {
            throw new RuntimeException("Not implemented.");
        }

        protected Iterator createIterator(Query query, BusinessDocumentManager businessDocumentManager, Class clazz) {
            throw new RuntimeException("Not implemented.");
        }

        protected IMetadataFactory getMetadataFactory() {
            throw new RuntimeException("Not implemented.");
        }
    }
}

