/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.test.regression;

import com.eibus.test.regression.Readonly_Testcode_Query_DataTypes;
import com.eibus.test.regression.Readonly_Testcode_Query_StreetsResidents;
import com.eibus.test.regression.TestCode_Content_Licensing;
import com.eibus.test.regression.TestCode_Tiger;
import com.eibus.test.regression.Testcode_BIN_XML;
import com.eibus.test.regression.Testcode_Database;
import com.eibus.test.regression.Testcode_Function;
import com.eibus.test.regression.Testcode_License_Override;
import com.eibus.test.regression.Testcode_Memory;
import com.eibus.test.regression.Testcode_Metadata;
import com.eibus.test.regression.Testcode_QueryByDLL;
import com.eibus.test.regression.Testcode_Query_DataTypes;
import com.eibus.test.regression.Testcode_Query_StreetsResidents;
import com.eibus.test.regression.Testcode_Security;
import com.eibus.test.regression.Testcode_Tiger_Wrapper;
import com.eibus.test.regression.Testutils;
import java.util.Enumeration;
import java.util.Vector;

public class B3test {
    private static final String COPYRIGHT = "Copyright (c) 1999-2005 SSA Global Technologies, Inc.";
    private static Vector s_skippedTests = new Vector();
    private static boolean showAnomalies = true;
    public static boolean failures;
    public static String server_comp;
    public static String sql_query;
    private static String odbc_options;
    public static int sql_company;

    public static void failure() {
        failures = true;
    }

    public static void skippedTest(String string) {
        s_skippedTests.addElement(string);
    }

    public static void main(String[] stringArray) {
        failures = false;
        int n = 4;
        int n2 = 1;
        Throwable throwable = null;
        Testutils.log_createFile(throwable);
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("|-------------------------------------------------------------------|");
        Testutils.log_PrintLn("|                                                                   |");
        Testutils.log_PrintLn("|     SSA Technology Architecture regression test (Java Client)     |");
        Testutils.log_PrintLn("|     (c) 1999-2003 Baan Development B.V. All rights reserved.      |");
        Testutils.log_PrintLn("|        use Server for BaanERP for functionality and tables        |");
        Testutils.log_PrintLn("|            or one of the other Servers for functionality          |");
        Testutils.log_PrintLn("|                        (.NET, COM, Java)                          |");
        Testutils.log_PrintLn("| Database functionality can be tested using Baan DB Driver Adapter |");
        Testutils.log_PrintLn("|                                                                   |");
        Testutils.log_PrintLn("|-------------------------------------------------------------------|");
        Testutils.log_PrintLn("");
        int n3 = stringArray.length;
        if (n3 > 0) {
            server_comp = stringArray[0];
        }
        if (n3 > 1) {
            n = B3test.parseArgument(stringArray[1]);
        }
        if (n3 > 2) {
            switch (n) {
                case 40: {
                    sql_query = stringArray[2];
                    if (n3 <= 3) break;
                    n2 = B3test.parseArgument(stringArray[3]);
                    break;
                }
                case 49: {
                    sql_query = stringArray[2];
                    if (n3 > 3) {
                        odbc_options = stringArray[3];
                    }
                    if (n3 <= 4) break;
                    n2 = B3test.parseArgument(stringArray[3]);
                    break;
                }
                default: {
                    n2 = B3test.parseArgument(stringArray[2]);
                }
            }
        }
        if (server_comp == null || n == -1) {
            B3test.showUsage();
        }
        Testutils.log_PrintLn("   - Backend component name = " + server_comp);
        Testutils.log_PrintLn("   - Test # " + n + ", number of loops = " + n2);
        int n4 = 1;
        while (n4 <= n2) {
            Testutils.log_PrintLn("");
            if (n2 != 1) {
                Testutils.log_PrintLn("Test loop : " + n4);
            }
            Testutils.log_PrintLn("");
            switch (n) {
                case 1: {
                    Testutils.log_PrintLn("-----| Testing All Functionality |------");
                    Testutils.log_PrintLn("");
                    Testcode_Query_DataTypes.test_DataTypes();
                    Testcode_Query_StreetsResidents.test_StreetsAndResidents();
                    Testcode_Query_StreetsResidents.test_strAndResGetAssociated();
                    Testcode_Query_StreetsResidents.test_strAndResGetAggregated();
                    Testcode_Query_StreetsResidents.test_MultipleManagers();
                    Testcode_Function.test_DLLcall_functionality();
                    Testcode_Tiger_Wrapper.test();
                    Testcode_Metadata.testMetadata();
                    break;
                }
                case 2: {
                    Testutils.log_PrintLn("-----| Testing All Performance |------");
                    Testutils.log_PrintLn("");
                    Testcode_Function.test_DLLcall_calls_perf();
                    Testcode_Function.test_DLLcall_bytes_perf();
                    Testcode_Query_DataTypes.test_DataTypesPerformance();
                    break;
                }
                case 3: {
                    Testutils.log_PrintLn("-----| Testing SQL functionality |------");
                    Testutils.log_PrintLn("");
                    Testcode_Query_DataTypes.test_DataTypes();
                    Testcode_Query_StreetsResidents.test_MultipleManagers();
                    Testcode_Query_StreetsResidents.test_StreetsAndResidents();
                    Testcode_Query_StreetsResidents.test_strAndResGetAssociated();
                    Testcode_Query_StreetsResidents.test_strAndResGetAggregated();
                    break;
                }
                case 4: {
                    Testutils.log_PrintLn("-----|Testing FunctionCall functionality |------");
                    Testutils.log_PrintLn("");
                    Testcode_Function.test_DLLcall_functionality();
                    break;
                }
                case 5: {
                    Testcode_QueryByDLL.test_QueryByDLL_functionality();
                    break;
                }
                case 6: {
                    Testcode_BIN_XML.test_BIN_XML_Datatype();
                    break;
                }
                case 7: {
                    Testcode_Query_StreetsResidents.test_MultipleManagers();
                    break;
                }
                case 8: {
                    Testcode_Query_StreetsResidents.test_strAndResGetAssociated();
                    break;
                }
                case 9: {
                    Testcode_Query_StreetsResidents.test_strAndResGetAggregated();
                    break;
                }
                case 10: {
                    Testcode_Tiger_Wrapper.test();
                    TestCode_Tiger.test();
                    break;
                }
                case 20: {
                    Testcode_Security.Test_UserInfo();
                    break;
                }
                case 21: {
                    Testcode_Security.Test_UserSession();
                    break;
                }
                case 22: {
                    Testcode_Security.Test_ServerActivation();
                    break;
                }
                case 23: {
                    Testcode_Security.Test_ServerActivationFromdifferentThreads();
                    break;
                }
                case 24: {
                    Testcode_Security.Test_ServerActivationFromdifferentThreadsAndUsers();
                    break;
                }
                case 25: {
                    Testcode_Security.Test_ServerActivationAPS();
                    break;
                }
                case 11: {
                    Testutils.log_PrintLn("-----| Testing All Read-Only Functionality |------");
                    Testutils.log_PrintLn("");
                    Testcode_Function.test_DLLcall_functionality();
                    Readonly_Testcode_Query_DataTypes.test_DataTypes();
                    Readonly_Testcode_Query_StreetsResidents.test_StreetsAndResidents();
                    Readonly_Testcode_Query_StreetsResidents.test_strAndResGetAssociated();
                    Readonly_Testcode_Query_StreetsResidents.test_strAndResGetAggregated();
                    break;
                }
                case 12: {
                    Testcode_Metadata.testMetadata();
                    break;
                }
                case 15: {
                    Testcode_Memory.testMemory();
                    break;
                }
                case 30: {
                    Testcode_License_Override.Test_Invalid_Using_Different_Key();
                    break;
                }
                case 31: {
                    Testcode_License_Override.Test_Invalid_Using_Different_Key_license();
                    break;
                }
                case 32: {
                    TestCode_Content_Licensing testCode_Content_Licensing = new TestCode_Content_Licensing(server_comp);
                    testCode_Content_Licensing.doDLLCalls();
                    break;
                }
                case 40: {
                    showAnomalies = false;
                    Testcode_Database.testExecuteQuery(sql_query);
                    break;
                }
                case 41: {
                    showAnomalies = false;
                    Testcode_Database.testDBConnection();
                    break;
                }
                case 42: {
                    showAnomalies = false;
                    Testcode_Database.testDBConnectionThreads();
                    break;
                }
                case 43: {
                    showAnomalies = false;
                    Testcode_Database.testMetaData();
                    break;
                }
                case 44: {
                    showAnomalies = false;
                    Testcode_Database.testMetaDataTable();
                    break;
                }
                case 45: {
                    showAnomalies = false;
                    Testcode_Database.testThreadingOneConnection();
                    break;
                }
                case 46: {
                    showAnomalies = false;
                    Testcode_Database.testThreadingMultipleConnection();
                    break;
                }
                case 47: {
                    showAnomalies = false;
                    Testcode_Database.testDatabaseInformation();
                    break;
                }
                case 48: {
                    showAnomalies = false;
                    Testcode_Database.testLabels();
                    break;
                }
                case 49: {
                    showAnomalies = false;
                    Testcode_Database.testExecuteQuery(sql_query, odbc_options);
                    break;
                }
                case 50: {
                    showAnomalies = false;
                    Testcode_Database.testExecuteQueryParams(sql_query, odbc_options);
                    break;
                }
                default: {
                    Testutils.log_PrintLn("Unknown test number entered (" + n + ")");
                }
            }
            ++n4;
        }
        boolean bl = s_skippedTests.size() == 0;
        Testutils.log_PrintLn(" ");
        if (bl) {
            Testutils.log_PrintLn("The test is complete");
        } else {
            Testutils.log_PrintLn("The test is INCOMPLETE");
            Testutils.log_PrintLn("");
            Enumeration enumeration2 = s_skippedTests.elements();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                Testutils.log_PrintLn("Skipped test: '" + string + "'");
            }
        }
        Testutils.log_PrintLn(" ");
        if (showAnomalies) {
            if (failures) {
                Testutils.log_PrintLn("There were ERROR(s) !!");
            } else {
                Testutils.log_PrintLn("There were no anomalies.");
            }
        }
        Testutils.log_closeFile();
        System.exit(failures || !bl ? 1 : 0);
    }

    private static int parseArgument(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    private static void showUsage() {
        Testutils.log_PrintLn("usage:");
        Testutils.log_PrintLn("  1st argument = Backend component name");
        Testutils.log_PrintLn("        example : \"cn=MQSeries test,o=baan.com\"");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn(" [2nd argument = test case no (default = 1)]");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn(" [3rd argument = number of test loops (default = 1)]");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     Regular testcases:");
        Testutils.log_PrintLn("        1 = All functionality");
        Testutils.log_PrintLn("        2 = All performance");
        Testutils.log_PrintLn("        3 = SQL functionality");
        Testutils.log_PrintLn("        4 = DLL functionality");
        Testutils.log_PrintLn("        5 = QueryByDLL functionality");
        Testutils.log_PrintLn("        6 = XMLNode and Binary primal Datatype test");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     Special testcases:");
        Testutils.log_PrintLn("        7 = SQL one synchronisation on multiple managers");
        Testutils.log_PrintLn("        8 = SQL Get associated data (2 tables)");
        Testutils.log_PrintLn("        9 = SQL Get aggregated data (2 tables)");
        Testutils.log_PrintLn("        10 = Tiger Wrapper functionality test");
        Testutils.log_PrintLn("        12 = Metadata information methods");
        Testutils.log_PrintLn("        15 = Memory boundaries test");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     Read-only testcases (without updates):");
        Testutils.log_PrintLn("        11 = All read-only functionality");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     Security tests (OW2.0 compatible / UserInfo):");
        Testutils.log_PrintLn("        20 = Security test with function calls");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     Security & Activation tests (OW2.1 / UserSession):");
        Testutils.log_PrintLn("        21 = Activation test with function calls & queries");
        Testutils.log_PrintLn("        22 = Server Activation performance (one thread)");
        Testutils.log_PrintLn("        23 = Server Activation and DLL calls from different threads");
        Testutils.log_PrintLn("        24 = Server Activation and DLL calls from different threads & different users");
        Testutils.log_PrintLn("        25 = Server Activation and DLL calls from different threads automated");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     License override tests (OW2.4):");
        Testutils.log_PrintLn("        30 = License override (full test, key)");
        Testutils.log_PrintLn("        31 = License override (full test, key & license)");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     Content License Tests (OW2.5):");
        Testutils.log_PrintLn("        32 = Content Licensing test");
        Testutils.log_PrintLn("");
        Testutils.log_PrintLn("     Database Testing, Database Model and API in Java:");
        Testutils.log_PrintLn("     This API & model is used to implement ODBC & JDBC with Baan DB Driver");
        Testutils.log_PrintLn("     Use system property 'API' to switch between [ODBC2], ODBC3 and [JDBC]");
        Testutils.log_PrintLn("        40 = query execution (user input)");
        Testutils.log_PrintLn("        41 = Connection testing");
        Testutils.log_PrintLn("        42 = Connection testing from threads (user input)");
        Testutils.log_PrintLn("        43 = Metadata tables, columns, etc.");
        Testutils.log_PrintLn("        44 = Metadata for specified table (user input)");
        Testutils.log_PrintLn("        45 = Multithread test, one connection (user input)");
        Testutils.log_PrintLn("        46 = Multithread test, multiple connections (user input)");
        Testutils.log_PrintLn("        47 = Show Database Information");
        Testutils.log_PrintLn("        48 = Label testing ,getTables with getColumns (user input)");
        Testutils.log_PrintLn("        49 = query execution with connect string Options (user input)");
        Testutils.log_PrintLn("        50 = query execution with connect string Options and parameters (user input)");
        Testutils.log_PrintLn("");
        Testutils.log_closeFile();
        System.exit(-1);
    }

    static {
        sql_company = 0;
    }
}

