/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.security;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.util.HexString;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BusDocDigest {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.security", "BusDocDigest");
    public static final String EMPTY_DIGEST = "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN";
    public static final String MESSAGEDIGEST_ATTR = "MD";
    public static final byte NOTCALCULATED = 78;
    private static final int STARTSEARCH = 25;
    private static final int STOPSEARCH = 45;
    private static final int MD5_HEX_BYTE_KEY_LENGTH = 32;
    private static final int MD5_BYTE_KEY_LENGTH = 16;

    public static boolean addBusDocDigest2BusDocText(byte[] byArray, int n) {
        int n2;
        if (n == -1) {
            s_logger.message("No space for Message Digest in busdoc (bytes)");
            return false;
        }
        if (byArray[n] != 78) {
            n2 = n;
            while (n2 < n + 32) {
                byArray[n2] = 78;
                ++n2;
            }
        }
        byte[] byArray2 = HexString.byteArray2HexByteArray(BusDocDigest.getKeyedMD5Digest(byArray));
        n2 = n;
        while (n2 < n + 32) {
            byArray[n2] = byArray2[n2 - n];
            ++n2;
        }
        s_logger.flowMessage("Message Digest Calculated and Added to Bytes");
        return true;
    }

    public static int hasBusDocDigest(byte[] byArray) {
        int n = BusDocDigest.findMessageDigestStart(byArray);
        return n;
    }

    public static boolean checkBusDocDigest(byte[] byArray, int n) {
        if (n == -1) {
            return false;
        }
        byte[] byArray2 = new byte[32];
        int n2 = n;
        while (n2 < n + 32) {
            byArray2[n2 - n] = byArray[n2];
            byArray[n2] = 78;
            ++n2;
        }
        byte[] byArray3 = HexString.byteArray2HexByteArray(BusDocDigest.getKeyedMD5Digest(byArray));
        int n3 = n;
        while (n3 < n + 32) {
            byArray[n3] = byArray2[n3 - n];
            ++n3;
        }
        if (BusDocDigest.areEqual(byArray2, byArray3)) {
            s_logger.flowMessage("Message Digest check is OK!");
            return true;
        }
        s_logger.errorMessage("Message Digest check failed, message digests are not equal !");
        return false;
    }

    private static int findMessageDigestStart(byte[] byArray) {
        int n = 25;
        while (n < 45) {
            if (byArray[n] == 77 && byArray[n + 1] == 68 && byArray[n + 2] == 61) {
                return n + 4;
            }
            ++n;
        }
        return -1;
    }

    private static byte[] getKeyedMD5Digest(byte[] byArray) {
        byte[] byArray2 = new byte[]{-54, 23, 65, 12, 43, -34, 65, 32, -76, 98, 123, 34, 76, 43, 123, -32};
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            return messageDigest.digest(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

