/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.security;

import com.eibus.services.security.Twofish_Algorithm;
import com.eibus.util.HexString;
import java.security.InvalidKeyException;

public class BlockEncryption {
    private static Twofish_Algorithm tfalg = new Twofish_Algorithm();
    public static final int BLOCKSIZE = 16;
    private static final int NUMBERLOOPS = 16;
    public static final int HEX_STRING_KEY_LENGTH = 64;

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void blockCopy(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = (byArray2.length - 1) / 16 + 1;
        int n4 = byArray2.length % 16;
        if (n + 1 == n3) {
            if (n4 == 0 && byArray2.length != 0) {
                n4 = 16;
            }
        } else {
            n4 = 16;
        }
        if (n2 == 0) {
            int n5 = 0;
            while (n5 < n4) {
                byArray[n5] = byArray2[n * 16 + n5];
                ++n5;
            }
            int n6 = n4;
            while (n6 < 16) {
                byArray[n6] = 0;
                ++n6;
            }
        } else {
            int n7 = 0;
            while (n7 < n4) {
                byArray[n * 16 + n7] = byArray2[n7];
                ++n7;
            }
            int n8 = n4;
            while (n8 < 16) {
                byArray[n * 16 + n8] = 0;
                ++n8;
            }
        }
    }

    public static byte[] DecryptToByteArray(String string, String string2) {
        Object object;
        if (string2.length() != 64) {
            return null;
        }
        try {
            object = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(string2));
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
        byte[] byArray = HexString.hexString2ByteArray(string);
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        int n2 = (n - 1) / 16 + 1;
        int n3 = 0;
        while (n3 < n2) {
            BlockEncryption.blockCopy(byArray4, byArray, n3, 0);
            int n4 = 0;
            while (n4 < 16) {
                byArray3 = Twofish_Algorithm.blockDecrypt(byArray4, 0, object);
                BlockEncryption.blockCopy(byArray4, byArray3, 0, 0);
                ++n4;
            }
            BlockEncryption.blockCopy(byArray2, byArray3, n3, 1);
            ++n3;
        }
        return byArray2;
    }

    public static String DecryptToString(String string, String string2) {
        Object object;
        if (string2.length() != 64) {
            return null;
        }
        try {
            object = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(string2));
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
        byte[] byArray = HexString.hexString2ByteArray(string);
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[16];
        byte[] byArray4 = new byte[16];
        int n2 = (n - 1) / 16 + 1;
        int n3 = 0;
        while (n3 < n2) {
            BlockEncryption.blockCopy(byArray4, byArray, n3, 0);
            int n4 = 0;
            while (n4 < 16) {
                byArray3 = Twofish_Algorithm.blockDecrypt(byArray4, 0, object);
                BlockEncryption.blockCopy(byArray4, byArray3, 0, 0);
                ++n4;
            }
            BlockEncryption.blockCopy(byArray2, byArray3, n3, 1);
            ++n3;
        }
        String string3 = new String(byArray2);
        return string3.trim();
    }

    public static String Encrypt(byte[] byArray, String string) {
        Object object;
        if (string.length() != 64) {
            return null;
        }
        try {
            object = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(string));
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        int n2 = (n - 1) / 16 + 1;
        byte[] byArray4 = new byte[n2 * 16];
        int n3 = 0;
        while (n3 < n2) {
            BlockEncryption.blockCopy(byArray2, byArray, n3, 0);
            int n4 = 0;
            while (n4 < 16) {
                byArray3 = Twofish_Algorithm.blockEncrypt(byArray2, 0, object);
                BlockEncryption.blockCopy(byArray2, byArray3, 0, 0);
                ++n4;
            }
            BlockEncryption.blockCopy(byArray4, byArray3, n3, 1);
            ++n3;
        }
        return HexString.byteArray2HexString(byArray4);
    }

    public static String Encrypt(String string, String string2) {
        Object object;
        byte[] byArray = string.getBytes();
        if (string2.length() != 64) {
            return "";
        }
        try {
            object = Twofish_Algorithm.makeKey(HexString.hexString2ByteArray(string2));
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[16];
        byte[] byArray3 = new byte[16];
        int n2 = (n - 1) / 16 + 1;
        byte[] byArray4 = new byte[n2 * 16];
        int n3 = 0;
        while (n3 < n2) {
            BlockEncryption.blockCopy(byArray2, byArray, n3, 0);
            int n4 = 0;
            while (n4 < 16) {
                byArray3 = Twofish_Algorithm.blockEncrypt(byArray2, 0, object);
                BlockEncryption.blockCopy(byArray2, byArray3, 0, 0);
                ++n4;
            }
            BlockEncryption.blockCopy(byArray4, byArray3, n3, 1);
            ++n3;
        }
        return HexString.byteArray2HexString(byArray4);
    }
}

