/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.runtime;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.exception.BusException;
import com.eibus.services.guid.Guid;
import com.eibus.services.runtime.IComponentId;
import com.eibus.services.runtime.Key;
import java.util.Hashtable;

public class Registry {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.runtime", "Registry");
    static Object defaultManager;
    static Hashtable factories;

    public static Object getManager(Guid guid, IComponentId iComponentId, String string) {
        Key key = new Key(guid, iComponentId, string);
        Object v = factories.get(key);
        if (iComponentId == null && string == null) {
            s_logger.flowMessage("Get manager " + v + " for message with id " + guid);
        } else {
            s_logger.flowMessage("Get manager " + v + " for key " + key);
        }
        return v;
    }

    public static Object unRegisterManager(Guid guid, IComponentId iComponentId, String string) {
        Key key = new Key(guid, iComponentId, string);
        Object v = factories.remove(key);
        s_logger.flowMessage("Unregistering manager  " + v + " for key " + key);
        return v;
    }

    public static Object registerManager(Guid guid, IComponentId iComponentId, String string, Object object) {
        Key key = new Key(guid, iComponentId, string);
        s_logger.flowMessage("Registering manager " + object + " for key " + key);
        return factories.put(key, object);
    }

    public static Object getDefaultManager() throws BusException {
        if (defaultManager == null) {
            s_logger.flowMessage("Registry now is creating default manager");
            try {
                defaultManager = Class.forName("com.eibus.bdf.BusinessDocumentManager").newInstance();
            }
            catch (Exception exception) {
                throw new BusException(exception);
            }
        }
        s_logger.flowMessage("Registry returns default manager");
        return defaultManager;
    }

    public static void setDefaultManager(Object object) {
        if (object == null) {
            throw new NullPointerException("Cannot set the default manager to null");
        }
        s_logger.flowMessage("Registry sets default manager to " + object);
        defaultManager = object;
    }

    static {
        factories = new Hashtable();
    }
}

