/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.runtime;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class BusProperties {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.runtime", "BusProperties");
    public static final String DIRECTORY_SERVICE = "bus.services.directory.Directory";
    public static final String DIRECTORY_SERVER = "bus.services.directory.ServerURL";
    public static final String DIRECTORY_SERVER_SAVE = "bus.services.directory.ServerURL.save";
    public static final String DIRECTORY_ROOT = "bus.services.directory.Root";
    public static final String DIRECTORY_TIMEOUT = "bus.services.directory.timeout";
    public static final String COMPONENT = "bus.component";
    public static final String SAX_PARSER = "org.xml.sax.parser";
    public static final String NUMBER_OF_XML_PARSERS = "bus.num.xml.parse.threads";
    public static final String MAX_READERS = "bus.connection.max.readers";
    public static final String DEFAULT_PROTOCOL = "bus.default.protocol";
    public static final String DEFAULT_CONNECTION_POINT = "bus.default.connection.uri";
    public static final String GUID_FACTORY = "bus.services.guid.GuidFactory";
    public static final String DEFAULT_TIMEOUT = "bus.bdf.manager.timeout";
    public static final String DEFAULT_ITERATOR_SIZE = "bus.bdf.iterator.size";
    public static final String QUEUE_READ_TIMEOUT = "bus.queue.read.timeout";
    public static final String DEFAULT_BACKEND = "bus.default.backend";
    public static final String USER = "user.name";
    public static final String WINDIR = "windir";
    public static final String LOG_FILE = "bus.log.file";
    public static final String LOG_MASK = "bus.log.mask";
    public static final String LOG_PROC = "bus.log.proc";
    public static final String LOG_MASK_SAVE = "bus.log.mask.save";
    public static final String REPOS_HTMLDOC_STYLESHEET = "bus.repository.htmldoc.stylesheet";
    public static final String REPOS_IMPORT_BAANERP = "bus.repository.import.baanerp";
    public static final String REPOS_DEFAULTREPOSITORY = "bus.repository.defaultrepository";
    private static final String ENV_INSTALL_DIR = new String("eai.connector.install.dir");
    private static PropertiesLoader propertiesLoader = null;

    public static synchronized void setLoader(PropertiesLoader propertiesLoader) {
        if (BusProperties.propertiesLoader != null) {
            throw new IllegalStateException("Properties loader is already set");
        }
        BusProperties.propertiesLoader = propertiesLoader;
    }

    private static synchronized void load() {
        if (propertiesLoader == null) {
            propertiesLoader = new StandardPropertiesLoader("bus.properties");
        }
    }

    private static Properties mergePropertySets(Properties properties, Properties properties2) {
        Properties properties3 = properties;
        Enumeration<?> enumeration2 = properties2.propertyNames();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            ((Hashtable)properties3).put(string, properties2.getProperty(string));
        }
        return properties3;
    }

    public static String getProperty(String string) {
        BusProperties.load();
        String string2 = propertiesLoader.getProperty(string);
        return string2;
    }

    public static String getProperty(String string, String string2) {
        String string3 = BusProperties.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public static Properties getProperties() {
        BusProperties.load();
        return propertiesLoader.getProperties();
    }

    public static boolean getBoolean(String string) {
        return new Boolean(BusProperties.getProperty(string, "false"));
    }

    public static Integer getInteger(String string) {
        return BusProperties.getInteger(string, null);
    }

    public static Integer getInteger(String string, int n) {
        return BusProperties.getInteger(string, new Integer(n));
    }

    public static Integer getInteger(String string, Integer n) {
        Integer n2;
        block2: {
            String string2 = BusProperties.getProperty(string);
            n2 = n;
            if (string2 == null) break block2;
            try {
                n2 = new Integer(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }

    public static String getInstallDir() {
        return System.getProperty(ENV_INSTALL_DIR);
    }

    public static interface PropertiesLoader {
        public Properties getProperties();

        public String getProperty(String var1);
    }

    public static class StandardPropertiesLoader
    implements PropertiesLoader {
        private Properties b3Properties = this.getDefaults();
        protected final String[] filePaths = new String[3];

        private String getWindir() {
            try {
                Process process = Runtime.getRuntime().exec("cmd.exe /c set windir");
                process.waitFor();
                byte[] byArray = new byte[128];
                process.getInputStream().read(byArray, 0, 127);
                String string = new String(byArray);
                if (string.startsWith(BusProperties.WINDIR)) {
                    return string.substring(7).trim();
                }
            }
            catch (Exception exception) {}
            return null;
        }

        public StandardPropertiesLoader(String string) {
            this.filePaths[0] = System.getProperty("user.home");
            String string2 = System.getProperty("com.ms.windir");
            if (string2 == null) {
                string2 = this.getWindir();
            }
            this.filePaths[1] = string2;
            this.filePaths[2] = "/etc";
            String string3 = System.getProperty(BusProperties.USER);
            if (string3 != null && string3.length() > 0) {
                String string4 = string3 + "_" + string;
                int n = 0;
                while (n < this.filePaths.length) {
                    if (this.filePaths[n] != null) {
                        String string5 = this.filePaths[n] + File.separator + string4;
                        s_logger.message("Searching for '" + string5 + "'");
                        if (this.loadProperties(string5, this.b3Properties)) {
                            s_logger.message("Using bus.properties file '" + string5 + "'");
                            return;
                        }
                    }
                    ++n;
                }
            }
            int n = 0;
            while (n < this.filePaths.length) {
                if (this.filePaths[n] != null) {
                    String string6 = this.filePaths[n] + File.separator + string;
                    s_logger.message("Searching for '" + string6 + "'");
                    if (this.loadProperties(string6, this.b3Properties)) {
                        s_logger.message("Using bus.properties file '" + string6 + "'");
                        return;
                    }
                }
                ++n;
            }
            s_logger.message("Searching for " + string3 + "_bus.properties file in current directory");
            if (this.loadProperties(string3 + "_" + string, this.b3Properties)) {
                s_logger.message("Using " + string3 + "_bus.properties file in current directory");
                return;
            }
            s_logger.message("Searching for bus.properties file in current directory");
            if (this.loadProperties(string, this.b3Properties)) {
                s_logger.message("Using bus.properties file in current directory");
                return;
            }
            s_logger.message("No bus.properties found !");
        }

        public Properties getProperties() {
            return this.b3Properties;
        }

        public String getProperty(String string) {
            s_logger.message("Retrieving property '" + string + "'='" + this.b3Properties.getProperty(string) + "'");
            return this.b3Properties.getProperty(string);
        }

        protected boolean loadProperties(String string, Properties properties) {
            Properties properties2 = properties;
            try {
                properties2 = properties;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                properties2.load(bufferedInputStream);
                ((InputStream)bufferedInputStream).close();
                ((Hashtable)properties2).put(BusProperties.SAX_PARSER, "com.baan.b3.jclark.xml.sax.Driver");
                return true;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        protected Properties getDefaults() {
            String string = "org.xml.sax.parser=com.baan.b3.jclark.xml.sax.Driver\nbus.services.guid.GuidFactory=com.eibus.services.guid.standard.NearEnoughGuidFactory\nbus.num_xml_parse_threads=1\n";
            try {
                Properties properties = System.getProperties();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                properties.load(byteArrayInputStream);
                ((InputStream)byteArrayInputStream).close();
                return properties;
            }
            catch (IOException iOException) {
                throw new UnknownError("IOException while reading from a String: " + iOException);
            }
        }
    }
}

