/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.profiling;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.profiling.ITimer;
import java.util.Vector;

public class Timer
implements ITimer {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.profiling", "Timer");
    private Vector m_splitTimers = new Vector();

    public Timer(String string) {
        this.m_splitTimers.addElement(new Stamp(System.currentTimeMillis(), string));
    }

    public void split(String string) {
        this.m_splitTimers.addElement(new Stamp(System.currentTimeMillis(), string));
    }

    public void stop() {
        this.m_splitTimers.addElement(new Stamp(System.currentTimeMillis(), null));
        this.logTimer();
    }

    public void stop(String string) {
        this.m_splitTimers.addElement(new Stamp(System.currentTimeMillis(), string));
        this.logTimer();
    }

    public long getTotalTimePassed() {
        Stamp stamp = (Stamp)this.m_splitTimers.firstElement();
        if (stamp != null) {
            return System.currentTimeMillis() - stamp.m_time;
        }
        return 0L;
    }

    private void logTimer() {
        long l = ((Stamp)this.m_splitTimers.firstElement()).m_time;
        long l2 = ((Stamp)this.m_splitTimers.lastElement()).m_time;
        String string = "OPM[total:" + (l2 - l);
        long l3 = l;
        int n = 1;
        while (n < this.m_splitTimers.size()) {
            Stamp stamp = (Stamp)this.m_splitTimers.elementAt(n);
            if (stamp.m_where != null) {
                string = string + "[" + stamp.m_where + ":" + (stamp.m_time - l3) + "]";
                l3 = stamp.m_time;
            }
            ++n;
        }
        string = string + "]";
        s_logger.message(string);
    }

    private class Stamp {
        public long m_time;
        public String m_where;

        public Stamp(long l, String string) {
            this.m_time = l;
            this.m_where = string;
        }
    }
}

