/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.licensing;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.ConcurrentUserLicense;
import com.eibus.services.licensing.DummyLicense;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.NamedUserLicense;
import com.eibus.services.licensing.ServerLicense;

public class LicenseFactory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.licensing", "LicenseFactory");

    public static ILicense createStudioLicense() throws LicenseException {
        LoggerFactory.setApplicationName(LoggerFactory.APP_BOI_STUDIO);
        return new NamedUserLicense(7072);
    }

    public static ILicense createXMLConnectorLicense() throws LicenseException {
        return new ConcurrentUserLicense(7065);
    }

    public static ILicense createSOAPHTTPConnectorLicense() throws LicenseException {
        return new ServerLicense(7066, "Connector for SOAP/HTTP");
    }

    public static ILicense createNamedUserLicense(int n) throws LicenseException {
        return new NamedUserLicense(n);
    }

    public static ILicense createNamedUserLicense(int n, String string, String string2) throws LicenseException {
        return new NamedUserLicense(n, string, string2);
    }

    public static ILicense createDummyLicense(int n, String string, String string2) {
        return new DummyLicense(n, string, string2);
    }

    public static ILicense createServerLicense(int n, String string) throws LicenseException {
        return new ServerLicense(n, string);
    }

    public static ILicense createConcurrentUserLicense(int n) throws LicenseException {
        return new ConcurrentUserLicense(n);
    }
}

