/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.licensing;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseEvent;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseFactory;
import com.eibus.services.licensing.LicenseListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class LicenseCache
implements LicenseListener {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$eibus$services$licensing$LicenseCache == null ? (class$com$eibus$services$licensing$LicenseCache = LicenseCache.class$("com.eibus.services.licensing.LicenseCache")) : class$com$eibus$services$licensing$LicenseCache);
    private Hashtable m_licenses = new Hashtable();
    static /* synthetic */ Class class$com$eibus$services$licensing$LicenseCache;

    public LicenseCache() {
        s_logger.message("LicenseCache: constructor");
    }

    public void put(ILicense iLicense) {
        int n = iLicense.getProductId();
        this.m_licenses.put(new Integer(n), iLicense);
        iLicense.addLicenseListener(this);
        s_logger.message("LicenseCache: license " + n + " stored in cache");
    }

    public ILicense get(int n, String string) {
        ILicense iLicense = (ILicense)this.m_licenses.get(new Integer(n));
        if (iLicense == null) {
            try {
                s_logger.message("LicenseCache: license " + n + " not found in cache, create new license");
                iLicense = LicenseFactory.createServerLicense(n, string);
                s_logger.message("LicenseCache: " + iLicense.getMessage());
                this.put(iLicense);
            }
            catch (LicenseException licenseException) {
                s_logger.message("LicenseCache: license " + n + " could not be created, exception: " + licenseException.toString());
            }
        } else {
            s_logger.message("LicenseCache: license " + n + " retrieved from cache");
        }
        return iLicense;
    }

    public void clear(boolean bl) {
        Enumeration enumeration2 = this.m_licenses.elements();
        while (enumeration2.hasMoreElements()) {
            ILicense iLicense = (ILicense)enumeration2.nextElement();
            iLicense.removeLicenseListener(this);
            if (!bl) continue;
            iLicense.release();
        }
        this.m_licenses.clear();
        s_logger.message("LicenseCache: cleared");
    }

    public void licenseChanged(LicenseEvent licenseEvent) {
        ILicense iLicense = licenseEvent.getLicense();
        s_logger.message("LicenseCache: received licenseChanged event for product ID " + iLicense.getProductId() + ", message: " + licenseEvent.getMessage());
        int n = licenseEvent.getReason();
        if (n == 1) {
            iLicense.removeLicenseListener(this);
            int n2 = iLicense.getProductId();
            this.m_licenses.remove(new Integer(n2));
            s_logger.message("LicenseCache: license " + n2 + " removed from cache");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

