/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.licensing;

import com.baan.bclm.LicenseManager;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.licensing.ILicense;
import com.eibus.services.licensing.LicenseEvent;
import com.eibus.services.licensing.LicenseException;
import com.eibus.services.licensing.LicenseListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class License
implements ILicense {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.licensing", "License");
    private static final String PRODUCT_NAME_STUDIO = "SSA_TA_Studio";
    private static final String PRODUCT_NAME_BAAN_IV = "SSA_TA_Adapter_for_Baan_IV";
    private static final String PRODUCT_NAME_BAAN_ERP = "SSA_TA_Adapter_for_Baan_ERP";
    private static final String PRODUCT_NAME_SSA_ERP_LN = "SSA_TA_Adapter_for_SSA_ERP_LN";
    private static final String PRODUCT_NAME_JAVA = "SSA_TA_Connector_for_Java";
    private static final String PRODUCT_NAME_NETCONNECTOR = "SSA_TA_Connector_for_DOTNET";
    private static final String PRODUCT_NAME_COMCONNECTOR = "SSA_TA_Connector_for_COM";
    private static final String PRODUCT_NAME_SOAPCONNECTOR = "SSA_TA_Connector_for_SOAP";
    private static final String PRODUCT_NAME_XMLCONNECTOR = "SSA_TA_Connector_for_XML";
    private static final String PRODUCT_NAME_CORBACONNECTOR = "SSA_TA_Connector_for CORBA";
    private static final String PRODUCT_NAME_OLEDBCONNECTOR = "SSA_TA_Connector_for_OLEDB";
    private static final String PRODUCT_NAME_JDBCCONNECTOR = "SSA_TA_Connector_for_JDBC";
    private static final String PRODUCT_NAME_BCBECONVERSIONTOOL = "SSA_TA_BCBE_Migration_ToolKit";
    private static final String PRODUCT_NAME_ISERIES_ADAPTER = "SSA_TA_Adapter_for_iSeries";
    public static final int MAX_HOURS = 23;
    public static final int MAX_MINUTES = 59;
    public static final int MAX_SECONDS = 59;
    public static final int MAX_MILLISECONDS = 999;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int WARNING_DAYS_3 = 30;
    public static final int WARNING_DAYS_2 = 14;
    public static final int WARNING_DAYS_1 = 2;
    public static final int DEFAULT_CONFIRM_TIME = 60;
    private com.baan.bclm.License m_license = null;
    private ConfirmTimer m_confirmTimer = null;
    private boolean m_extended = false;
    private int m_initializedResult = 1;
    private int m_productId = 0;
    private String m_appName = "";
    private String m_userName = null;
    private String m_hostName = null;
    private Vector m_listeners = new Vector();
    private static Hashtable m_productList = new Hashtable();

    public License(int n) throws LicenseException {
        this(n, System.getProperty("user.name"));
    }

    public License(int n, String string) throws LicenseException {
        this(n, string, null);
    }

    public License(int n, String string, String string2) throws LicenseException {
        this.m_productId = n;
        this.m_appName = (String)m_productList.get(new Integer(n));
        if (this.m_appName == null) {
            this.m_appName = "OpenWorld_" + n;
        }
        this.m_userName = string;
        if (string2 != null) {
            this.m_hostName = string2;
        } else {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.m_hostName = inetAddress.getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                s_logger.errorMessage("license: Unknown host exception, unable to retrieve hostname");
                this.m_hostName = "";
            }
        }
        int n2 = this.m_hostName.indexOf(".");
        if (n2 > 0) {
            this.m_hostName = this.m_hostName.substring(0, n2);
        }
        s_logger.message("license: Trying to create SLM license for id '" + n + "' and app '" + this.m_appName + "'");
        s_logger.message("license: with user name '" + this.m_userName + "' and host name '" + this.m_hostName + "'");
        try {
            this.m_initializedResult = LicenseManager.Initialize((String)this.m_appName);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string3 = "license: Error initializing SLM client, SLM client not correctly installed, com_baan_bclm_LicenseManager library not found: " + unsatisfiedLinkError;
            s_logger.errorMessage(string3);
            throw new LicenseException(string3);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string4 = "license: Error initializing SLM client, SLM client not correctly installed, com_baan_bclm.jar not found";
            s_logger.errorMessage(string4);
            throw new LicenseException(string4);
        }
        if (this.m_initializedResult != 0) {
            s_logger.errorMessage("license: SLM server cannot be reached");
            this.m_license = null;
            if (this.m_license != null) {
                if (this.getDaysLeft() < 0) {
                    s_logger.message("license: Cached information is expired");
                    this.m_license = null;
                } else {
                    s_logger.message("license: Cached information found, using it");
                }
            } else {
                s_logger.message("license: Cached information not found");
            }
        } else {
            s_logger.message("license: SLM Library initialized, requesting license");
            this.m_license = LicenseManager.RequestLicense((int)this.m_productId, (String)this.m_userName, (String)this.m_hostName);
            s_logger.message("license: " + this.getMessage());
        }
        int n3 = 60;
        if (this.m_license != null && this.m_license.getState() == 0) {
            n3 = this.m_license.getConfirmTime();
        }
        s_logger.message("license: Starting confirm timer, confirm to SLM every '" + n3 + "' seconds");
        this.m_confirmTimer = new ConfirmTimer(n3, this);
    }

    public void release() {
        if (this.m_confirmTimer != null) {
            s_logger.message("license: Stop confirm timer");
            this.m_confirmTimer.stopTimer();
            this.m_confirmTimer = null;
        }
        if (this.m_initializedResult == 0) {
            if (this.m_license.getState() == 0) {
                s_logger.message("license: Releasing license from SLM server (productID=" + this.m_productId + ")");
                LicenseManager.ReleaseLicense((com.baan.bclm.License)this.m_license);
                int n = this.m_license.getState();
                if (n != 0) {
                    s_logger.errorMessage("license: Error releasing license from SLM server, '" + License.fromBclmCode2String(n) + "'");
                }
            } else {
                s_logger.message("license: Not a valid license, ignoring the release");
            }
        } else {
            s_logger.message("license: Not connected to SLM server, ignoring the release");
        }
    }

    private int confirm() {
        int n;
        block14: {
            block12: {
                int n2;
                int n3;
                block13: {
                    n3 = this.getDaysLeft();
                    n2 = -1;
                    if (this.m_license != null) {
                        n2 = this.m_license.getState();
                    }
                    this.m_extended = false;
                    if (this.m_initializedResult != 0) {
                        this.m_initializedResult = LicenseManager.Initialize((String)this.m_appName);
                        if (this.m_initializedResult == 0) {
                            s_logger.message("license: connected to SLM server");
                            this.m_license = null;
                        }
                    }
                    if (this.m_initializedResult != 0) break block12;
                    if (this.m_license != null && this.m_license.getState() == 0) break block13;
                    s_logger.message("license: Request license from SLM server (productID=" + this.m_productId + ", user=" + this.m_userName + ")");
                    this.m_license = LicenseManager.RequestLicense((int)this.m_productId, (String)this.m_userName, (String)this.m_hostName);
                    if (this.m_license.getState() == 0) {
                        this.m_extended = true;
                        s_logger.message("license: notify: " + this.getMessage());
                        this.notify(2);
                    }
                    break block14;
                }
                s_logger.message("license: Confirming license with SLM server (productID=" + this.m_productId + ", user=" + this.m_userName + ")");
                LicenseManager.ConfirmLicense((com.baan.bclm.License)this.m_license);
                n = this.m_license.getState();
                switch (n) {
                    case 0: {
                        int n4 = this.getDaysLeft();
                        if (n4 != n3 && n4 <= 30) {
                            s_logger.message("license: notify: " + this.getMessage());
                            this.notify(3);
                            break;
                        }
                        break block14;
                    }
                    case 7: {
                        s_logger.message("license: " + this.getMessage());
                        if (n2 != n) {
                            this.notify(1);
                            break;
                        }
                        break block14;
                    }
                    default: {
                        s_logger.message("license: " + this.getMessage());
                        if (n2 != n) {
                            this.notify(4);
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            s_logger.message("license: Not connected to SLM server, ignoring the confirm");
        }
        n = 60;
        if (this.m_license != null && this.m_license.getState() == 0) {
            n = this.m_license.getConfirmTime();
        }
        return n;
    }

    public int getProductId() {
        return this.m_productId;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getHostName() {
        return this.m_hostName;
    }

    public int getDaysLeft() {
        if (this.m_license == null) {
            return -1;
        }
        if (this.m_license.getState() != 0) {
            return -1;
        }
        return this.m_license.getDaysLeft();
    }

    public Date getExpirationDate() {
        if (this.m_license == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        License.setCalendarToMidnight(calendar);
        calendar.add(6, this.m_license.getDaysLeft());
        return calendar.getTime();
    }

    public String getFormattedExpirationDate() {
        int n = this.getDaysLeft();
        if (n == Integer.MAX_VALUE) {
            return "Never Expires";
        }
        if (n < 0) {
            return "Expired";
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        return simpleDateFormat.format(this.getExpirationDate());
    }

    public String getWarningMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        String string = "The license for product ID " + this.m_productId;
        if (this.m_license != null) {
            if (this.m_license.getState() == 0) {
                int n = this.m_license.getDaysLeft();
                if (this.m_extended) {
                    return string + " is extended" + (n == Integer.MAX_VALUE ? ", it never expires." : " for " + (n + 1) + " day(s).");
                }
                String string2 = "";
                if (this.m_initializedResult != 0) {
                    string2 = "\r(Note: not connected to license server)";
                }
                switch (n) {
                    case -1: {
                        return string + " has expired." + string2;
                    }
                    case 0: {
                        return string + " expires today." + string2;
                    }
                    case 1: {
                        return string + " expires tomorrow." + string2;
                    }
                    case 0x7FFFFFFF: {
                        return string + " never expires." + string2;
                    }
                }
                return string + " expires in " + n + " days." + string2;
            }
            return string + " is not valid, reason: '" + License.fromBclmCode2String(this.m_license.getState()) + "'";
        }
        if (this.m_initializedResult == 0) {
            return string + " is not available";
        }
        return string + " can not be requested. SLM server cannot be reached, reason: " + License.fromBclmCode2String(this.m_initializedResult) + "'";
    }

    public void addLicenseListener(LicenseListener licenseListener) {
        this.m_listeners.addElement(licenseListener);
    }

    public void removeLicenseListener(LicenseListener licenseListener) {
        this.m_listeners.removeElement(licenseListener);
    }

    private void notify(int n) {
        LicenseEvent licenseEvent = new LicenseEvent(this, n, this.getMessage());
        Enumeration enumeration2 = this.m_listeners.elements();
        while (enumeration2.hasMoreElements()) {
            LicenseListener licenseListener = (LicenseListener)enumeration2.nextElement();
            licenseListener.licenseChanged(licenseEvent);
        }
    }

    static String fromBclmCode2String(int n) {
        switch (n) {
            case 0: {
                return "Application function call okay";
            }
            case 1: {
                return "Initialization failed";
            }
            case 2: {
                return "No master application server found";
            }
            case 3: {
                return "Cannot make connection";
            }
            case 4: {
                return "Protocol version error";
            }
            case 5: {
                return "Product-ID unknown";
            }
            case 6: {
                return "Too early to run product";
            }
            case 7: {
                return "Product license is expired";
            }
            case 8: {
                return "Out of licenses for product";
            }
            case 9: {
                return "Desktop unknown";
            }
            case 10: {
                return "Product out of concurrent licenses";
            }
            case 11: {
                return "User unknown";
            }
            case 12: {
                return "User running on too many desktops";
            }
            case 13: {
                return "Server-ID unknown";
            }
            case 14: {
                return "License-ID unknown";
            }
            case 15: {
                return "License-ID expired";
            }
            case 16: {
                return "Slave cannot process request";
            }
            case 17: {
                return "Document layout is invalid";
            }
            case 18: {
                return "Document version is invalid";
            }
            case 19: {
                return "Invalid activation-key";
            }
            case 20: {
                return "Write failure";
            }
            case 21: {
                return "Memory buffer size too small";
            }
            case 255: {
                return "Processing error";
            }
        }
        return "Unknown SLM/Licensing Error occured";
    }

    public static void setCalendarToMidnight(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
    }

    static {
        m_productList.put(new Integer(7072), PRODUCT_NAME_STUDIO);
        m_productList.put(new Integer(7069), PRODUCT_NAME_OLEDBCONNECTOR);
        m_productList.put(new Integer(7068), PRODUCT_NAME_JDBCCONNECTOR);
        m_productList.put(new Integer(7062), PRODUCT_NAME_JAVA);
        m_productList.put(new Integer(7071), PRODUCT_NAME_CORBACONNECTOR);
        m_productList.put(new Integer(7065), PRODUCT_NAME_XMLCONNECTOR);
        m_productList.put(new Integer(7063), PRODUCT_NAME_COMCONNECTOR);
        m_productList.put(new Integer(7064), PRODUCT_NAME_NETCONNECTOR);
        m_productList.put(new Integer(7066), PRODUCT_NAME_SOAPCONNECTOR);
    }

    private class ConfirmTimer
    extends Thread {
        private int m_time;
        private License m_callback_obj;
        private boolean m_keepRunning;

        public ConfirmTimer(int n, License license2) {
            this.m_time = n;
            this.m_callback_obj = license2;
            this.m_keepRunning = true;
            this.setName("ConfirmTimer");
            this.setDaemon(true);
            this.start();
        }

        public void stopTimer() {
            this.m_keepRunning = false;
            this.interrupt();
        }

        public void run() {
            try {
                while (this.m_keepRunning) {
                    Thread.sleep(this.m_time * 999);
                    if (!this.m_keepRunning) continue;
                    this.m_time = this.m_callback_obj.confirm();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

