/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory.ldap;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryEntry;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.NoSuchElementException;
import com.eibus.services.directory.UnsupportedTypeException;
import com.eibus.services.runtime.BusProperties;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPDirectory
implements Directory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.directory.ldap", "LDAPDirectory");
    private Hashtable m_env = new Hashtable(5, 0.075f);
    private InitialDirContext m_ctx = null;
    private String m_defaultSearchRoot;
    private long m_timestamp;
    private Timer m_timer = null;
    private AttributeNameMapping m_mapping = new AttributeNameMapping();
    private static final String OBJECT_CLASS_ATTRIBUTE = "objectclass";
    private static final String ACTIVATION_OBJECTCLASS = "b3activation";
    private static final String CONNECTIONPOINT_OBJECTCLASS = "b3connectiontype";

    private LDAPDirectory() {
        this.m_mapping.add("identifier", null);
        this.m_mapping.add("ownerid", "owner");
        this.m_mapping.add("description", "description");
        this.m_mapping.add("categories", "b3category");
        this.m_mapping.add("physicallocationid", "b3location");
        this.m_mapping.add("physicallocationdesc", "b3locationdesc");
        this.m_mapping.add("administratorid", "b3admin");
        this.m_mapping.add("online", "b3online");
        this.m_mapping.add("companynumber", "companyNumber");
        this.m_mapping.add("uri", "labeleduri");
        this.m_mapping.add("transactional", "b3transactional");
        this.m_mapping.add("implementationclassname", "b3implementationclass");
        this.m_mapping.add("preferredconnection", "PreferredConnection");
        this.m_mapping.add("policy", "eibconnectionpolicy");
        this.m_mapping.add("type", "b3activationtype");
        this.m_mapping.add("servicereference", "b3activationreference");
        this.m_mapping.add("activationpolicy", "b3activationpoolpolicy");
        this.m_mapping.add("servertimeout", "b3activationservertimeout");
    }

    public LDAPDirectory(String string, String string2) throws DirectoryException {
        this();
        this.m_defaultSearchRoot = string2;
        this.m_env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.m_env.put("java.naming.provider.url", string);
        this.InitialDirContext();
    }

    public LDAPDirectory(String string, String string2, String string3, String string4, String string5) throws DirectoryException {
        this();
        this.m_defaultSearchRoot = string2;
        this.m_env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.m_env.put("java.naming.provider.url", string);
        this.m_env.put("java.naming.security.authentication", string3);
        this.m_env.put("java.naming.security.principal", string4);
        this.m_env.put("java.naming.security.credentials", string5);
        this.InitialDirContext();
    }

    public BusComponent retrieveBusComponent(String string) throws DirectoryException, NoSuchElementException, UnsupportedTypeException {
        BusComponent busComponent;
        Attributes attributes;
        s_logger.flowMessage("DirectoryService.retrieveBusComponent '" + string + "'");
        try {
            attributes = this.getAttributes(string);
        }
        catch (NameNotFoundException nameNotFoundException) {
            throw new NoSuchElementException(string);
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
        try {
            Attribute attribute = attributes.get(OBJECT_CLASS_ATTRIBUTE);
            if (attribute == null) {
                throw new UnsupportedTypeException(string);
            }
            if (!attribute.contains("b3component")) {
                throw new UnsupportedTypeException(string);
            }
            busComponent = new BusComponent(this.m_mapping.toB3(attributes));
            busComponent.setIdentifier(string);
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
        busComponent.setConnectionPoints(this.retrieveConnectionPoints(string));
        busComponent.setActivation(this.retrieveActivation(string));
        return busComponent;
    }

    private Vector retrieveConnectionPoints(String string) throws DirectoryException {
        s_logger.flowMessage("DirectoryService.retrieveConnectionPoints for '" + string + "'");
        Vector<ConnectionPoint> vector = new Vector<ConnectionPoint>();
        try {
            NamingEnumeration namingEnumeration = this.list(string);
            while (namingEnumeration.hasMore()) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.next();
                String string2 = nameClassPair.getName() + ", " + string;
                Attributes attributes = this.getAttributes(string2);
                Attribute attribute = attributes.get(OBJECT_CLASS_ATTRIBUTE);
                if (attribute == null) {
                    throw new UnsupportedTypeException(string);
                }
                if (!attribute.contains(CONNECTIONPOINT_OBJECTCLASS)) continue;
                ConnectionPoint connectionPoint = new ConnectionPoint(this.m_mapping.toB3(attributes));
                connectionPoint.setIdentifier(string2);
                vector.addElement(connectionPoint);
            }
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
        return vector;
    }

    private Activation retrieveActivation(String string) throws DirectoryException {
        s_logger.flowMessage("DirectoryService.retrieveActivation for '" + string + "'");
        Activation activation = null;
        try {
            NamingEnumeration namingEnumeration = this.list(string);
            boolean bl = false;
            while (!bl && namingEnumeration.hasMore()) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.next();
                String string2 = nameClassPair.getName() + ", " + string;
                Attributes attributes = this.getAttributes(string2);
                Attribute attribute = attributes.get(OBJECT_CLASS_ATTRIBUTE);
                if (attribute == null) {
                    throw new UnsupportedTypeException(string);
                }
                if (!attribute.contains(ACTIVATION_OBJECTCLASS)) continue;
                activation = new Activation(this.m_mapping.toB3(attributes));
                activation.setIdentifier(string2);
                bl = true;
            }
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
        return activation;
    }

    public void storeBusComponent(BusComponent busComponent) throws DirectoryException {
        Activation activation;
        Serializable serializable;
        Object object;
        if (!busComponent.isStorable()) {
            throw new DirectoryException("Cannot store entry " + busComponent + ". It is not storable (most probably an anonymous client)");
        }
        String string = busComponent.getIdentifier();
        try {
            object = this.list(string);
            while (object.hasMore()) {
                serializable = (NameClassPair)object.next();
                try {
                    this.destroySubcontext(((NameClassPair)serializable).getName() + ", " + string);
                }
                catch (NamingException namingException) {
                    throw new DirectoryException(namingException);
                }
            }
        }
        catch (NameNotFoundException nameNotFoundException) {
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
        object = this.m_mapping.toLDAP(busComponent.getAttributes());
        serializable = new BasicAttribute(OBJECT_CLASS_ATTRIBUTE);
        serializable.add("top");
        serializable.add("b3component");
        object.put((Attribute)serializable);
        object.put("cn", this.getCN(string));
        try {
            this.createSubcontext(string, (Attributes)object);
        }
        catch (NameAlreadyBoundException nameAlreadyBoundException) {
            try {
                this.destroySubcontext(string);
                this.createSubcontext(string, (Attributes)object);
            }
            catch (NamingException namingException) {
                throw new DirectoryException(namingException);
            }
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
        this.storeConnectionPoints(string, busComponent.getConnectionPoints());
        try {
            activation = busComponent.getActivation();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            activation = null;
        }
        this.storeActivation(string, activation);
    }

    public void deleteBusComponent(BusComponent busComponent) throws DirectoryException {
        DirectoryEntry directoryEntry;
        Enumeration enumeration2 = busComponent.getConnectionPoints();
        if (enumeration2 != null) {
            while (enumeration2.hasMoreElements()) {
                directoryEntry = (ConnectionPoint)enumeration2.nextElement();
                this.deleteConnectionPoint((ConnectionPoint)directoryEntry);
            }
        }
        try {
            directoryEntry = busComponent.getActivation();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            directoryEntry = null;
        }
        if (directoryEntry != null) {
            try {
                this.unbind("cn=activation, " + busComponent.getIdentifier());
            }
            catch (NamingException namingException) {
                throw new DirectoryException(namingException);
            }
        }
        try {
            this.unbind(busComponent.getIdentifier());
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
    }

    private void deleteConnectionPoint(ConnectionPoint connectionPoint) throws DirectoryException {
        try {
            this.unbind(connectionPoint.getIdentifier());
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
    }

    private void storeConnectionPoints(String string, Enumeration enumeration2) throws DirectoryException {
        if (enumeration2 == null) {
            return;
        }
        Enumeration enumeration3 = enumeration2;
        while (enumeration3.hasMoreElements()) {
            ConnectionPoint connectionPoint = (ConnectionPoint)enumeration3.nextElement();
            Attributes attributes = this.m_mapping.toLDAP(connectionPoint.getAttributes());
            BasicAttribute basicAttribute = new BasicAttribute(OBJECT_CLASS_ATTRIBUTE);
            basicAttribute.add("top");
            basicAttribute.add(CONNECTIONPOINT_OBJECTCLASS);
            attributes.put(basicAttribute);
            String string2 = this.getCN(connectionPoint.getIdentifier());
            attributes.put("cn", string2);
            try {
                this.createSubcontext("cn=" + string2 + ", " + string, attributes);
            }
            catch (NamingException namingException) {
                throw new DirectoryException(namingException);
            }
        }
    }

    private void storeActivation(String string, Activation activation) throws DirectoryException {
        if (activation == null) {
            return;
        }
        Attributes attributes = this.m_mapping.toLDAP(activation.getAttributes());
        BasicAttribute basicAttribute = new BasicAttribute(OBJECT_CLASS_ATTRIBUTE);
        basicAttribute.add("top");
        basicAttribute.add(ACTIVATION_OBJECTCLASS);
        attributes.put(basicAttribute);
        String string2 = "activation";
        attributes.put("cn", string2);
        try {
            this.createSubcontext("cn=" + string2 + ", " + string, attributes);
        }
        catch (NamingException namingException) {
            throw new DirectoryException(namingException);
        }
    }

    private String getCN(String string) {
        int n = string.indexOf(44);
        if (n == -1) {
            n = string.length();
        }
        return string.substring(string.indexOf(61) + 1, n).trim();
    }

    public String[] listAllBusComponents() throws DirectoryException {
        Object[] objectArray;
        Enumeration enumeration2 = this.findAllBusComponents(0);
        Vector<String> vector = new Vector<String>();
        while (enumeration2.hasMoreElements()) {
            objectArray = (BusComponent)enumeration2.nextElement();
            vector.addElement(objectArray.getIdentifier());
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] listAllBusComponentCategories() throws DirectoryException {
        throw new DirectoryException("Method listAllBusComponentCategories not supported");
    }

    public String[] listBusComponentIdsWithCategory(String string) throws DirectoryException {
        throw new DirectoryException("Method listBusComponentIdsWithCategory not supported");
    }

    public Enumeration findAllBusComponents(int n) throws DirectoryException {
        return this.findAllBusComponents(this.m_defaultSearchRoot, n);
    }

    public Enumeration findBusComponents(String string, String string2, int n) throws DirectoryException {
        return this.findBusComponents(this.m_defaultSearchRoot, string, string2, n);
    }

    public Enumeration findAllBusComponents(String string, int n) throws DirectoryException {
        return this.findB3ComponentsWithFilter(string, "(objectclass=b3component)", n);
    }

    public Enumeration findBusComponents(String string, String string2, String string3, int n) throws DirectoryException {
        String string4 = this.m_mapping.getLDAPName(string2.toLowerCase());
        if (string4 == null) {
            throw new DirectoryException("Don't know how to handle the " + string2 + " attribute.");
        }
        return this.findB3ComponentsWithFilter(string, "(&(objectclass=b3component)(" + string4 + "=" + string3 + "))", n);
    }

    private Enumeration findB3ComponentsWithFilter(String string, String string2, int n) throws DirectoryException {
        Vector<BusComponent> vector = new Vector<BusComponent>();
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setCountLimit(n);
            NamingEnumeration namingEnumeration = this.search(string, string2, searchControls);
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = (SearchResult)namingEnumeration.next();
                try {
                    String string3 = searchResult.getName();
                    string3 = string3 == null ? string : string3 + ", " + string;
                    vector.addElement(this.retrieveBusComponent(string3));
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                catch (UnsupportedTypeException unsupportedTypeException) {
                    throw new DirectoryException("Invalid directory structure.");
                }
            }
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
        }
        catch (NamingException namingException) {
            s_logger.errorException(namingException);
            throw new DirectoryException(namingException);
        }
        return vector.elements();
    }

    public void update() {
    }

    public BusComponent createAnonymousComponent(String string, String string2, String string3) throws DirectoryException {
        BusComponent busComponent = null;
        try {
            while (this.retrieveBusComponent(string) != null) {
                string = "_" + string;
            }
        }
        catch (DirectoryException directoryException) {
            busComponent = new BusComponent(string, string2, false);
        }
        Vector vector = ConnectionPoint.getDefaultConnectionPoints(string3);
        if (vector != null) {
            busComponent.setConnectionPoints(vector);
        }
        return busComponent;
    }

    private synchronized void InitialDirContext() throws DirectoryException {
        this.open();
    }

    private void open() throws DirectoryException {
        this.m_timestamp = new Date().getTime();
        if (this.m_ctx == null) {
            s_logger.message("Opening LDAP connection");
            try {
                this.m_ctx = new InitialDirContext(this.m_env);
                Timer timer = new Timer();
                timer.setDaemon(true);
                timer.start();
            }
            catch (NamingException namingException) {
                throw new DirectoryException(namingException);
            }
        }
    }

    private synchronized void close() {
        s_logger.flowMessage("Closing LDAP connection (by dereferencing it)");
        this.m_ctx = null;
    }

    private synchronized Attributes getAttributes(String string) throws DirectoryException, NamingException {
        this.open();
        Attributes attributes = this.m_ctx.getAttributes(string);
        return attributes;
    }

    private synchronized NamingEnumeration list(String string) throws DirectoryException, NamingException {
        this.open();
        NamingEnumeration<NameClassPair> namingEnumeration = this.m_ctx.list(string);
        return namingEnumeration;
    }

    private synchronized void destroySubcontext(String string) throws DirectoryException, NamingException {
        this.open();
        this.m_ctx.destroySubcontext(string);
    }

    private synchronized void createSubcontext(String string, Attributes attributes) throws DirectoryException, NamingException {
        this.open();
        this.m_ctx.createSubcontext(string, attributes);
    }

    private synchronized void unbind(String string) throws DirectoryException, NamingException {
        this.open();
        this.m_ctx.unbind(string);
    }

    private synchronized NamingEnumeration search(String string, String string2, SearchControls searchControls) throws DirectoryException, NamingException {
        this.open();
        NamingEnumeration<SearchResult> namingEnumeration = this.m_ctx.search(string, string2, searchControls);
        return namingEnumeration;
    }

    public boolean isADS() {
        try {
            String string = BusProperties.getProperty("bus.services.directory.Root");
            String string2 = "";
            string2 = string.indexOf("DC=", 0) > 0 ? string.substring(string.indexOf("DC=", 0)) : string;
            try {
                this.open();
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
            Attributes attributes = this.m_ctx.getAttributes("CN=MicrosoftDNS,CN=System," + string2);
            return true;
        }
        catch (NamingException namingException) {
            return false;
        }
    }

    class Timer
    extends Thread {
        Timer() {
        }

        public void run() {
            long l;
            long l2 = 300000L;
            do {
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((l = new Date().getTime()) - LDAPDirectory.this.m_timestamp <= l2);
            LDAPDirectory.this.close();
        }
    }

    private class AttributeNameMapping {
        private Hashtable m_busLdapMapping = new Hashtable();
        private Hashtable m_ldapBusMapping = new Hashtable();
        private VoidObject m_void = new VoidObject();

        private AttributeNameMapping() {
        }

        void add(String string, String string2) {
            if (string != null) {
                if (string2 == null) {
                    this.m_busLdapMapping.put(string.toLowerCase(), this.m_void);
                } else {
                    this.m_busLdapMapping.put(string.toLowerCase(), string2.toLowerCase());
                }
            }
            if (string2 != null) {
                if (string == null) {
                    this.m_ldapBusMapping.put(string2.toLowerCase(), this.m_void);
                } else {
                    this.m_ldapBusMapping.put(string2.toLowerCase(), string.toLowerCase());
                }
            }
        }

        String getLDAPName(String string) {
            String string2 = string.toLowerCase();
            if (!this.m_busLdapMapping.containsKey(string2)) {
                return null;
            }
            Object v = this.m_busLdapMapping.get(string2);
            if (v instanceof VoidObject) {
                return null;
            }
            return (String)v;
        }

        String getB3Name(String string) {
            String string2 = string.toLowerCase();
            if (!this.m_ldapBusMapping.containsKey(string2)) {
                return string2;
            }
            Object v = this.m_ldapBusMapping.get(string2);
            if (v instanceof VoidObject) {
                return null;
            }
            return (String)v;
        }

        Attributes toLDAP(Hashtable hashtable) {
            BasicAttributes basicAttributes = new BasicAttributes(true);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                String string2 = this.getLDAPName(string);
                if (string2 == null) continue;
                BasicAttribute basicAttribute = new BasicAttribute(string2);
                Object v = hashtable.get(string);
                if (v instanceof String) {
                    basicAttribute.add(v);
                } else {
                    if (((Vector)v).size() == 0) continue;
                    Enumeration enumeration3 = ((Vector)v).elements();
                    while (enumeration3.hasMoreElements()) {
                        basicAttribute.add(enumeration3.nextElement());
                    }
                }
                basicAttributes.put(basicAttribute);
            }
            return basicAttributes;
        }

        Hashtable toB3(Attributes attributes) throws NamingException {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
            while (namingEnumeration.hasMore()) {
                int n;
                Attribute attribute = namingEnumeration.next();
                String string = this.getB3Name(attribute.getID());
                if (string == null || (n = attribute.size()) == 0) continue;
                if (n == 1) {
                    hashtable.put(string, attribute.get());
                    continue;
                }
                Vector vector = new Vector(n);
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMore()) {
                    vector.addElement(namingEnumeration2.next());
                }
                hashtable.put(string, vector);
            }
            return hashtable;
        }

        private class VoidObject {
            private VoidObject() {
            }
        }
    }
}

