/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory.file;

import com.eibus.services.directory.DirectoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class ServerSource {
    String description;
    File file;
    URL url;

    public ServerSource(String string) throws DirectoryException {
        if (string == null) {
            throw new DirectoryException("Cannot find property denoting file containing directory service");
        }
        this.description = string;
        this.file = new File(string);
        if (this.file.exists()) {
            return;
        }
        this.file = null;
        try {
            this.url = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new DirectoryException("Directory Server '" + string + "' is neither a file nor a URL");
        }
    }

    public InputStream getInputStream() throws DirectoryException {
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (IOException iOException) {
                throw new DirectoryException(iOException);
            }
        }
        try {
            return this.url.openStream();
        }
        catch (IOException iOException) {
            throw new DirectoryException(iOException);
        }
    }

    public OutputStream getOutputStream() throws DirectoryException {
        if (this.file != null) {
            try {
                return new FileOutputStream(this.file);
            }
            catch (IOException iOException) {
                throw new DirectoryException(iOException);
            }
        }
        throw new DirectoryException("The source you are using is a URL (" + this.url + "). Cannot write to a web server");
    }
}

