/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory.file;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.xml.util.ElementEnumeration;
import com.eibus.xml.util.NiceDOMWriter;
import java.util.Dictionary;
import java.util.Hashtable;

class OldDirectoryFileConverter {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.directory.file", "OldDirectoryFileConverter");
    Document document;
    static final String B3COMPONENT_TAG = "b3component";
    static final String BUSCOMPONENT_TAG = "BusComponent";
    static Dictionary mappingTable = new Hashtable();

    OldDirectoryFileConverter(Document document) {
        this.document = document;
        Element element = document.getDocumentElement();
        ElementEnumeration elementEnumeration = new ElementEnumeration(element, B3COMPONENT_TAG);
        while (elementEnumeration.hasMoreElements()) {
            Element element2 = (Element)elementEnumeration.nextElement();
            s_logger.message("Converting directory-component that is stored in old format\nFormat of old component:\n" + new NiceDOMWriter(element2).toString());
            Element element3 = this.convertB3Component(element2);
            s_logger.message("Format of new component: \n" + new NiceDOMWriter(element3).toString());
            element.appendChild(element3);
            element.removeChild(element2);
        }
    }

    private Element convertB3Component(Element element) {
        Element element2 = this.document.createElement(BUSCOMPONENT_TAG);
        Element element3 = null;
        Element element4 = null;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element5 = (Element)node;
                String string = element5.getTagName();
                if (string.equals("connectionType")) {
                    if (element3 == null) {
                        element3 = this.document.createElement("connection-points");
                        element2.appendChild(element3);
                    }
                    element3.appendChild(this.convertConnectionType(element5));
                } else if (string.equals("category")) {
                    if (element4 == null) {
                        element4 = this.document.createElement("categories");
                        element2.appendChild(element4);
                    }
                    element4.appendChild(element5.removeChild(element5.getFirstChild()));
                } else {
                    String string2 = (String)mappingTable.get(string);
                    if (string2 != null) {
                        Element element6 = this.document.createElement(string2);
                        this.moveChildren(element5, element6);
                        element2.appendChild(element6);
                    }
                }
            }
            node = node.getNextSibling();
        }
        return element2;
    }

    private Element convertConnectionType(Element element) {
        Element element2 = null;
        element2 = this.document.createElement("ConnectionPoint");
        Node node = element.getFirstChild();
        while (node != null) {
            Element element3;
            String string;
            if (node instanceof Element && (string = (String)mappingTable.get((element3 = (Element)node).getTagName())) != null) {
                Element element4 = this.document.createElement(string);
                this.moveChildren(element3, element4);
                element2.appendChild(element4);
            }
            node = node.getNextSibling();
        }
        return element2;
    }

    private void moveChildren(Element element, Element element2) {
        Node node = element.getFirstChild();
        while (node != null) {
            element2.appendChild(element.removeChild(node));
            node = element.getFirstChild();
        }
    }

    static {
        mappingTable.put("id", "identifier");
        mappingTable.put("owner", "ownerid");
        mappingTable.put("description", "description");
        mappingTable.put("admin", "administratorid");
        mappingTable.put("companyNumber", "companynumber");
        mappingTable.put("online", "online");
        mappingTable.put("location", "physicallocationdesc");
        mappingTable.put("locationid", "physicallocationid");
        mappingTable.put("policy", "policy");
        mappingTable.put("preferredConnection", "preferredconnection");
        mappingTable.put("transactional", "transactional");
        mappingTable.put("uri", "uri");
    }
}

