/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory.file;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryEntry;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.NoSuchElementException;
import com.eibus.services.directory.UnsupportedTypeException;
import com.eibus.services.directory.file.OldDirectoryFileConverter;
import com.eibus.services.directory.file.ServerSource;
import com.eibus.xml.dom.DocumentImpl;
import com.eibus.xml.dom.SAXDocument;
import com.eibus.xml.util.DOMWriter;
import com.eibus.xml.util.ElementEnumeration;
import com.eibus.xml.util.NiceDOMWriter;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FileDirectory
implements Directory {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.directory.file", "FileDirectory");
    public static final String BUSCOMPONENT_TAG = "BusComponent";
    public static final String SEPERATOR_WITH_SPACE = ", o=";
    public static final String SEPERATOR_WITHOUT_SPACE = ",o=";
    public static final int NOTFOUND = -1;
    private String locationDescription;
    private String defaultSearchRoot;
    private Dictionary names;
    private ServerSource source;

    public FileDirectory(String string, String string2) throws DirectoryException {
        this.locationDescription = new String(string);
        this.defaultSearchRoot = new String(string2);
        this.initialize();
    }

    public FileDirectory(String string, String string2, String string3, String string4, String string5) throws DirectoryException {
        this(string, string2);
    }

    public void initialize() throws DirectoryException {
        this.names = new Hashtable();
        if (this.locationDescription == null) {
            this.locationDescription = System.getProperty("bus.services.directory.ServerURL");
        }
        this.source = new ServerSource(this.locationDescription);
        this.load(this.source);
    }

    public DirectoryEntry getObject(String string) throws NoSuchElementException {
        Object v = this.names.get(this.normalize(string));
        if (v == null) {
            throw new NoSuchElementException(string);
        }
        return (DirectoryEntry)v;
    }

    String normalize(String string) {
        return string.toLowerCase().trim();
    }

    public void register(DirectoryEntry directoryEntry) throws DirectoryException {
        String string = directoryEntry.getIdentifier();
        if (string != null) {
            this.names.put(this.normalize(string), directoryEntry);
        }
    }

    public void unregister(BusComponent busComponent) throws DirectoryException {
        String string = busComponent.getIdentifier();
        this.names.remove(this.normalize(string));
    }

    public Enumeration contents() {
        return this.names.elements();
    }

    private void load(ServerSource serverSource) throws DirectoryException {
        SAXDocument sAXDocument = new SAXDocument();
        InputStream inputStream = serverSource.getInputStream();
        try {
            sAXDocument.load(inputStream);
        }
        catch (Exception exception) {
            throw new DirectoryException("Could not parse XML document: " + exception);
        }
        Element element = sAXDocument.getDocumentElement();
        new OldDirectoryFileConverter(sAXDocument);
        ElementEnumeration elementEnumeration = new ElementEnumeration(element, BUSCOMPONENT_TAG);
        while (elementEnumeration.hasMoreElements()) {
            BusComponent busComponent = this.readComponent((Element)elementEnumeration.nextElement());
            this.register(busComponent);
        }
    }

    private BusComponent readComponent(Element element) {
        Object object;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Node node = element.getFirstChild();
        Activation activation = null;
        while (node != null) {
            if (node instanceof Element) {
                object = (Element)node;
                String string = object.getTagName();
                if (string.equals("connection-points")) {
                    vector = this.getConnectionPoints((Element)object);
                } else if (string.equals("categories")) {
                    vector2 = this.getCategories((Element)object);
                } else if (string.equals("Activation")) {
                    try {
                        activation = this.readActivation((Element)object);
                    }
                    catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                        s_logger.message(attributeNotSpecifiedException.getMessage());
                    }
                } else {
                    Node node2 = object.getFirstChild();
                    String string2 = "";
                    if (node2 != null) {
                        string2 = node2.getNodeValue();
                    }
                    hashtable.put(string, string2);
                }
            }
            node = node.getNextSibling();
        }
        object = new BusComponent(hashtable);
        ((BusComponent)object).setCategories(vector2);
        ((BusComponent)object).setConnectionPoints(vector);
        ((BusComponent)object).setActivation(activation);
        return object;
    }

    private Vector getCategories(Element element) {
        Vector<String> vector = new Vector<String>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                vector.addElement(node.getFirstChild().getNodeValue());
            }
            node = node.getNextSibling();
        }
        return vector;
    }

    private Vector getConnectionPoints(Element element) {
        Vector<ConnectionPoint> vector = new Vector<ConnectionPoint>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                vector.addElement(this.readConnectionPoint((Element)node));
            }
            node = node.getNextSibling();
        }
        return vector;
    }

    ConnectionPoint readConnectionPoint(Element element) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                Node node2 = element2.getFirstChild();
                String string2 = "";
                if (node2 != null) {
                    string2 = node2.getNodeValue();
                }
                hashtable.put(string, string2);
            }
            node = node.getNextSibling();
        }
        return new ConnectionPoint(hashtable);
    }

    private Activation readActivation(Element element) throws AttributeNotSpecifiedException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = element.getTagName();
        if (!string5.equals("Activation")) {
            throw new RuntimeException("Programming Error: trying to convert " + string5 + " XML Tree to Activation object");
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                String string6 = element2.getTagName();
                if (string6.equals("type")) {
                    string = new DOMWriter(element2.getFirstChild()).toString();
                } else if (string6.equals("servicereference")) {
                    string2 = new DOMWriter(element2.getFirstChild()).toString();
                } else if (string6.equals("activationpolicy")) {
                    string3 = new DOMWriter(element2.getFirstChild()).toString();
                } else if (string6.equals("servertimeout")) {
                    string4 = new DOMWriter(element2.getFirstChild()).toString();
                }
            }
            node = node.getNextSibling();
        }
        if (string == null) {
            throw new AttributeNotSpecifiedException("type");
        }
        if (string2 == null) {
            throw new AttributeNotSpecifiedException("servicereference");
        }
        if (string3 == null) {
            string3 = "shared";
            s_logger.message("policy not specified in BusComponent, using default policy");
        }
        if (string4 == null) {
            string4 = "720";
            s_logger.message("timeout not specified in BusComponent, using default timeout");
        }
        return new Activation(string, string2, string3, string4);
    }

    public void save() throws DirectoryException {
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElement("DirectoryService");
        documentImpl.appendChild(element);
        Enumeration enumeration2 = this.contents();
        while (enumeration2.hasMoreElements()) {
            BusComponent busComponent = (BusComponent)enumeration2.nextElement();
            Document document = busComponent.toDOM();
            element.appendChild(document.getDocumentElement());
        }
        new NiceDOMWriter(documentImpl, this.source.getOutputStream(), 0, 4).flush();
    }

    public BusComponent retrieveBusComponent(String string) throws DirectoryException, NoSuchElementException, UnsupportedTypeException {
        DirectoryEntry directoryEntry;
        block7: {
            String string2 = null;
            int n = 0;
            directoryEntry = null;
            DirectoryEntry directoryEntry2 = null;
            s_logger.message("(file) DirectoryService.retrieveBusComponent '" + string + "'");
            try {
                directoryEntry = this.getObject(string);
            }
            catch (DirectoryException directoryException) {
                n = string.indexOf(SEPERATOR_WITH_SPACE);
                if (n != -1) {
                    string2 = string.substring(0, n + 1) + string.substring(n + 2, string.length());
                } else {
                    n = string.indexOf(SEPERATOR_WITHOUT_SPACE);
                    if (n != -1) {
                        string2 = string.substring(0, n + 1) + " " + string.substring(n + 1, string.length());
                    } else {
                        throw new DirectoryException(directoryException);
                    }
                }
                s_logger.message("Not fond '" + string + "' in the file based directory, trying to find '" + string2 + "' instead");
                directoryEntry = directoryEntry2 = this.getObject(string2);
                if (directoryEntry instanceof BusComponent) break block7;
                throw new UnsupportedTypeException(string2);
            }
        }
        if (!(directoryEntry instanceof BusComponent)) {
            throw new UnsupportedTypeException(string);
        }
        return (BusComponent)directoryEntry;
    }

    public void storeBusComponent(BusComponent busComponent) throws DirectoryException {
        this.register(busComponent);
        this.save();
    }

    public void deleteBusComponent(BusComponent busComponent) throws DirectoryException {
        this.unregister(busComponent);
        this.save();
    }

    public String[] listAllBusComponents() throws DirectoryException {
        Object[] objectArray;
        Enumeration enumeration2 = this.findAllBusComponents(0);
        Vector<String> vector = new Vector<String>();
        while (enumeration2.hasMoreElements()) {
            objectArray = (BusComponent)enumeration2.nextElement();
            vector.addElement(objectArray.getIdentifier());
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] listAllBusComponentCategories() throws DirectoryException {
        throw new DirectoryException("Method listAllBusComponentCategories not supported");
    }

    public String[] listBusComponentIdsWithCategory(String string) throws DirectoryException {
        throw new DirectoryException("Method listBusComponentIdsWithCategory not supported");
    }

    public Enumeration findAllBusComponents(int n) throws DirectoryException {
        if (n == 0) {
            n = this.names.size() + 1;
        }
        int n2 = 0;
        Vector<BusComponent> vector = new Vector<BusComponent>();
        Enumeration enumeration2 = this.names.elements();
        while (enumeration2.hasMoreElements() && n2 < n) {
            Object v = enumeration2.nextElement();
            if (v instanceof BusComponent) {
                String string;
                String string2 = ((BusComponent)v).getIdentifier();
                int n3 = string2.indexOf("=");
                int n4 = string2.indexOf(",");
                if (n4 >= 0 && (string = string2.substring(n3 + 1, n4)).trim().length() != 0) {
                    vector.addElement((BusComponent)v);
                }
            }
            ++n2;
        }
        return vector.elements();
    }

    public Enumeration findBusComponents(String string, String string2, int n) throws DirectoryException {
        String string3 = null;
        int n2 = 0;
        Vector<BusComponent> vector = new Vector<BusComponent>();
        Enumeration enumeration2 = this.names.elements();
        while (enumeration2.hasMoreElements() && n2 < n) {
            Object v = enumeration2.nextElement();
            if (v instanceof BusComponent) {
                BusComponent busComponent = (BusComponent)v;
                try {
                    string3 = busComponent.getAttributeValue(string);
                }
                catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                    throw new DirectoryException(attributeNotSpecifiedException.toString());
                }
                if (string3.equals(string2)) {
                    vector.addElement(busComponent);
                }
            }
            ++n2;
        }
        return vector.elements();
    }

    public Enumeration findAllBusComponents(String string, int n) throws DirectoryException {
        s_logger.message("File directory service does not support hierarchial subtrees. Returns enumeration from root.");
        return this.findAllBusComponents(n);
    }

    public Enumeration findBusComponents(String string, String string2, String string3, int n) throws DirectoryException {
        s_logger.message("File directory service does not support hierarchial subtrees. Returns enumeration from root.");
        return this.findBusComponents(string2, string3, n);
    }

    public void update() {
    }

    public BusComponent createAnonymousComponent(String string, String string2, String string3) throws DirectoryException {
        BusComponent busComponent = null;
        try {
            while (this.retrieveBusComponent(string) != null) {
                string = "_" + string;
            }
        }
        catch (DirectoryException directoryException) {
            busComponent = new BusComponent(string, string2, false);
        }
        Vector vector = ConnectionPoint.getDefaultConnectionPoints(string3);
        if (vector != null) {
            busComponent.setConnectionPoints(vector);
        }
        return busComponent;
    }

    public boolean isADS() {
        return false;
    }
}

