/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory.ccf;

import com.baan.owimpl.fw.ccf.BusComponentCategoryContext;
import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.baan.owimpl.fw.ccf.BusComponentContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.NoSuchElementException;
import com.eibus.services.directory.UnsupportedTypeException;
import java.util.Enumeration;
import java.util.Vector;

public class CCFDirectory
implements Directory {
    private static final ILogger s_logger = LoggerFactory.createLogger(class$com$eibus$services$directory$ccf$CCFDirectory == null ? (class$com$eibus$services$directory$ccf$CCFDirectory = CCFDirectory.class$("com.eibus.services.directory.ccf.CCFDirectory")) : class$com$eibus$services$directory$ccf$CCFDirectory);
    private BusComponentContext m_BusComponentContext;
    private BusComponentCategoryContext m_BusComponentCategoryContext;
    static /* synthetic */ Class class$com$eibus$services$directory$ccf$CCFDirectory;

    public CCFDirectory() throws DirectoryException {
        try {
            this.m_BusComponentContext = BusComponentContext.getInstance();
            s_logger.message("Using ccf-based Buscomponent Directory, URL=" + this.m_BusComponentContext.getURL());
            this.m_BusComponentCategoryContext = BusComponentCategoryContext.getInstance();
            s_logger.message("Using ccf-based BuscomponentCategory Directory, URL=" + this.m_BusComponentCategoryContext.getURL());
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException.getMessage());
        }
    }

    public CCFDirectory(String string, String string2) throws DirectoryException {
        this();
    }

    public CCFDirectory(String string, String string2, String string3, String string4, String string5) throws DirectoryException {
        this();
    }

    private static String convertIdentifier(String string) {
        int n;
        if (string.startsWith("cn=")) {
            string = string.substring(3);
        }
        if ((n = string.indexOf(44)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public BusComponent retrieveBusComponent(String string) throws DirectoryException, NoSuchElementException, UnsupportedTypeException {
        s_logger.flowMessage("DirectoryService.retrieveBusComponent '" + string + "'");
        string = CCFDirectory.convertIdentifier(string);
        try {
            BusComponentConfiguration busComponentConfiguration = this.m_BusComponentContext.get(string);
            BusComponent busComponent = new BusComponent(busComponentConfiguration);
            return busComponent;
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException.getMessage());
        }
    }

    public void storeBusComponent(BusComponent busComponent) throws DirectoryException {
        if (!busComponent.isStorable()) {
            throw new DirectoryException("Cannot store entry " + busComponent + ". It is not storable (most probably an anonymous client)");
        }
        try {
            BusComponentConfiguration busComponentConfiguration = busComponent.getConfiguration();
            busComponentConfiguration.store();
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException);
        }
    }

    public void deleteBusComponent(BusComponent busComponent) throws DirectoryException {
        try {
            BusComponentConfiguration busComponentConfiguration = busComponent.getConfiguration();
            busComponentConfiguration.remove();
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException);
        }
    }

    public String[] listAllBusComponents() throws DirectoryException {
        try {
            return this.m_BusComponentContext.list();
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException);
        }
    }

    public String[] listBusComponentIdsWithCategory(String string) throws DirectoryException {
        Vector<String> vector = new Vector<String>();
        try {
            Object object;
            String[] stringArray = this.m_BusComponentContext.list();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n];
                object = this.retrieveBusComponent(string2);
                try {
                    Enumeration enumeration2 = ((BusComponent)object).getCategories();
                    while (enumeration2.hasMoreElements()) {
                        String string3 = (String)enumeration2.nextElement();
                        if (!string3.equalsIgnoreCase(string)) continue;
                        vector.addElement(string2);
                    }
                }
                catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                    // empty catch block
                }
                ++n;
            }
            int n2 = vector.size();
            object = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                object[n3] = (String)vector.elementAt(n3);
                ++n3;
            }
            return object;
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException);
        }
    }

    public String[] listAllBusComponentCategories() throws DirectoryException {
        try {
            return this.m_BusComponentCategoryContext.list();
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException);
        }
    }

    public Enumeration findAllBusComponents(int n) throws DirectoryException {
        try {
            String[] stringArray = this.m_BusComponentContext.list();
            Vector<BusComponent> vector = new Vector<BusComponent>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.addElement(this.retrieveBusComponent(stringArray[n2]));
                ++n2;
            }
            return vector.elements();
        }
        catch (OWConfigurationException oWConfigurationException) {
            throw new DirectoryException(oWConfigurationException);
        }
    }

    public Enumeration findBusComponents(String string, String string2, int n) throws DirectoryException {
        return this.findAllBusComponents(n);
    }

    public Enumeration findAllBusComponents(String string, int n) throws DirectoryException {
        return this.findAllBusComponents(n);
    }

    public Enumeration findBusComponents(String string, String string2, String string3, int n) throws DirectoryException {
        return this.findAllBusComponents(n);
    }

    public void update() {
    }

    public BusComponent createAnonymousComponent(String string, String string2, String string3) throws DirectoryException {
        BusComponent busComponent = null;
        try {
            while (this.retrieveBusComponent(string) != null) {
                string = "_" + string;
            }
        }
        catch (DirectoryException directoryException) {
            busComponent = new BusComponent(string, string2, false);
        }
        Vector vector = ConnectionPoint.getDefaultConnectionPoints(string3);
        if (vector != null) {
            busComponent.setConnectionPoints(vector);
        }
        return busComponent;
    }

    public boolean isADS() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

