/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.MalformedURIException;

public class URI {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.directory", "URI");
    private int m_port = -1;
    private String m_protocol = null;
    private String m_host = null;
    private String m_path = "";
    private String m_remainder = "";
    private String m_strRepresentation = null;
    private static final String ENDPORT_SPEC = "#endport=";
    private static final char COLON = ':';
    private static final char PATH_SEPARATOR = '/';
    private static final char OTHER_SEPARATOR = ':';
    private static final char NUMBER_SIGN = '#';
    private static final char QUESTION_MARK = '?';
    private static final char EXCLAMATION_MARK = '!';

    public static URI createTransportURI(String string) throws MalformedURIException {
        return new URI(string, true);
    }

    public static URI createURI(String string) throws MalformedURIException {
        return new URI(string, false);
    }

    private URI(String string, boolean bl) throws MalformedURIException {
        if (string == null || string.equals("")) {
            throw new MalformedURIException("Cannot create an uri from an empty string");
        }
        this.parseURI(string, bl);
    }

    public String toString() {
        if (this.m_strRepresentation == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.m_protocol != null) {
                stringBuffer.append(this.m_protocol + "://");
            }
            if (this.m_host != null) {
                stringBuffer.append(this.m_host);
                if (this.m_port >= 0) {
                    stringBuffer.append(":" + this.m_port);
                }
                stringBuffer.append("/");
            }
            stringBuffer.append(this.m_path);
            stringBuffer.append(this.m_remainder);
            this.m_strRepresentation = stringBuffer.toString();
        }
        return this.m_strRepresentation;
    }

    public String getProtocol() {
        return this.m_protocol;
    }

    private void setProtocol(String string) throws MalformedURIException {
        if (string == null || string.equals("")) {
            throw new MalformedURIException("The protocol part of the URI is mandatory");
        }
        if (string.indexOf(32) >= 0) {
            throw new MalformedURIException("The protocol part of the URI cannot contain spaces");
        }
        this.m_protocol = string;
        this.m_strRepresentation = null;
    }

    public String getHost() {
        return this.m_host;
    }

    public void setHost(String string) throws MalformedURIException {
        if (string == null || string.equals("")) {
            if (this.m_protocol != null && this.m_protocol.equals("file")) {
                string = "localhost";
            } else {
                throw new MalformedURIException("The host part of the URI is mandatory");
            }
        }
        if (string.indexOf(32) >= 0) {
            throw new MalformedURIException("The host part of the URI cannot contain spaces");
        }
        this.m_host = string;
        this.m_strRepresentation = null;
    }

    public String getPath() {
        return this.m_path;
    }

    private void setPath(String string) {
        this.m_path = string;
        this.m_strRepresentation = null;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int n) throws MalformedURIException {
        this.setPortRange(n, n);
    }

    public void setPortRange(int n, int n2) throws MalformedURIException {
        if (n >= 0 && n2 >= 0 && n != n2 && n > n2) {
            throw new MalformedURIException("Invalid portrange: the first port (" + n + ") should be smaller than the second port (" + n2 + ")");
        }
        this.m_port = n;
        this.m_strRepresentation = null;
        this.setEndPort(n2);
    }

    public String getRemainder() {
        return this.m_remainder;
    }

    private void setRemainder(String string) {
        this.m_remainder = string;
        this.m_strRepresentation = null;
    }

    public int getEndPort() {
        String string = this.getRemainder();
        int n = 0;
        if (string.equals("")) {
            return this.getPort();
        }
        n = string.indexOf(ENDPORT_SPEC);
        if (n >= 0) {
            int n2 = n += ENDPORT_SPEC.length();
            while (n2 < string.length()) {
                if (!Character.isDigit(string.charAt(n2))) break;
                ++n2;
            }
            return Integer.parseInt(new String(string.toCharArray(), n, n2 - n));
        }
        return this.getPort();
    }

    private void setEndPort(int n) throws MalformedURIException {
        int n2;
        if (n < this.getPort()) {
            throw new MalformedURIException("Invalid portrange: the second port (" + n + ") should be greater than the first port (" + this.getPort() + ")");
        }
        if (n <= 0) {
            throw new MalformedURIException("Invalid portrange: port numbers should be greater than 0");
        }
        String string = this.getRemainder();
        if (string != null && (n2 = string.indexOf(ENDPORT_SPEC)) >= 0) {
            int n3 = n2 + ENDPORT_SPEC.length();
            while (n3 < string.length()) {
                if (!Character.isDigit(string.charAt(n3))) break;
                ++n3;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 > 0) {
                stringBuffer.append(new String(string.toCharArray(), 0, n2));
            }
            if (n3 < string.length()) {
                stringBuffer.append(new String(string.toCharArray(), n3, string.length() - n3));
            }
            this.setRemainder(stringBuffer.toString());
        }
        if (n >= 0 && n != this.getPort()) {
            this.setRemainder(this.getRemainder() + ENDPORT_SPEC + n);
        }
        this.m_strRepresentation = null;
    }

    private void parseURI(String string, boolean bl) throws MalformedURIException {
        int n = 0;
        int n2 = 0;
        while (n < string.length()) {
            if (string.charAt(n) == ':') break;
            ++n;
        }
        if (n == string.length()) {
            throw new MalformedURIException("Invalid or missing protocol");
        }
        String string2 = new String(string.toCharArray(), n2, n);
        this.setProtocol(string2);
        if (!(!bl || string2.equalsIgnoreCase("socket") || string2.equalsIgnoreCase("bidisocket") || string2.equalsIgnoreCase("sslsocket") || string2.equalsIgnoreCase("inproc") || string2.equalsIgnoreCase("jms") || string2.equalsIgnoreCase("MQSeries"))) {
            throw new MalformedURIException("invalid URL protocol " + string2 + " must be: socket, bidisocket, sslsocket, inproc or jms");
        }
        if (string.charAt(n++) != ':' || string.charAt(n++) != '/' || string.charAt(n++) != '/') {
            throw new MalformedURIException("Invalid or missing protocol (:// part is missing)");
        }
        n2 = n;
        while (n < string.length()) {
            if (string.charAt(n) == '/' || string.charAt(n) == ':') break;
            ++n;
        }
        this.setHost(new String(string.toCharArray(), n2, n - n2));
        if (n < string.length()) {
            if (string.charAt(n) == ':') {
                n2 = ++n;
                while (n < string.length()) {
                    if (!Character.isDigit(string.charAt(n))) break;
                    ++n;
                }
                if (n == n2) {
                    throw new MalformedURIException("Expected port after colon (position=" + n + ")");
                }
                this.setPort(Integer.parseInt(new String(string.toCharArray(), n2, n - n2)));
            }
            if (n < string.length() - 1) {
                if (string.charAt(n) != '/') {
                    if (string.charAt(n) == '-') {
                        int n3;
                        int n4;
                        if (!string2.equals("sslsocket") && !string2.equals("bidisocket")) {
                            throw new MalformedURIException("Portrange not supported for protocol '" + string2 + "' only for 'bidisocket' and 'sslsocket'");
                        }
                        try {
                            String string3 = string.substring(n + 1);
                            if (string3.endsWith("/")) {
                                string3 = string3.substring(0, string3.length() - 1);
                            }
                            String string4 = new String(string.toCharArray(), n2, n - n2);
                            n4 = Integer.parseInt(string4);
                            n3 = Integer.parseInt(string3);
                        }
                        catch (Exception exception) {
                            throw new MalformedURIException("Portrange should be <startport>-<endport>");
                        }
                        this.setPortRange(n4, n3);
                    } else {
                        throw new MalformedURIException("Expected '/' or '-' after port specification (instead of a '" + string.charAt(n) + "')");
                    }
                }
                n2 = ++n;
                while (n < string.length()) {
                    if (this.isOtherSeparator(string.charAt(n))) break;
                    ++n;
                }
                this.setPath(new String(string.toCharArray(), n2, n - n2));
                if (n < string.length()) {
                    n2 = n;
                    n = string.length();
                    this.setRemainder(new String(string.toCharArray(), n2, n - n2));
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof URI)) {
            return false;
        }
        return this == object || this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private boolean isOtherSeparator(char c) {
        return c == '#' || c == '?' || c == '!';
    }
}

