/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.ccf.CCFDirectory;
import com.eibus.services.directory.file.FileDirectory;
import com.eibus.services.directory.ldap.LDAPDirectory;

public class DirectoryServiceProvider {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.directory", "DirectoryServiceProvider");
    private static Directory ds = null;

    public Directory getDirectoryService() throws DirectoryException {
        if (ds == null) {
            ds = new CCFDirectory();
        }
        return ds;
    }

    public static Directory getOldDirectoryService(String string, String string2) throws DirectoryException {
        try {
            s_logger.message("Using legacy directory server " + string + ", root is " + string2);
            Directory directory = string.toLowerCase().startsWith("ldap:") ? new LDAPDirectory(string, string2) : new FileDirectory(string, string2);
            return directory;
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            throw new DirectoryException(exception);
        }
    }
}

