/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.Text;
import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.xml.dom.DocumentImpl;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public abstract class DirectoryEntry
implements Cloneable,
Serializable {
    public static final String IDENTIFIER_ATTRIBUTE = "identifier";
    protected Hashtable m_attributes = new Hashtable();
    protected BusComponentConfiguration m_busComponentConfiguration = null;
    private boolean storable = true;
    static Vector s_ignoreAttributes = null;

    public DirectoryEntry() {
    }

    public DirectoryEntry(BusComponentConfiguration busComponentConfiguration) {
        this.m_busComponentConfiguration = busComponentConfiguration;
    }

    public boolean isStorable() {
        return this.storable;
    }

    protected void setStorable(boolean bl) {
        this.storable = bl;
    }

    public DirectoryEntry(boolean bl) {
        this.storable = bl;
    }

    public String getIdentifier() {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getIdentifier();
        }
        return (String)this.m_attributes.get(IDENTIFIER_ATTRIBUTE);
    }

    public Hashtable getAttributes() {
        return (Hashtable)this.m_attributes.clone();
    }

    public BusComponentConfiguration getConfiguration() {
        return this.m_busComponentConfiguration;
    }

    public Document toDOM() {
        DocumentImpl documentImpl = new DocumentImpl();
        String string = this.getClass().getName();
        Element element = documentImpl.createElement(string.substring(string.lastIndexOf(46) + 1));
        documentImpl.appendChild(element);
        Enumeration enumeration2 = this.m_attributes.keys();
        while (enumeration2.hasMoreElements()) {
            String string2 = (String)enumeration2.nextElement();
            Object v = this.m_attributes.get(string2);
            if (s_ignoreAttributes.contains(string2)) continue;
            DirectoryEntry.addProperty(element, string2, v);
        }
        return documentImpl;
    }

    protected static void addProperty(Element element, String string, Object object) {
        Document document = element.getOwnerDocument();
        if (object instanceof DirectoryEntry) {
            Document document2 = ((DirectoryEntry)object).toDOM();
            element.appendChild(document2.getDocumentElement());
        } else {
            Element element2 = document.createElement(string);
            if (object instanceof Vector) {
                Enumeration enumeration2 = ((Vector)object).elements();
                while (enumeration2.hasMoreElements()) {
                    Node node;
                    Object e = enumeration2.nextElement();
                    if (e instanceof DirectoryEntry) {
                        node = ((DirectoryEntry)e).toDOM();
                        element2.appendChild(node.getDocumentElement());
                        continue;
                    }
                    node = document.createElement("string");
                    Text text = document.createTextNode(e.toString());
                    node.appendChild(text);
                    element2.appendChild(node);
                }
            } else {
                Text text = document.createTextNode(object.toString());
                element2.appendChild(text);
            }
            element.appendChild(element2);
        }
    }

    public String getAttributeValue(String string) throws AttributeNotSpecifiedException {
        Object v = this.m_attributes.get(string);
        if (v == null) {
            throw new AttributeNotSpecifiedException(string);
        }
        if (v instanceof String) {
            return (String)v;
        }
        try {
            return (String)((Vector)v).firstElement();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new AttributeNotSpecifiedException(string);
        }
    }

    public Enumeration getAllAttributeValues(String string) throws AttributeNotSpecifiedException {
        Object v = this.m_attributes.get(string);
        if (v == null) {
            throw new AttributeNotSpecifiedException(string);
        }
        if (v instanceof String) {
            Vector vector = new Vector(1);
            vector.addElement(v);
            return vector.elements();
        }
        return ((Vector)v).elements();
    }

    public synchronized void setIdentifier(String string) {
        this.m_attributes.put(IDENTIFIER_ATTRIBUTE, string);
    }

    public String toString() {
        return this.getIdentifier();
    }

    static {
        s_ignoreAttributes = new Vector();
        s_ignoreAttributes.addElement("objectguid");
        s_ignoreAttributes.addElement("instancetype");
        s_ignoreAttributes.addElement("usncreated");
        s_ignoreAttributes.addElement("usnchanged");
        s_ignoreAttributes.addElement("whencreated");
        s_ignoreAttributes.addElement("whenchanged");
        s_ignoreAttributes.addElement("objectclass");
    }
}

