/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory;

import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.eibus.connection.ConnectionProvider;
import com.eibus.connection.IConnection;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.DirectoryEntry;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.URI;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Vector;

public class ConnectionPoint
extends DirectoryEntry {
    private boolean m_isClientConnection = false;
    public static final String POLICY_ATTRIBUTE = "policy";
    public static final String URI_ATTRIBUTE = "uri";
    public static final String PREFERRED_CONNECTION_ATTRIBUTE = "preferredconnection";
    public static final String TRANSACTIONAL_ATTRIBUTE = "transactional";

    public ConnectionPoint(String string, URI uRI) {
        this(string, uRI, true);
    }

    public ConnectionPoint(String string, URI uRI, boolean bl) {
        super(bl);
        this.setIdentifier(string);
        this.setURI(uRI);
    }

    public ConnectionPoint(ConnectionPoint connectionPoint) {
        this.m_attributes = connectionPoint.getAttributes();
        this.setStorable(connectionPoint.isStorable());
    }

    public ConnectionPoint(Hashtable hashtable) {
        this.m_attributes = hashtable;
    }

    public URI getURI() throws MalformedURIException {
        return URI.createURI((String)this.m_attributes.get(URI_ATTRIBUTE));
    }

    public String getPolicy() throws AttributeNotSpecifiedException {
        return (String)this.m_attributes.get(POLICY_ATTRIBUTE);
    }

    public void setPolicy(String string) {
        if (string.equals("")) {
            this.m_attributes.remove(POLICY_ATTRIBUTE);
        } else {
            this.m_attributes.put(POLICY_ATTRIBUTE, string);
        }
    }

    public boolean isTransactional() throws AttributeNotSpecifiedException {
        String string = (String)this.m_attributes.get(TRANSACTIONAL_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(TRANSACTIONAL_ATTRIBUTE);
        }
        return string.equalsIgnoreCase("TRUE");
    }

    public boolean isPreferredConnection() throws AttributeNotSpecifiedException {
        String string = (String)this.m_attributes.get(PREFERRED_CONNECTION_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(PREFERRED_CONNECTION_ATTRIBUTE);
        }
        return string.equalsIgnoreCase("TRUE");
    }

    public void setURI(URI uRI) {
        this.m_attributes.put(URI_ATTRIBUTE, uRI.toString());
    }

    public void setTransactional(boolean bl) {
        this.m_attributes.put(TRANSACTIONAL_ATTRIBUTE, bl ? "TRUE" : "FALSE");
    }

    public void setPreferredConnection(String string) {
        this.m_attributes.put(PREFERRED_CONNECTION_ATTRIBUTE, string);
    }

    public String toString() {
        return this.getIdentifier();
    }

    public static Vector getDefaultConnectionPoints(String string) throws DirectoryException {
        Vector<ConnectionPoint> vector = new Vector<ConnectionPoint>();
        if ("inproc".equals(string)) {
            ConnectionPoint connectionPoint = ConnectionPoint.getInprocPoint();
            if (connectionPoint != null) {
                vector.addElement(connectionPoint);
            }
        } else if (string == null || "socket".equals(string) || "bidisocket".equals(string) || "sslsocket".equals(string)) {
            ConnectionPoint connectionPoint = ConnectionPoint.getSocketPoint(string);
            if (connectionPoint != null) {
                vector.addElement(connectionPoint);
            }
        } else if ("jms".equals(string)) {
            ConnectionPoint connectionPoint = ConnectionPoint.getJmsPoint();
            if (connectionPoint != null) {
                vector.addElement(connectionPoint);
            }
        } else {
            throw new DirectoryException("Creating anonymous connection points for protocol '" + string + "' is not supported.");
        }
        return vector;
    }

    public static ConnectionPoint getDefaultConnectionPoint(String string) {
        return ConnectionPoint.getSocketPoint(string);
    }

    private static ConnectionPoint getSocketPoint(String string) {
        Object object;
        if (string == null || string.equals("")) {
            try {
                object = AdapterClientContext.getCurrent();
                string = ((AdapterClientConfiguration)object).getDefaultProtocol();
            }
            catch (OWConfigurationException oWConfigurationException) {
                return null;
            }
        }
        object = null;
        URI uRI = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        try {
            uRI = URI.createURI(string + "://" + string2);
            object = string2 + "-UserX";
        }
        catch (MalformedURIException malformedURIException) {
            return null;
        }
        ConnectionPoint connectionPoint = new ConnectionPoint((String)object, uRI, false);
        connectionPoint.setPreferredConnection("true");
        connectionPoint.setPolicy("variable");
        return connectionPoint;
    }

    private static ConnectionPoint getInprocPoint() {
        String string = null;
        URI uRI = null;
        String string2 = "inproc";
        try {
            uRI = URI.createURI(string2 + "://local");
            string = string2;
        }
        catch (MalformedURIException malformedURIException) {
            return null;
        }
        ConnectionPoint connectionPoint = new ConnectionPoint(string, uRI, false);
        connectionPoint.setPreferredConnection("true");
        connectionPoint.setPolicy("variable");
        return connectionPoint;
    }

    private static ConnectionPoint getJmsPoint() {
        String string = null;
        URI uRI = null;
        String string2 = "jms";
        try {
            uRI = URI.createURI(string2 + "://v1.0/#");
            string = string2;
        }
        catch (MalformedURIException malformedURIException) {
            return null;
        }
        ConnectionPoint connectionPoint = new ConnectionPoint(string, uRI, false);
        connectionPoint.setPreferredConnection("true");
        connectionPoint.setPolicy("variable");
        return connectionPoint;
    }

    void checkAndsetPolicy(URI uRI) {
        String string = uRI.getProtocol();
        try {
            IConnection iConnection = ConnectionProvider.getConnection(string, null);
            if (iConnection.isURIVariable(uRI)) {
                this.setPolicy("variable");
            }
        }
        catch (Exception exception) {}
    }

    public void isClientConnection(boolean bl) {
        this.m_isClientConnection = bl;
    }

    public boolean isClientConnection() {
        return this.m_isClientConnection;
    }
}

