/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.b3.dom.NodeList;
import com.baan.b3.xml.sax.InputSource;
import com.baan.b3.xml.sax.Parser;
import com.baan.b3.xml.sax.SAXParseException;
import com.baan.b3.xml.sax.helpers.ParserFactory;
import com.baan.b3impl.boi1.UserSession;
import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.exception.BusException;
import com.eibus.parse.GenericEventDelegator;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.Directory;
import com.eibus.services.directory.DirectoryEntry;
import com.eibus.services.directory.DirectoryException;
import com.eibus.services.directory.DirectoryServiceProvider;
import com.eibus.services.directory.MalformedURIException;
import com.eibus.services.directory.PiggyBackUserInfoOnAdministrator;
import com.eibus.services.directory.URI;
import com.eibus.services.guid.Guid;
import com.eibus.services.runtime.BusProperties;
import com.eibus.services.runtime.IComponentId;
import com.eibus.services.security.BlockEncryption;
import com.eibus.xml.dom.DocumentImpl;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BusComponent
extends DirectoryEntry
implements IComponentId {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.directory", "BusComponent");
    static Directory directory;
    private boolean validated = false;
    private boolean m_isClientComponent = false;
    private Activation m_activation = null;
    public static final String CONNECTIONS_ATTRIBUTE = "connection-points";
    public static final String CATEGORIES_ATTRIBUTE = "categories";
    public static final String OWNER_ATTRIBUTE = "ownerid";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String PHYSICAL_LOC_ID_ATTRIBUTE = "physicallocationid";
    public static final String PHYSICAL_LOC_DESC_ATTRIBUTE = "physicallocationdesc";
    public static final String ADMINISTRATOR_ATTRIBUTE = "administratorid";
    public static final String ONLINE_ATTRIBUTE = "online";
    public static final String COMPANY_NUMBER_ATTRIBUTE = "companynumber";
    public static final String ACTIVATION_ATTRIBUTE = "Activation";
    public static final String REFERENCE_KEY = "7463A53B86ED6A15C2B4E43F94D98A7C7463A53B86ED6A15C2B4E43F94D98A7C";
    public static final String REFERENCE_START = "#BR>";
    public static final String REFERENCE_END = "<#";
    private static int CP_ID;
    ConnectionPoint preferredConnection = null;

    public BusComponent(BusComponentConfiguration busComponentConfiguration) {
        super(busComponentConfiguration);
        if (busComponentConfiguration.getActivationType().length() > 0) {
            this.m_activation = new Activation(this.m_busComponentConfiguration);
        }
    }

    public static boolean isBackendReference(String string) {
        return string.startsWith(REFERENCE_START) && string.endsWith(REFERENCE_END);
    }

    public static BusComponent getComponentFromBackendReference(String string) throws Exception {
        String string2;
        try {
            string2 = null;
            if (BusComponent.isBackendReference(string)) {
                s_logger.flowMessage("BusComponent: Creating from BackendReference '" + string + "'");
                int n = string.indexOf(REFERENCE_END);
                String string3 = string.substring(REFERENCE_START.length(), n);
                string2 = BlockEncryption.DecryptToString(string3, REFERENCE_KEY);
                return new BusComponent(string2, false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        string2 = "Error creating BusComponent from reference: The passed reference is not a valid Backend Reference";
        s_logger.errorMessage(string2);
        throw new Exception(string2);
    }

    public BusComponent(String string) {
        this(string, true);
    }

    private BusComponent(String string, boolean bl) {
        super(false);
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            s_logger.message("UTF8 Enconding not supported: " + unsupportedEncodingException.getMessage());
        }
        Parser parser = null;
        GenericEventDelegator genericEventDelegator = null;
        Object var6_7 = null;
        InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
        Document document = null;
        try {
            parser = ParserFactory.makeParser();
            genericEventDelegator = new GenericEventDelegator();
            parser.setDocumentHandler(genericEventDelegator);
            parser.parse(inputSource);
            document = genericEventDelegator.getDocument();
        }
        catch (BusException busException) {
            s_logger.message("Error creating BusComponent(String): " + busException.getMessage());
        }
        catch (SAXParseException sAXParseException) {
            s_logger.message("Error creating BusComponent(String)\n" + sAXParseException.getMessage() + "at line '" + sAXParseException.getLineNumber() + "', column '" + sAXParseException.getColumnNumber() + "', exception '" + sAXParseException.getException() + "'\n" + "Char1= '" + string.charAt(sAXParseException.getColumnNumber() - 1) + "','" + string.charAt(sAXParseException.getColumnNumber()) + "', '" + string.charAt(sAXParseException.getColumnNumber() + 1) + "'\n" + "Char2='" + Character.getNumericValue(string.charAt(sAXParseException.getColumnNumber())) + "'");
        }
        catch (Exception exception) {
            s_logger.message("Error creating BusComponent(String): " + exception.getMessage());
        }
        String string2 = "" + CP_ID++;
        Vector<ConnectionPoint> vector = new Vector<ConnectionPoint>();
        Activation activation = null;
        if (document != null) {
            try {
                Object object;
                String string3;
                String string4;
                Element element = (Element)document.getFirstChild();
                NodeList nodeList = element.getElementsByTagName("identifier");
                if (nodeList.getLength() == 1) {
                    Node node = nodeList.item(0);
                    string2 = node.getFirstChild().getNodeValue();
                    if (bl) {
                        this.setIdentifier(string2 + "-" + Guid.createGuid());
                    } else {
                        this.setIdentifier(string2);
                    }
                }
                nodeList = element.getElementsByTagName(CONNECTIONS_ATTRIBUTE);
                Element element2 = (Element)nodeList.item(0);
                nodeList = element2.getElementsByTagName("ConnectionPoint");
                int n = 0;
                while (n < nodeList.getLength()) {
                    element2 = (Element)nodeList.item(n);
                    string4 = "";
                    nodeList = element2.getElementsByTagName("uri");
                    string3 = nodeList.item(0).getFirstChild().getNodeValue();
                    object = new ConnectionPoint(string4, URI.createURI(string3));
                    nodeList = element2.getElementsByTagName("policy");
                    if (nodeList != null && nodeList.getLength() != 0) {
                        ((ConnectionPoint)object).setPolicy(nodeList.item(0).getFirstChild().getNodeValue());
                    }
                    vector.addElement((ConnectionPoint)object);
                    ++n;
                }
                this.setConnectionPoints(vector);
                nodeList = element.getElementsByTagName(ACTIVATION_ATTRIBUTE);
                if (nodeList.getLength() == 1) {
                    element2 = (Element)nodeList.item(0);
                    string4 = (nodeList = element2.getElementsByTagName("type")).getLength() != 0 ? nodeList.item(0).getFirstChild().getNodeValue() : "";
                    nodeList = element2.getElementsByTagName("servicereference");
                    string3 = nodeList.getLength() != 0 ? nodeList.item(0).getFirstChild().getNodeValue() : "";
                    nodeList = element2.getElementsByTagName("activationpolicy");
                    object = nodeList.getLength() != 0 ? nodeList.item(0).getFirstChild().getNodeValue() : "shared";
                    nodeList = element2.getElementsByTagName("servertimeout");
                    String string5 = nodeList.getLength() != 0 ? nodeList.item(0).getFirstChild().getNodeValue() : "720";
                    if (string4.length() != 0 && string3.length() != 0 && ((String)object).length() != 0) {
                        activation = new Activation(string4, string3, (String)object, string5);
                        this.setActivation(activation);
                    }
                }
            }
            catch (Exception exception) {
                s_logger.message(exception.toString());
            }
            this.setOwnerID("OW client adapter");
        }
    }

    public BusComponent(String string, String string2) {
        this(string, string2, true);
    }

    public BusComponent(String string, String string2, boolean bl) {
        super(bl);
        this.setIdentifier(string);
        this.setOwnerID(string2);
    }

    public BusComponent(BusComponent busComponent) {
        this.m_attributes = busComponent.getAttributes();
        this.setStorable(busComponent.isStorable());
        this.validated = busComponent.validated;
    }

    public BusComponent(Hashtable hashtable) {
        this.m_attributes = hashtable;
        this.validated = true;
    }

    public String getOwnerID() {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getOwner();
        }
        return (String)this.m_attributes.get(OWNER_ATTRIBUTE);
    }

    public Enumeration getConnectionPoints() {
        if (this.m_busComponentConfiguration != null) {
            String[] stringArray = this.m_busComponentConfiguration.getConnectionPoints();
            Vector<ConnectionPoint> vector = new Vector<ConnectionPoint>();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    URI uRI = URI.createURI(stringArray[n]);
                    ConnectionPoint connectionPoint = new ConnectionPoint("", uRI, false);
                    if (n == 0) {
                        connectionPoint.setPreferredConnection("true");
                    }
                    connectionPoint.checkAndsetPolicy(uRI);
                    vector.addElement(connectionPoint);
                }
                catch (MalformedURIException malformedURIException) {
                    // empty catch block
                }
                ++n;
            }
            return vector.elements();
        }
        Vector vector = (Vector)this.getAttribute(CONNECTIONS_ATTRIBUTE);
        if (vector != null) {
            return vector.elements();
        }
        return new Vector().elements();
    }

    public ConnectionPoint getPreferredConnection() {
        if (this.m_busComponentConfiguration != null) {
            String[] stringArray;
            if (this.preferredConnection == null && (stringArray = this.m_busComponentConfiguration.getConnectionPoints()).length > 0) {
                try {
                    URI uRI = URI.createURI(stringArray[0]);
                    this.preferredConnection = new ConnectionPoint("", uRI, false);
                    this.preferredConnection.setPreferredConnection("true");
                    this.preferredConnection.checkAndsetPolicy(uRI);
                }
                catch (MalformedURIException malformedURIException) {
                    // empty catch block
                }
            }
            return this.preferredConnection;
        }
        if (this.preferredConnection != null) {
            try {
                if (this.preferredConnection.isPreferredConnection()) {
                    return this.preferredConnection;
                }
            }
            catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                // empty catch block
            }
        }
        Enumeration enumeration2 = this.getConnectionPoints();
        while (enumeration2.hasMoreElements()) {
            ConnectionPoint connectionPoint = (ConnectionPoint)enumeration2.nextElement();
            if (this.preferredConnection == null) {
                this.preferredConnection = connectionPoint;
            }
            try {
                if (!connectionPoint.isPreferredConnection()) continue;
                this.preferredConnection = connectionPoint;
                return this.preferredConnection;
            }
            catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                // empty catch block
            }
        }
        return this.preferredConnection;
    }

    public String getDescription() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getDescription();
        }
        String string = (String)this.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(DESCRIPTION_ATTRIBUTE);
        }
        return string;
    }

    public Enumeration getCategories() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            String[] stringArray = this.m_busComponentConfiguration.getCategories();
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
            return vector.elements();
        }
        Object object = this.getAttribute(CATEGORIES_ATTRIBUTE);
        if (object == null) {
            throw new AttributeNotSpecifiedException(CATEGORIES_ATTRIBUTE);
        }
        if (object instanceof String) {
            Vector<String> vector = new Vector<String>();
            vector.addElement((String)object);
            this.setCategories(vector);
            return vector.elements();
        }
        if (object instanceof Vector) {
            return ((Vector)object).elements();
        }
        throw new AttributeNotSpecifiedException(CATEGORIES_ATTRIBUTE);
    }

    public String getPhysicalLocationID() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            throw new AttributeNotSpecifiedException(PHYSICAL_LOC_ID_ATTRIBUTE);
        }
        String string = (String)this.getAttribute(PHYSICAL_LOC_ID_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(PHYSICAL_LOC_ID_ATTRIBUTE);
        }
        return string;
    }

    public String getPhysicalLocationDesc() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            throw new AttributeNotSpecifiedException(PHYSICAL_LOC_DESC_ATTRIBUTE);
        }
        String string = (String)this.getAttribute(PHYSICAL_LOC_DESC_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(PHYSICAL_LOC_DESC_ATTRIBUTE);
        }
        return string;
    }

    public String getAdministratorID() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getAdministrator();
        }
        String string = (String)this.getAttribute(ADMINISTRATOR_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(ADMINISTRATOR_ATTRIBUTE);
        }
        PiggyBackUserInfoOnAdministrator piggyBackUserInfoOnAdministrator = new PiggyBackUserInfoOnAdministrator(string);
        return piggyBackUserInfoOnAdministrator.getAdministrator();
    }

    public String getCryptedUsername() {
        if (this.m_busComponentConfiguration != null) {
            return null;
        }
        String string = (String)this.getAttribute(ADMINISTRATOR_ATTRIBUTE);
        if (string == null) {
            return null;
        }
        PiggyBackUserInfoOnAdministrator piggyBackUserInfoOnAdministrator = new PiggyBackUserInfoOnAdministrator(string);
        return piggyBackUserInfoOnAdministrator.getUsername();
    }

    public String getCryptedPassword() {
        if (this.m_busComponentConfiguration != null) {
            return null;
        }
        String string = (String)this.getAttribute(ADMINISTRATOR_ATTRIBUTE);
        if (string == null) {
            return null;
        }
        PiggyBackUserInfoOnAdministrator piggyBackUserInfoOnAdministrator = new PiggyBackUserInfoOnAdministrator(string);
        return piggyBackUserInfoOnAdministrator.getPassword();
    }

    public UserSession getDefaultUserSession() {
        if (this.m_busComponentConfiguration != null) {
            return (UserSession)this.m_busComponentConfiguration.getDefaultUserSession();
        }
        UserSession userSession = null;
        try {
            String string = (String)this.getAttribute(ADMINISTRATOR_ATTRIBUTE);
            if (string == null) {
                throw new AttributeNotSpecifiedException(ADMINISTRATOR_ATTRIBUTE);
            }
            PiggyBackUserInfoOnAdministrator piggyBackUserInfoOnAdministrator = new PiggyBackUserInfoOnAdministrator(string);
            userSession = (UserSession)piggyBackUserInfoOnAdministrator.getUserSession();
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {}
        return userSession;
    }

    public boolean isOnline() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            throw new AttributeNotSpecifiedException(ONLINE_ATTRIBUTE);
        }
        String string = (String)this.getAttribute(ONLINE_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(ONLINE_ATTRIBUTE);
        }
        return string.equalsIgnoreCase("TRUE");
    }

    public int getCompanyNumber() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getCompanyNumber();
        }
        String string = (String)this.getAttribute(COMPANY_NUMBER_ATTRIBUTE);
        if (string == null) {
            throw new AttributeNotSpecifiedException(COMPANY_NUMBER_ATTRIBUTE);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            s_logger.message("Company number '" + string + "' is not a valid number: " + numberFormatException);
            return -1;
        }
    }

    public Activation getActivation() throws AttributeNotSpecifiedException {
        if (this.m_busComponentConfiguration != null) {
            return this.m_activation;
        }
        Activation activation = (Activation)this.getAttribute(ACTIVATION_ATTRIBUTE);
        if (activation == null) {
            throw new AttributeNotSpecifiedException(ACTIVATION_ATTRIBUTE);
        }
        return activation;
    }

    public void setOwnerID(String string) {
        if (this.isADS()) {
            String string2 = this.getDomain();
            String string3 = "CN=Users," + string2;
            this.m_attributes.put(OWNER_ATTRIBUTE, string3);
        } else if (string.equals("")) {
            this.m_attributes.remove(OWNER_ATTRIBUTE);
        } else {
            this.m_attributes.put(OWNER_ATTRIBUTE, string);
        }
    }

    public void setConnectionPoints(Vector vector) {
        try {
            if (this.m_busComponentConfiguration != null) {
                String[] stringArray = new String[vector.size()];
                int n = 0;
                while (n < vector.size()) {
                    ConnectionPoint connectionPoint = (ConnectionPoint)vector.elementAt(n);
                    stringArray[n] = connectionPoint.getURI().toString();
                    ++n;
                }
                this.m_busComponentConfiguration.setConnectionPoints(stringArray);
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage("Error in setConnectionPoints: " + exception);
        }
        if (vector.size() == 0) {
            this.delAttribute(CONNECTIONS_ATTRIBUTE);
        } else {
            this.putAttribute(CONNECTIONS_ATTRIBUTE, vector);
        }
    }

    public void setDescription(String string) {
        try {
            if (this.m_busComponentConfiguration != null) {
                this.m_busComponentConfiguration.setDescription(string);
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage("Error in setDescription: " + exception);
        }
        if (string.equals("")) {
            this.delAttribute(DESCRIPTION_ATTRIBUTE);
        } else {
            this.putAttribute(DESCRIPTION_ATTRIBUTE, string);
        }
    }

    public void setCategories(Vector vector) {
        if (vector.size() == 0) {
            this.delAttribute(CATEGORIES_ATTRIBUTE);
        } else {
            this.putAttribute(CATEGORIES_ATTRIBUTE, vector);
        }
    }

    public void setPhysicalLocationID(String string) {
        if (string.equals("")) {
            this.delAttribute(PHYSICAL_LOC_ID_ATTRIBUTE);
        } else {
            this.putAttribute(PHYSICAL_LOC_ID_ATTRIBUTE, string);
        }
    }

    public void setPhysicalLocationDesc(String string) {
        if (string.equals("")) {
            this.delAttribute(PHYSICAL_LOC_DESC_ATTRIBUTE);
        } else {
            this.putAttribute(PHYSICAL_LOC_DESC_ATTRIBUTE, string);
        }
    }

    public void setAdministratorID(String string) {
        try {
            if (this.m_busComponentConfiguration != null) {
                this.m_busComponentConfiguration.setAdministrator(string);
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage("Error in setAdministrator: " + exception);
        }
        if (this.isADS()) {
            String string2 = this.getDomain();
            String string3 = "CN=Users," + string2;
            this.m_attributes.put(ADMINISTRATOR_ATTRIBUTE, string3);
        } else if (string.equals("")) {
            this.delAttribute(ADMINISTRATOR_ATTRIBUTE);
        } else {
            this.putAttribute(ADMINISTRATOR_ATTRIBUTE, string);
        }
    }

    public void setOnline(boolean bl) {
        this.putAttribute(ONLINE_ATTRIBUTE, bl ? "true" : "false");
    }

    public void setCompanyNumber(String string) {
        try {
            if (this.m_busComponentConfiguration != null) {
                int n = Integer.parseInt(string);
                this.m_busComponentConfiguration.setCompanyNumber(n);
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage("Error in setCompanyNumber with '" + string + "' : " + exception);
        }
        if (string.equals("")) {
            this.delAttribute(COMPANY_NUMBER_ATTRIBUTE);
        } else {
            this.putAttribute(COMPANY_NUMBER_ATTRIBUTE, string);
        }
    }

    public void setActivation(Activation activation) {
        try {
            if (this.m_busComponentConfiguration != null) {
                int n = Integer.parseInt(activation.getServerTimeout());
                this.m_busComponentConfiguration.setActivationKeepAliveTime(activation.getKeepAliveTime());
                this.m_busComponentConfiguration.setActivationMaxConnections(activation.getMaxConnections());
                this.m_busComponentConfiguration.setActivationMaxReferences(activation.getMaxReferences());
                this.m_busComponentConfiguration.setActivationPoolingPolicy(activation.getPolicy());
                this.m_busComponentConfiguration.setActivationPoolingService(activation.getServiceReference());
                this.m_busComponentConfiguration.setActivationServerTimeout(n);
                this.m_busComponentConfiguration.setActivationServiceReference(activation.getServiceReference());
                this.m_busComponentConfiguration.setActivationType(activation.getType());
            }
        }
        catch (Exception exception) {
            s_logger.errorMessage("Error in setActivation: " + exception);
        }
        if (activation == null) {
            this.delAttribute(ACTIVATION_ATTRIBUTE);
        } else {
            this.putAttribute(ACTIVATION_ATTRIBUTE, activation);
        }
    }

    public String toString() {
        return this.getIdentifier();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BusComponent)) {
            return false;
        }
        BusComponent busComponent = (BusComponent)object;
        return this.getIdentifier() == busComponent.getIdentifier();
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }

    private void validate() {
        try {
            if (directory == null) {
                directory = new DirectoryServiceProvider().getDirectoryService();
            }
            this.validated = true;
            BusComponent busComponent = directory.retrieveBusComponent(this.getIdentifier());
            this.m_attributes = busComponent.m_attributes;
        }
        catch (DirectoryException directoryException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAttribute(String string) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.validated) {
                this.validate();
            }
            return this.m_attributes.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAttribute(String string, Object object) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.validated) {
                this.validate();
            }
            this.m_attributes.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delAttribute(String string) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!this.validated) {
                this.validate();
            }
            this.m_attributes.remove(string);
        }
    }

    public void isClientComponent(boolean bl) {
        this.m_isClientComponent = bl;
    }

    public boolean isClientComponent() {
        return this.m_isClientComponent;
    }

    private boolean isADS() {
        try {
            if (directory == null) {
                directory = new DirectoryServiceProvider().getDirectoryService();
            }
        }
        catch (DirectoryException directoryException) {}
        return directory.isADS();
    }

    private String getDomain() {
        String string = BusProperties.getProperty("bus.services.directory.Root");
        String string2 = "";
        string2 = string.indexOf("DC=", 0) > 0 ? string.substring(string.indexOf("DC=", 0)) : string;
        return string2;
    }

    public static String toBackendReference(String string) {
        BusComponent busComponent = new BusComponent(string, false);
        return busComponent.toBackendReference();
    }

    public String toBackendReference() {
        Object object;
        Object object2;
        DocumentImpl documentImpl = new DocumentImpl();
        String string = this.getClass().getName();
        Element element = documentImpl.createElement(string.substring(string.lastIndexOf(46) + 1));
        documentImpl.appendChild(element);
        DirectoryEntry.addProperty(element, "identifier", "ref-to-" + this.getIdentifier());
        Enumeration enumeration2 = this.getConnectionPoints();
        Element element2 = documentImpl.createElement(CONNECTIONS_ATTRIBUTE);
        element.appendChild(element2);
        while (enumeration2.hasMoreElements()) {
            object2 = (ConnectionPoint)enumeration2.nextElement();
            object = ((DirectoryEntry)object2).toDOM();
            element2.appendChild(object.getDocumentElement());
        }
        object2 = XMLNode.FromXmlNode2String(element);
        try {
            object = BlockEncryption.Encrypt(((String)object2).getBytes("UTF-8"), REFERENCE_KEY);
            object = REFERENCE_START + (String)object + REFERENCE_END;
            s_logger.message("Created Backend Reference '" + (String)object + "'");
        }
        catch (Exception exception) {
            object = "Error creating Backend Reference, " + exception.getMessage();
            s_logger.errorMessage((String)object);
        }
        return object;
    }

    public Document toDOM() {
        Node node;
        Object object;
        if (this.m_busComponentConfiguration == null) {
            return super.toDOM();
        }
        DocumentImpl documentImpl = new DocumentImpl();
        String string = this.getClass().getName();
        Element element = documentImpl.createElement(string.substring(string.lastIndexOf(46) + 1));
        documentImpl.appendChild(element);
        DirectoryEntry.addProperty(element, "identifier", this.getIdentifier());
        DirectoryEntry.addProperty(element, OWNER_ATTRIBUTE, this.getOwnerID());
        try {
            DirectoryEntry.addProperty(element, ADMINISTRATOR_ATTRIBUTE, this.getAdministratorID());
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        try {
            DirectoryEntry.addProperty(element, DESCRIPTION_ATTRIBUTE, this.getDescription());
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        try {
            DirectoryEntry.addProperty(element, COMPANY_NUMBER_ATTRIBUTE, "" + this.getCompanyNumber());
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        Enumeration enumeration2 = this.getConnectionPoints();
        Element element2 = documentImpl.createElement(CONNECTIONS_ATTRIBUTE);
        element.appendChild(element2);
        while (enumeration2.hasMoreElements()) {
            object = (ConnectionPoint)enumeration2.nextElement();
            node = ((DirectoryEntry)object).toDOM();
            element2.appendChild(node.getDocumentElement());
        }
        try {
            object = this.getCategories();
            node = documentImpl.createElement(CATEGORIES_ATTRIBUTE);
            element.appendChild(node);
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                Element element3 = documentImpl.createElement("string");
                element3.appendChild(documentImpl.createTextNode(e.toString()));
                node.appendChild(element3);
            }
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
            // empty catch block
        }
        try {
            object = this.getActivation();
            if (object != null) {
                node = ((Activation)object).toDOM();
                element.appendChild(node.getDocumentElement());
            }
        }
        catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {}
        return documentImpl;
    }

    static {
        CP_ID = 0;
    }
}

