/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.directory;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.owimpl.fw.ccf.BusComponentConfiguration;
import com.eibus.services.activation.utils.SplitString;
import com.eibus.services.directory.DirectoryEntry;
import com.eibus.xml.dom.DocumentImpl;
import java.util.Hashtable;

public class Activation
extends DirectoryEntry {
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String SERVER_TIMEOUT_ATTRIBUTE = "servertimeout";
    public static final String REFERENCE_ATTRIBUTE = "servicereference";
    public static final String POLICY_ATTRIBUTE = "activationpolicy";
    public static final String DEFAULT_POLICY_VALUE = "shared";
    public static final String DEFAULT_SERVERTIMEOUT_VALUE = "720";
    private static final String APS_DELIMITER = "#APS#";
    public boolean m_disableAPS = false;

    public Activation(BusComponentConfiguration busComponentConfiguration) {
        super(busComponentConfiguration);
    }

    public Activation(String string, String string2, String string3, String string4) {
        this.setType(string);
        this.setServiceReference(string2);
        this.setPolicy(string3);
        this.setServerTimeout(string4);
    }

    public Activation(Hashtable hashtable) {
        this.m_attributes = hashtable;
    }

    private void setPolicy(String string) {
        if (string == null || string.equals("")) {
            string = DEFAULT_POLICY_VALUE;
        }
        this.m_attributes.put(POLICY_ATTRIBUTE, string);
    }

    private void setType(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Type is a mandatory attribute and cannot be empty.");
        }
        this.m_attributes.put(TYPE_ATTRIBUTE, string);
    }

    private void setServerTimeout(String string) {
        if (string == null || string.equals("")) {
            string = DEFAULT_SERVERTIMEOUT_VALUE;
        }
        this.m_attributes.put(SERVER_TIMEOUT_ATTRIBUTE, string);
    }

    private void setServiceReference(String string) {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Reference is a mandatory attribute and cannot be empty.");
        }
        this.m_attributes.put(REFERENCE_ATTRIBUTE, string);
    }

    public String getType() {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getActivationType();
        }
        String string = (String)this.m_attributes.get(TYPE_ATTRIBUTE);
        if (string.equalsIgnoreCase("aps")) {
            String string2 = (String)this.m_attributes.get(REFERENCE_ATTRIBUTE);
            String[] stringArray = new SplitString(string2, APS_DELIMITER).getParts();
            string = stringArray.length == 3 ? stringArray[1] : "";
        }
        return string;
    }

    public String getPolicy() {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getActivationPoolingPolicy();
        }
        String string = (String)this.m_attributes.get(POLICY_ATTRIBUTE);
        if (string == null) {
            string = DEFAULT_POLICY_VALUE;
        }
        String[] stringArray = new SplitString(string, ":").getParts();
        string = stringArray[0];
        return string;
    }

    public int getMaxReferences() {
        String[] stringArray;
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getActivationMaxReferences();
        }
        int n = 1;
        String string = (String)this.m_attributes.get(POLICY_ATTRIBUTE);
        if (string == null) {
            string = DEFAULT_POLICY_VALUE;
        }
        if ((stringArray = new SplitString(string, ":").getParts()).length > 1) {
            try {
                n = stringArray.length == 2 ? Integer.parseInt(stringArray[1]) : Integer.parseInt(stringArray[2]);
                if (n <= 0) {
                    throw new RuntimeException("Invalid limit in policy '" + string + "', must be greater than 0.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Invalid limit in policy '" + string + "', not a number.");
            }
        }
        return n;
    }

    public int getMaxConnections() {
        String[] stringArray;
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getActivationMaxConnections();
        }
        int n = 1;
        String string = (String)this.m_attributes.get(POLICY_ATTRIBUTE);
        if (string == null) {
            string = DEFAULT_POLICY_VALUE;
        }
        if ((stringArray = new SplitString(string, ":").getParts()).length > 1) {
            try {
                n = Integer.parseInt(stringArray[1]);
                if (n <= 0) {
                    throw new RuntimeException("Invalid limit in policy '" + string + "', must be greater than 0.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Invalid limit in policy '" + string + "', not a number.");
            }
        }
        return n;
    }

    public int getKeepAliveTime() {
        String[] stringArray;
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getActivationKeepAliveTime();
        }
        int n = 0;
        String string = (String)this.m_attributes.get(POLICY_ATTRIBUTE);
        if (string == null) {
            string = DEFAULT_POLICY_VALUE;
        }
        if ((stringArray = new SplitString(string, ":").getParts()).length > 3) {
            try {
                n = Integer.parseInt(stringArray[3]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("Invalid keep alive time in policy '" + string + "', not a number.");
            }
        }
        return n;
    }

    public String getServerTimeout() {
        if (this.m_busComponentConfiguration != null) {
            return "" + this.m_busComponentConfiguration.getActivationServerTimeout();
        }
        String string = (String)this.m_attributes.get(SERVER_TIMEOUT_ATTRIBUTE);
        if (string == null) {
            string = DEFAULT_SERVERTIMEOUT_VALUE;
        }
        return string;
    }

    public String getServiceReference() {
        if (this.m_busComponentConfiguration != null) {
            return this.m_busComponentConfiguration.getActivationServiceReference();
        }
        String string = (String)this.m_attributes.get(REFERENCE_ATTRIBUTE);
        String string2 = (String)this.m_attributes.get(TYPE_ATTRIBUTE);
        if (string2.equalsIgnoreCase("aps")) {
            String[] stringArray = new SplitString(string, APS_DELIMITER).getParts();
            string = stringArray.length == 3 ? stringArray[2] : "";
        }
        return string;
    }

    public String getAPSBusComponent() {
        String string;
        String[] stringArray;
        if (this.m_busComponentConfiguration != null) {
            if (this.m_disableAPS) {
                return null;
            }
            return this.m_busComponentConfiguration.getActivationPoolingService();
        }
        String string2 = null;
        String string3 = (String)this.m_attributes.get(TYPE_ATTRIBUTE);
        if (string3.equalsIgnoreCase("aps") && (stringArray = new SplitString(string = (String)this.m_attributes.get(REFERENCE_ATTRIBUTE), APS_DELIMITER).getParts()).length > 0) {
            string2 = stringArray[0];
        }
        return string2;
    }

    public void resetAPSComponent() {
        if (this.m_busComponentConfiguration != null) {
            this.m_disableAPS = true;
        } else {
            String string = this.getType();
            String string2 = this.getServiceReference();
            this.setType(string);
            this.setServiceReference(string2);
        }
    }

    public String toString() {
        return this.getType() + ":" + this.getServiceReference();
    }

    public Document toDOM() {
        if (this.m_busComponentConfiguration == null) {
            return super.toDOM();
        }
        String string = this.getAPSBusComponent();
        String string2 = this.getType();
        String string3 = this.getServiceReference();
        if (string != null && string.length() > 0) {
            string3 = string + APS_DELIMITER + string2 + APS_DELIMITER + string3;
            string2 = "aps";
        }
        DocumentImpl documentImpl = new DocumentImpl();
        String string4 = this.getClass().getName();
        Element element = documentImpl.createElement(string4.substring(string4.lastIndexOf(46) + 1));
        documentImpl.appendChild(element);
        DirectoryEntry.addProperty(element, TYPE_ATTRIBUTE, string2);
        DirectoryEntry.addProperty(element, POLICY_ATTRIBUTE, this.getPolicy());
        DirectoryEntry.addProperty(element, REFERENCE_ATTRIBUTE, string3);
        DirectoryEntry.addProperty(element, SERVER_TIMEOUT_ATTRIBUTE, this.getServerTimeout());
        return documentImpl;
    }
}

