/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.datatypes;

import com.baan.b3.dom.Element;
import com.baan.b3.dom.Node;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.xml.dom.SAXDocument;
import com.eibus.xml.util.DOMWriter;
import com.eibus.xml.util.W3CDOMWriter;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class XMLNode {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.datatypes", "XMLNode");

    public static String FromXmlNode2String(Node node) {
        return new DOMWriter(node).toString();
    }

    public static String FromXmlNode2String(org.w3c.dom.Node node) {
        return new W3CDOMWriter(node).toString();
    }

    public static org.w3c.dom.Node FromString2XmlNode(String string) {
        try {
            return XMLNode.parse(string.getBytes("UTF8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Node FromString2BaanXmlNode(String string) {
        try {
            return XMLNode.parseBaanDOM(string.getBytes("UTF8"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Element FromString2XmlElement(String string) {
        try {
            Element element = null;
            SAXDocument sAXDocument = XMLNode.parseBaanDOM(string.getBytes("UTF8"));
            if (sAXDocument != null) {
                element = sAXDocument.getDocumentElement();
                return element;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Element FromByteArray2XmlElement(byte[] byArray) {
        try {
            Element element = null;
            SAXDocument sAXDocument = XMLNode.parseBaanDOM(byArray);
            if (sAXDocument != null) {
                element = sAXDocument.getDocumentElement();
                return element;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Document parse(byte[] byArray) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            return null;
        }
        return document;
    }

    private static SAXDocument parseBaanDOM(byte[] byArray) {
        SAXDocument sAXDocument = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            sAXDocument = new SAXDocument();
            sAXDocument.load(byteArrayInputStream);
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
            return null;
        }
        return sAXDocument;
    }
}

