/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation.utils;

import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.activation.utils.Synchronize;
import com.eibus.services.activation.utils.Windows;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class ASMReply
extends Thread {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation.utils", "ASMReply");
    ServerSocket m_sReply;
    Synchronize m_notifyClass;
    ASMReply m_extraReply;
    private static final String PROPERTY_ACTIVATION_TIMEOUT = "com.ow.activation.timeout";
    private static final int DEFAULT_TIMEOUT = 90000;
    int ListenPort;
    int SwappedListenPort;

    public ASMReply(Synchronize synchronize) {
        block5: {
            this.m_sReply = null;
            this.m_notifyClass = null;
            this.m_extraReply = null;
            this.ListenPort = 0;
            this.SwappedListenPort = 0;
            try {
                this.m_notifyClass = synchronize;
                this.m_sReply = new ServerSocket(0);
                this.ListenPort = this.m_sReply.getLocalPort();
                this.start();
                if (!Windows.isWindows()) break block5;
                try {
                    String string = Integer.toHexString(this.ListenPort);
                    if (string.length() == 3) {
                        string = "0" + string;
                    }
                    string = string.substring(2, 4) + string.substring(0, 2);
                    this.SwappedListenPort = Integer.parseInt(string, 16);
                    this.m_extraReply = new ASMReply(this.m_notifyClass, this.SwappedListenPort);
                }
                catch (Exception exception) {
                }
            }
            catch (IOException iOException) {
                s_logger.message("Error creating socket, " + iOException.getMessage());
            }
        }
    }

    public static int getActivationReplyTimeout() {
        int n = 90000;
        String string = System.getProperty(PROPERTY_ACTIVATION_TIMEOUT);
        if (string != null && string.length() > 0) {
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        s_logger.message("Will wait for " + n + " milliseconds for an activation reply");
        return n;
    }

    public ASMReply(Synchronize synchronize, int n) {
        this.m_sReply = null;
        this.m_notifyClass = null;
        this.m_extraReply = null;
        this.ListenPort = 0;
        this.SwappedListenPort = 0;
        try {
            this.ListenPort = n;
            this.m_notifyClass = synchronize;
            this.m_sReply = new ServerSocket(this.ListenPort);
            this.start();
        }
        catch (IOException iOException) {
            s_logger.message("Error creating socket ");
        }
    }

    public int getPort() {
        return this.ListenPort;
    }

    int getReversedPort() {
        return this.SwappedListenPort;
    }

    public void close() {
        try {
            this.m_sReply.close();
            this.stop();
            if (this.m_extraReply != null) {
                this.m_extraReply.close();
            }
        }
        catch (IOException iOException) {
            s_logger.message("Error closing socket " + this.m_sReply.toString());
        }
    }

    public void run() {
        try {
            byte by;
            s_logger.message("Waiting for reply on socket " + this.m_sReply.toString());
            Socket socket = this.m_sReply.accept();
            InputStream inputStream = socket.getInputStream();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte[] byArray = new byte[4096];
            dataInputStream.skip(11L);
            short s = dataInputStream.readShort();
            if (s < 3) {
                dataInputStream.skip(6L);
            } else {
                dataInputStream.skip(8L);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((by = dataInputStream.readByte()) != 0) {
                byteArrayOutputStream.write(by);
            }
            String string = byteArrayOutputStream.toString();
            int n = string.length();
            s_logger.message("got reply (ASM ver=" + s + ")(" + n + " bytes) on port " + this.m_sReply.getLocalPort());
            this.m_notifyClass.putReply(string);
            OutputStream outputStream = socket.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeShort(s);
            if (s < 3) {
                dataOutputStream.writeShort(4);
            } else {
                dataOutputStream.writeInt(4);
            }
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(0);
        }
        catch (IOException iOException) {
            s_logger.message("Error in waiting for reply, " + iOException.getMessage());
        }
    }
}

