/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.eibus.services.activation.utils.SplitString;
import java.util.Vector;

public class ServiceRefExecBaan {
    private static final String DELIMITER = "--;--";
    private static final String DELIMITER_ENV = "::;::";
    private String m_bse;
    private String m_bshellEntry;
    private String m_bshellArgs;
    private String m_extraOWServerArgs;
    private String m_serviceRef;
    private Vector m_envVars = new Vector();

    public ServiceRefExecBaan(String string) throws Exception {
        this.m_serviceRef = string;
        SplitString splitString = new SplitString(string, DELIMITER);
        String[] stringArray = splitString.getParts();
        if (stringArray.length != 5) {
            throw new Exception("Service reference not correct, '" + string + "'");
        }
        this.m_bse = stringArray[0];
        this.m_bshellEntry = stringArray[1];
        String string2 = stringArray[2];
        this.m_bshellArgs = stringArray[3];
        this.m_extraOWServerArgs = stringArray[4];
        if (this.m_bse.equals("") || this.m_bshellEntry.equals("")) {
            throw new Exception("ServiceReference not correct. not all required fields are filled correctly");
        }
        if (!string2.equals("")) {
            String[] stringArray2 = new SplitString(string2, DELIMITER_ENV).getParts();
            int n = 0;
            while (n < stringArray2.length) {
                this.m_envVars.addElement(stringArray2[n]);
                ++n;
            }
        }
    }

    public ServiceRefExecBaan(String string, String string2, String[] stringArray, String string3, String string4) {
        String string5 = "";
        int n = 0;
        while (n < stringArray.length) {
            string5 = n == stringArray.length - 1 ? string5 + stringArray[n] : string5 + stringArray[n] + DELIMITER_ENV;
            ++n;
        }
        this.m_serviceRef = string + DELIMITER + string2 + DELIMITER + string5 + DELIMITER + string3 + DELIMITER + string4;
    }

    public String getServiceRef() {
        return this.m_serviceRef;
    }

    public String getBse() {
        return this.m_bse;
    }

    public int getNrEnvVars() {
        return this.m_envVars.size();
    }

    public String getEnvVarAt(int n) {
        return (String)this.m_envVars.elementAt(n);
    }

    public String getBshellEntry() {
        return this.m_bshellEntry;
    }

    public String getBshellArgs() {
        return this.m_bshellArgs;
    }

    public String getExtraOWServerArgs() {
        return this.m_extraOWServerArgs;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_bse);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(this.m_bshellEntry);
        stringBuffer.append(DELIMITER);
        int n = 0;
        while (n < this.m_envVars.size()) {
            if (n > 0) {
                stringBuffer.append(DELIMITER_ENV);
            }
            stringBuffer.append(this.getEnvVarAt(n));
            ++n;
        }
        stringBuffer.append(DELIMITER);
        stringBuffer.append(this.m_bshellArgs);
        stringBuffer.append(DELIMITER);
        stringBuffer.append(this.m_extraOWServerArgs);
        stringBuffer.append(DELIMITER);
        return stringBuffer.toString();
    }
}

