/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.eibus.services.activation.utils.SplitString;

public class ServiceRefASM {
    private static final String DELIMITER = ":";
    private String m_host;
    private String m_port;
    private String m_env;
    private int m_iPort;
    private String m_serviceRef;

    public ServiceRefASM(String string) throws Exception {
        this.m_serviceRef = string;
        SplitString splitString = new SplitString(string, DELIMITER);
        String[] stringArray = splitString.getParts();
        if (stringArray.length >= 3) {
            this.m_host = stringArray[0];
            this.m_port = stringArray[1];
            this.m_env = "";
            if (stringArray.length == 3) {
                this.m_env = stringArray[2];
            } else {
                int n = 0;
                while (n <= stringArray.length - 3) {
                    this.m_env = n + 3 == stringArray.length ? this.m_env + stringArray[2 + n] : this.m_env + stringArray[2 + n] + DELIMITER;
                    ++n;
                }
            }
        } else {
            throw new Exception("ASM serviceRef. not correct, delimiter");
        }
        try {
            this.m_iPort = Integer.parseInt(this.m_port);
        }
        catch (Exception exception) {
            throw new Exception("ASM serviceRef. not correct, port is not a number");
        }
    }

    public ServiceRefASM(String string, String string2, String string3) {
        this.m_serviceRef = string + DELIMITER + string2 + DELIMITER + string3;
    }

    public String getServiceRef() {
        return this.m_serviceRef;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_iPort;
    }

    public String getEnv() {
        return this.m_env;
    }
}

