/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.b3impl.connection.BusTimeOutException;
import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.Action;
import com.eibus.co.BusDoc;
import com.eibus.co.Control;
import com.eibus.co.dom.BusDocFactoryImpl;
import com.eibus.co.dom.ControlImpl;
import com.eibus.exception.BusException;
import java.util.Enumeration;

public class ControlStopMessage {
    private static int defaultTimeOut = 5000;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ControlStopMessage");

    public static void Send(Connection connection) throws BusException {
        Enumeration enumeration2;
        BusDoc busDoc;
        Object object;
        s_logger.message("Deactivate backend for connection '" + connection.getServerComponentId() + "'");
        BusDocFactoryImpl busDocFactoryImpl = new BusDocFactoryImpl();
        BusDoc busDoc2 = busDocFactoryImpl.createBusDoc();
        Control control = busDocFactoryImpl.createControl();
        Action action = busDocFactoryImpl.createAction();
        control.setTypeIsRequestForAction();
        action.setActionParameter("");
        action.setActionType("deactivate");
        control.setAction(action);
        busDoc2.addCO(control);
        busDoc2.setVersion(2);
        String string = "";
        try {
            object = AdapterClientContext.getCurrent();
            int n = ((AdapterClientConfiguration)object).getTimeout();
            if (n < defaultTimeOut) {
                defaultTimeOut = n;
            }
        }
        catch (OWConfigurationException oWConfigurationException) {
            // empty catch block
        }
        s_logger.message("ACTIVATION: Using timeout = " + defaultTimeOut + " ms. for sending stop signal");
        try {
            busDoc = connection.sendAndWaitForAnswer(busDoc2, defaultTimeOut);
            enumeration2 = busDoc.getErrors();
        }
        catch (BusTimeOutException busTimeOutException) {
            s_logger.message("ACTIVATION: Deactivation warning, stop confirm not received within timeout.");
            throw new BusException("Deactivation warning, stop confirm not received within timeout.");
        }
        catch (BusException busException) {
            string = busException.getMessage();
            s_logger.errorMessage("ACTIVATION: Close failed, automatically started backend not stopped, " + string);
            throw new BusException("Close failed, automatically started backend not stopped, " + string);
        }
        if (enumeration2.hasMoreElements()) {
            s_logger.errorMessage("ACTIVATION: Close failed, automatically started backend not stopped, " + string);
            throw new BusException("Close failed, automatically started backend not stopped, " + string);
        }
        object = busDoc.getFirstCO();
        while (!(object instanceof ControlImpl)) {
            object.getNextSibling();
        }
        control = (Control)object;
        Action action2 = control.getAction();
        String string2 = action2.getActionType();
        if (!control.getTypeIsReplyOnAction() || !(string2 != null & string2.equals("deactivate"))) {
            s_logger.message("ACTIVATION: Close failed, automatically started backend may not be stopped, Reply busDoc is invalid");
            throw new BusException("Close failed, automatically started backend may not be stopped, Reply busDoc is invalid");
        }
        s_logger.message("ACTIVATION: ActivationService : Close succeeded, Stop signal is send successfully to Backend.");
    }
}

