/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.b3.server.ServerActivationCallBack;
import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.UserInfoCo;
import com.eibus.exception.BusException;
import com.eibus.services.activation.ControlStopMessage;
import com.eibus.services.activation.IActivationCallBack;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.BusComponent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ActivationServiceInproc
implements IActivationService {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ActivationServiceInproc");
    public static final String TYPE = "inproc";
    private static final String TYPE_IDENTIFICATION = "OpenWorld Adapter Inproc Activation";
    private static final String JAVA_SERVICE_NAME = "java-owserver";
    private static final String JAVA_SERVICE_LOCATION = "com.eibus.java.james.James";
    private static final String CORBA_SERVICE_NAME = "corba-owserver";
    private static final String CORBA_SERVICE_LOCATION = "com.baan.owimpl.b3.corbaconnector.Dispatcher";
    private static final String BAANERP_SERVICE_NAME = "baanerp-owserver";
    private static final String BAANERP_SERVICE_LOCATION = "com.eibus.baanC.BaanERPServerActivationListenerImpl";
    private static final String DOTNET_SERVICE_NAME = "dotnet-owserver";
    private static final String DOTNET_SERVICE_LOCATION = "com.baan.owimpl.b3.dotnet.Server";
    private static final String COM_SERVICE_NAME = "com-owserver";
    private static final String COM_SERVICE_LOCATION = "com.baan.owimpl.b3.COM.Server";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$baan$b3$server$ServerActivationCallBack;

    public synchronized BusComponent Activate(BusComponent busComponent, UserInfoCo userInfoCo) throws BusException {
        ServerActivationCallBack serverActivationCallBack;
        BusComponent busComponent2;
        block34: {
            String string = "";
            String string2 = "";
            String string3 = busComponent.getIdentifier();
            busComponent2 = null;
            serverActivationCallBack = ServerActivationCallBack.getActivationCallBackINPROC();
            try {
                Activation activation = busComponent.getActivation();
                if (activation == null || !TYPE.equalsIgnoreCase(activation.getType())) break block34;
                String string4 = activation.getServiceReference();
                if (string4 == null) {
                    throw new BusException("serviceReference not correct cannot use Inproc Activation, check BusComponent Configuration for '" + string3 + "'.");
                }
                if (string4.equalsIgnoreCase(JAVA_SERVICE_NAME)) {
                    try {
                        Class<?> clazz = Class.forName(JAVA_SERVICE_LOCATION);
                        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActivationServiceInproc.class$("java.lang.String")) : class$java$lang$String, class$com$baan$b3$server$ServerActivationCallBack == null ? (class$com$baan$b3$server$ServerActivationCallBack = ActivationServiceInproc.class$("com.baan.b3.server.ServerActivationCallBack")) : class$com$baan$b3$server$ServerActivationCallBack};
                        Constructor<?> constructor = clazz.getConstructor(classArray);
                        Object[] objectArray = new Object[]{string3, serverActivationCallBack};
                        constructor.newInstance(objectArray);
                        s_logger.message("ACTIVATION: Started the Java Server Adapter (James), with buscomponent '" + string3 + "'");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        s_logger.message("ACTIVATION: Error in starting the Java Server Adapter (James), with buscomponent '" + string3 + "'");
                        s_logger.errorException(invocationTargetException.getTargetException());
                        serverActivationCallBack.setActivationError(invocationTargetException.getTargetException().toString());
                    }
                    catch (Exception exception) {
                        s_logger.message("ACTIVATION: Error in starting the Java Server Adapter (James), with buscomponent '" + string3 + "'");
                        s_logger.errorException(exception);
                        serverActivationCallBack.setActivationError(exception.toString());
                    }
                } else if (string4.equalsIgnoreCase(DOTNET_SERVICE_NAME)) {
                    try {
                        Class<?> clazz = Class.forName(DOTNET_SERVICE_LOCATION);
                        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActivationServiceInproc.class$("java.lang.String")) : class$java$lang$String, class$com$baan$b3$server$ServerActivationCallBack == null ? (class$com$baan$b3$server$ServerActivationCallBack = ActivationServiceInproc.class$("com.baan.b3.server.ServerActivationCallBack")) : class$com$baan$b3$server$ServerActivationCallBack};
                        Constructor<?> constructor = clazz.getConstructor(classArray);
                        Object[] objectArray = new Object[]{string3, serverActivationCallBack};
                        constructor.newInstance(objectArray);
                        s_logger.message("ACTIVATION: Started the .Net Server Connector, with buscomponent '" + string3 + "'");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        s_logger.message("ACTIVATION: Error in starting the .Net Server Connector, with buscomponent '" + string3 + "'");
                        s_logger.errorException(invocationTargetException.getTargetException());
                        serverActivationCallBack.setActivationError(invocationTargetException.getTargetException().toString());
                    }
                    catch (Exception exception) {
                        s_logger.message("ACTIVATION: Error in starting the .Net Server Connector, with buscomponent '" + string3 + "'");
                        s_logger.errorException(exception);
                        serverActivationCallBack.setActivationError(exception.toString());
                    }
                } else if (string4.equalsIgnoreCase(COM_SERVICE_NAME)) {
                    try {
                        Class<?> clazz = Class.forName(COM_SERVICE_LOCATION);
                        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActivationServiceInproc.class$("java.lang.String")) : class$java$lang$String, class$com$baan$b3$server$ServerActivationCallBack == null ? (class$com$baan$b3$server$ServerActivationCallBack = ActivationServiceInproc.class$("com.baan.b3.server.ServerActivationCallBack")) : class$com$baan$b3$server$ServerActivationCallBack};
                        Constructor<?> constructor = clazz.getConstructor(classArray);
                        Object[] objectArray = new Object[]{string3, serverActivationCallBack};
                        constructor.newInstance(objectArray);
                        s_logger.message("ACTIVATION: Started the COM Server Connector, with buscomponent '" + string3 + "'");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        s_logger.message("ACTIVATION: Error in starting the COM Server Connector, with buscomponent '" + string3 + "'");
                        s_logger.errorException(invocationTargetException.getTargetException());
                        serverActivationCallBack.setActivationError(invocationTargetException.getTargetException().toString());
                    }
                    catch (Exception exception) {
                        s_logger.message("ACTIVATION: Error in starting the COM Server Connector, with buscomponent '" + string3 + "'");
                        s_logger.errorException(exception);
                        serverActivationCallBack.setActivationError(exception.toString());
                    }
                } else if (string4.equalsIgnoreCase(CORBA_SERVICE_NAME)) {
                    try {
                        Class<?> clazz = Class.forName(CORBA_SERVICE_LOCATION);
                        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActivationServiceInproc.class$("java.lang.String")) : class$java$lang$String, class$com$baan$b3$server$ServerActivationCallBack == null ? (class$com$baan$b3$server$ServerActivationCallBack = ActivationServiceInproc.class$("com.baan.b3.server.ServerActivationCallBack")) : class$com$baan$b3$server$ServerActivationCallBack};
                        Constructor<?> constructor = clazz.getConstructor(classArray);
                        Object[] objectArray = new Object[]{string3, serverActivationCallBack};
                        constructor.newInstance(objectArray);
                        s_logger.message("ACTIVATION: Started the Corba Server Adapter (Dispatcher/Comes), with buscomponent '" + string3 + "'");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        s_logger.message("ACTIVATION: Error in starting the Corba Server Adapter (Dispatcher/Comes), with buscomponent '" + string3 + "'");
                        s_logger.errorException(invocationTargetException.getTargetException());
                        serverActivationCallBack.setActivationError(invocationTargetException.getTargetException().toString());
                    }
                    catch (Exception exception) {
                        s_logger.message("ACTIVATION: Error in starting the Corba Server Adapter (Dispatcher/Comes), with buscomponent '" + string3 + "'");
                        s_logger.errorException(exception);
                        serverActivationCallBack.setActivationError(exception.toString());
                    }
                } else if (string4.equalsIgnoreCase(BAANERP_SERVICE_NAME)) {
                    try {
                        Class<?> clazz = Class.forName(BAANERP_SERVICE_LOCATION);
                        Class[] classArray = new Class[]{};
                        Method method = clazz.getMethod("getBaanERPServerActivationListenerImpl", classArray);
                        Object object = method.invoke(null, null);
                        if (object == null) {
                            throw new Exception("Inproc Connection with BaanERP not present");
                        }
                        classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActivationServiceInproc.class$("java.lang.String")) : class$java$lang$String, class$com$baan$b3$server$ServerActivationCallBack == null ? (class$com$baan$b3$server$ServerActivationCallBack = ActivationServiceInproc.class$("com.baan.b3.server.ServerActivationCallBack")) : class$com$baan$b3$server$ServerActivationCallBack};
                        Method method2 = clazz.getMethod("startOpenWorldServer", classArray);
                        Object[] objectArray = new Object[]{string3, serverActivationCallBack};
                        method2.invoke(object, objectArray);
                        s_logger.message("ACTIVATION: Started the BaanERP Server Adapter, with buscomponent '" + string3 + "'");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        s_logger.message("ACTIVATION: Error in starting the BaanERP Server Adapter, with buscomponent '" + string3 + "'");
                        s_logger.errorException(invocationTargetException.getTargetException());
                        serverActivationCallBack.setActivationError(invocationTargetException.getTargetException().toString());
                    }
                    catch (Exception exception) {
                        s_logger.message("ACTIVATION: Error in starting the BaanERP Server Adapter, with buscomponent '" + string3 + "'");
                        s_logger.errorException(exception);
                        serverActivationCallBack.setActivationError(exception.toString());
                    }
                } else {
                    try {
                        Class<?> clazz = Class.forName(string4);
                        Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ActivationServiceInproc.class$("java.lang.String")) : class$java$lang$String, class$com$baan$b3$server$ServerActivationCallBack == null ? (class$com$baan$b3$server$ServerActivationCallBack = ActivationServiceInproc.class$("com.baan.b3.server.ServerActivationCallBack")) : class$com$baan$b3$server$ServerActivationCallBack};
                        Constructor<?> constructor = clazz.getConstructor(classArray);
                        Object[] objectArray = new Object[]{string3, serverActivationCallBack};
                        constructor.newInstance(objectArray);
                        s_logger.message("ACTIVATION: Started Server Adapter with reference '" + string4 + "', with buscomponent '" + string3 + "'");
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        s_logger.message("ACTIVATION: Error in starting Server Adapter with reference '" + string4 + "', with buscomponent '" + string3 + "'");
                        s_logger.errorException(invocationTargetException.getTargetException());
                        serverActivationCallBack.setActivationError(invocationTargetException.getTargetException().toString());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        s_logger.message("ACTIVATION: Error in starting Server Adapter with reference '" + string4 + "', with buscomponent '" + string3 + "'");
                        s_logger.errorException(noSuchMethodException);
                        serverActivationCallBack.setActivationError("Error starting inproc server, missing constructor in class '" + string4 + "', Check your server implementation");
                    }
                    catch (Exception exception) {
                        s_logger.message("ACTIVATION: Error in starting Inproc Server Adapter with reference '" + string4 + "', with buscomponent '" + string3 + "'");
                        s_logger.errorException(exception);
                        serverActivationCallBack.setActivationError("Error in starting Inproc Server Adapter with reference '" + string4 + "' " + exception.toString());
                    }
                }
                busComponent2 = ((IActivationCallBack)((Object)serverActivationCallBack)).returnBusComponent();
            }
            catch (Exception exception) {
                s_logger.message("ACTIVATION: Error, some error occured in the inproc activation of buscomponent '" + string3 + "'");
            }
        }
        if (busComponent2 == null) {
            throw new BusException("Inproc server not started, '" + ((IActivationCallBack)((Object)serverActivationCallBack)).getActivationError() + "'");
        }
        return busComponent2;
    }

    public synchronized void Deactivate(Connection connection) throws BusException {
        ControlStopMessage.Send(connection);
    }

    public String ActivationServiceImplementation() {
        return TYPE_IDENTIFICATION;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

