/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.b3.dom.Document;
import com.baan.b3.dom.Element;
import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusinessDocumentManager;
import com.eibus.co.UserInfoCo;
import com.eibus.co.dom.UserInfoCoImpl;
import com.eibus.exception.BusException;
import com.eibus.services.activation.ControlStopMessage;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.BusComponent;
import com.eibus.xml.dom.TextImpl;
import com.eibus.xml.util.DOMWriter;

public class ActivationServiceExecLx
implements IActivationService {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ActivationServiceExecLx");
    public static final String TYPE = "ExecLx";
    public static final String LOG_PREFIX = "ExecLx: ";
    private static final String TYPE_IDENTIFICATION = "Activate Adapter for Lx";
    private static final String fileSeparator = new String(System.getProperty("file.separator"));
    public static final int TIMEOUT_FOR_STARTING_SERVER = 5000;

    public synchronized BusComponent Activate(BusComponent busComponent, UserInfoCo userInfoCo) throws BusException {
        String string = busComponent.getIdentifier();
        s_logger.flowMessage("ExecLx: Activate(ExecLx) for BC '" + string + "'");
        Activation activation = busComponent.getActivation();
        if (activation != null && TYPE.equalsIgnoreCase(activation.getType())) {
            String string2 = activation.getServiceReference();
            if (string2 == null) {
                throw new BusException("serviceReference not correct cannot activate Lx, check BusComponent Configuration for '" + string + "'.");
            }
            String string3 = userInfoCo.getUsername(false);
            s_logger.message("ExecLx: Retrieved activation info. from BC '" + string + "', ServiceRef '" + string2 + "'");
            UserInfoCoImpl userInfoCoImpl = (UserInfoCoImpl)userInfoCo;
            String string4 = userInfoCoImpl.getPassword(false);
            BusinessDocumentManager businessDocumentManager = null;
            try {
                Document document = busComponent.toDOM();
                Element element = (Element)document.getFirstChild();
                Element element2 = (Element)element.getElementsByTagName("connection-points").item(0);
                Element element3 = (Element)element2.getElementsByTagName("ConnectionPoint").item(0);
                Element element4 = (Element)element3.getElementsByTagName("uri").item(0);
                String string5 = element4.getFirstChild().getNodeValue();
                s_logger.flowMessage("ExecLx: Requesting new server for URI '" + string5 + "'");
                try {
                    businessDocumentManager = new BusinessDocumentManager();
                    businessDocumentManager.initialize(string2);
                }
                catch (BusException busException) {
                    String string6 = "Cannot make connection to Adapter for Lx Activation Server, BC='" + string2 + "'";
                    s_logger.errorMessage(LOG_PREFIX + string6);
                    throw new BusException(string6);
                }
                String string7 = businessDocumentManager.getConnection().sendControlMessage("activate", string3 + ":" + string4 + ":" + string5, 5000L);
                businessDocumentManager.close();
                s_logger.flowMessage("ExecLx: Retreived reply from Server '" + string7 + "'");
                if (string7.startsWith("error:")) {
                    int n = string7.indexOf(":");
                    String string8 = "Could not activate (execLX) backend for '" + string + "', " + string7.substring(n + 1);
                    s_logger.errorMessage(LOG_PREFIX + string8);
                    throw new BusException(string8);
                }
                element4.removeChild(element4.getFirstChild());
                element4.appendChild(new TextImpl(string7));
                String string9 = new DOMWriter(document.getFirstChild()).toString();
                return new BusComponent(string9);
            }
            catch (BusException busException) {
                businessDocumentManager.close();
                String string10 = "Cannot make connection to Adapter for Lx Activation Server, BC='" + string2 + "', " + busException.getMessage();
                s_logger.errorMessage(LOG_PREFIX + string10);
                throw new BusException(string10);
            }
            catch (Exception exception) {
                s_logger.errorException(exception);
                throw new BusException(exception.getMessage());
            }
        }
        return null;
    }

    public void Deactivate(Connection connection) throws BusException {
        ControlStopMessage.Send(connection);
    }

    public String ActivationServiceImplementation() {
        return TYPE_IDENTIFICATION;
    }
}

