/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.UserInfoCo;
import com.eibus.exception.BusException;
import com.eibus.services.activation.ControlStopMessage;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.activation.ServiceRefExecCmd;
import com.eibus.services.activation.utils.AS400;
import com.eibus.services.activation.utils.ASMReply;
import com.eibus.services.activation.utils.AdjustCommand;
import com.eibus.services.activation.utils.Synchronize;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.BusComponent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class ActivationServiceExecCmd
implements IActivationService {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ActivationServiceExecCmd");
    public static final String TYPE = "ExecCmd";
    public static final String LOG_PREFIX = "ExecCmd: ";
    private static final String TYPE_IDENTIFICATION = "Execute Command (locally)";
    public static final int TIMEOUT_FOR_RETRIEVING_ASM_REPLY = 60000;
    public static final String REPLACE_BUSCOMPONENT = "%BUSC%";
    public static final String REPLACE_PORT = "%PORT%";
    public static final String Q = "\"";
    private static char _TAB = (char)9;
    private static char _SPACE = (char)32;
    private static int m_ThreadCounter = 0;

    public synchronized BusComponent Activate(BusComponent busComponent, UserInfoCo userInfoCo) throws BusException {
        String string = busComponent.getIdentifier();
        boolean bl = false;
        Activation activation = busComponent.getActivation();
        if (activation != null && TYPE.equalsIgnoreCase(activation.getType())) {
            String string2 = activation.getServiceReference();
            if (string2 == null) {
                throw new BusException("serviceReference not correct cannot use execCmd, check BusComponent Configuration for '" + string + "'.");
            }
            s_logger.message("ExecCmd: Trying to activate '" + string + "', serviceref = '" + string2 + "'");
            try {
                String string3;
                int n;
                ServiceRefExecCmd serviceRefExecCmd = new ServiceRefExecCmd(string2);
                String string4 = serviceRefExecCmd.getCommand();
                String[] stringArray = serviceRefExecCmd.getEnv();
                Synchronize synchronize = new Synchronize();
                ASMReply aSMReply = new ASMReply(synchronize);
                int n2 = aSMReply.getPort();
                int n3 = string4.indexOf(REPLACE_BUSCOMPONENT);
                if (n3 >= 0) {
                    n = n3 + REPLACE_BUSCOMPONENT.length();
                    string4 = string3 = string4.substring(0, n3) + Q + string + Q + string4.substring(n, string4.length());
                }
                if ((n3 = string4.indexOf(REPLACE_PORT)) >= 0) {
                    n = n3 + REPLACE_PORT.length();
                    string4 = string3 = string4.substring(0, n3) + n2 + string4.substring(n, string4.length());
                }
                if (AS400.isAs400()) {
                    string4 = AS400.adjustCommand(string4);
                    s_logger.message("ExecCmd: Running on AS/400, adjusted startup command to: " + string4);
                } else {
                    s_logger.message("ExecCmd: Before removing space: " + string4);
                    string4 = AdjustCommand.removeSpaceInBusComponent(string4);
                    s_logger.message("ExecCmd: After removing space: " + string4);
                }
                String[] stringArray2 = this.parseCommand(string4);
                if (stringArray2 == null) {
                    throw new BusException("Backend not started, Command specified not valid '" + string4 + "', check configuration");
                }
                s_logger.message("ExecCmd: Command string after replace '" + string4 + "'");
                int n4 = 0;
                while (n4 < stringArray2.length) {
                    s_logger.message("ExecCmd: Command -> '" + stringArray2[n4] + "'");
                    ++n4;
                }
                if (stringArray == null) {
                    s_logger.message("ExecCmd: No Environment settings specified, using default system settings");
                } else {
                    s_logger.message("ExecCmd: Environment settings specified (" + stringArray.length + "), overruling all system settings");
                    int n5 = 0;
                    while (n5 < stringArray.length) {
                        s_logger.message("ExecCmd: Setting -> '" + stringArray[n5] + "'");
                        ++n5;
                    }
                }
                try {
                    ExecuteCommand executeCommand = new ExecuteCommand(stringArray2, stringArray);
                    executeCommand.startProcess(synchronize);
                    String string5 = synchronize.getReply(60000);
                    if (string5 == null) {
                        executeCommand.stopProcess();
                        aSMReply.close();
                        throw new BusException("Backend not started, Did not receive reply before timeout expired");
                    }
                    if (string5.startsWith("Error")) {
                        aSMReply.close();
                        throw new BusException(string5);
                    }
                    s_logger.message("ExecCmd: Reply from backend:");
                    s_logger.message(string5);
                    aSMReply.close();
                    return new BusComponent(string5);
                }
                catch (Exception exception) {
                    aSMReply.close();
                    throw new BusException(exception.getMessage());
                }
            }
            catch (Exception exception) {
                throw new BusException(exception.getMessage());
            }
        }
        return null;
    }

    public void Deactivate(Connection connection) throws BusException {
        ControlStopMessage.Send(connection);
    }

    public String ActivationServiceImplementation() {
        return TYPE_IDENTIFICATION;
    }

    private int getFirstWhite(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == _SPACE) {
                return n;
            }
            if (c == _TAB) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private String[] parseCommand(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        Vector<String> vector = new Vector<String>();
        int n = string.length();
        String string2 = string;
        int n2 = this.getFirstWhite(string2);
        while (n2 > -1) {
            if (string2.startsWith(Q)) {
                n2 = (string2 = string2.substring(1, string2.length())).indexOf(Q);
                if (n2 < 0) {
                    return null;
                }
                vector.addElement(string2.substring(0, n2));
                string2 = string2.substring(n2 + 1, string2.length()).trim();
            } else {
                vector.addElement(string2.substring(0, n2));
                string2 = string2.substring(n2, string2.length()).trim();
            }
            n2 = this.getFirstWhite(string2);
        }
        if (string2.startsWith(Q)) {
            n2 = (string2 = string2.substring(1, string2.length())).indexOf(Q);
            if (n2 < 0) {
                return null;
            }
            vector.addElement(string2.substring(0, n2));
        } else if (string2.length() > 0) {
            vector.addElement(string2);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static /* synthetic */ int access$008() {
        return m_ThreadCounter++;
    }

    private class StreamGobbler
    extends Thread {
        InputStream m_is;
        StringBuffer m_sb = new StringBuffer();
        private final String NEWLINE = System.getProperty("line.separator");

        StreamGobbler(InputStream inputStream) {
            this.m_is = inputStream;
            this.start();
        }

        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.m_is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null || this.keepRunning()) {
                    this.m_sb.append(string + this.NEWLINE);
                }
            }
            catch (IOException iOException) {}
        }

        synchronized boolean keepRunning() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }

        public synchronized StringBuffer getGobbledData() {
            this.notify();
            return this.m_sb;
        }
    }

    private class ExecuteCommand
    extends Thread {
        private String[] m_aCommand;
        private String[] m_saEnv;
        private Runtime m_rt;
        private Process m_ServerProc;
        private StreamGobbler m_errorGobbler;
        private StreamGobbler m_outputGobbler;
        private Synchronize m_sync;
        private String m_ThreadName = "ExecProc-" + ActivationServiceExecCmd.access$008();

        ExecuteCommand(String[] stringArray, String[] stringArray2) throws Exception {
            this.m_aCommand = stringArray;
            this.m_saEnv = stringArray2;
            this.m_rt = Runtime.getRuntime();
            try {
                this.m_ServerProc = this.m_rt.exec(this.m_aCommand, this.m_saEnv);
                this.m_errorGobbler = new StreamGobbler(this.m_ServerProc.getErrorStream());
                this.m_outputGobbler = new StreamGobbler(this.m_ServerProc.getInputStream());
            }
            catch (IOException iOException) {
                String string = "IOException: " + iOException.getMessage() + ", while starting '" + stringArray[0] + "'";
                throw new Exception(string);
            }
        }

        public void startProcess(Synchronize synchronize) {
            this.m_sync = synchronize;
            this.start();
        }

        public void stopProcess() {
            s_logger.message("ExecCmd: Stopping backend process");
            this.m_ServerProc.destroy();
            s_logger.message("ExecCmd: Stopping dedicated thread for backend process (" + this.m_ThreadName + ")");
            this.stop();
        }

        public void run() {
            try {
                this.setName(this.m_ThreadName);
                s_logger.message("ExecCmd: Starting dedicated thread for backend process");
                int n = this.m_ServerProc.waitFor();
                StringBuffer stringBuffer = this.m_errorGobbler.getGobbledData();
                StringBuffer stringBuffer2 = this.m_outputGobbler.getGobbledData();
                if (n != 0) {
                    this.m_sync.putReply("Error, " + stringBuffer.toString());
                    s_logger.message("ExecCmd: Stop backend process");
                    this.m_ServerProc.destroy();
                }
                s_logger.message("ExecCmd: Process '" + this.m_aCommand[0] + "' exited with '" + n + "'");
                s_logger.message("ExecCmd: Error Output: '" + stringBuffer.toString() + "'");
                s_logger.message("ExecCmd: proc. Output: '" + stringBuffer2.toString() + "'");
            }
            catch (InterruptedException interruptedException) {
                s_logger.message("ExecCmd: Unexpected interrupt during wait for process exit of '" + this.m_aCommand[0] + "'");
            }
            s_logger.message("ExecCmd: Stopping dedicated thread for backend proc");
        }
    }
}

