/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.UserInfoCo;
import com.eibus.co.dom.UserInfoCoImpl;
import com.eibus.exception.BusException;
import com.eibus.services.activation.ControlStopMessage;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.activation.ServiceRefExecBaan;
import com.eibus.services.activation.utils.AS400;
import com.eibus.services.activation.utils.ASMReply;
import com.eibus.services.activation.utils.AdjustCommand;
import com.eibus.services.activation.utils.Synchronize;
import com.eibus.services.activation.utils.Windows;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.BusComponent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Vector;

public class ActivationServiceExecBaan
implements IActivationService {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ActivationServiceExecBaan");
    public static final String TYPE = "ExecBaan";
    public static final String LOG_PREFIX = "ExecBaan: ";
    private static final String TYPE_IDENTIFICATION = "Execute Baan using REXEC";
    private static final String fileSeparator = new String(System.getProperty("file.separator"));
    public static final int TIMEOUT_FOR_STARTING_SERVER = 5000;

    public synchronized BusComponent Activate(BusComponent busComponent, UserInfoCo userInfoCo) throws BusException {
        ServiceRefExecBaan serviceRefExecBaan = null;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = busComponent.getIdentifier();
        Activation activation = busComponent.getActivation();
        if (activation != null && TYPE.equalsIgnoreCase(activation.getType())) {
            String string8 = activation.getServiceReference();
            if (string8 == null) {
                throw new BusException("serviceReference not correct cannot use execBaan, check BusComponent Configuration for '" + string7 + "'.");
            }
            try {
                serviceRefExecBaan = new ServiceRefExecBaan(string8);
            }
            catch (Exception exception) {
                throw new BusException(exception);
            }
            string6 = userInfoCo.getUsername(false);
            s_logger.message("ExecBaan: Retrieved activation info. BSE = '" + string + "'. # Environment vars = '" + serviceRefExecBaan.getNrEnvVars() + "'. Bshell entry = '" + serviceRefExecBaan.getBshellEntry() + "'. BshellArgs = '" + serviceRefExecBaan.getBshellArgs() + "'. ExtraOWServerArgs = '" + serviceRefExecBaan.getExtraOWServerArgs() + "'. User = '" + string6 + "'.");
            UserInfoCoImpl userInfoCoImpl = (UserInfoCoImpl)userInfoCo;
            String string9 = userInfoCoImpl.getPassword(false);
            try {
                int n;
                Synchronize synchronize = new Synchronize();
                ASMReply aSMReply = new ASMReply(synchronize);
                int n2 = aSMReply.getPort();
                String string10 = this.resolveEntryFromIpcInfo(serviceRefExecBaan.getBse(), serviceRefExecBaan.getBshellEntry());
                StringBuffer stringBuffer = new StringBuffer();
                if (Windows.isWindows()) {
                    s_logger.message("ExecBaan: Running on Windows");
                    stringBuffer.append(string10 + " " + string4 + " -set BSE=" + serviceRefExecBaan.getBse());
                    n = 0;
                    while (n < serviceRefExecBaan.getNrEnvVars()) {
                        stringBuffer.append(" -set " + serviceRefExecBaan.getEnvVarAt(n));
                        ++n;
                    }
                } else {
                    s_logger.message("ExecBaan: Running on Unix or AS/400");
                    n = 0;
                    while (n < serviceRefExecBaan.getNrEnvVars()) {
                        stringBuffer.append(serviceRefExecBaan.getEnvVarAt(n) + " ");
                        ++n;
                    }
                    stringBuffer.append("BSE=" + serviceRefExecBaan.getBse() + " " + string10 + " " + string4);
                }
                stringBuffer.append(" -server ");
                if (serviceRefExecBaan.getBshellArgs() != null && serviceRefExecBaan.getBshellArgs().length() > 0) {
                    stringBuffer.append(serviceRefExecBaan.getBshellArgs() + " ");
                }
                stringBuffer.append("otmboaasmserver -busc \"" + busComponent.getIdentifier() + "\" -asmp " + n2 + " " + serviceRefExecBaan.getExtraOWServerArgs());
                if (AS400.isAs400()) {
                    stringBuffer = AS400.adjustCommand(stringBuffer);
                    s_logger.message("ExecBaan: Running on AS/400, adjusted startup command to: " + stringBuffer);
                } else {
                    stringBuffer = AdjustCommand.removeSpaceInBusComponent(stringBuffer);
                }
                s_logger.message("ExecBaan: Command: " + stringBuffer);
                Synchronize synchronize2 = new Synchronize();
                RExec rExec = new RExec(string6, string9, stringBuffer.toString(), synchronize2);
                String string11 = synchronize2.getReply(5000);
                if (string11 == null) {
                    s_logger.message("ExecBaan: Did not receive reply from rexec, assuming success");
                    string11 = "ok";
                }
                s_logger.message("ExecBaan: REXEC execute returned = " + string11);
                rExec.close();
                if (!string11.startsWith("ok")) {
                    aSMReply.close();
                    throw new BusException("Error in execBaan, check Activation Configuration for '" + string7 + "'." + string11);
                }
                String string12 = synchronize.getReply(ASMReply.getActivationReplyTimeout());
                if (string12 == null) {
                    aSMReply.close();
                    throw new BusException("Did not receive reply from the Baan backend before timeout expired");
                }
                if (string12.startsWith("Error")) {
                    aSMReply.close();
                    throw new BusException(string12);
                }
                s_logger.message("ExecBaan: Reply from backend:");
                s_logger.message(LOG_PREFIX + string12);
                aSMReply.close();
                return new BusComponent(string12);
            }
            catch (IOException iOException) {
                s_logger.errorException(iOException);
            }
            catch (BusException busException) {
                throw busException;
            }
            catch (Exception exception) {
                s_logger.errorException(exception);
            }
        }
        return null;
    }

    public void Deactivate(Connection connection) throws BusException {
        ControlStopMessage.Send(connection);
    }

    public String ActivationServiceImplementation() {
        return TYPE_IDENTIFICATION;
    }

    private String resolveEntryFromIpcInfo(String string, String string2) throws BusException {
        BufferedReader bufferedReader;
        String string3 = string + fileSeparator + "lib" + fileSeparator + "ipc_info";
        try {
            bufferedReader = new BufferedReader(new FileReader(string3));
        }
        catch (FileNotFoundException fileNotFoundException) {
            s_logger.message("ExecBaan: The specified BSE path (" + string + ") is invalid.");
            s_logger.errorException(fileNotFoundException);
            throw new BusException("The specified BSE path (" + string + ") is invalid.");
        }
        try {
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                String string5;
                int n;
                if (!string4.startsWith(string2) || string4.charAt(string2.length()) != ' ' && string4.charAt(string2.length()) != '\t') continue;
                int n2 = string4.lastIndexOf(9);
                int n3 = (n2 > (n = string4.lastIndexOf(32)) ? n2 : n) + 1;
                String string6 = new String(string4.toCharArray(), n3, string4.length() - n3);
                n3 = string6.indexOf(string5 = new String("${BSE}"));
                if (n3 < 0) {
                    return string6;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (n3 != 0) {
                    stringBuffer.append(new String(string6.toCharArray(), 0, n3 - 1));
                }
                stringBuffer.append(string);
                if ((n3 += string5.length()) < string6.length()) {
                    stringBuffer.append(new String(string6.toCharArray(), n3, string6.length() - n3));
                }
                return stringBuffer.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new BusException("Failed to locate entry '" + string2 + "' inside ipc_info file for BSE: " + string);
    }

    class RExec
    extends Thread {
        private final int REXECPORT = 512;
        Synchronize m_notifyClass = null;
        private InputStream m_data = null;
        private InputStream m_in = null;
        private OutputStream m_out = null;
        private Socket m_socket = null;
        private String m_user = null;
        private String m_passwd = null;
        private String m_command = null;
        private Vector listeners = null;

        public RExec(String string, String string2, String string3, Synchronize synchronize) throws Exception {
            this.m_notifyClass = synchronize;
            this.m_user = string;
            this.m_passwd = string2;
            this.m_command = string3;
            s_logger.message("ExecBaan: Starting RExec");
            try {
                this.m_socket = new Socket("localhost", 512);
                this.m_in = this.m_socket.getInputStream();
                this.m_out = this.m_socket.getOutputStream();
            }
            catch (UnknownHostException unknownHostException) {
                throw new Exception(unknownHostException.toString());
            }
            catch (IOException iOException) {
                throw new Exception(iOException.toString());
            }
            this.start();
        }

        public void run() {
            try {
                this.placeRexecRequest();
                this.readRexecRequest();
            }
            catch (IOException iOException) {
                this.close();
                this.m_notifyClass.putReply("Error, " + iOException.toString());
            }
        }

        private void placeRexecRequest() throws IOException {
            this.m_out.write(0);
            int n = 8;
            if (this.m_user.length() < n) {
                n = this.m_user.length();
            }
            this.m_out.write(this.m_user.getBytes(), 0, n);
            this.m_out.write(0);
            n = 8;
            if (this.m_passwd.length() < n) {
                n = this.m_passwd.length();
            }
            this.m_out.write(this.m_passwd.getBytes(), 0, n);
            this.m_out.write(0);
            n = 4096;
            if (this.m_command.length() < n) {
                n = this.m_command.length();
            }
            this.m_out.write(this.m_command.getBytes(), 0, n);
            this.m_out.write(0);
            if (this.m_data != null) {
                int n2;
                byte[] byArray = new byte[1024];
                while ((n2 = this.m_data.read(byArray, 0, byArray.length)) != -1) {
                    this.m_out.write(byArray, 0, n2);
                }
            }
        }

        private void readRexecRequest() throws IOException {
            byte[] byArray = new byte[1];
            this.m_in.read(byArray, 0, 1);
            byte[] byArray2 = new byte[2048];
            if (byArray[0] == 0) {
                int n = this.m_in.read(byArray2, 0, byArray2.length);
                if (n == -1) {
                    this.m_notifyClass.putReply("ok");
                } else {
                    this.m_notifyClass.putReply("ok, " + new String(byArray2, 0, n));
                }
            } else {
                int n;
                StringBuffer stringBuffer = null;
                while ((n = this.m_in.read(byArray2, 0, byArray2.length)) != -1) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(new String(byArray2, 0, n));
                }
                this.close();
                if (stringBuffer != null) {
                    if (stringBuffer.charAt(stringBuffer.length() - 1) == '\u0000') {
                        stringBuffer = new StringBuffer(stringBuffer.toString().substring(0, stringBuffer.length() - 2));
                    }
                    String string = new String(stringBuffer.toString().getBytes(), "UTF-8");
                    this.m_notifyClass.putReply("Error, " + string);
                } else {
                    this.m_notifyClass.putReply("Error");
                }
            }
        }

        public void close() {
            try {
                this.m_in.close();
                this.m_out.close();
                this.m_socket.close();
            }
            catch (Exception exception) {}
        }
    }
}

