/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.asm.AsmClientAPI;
import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.UserInfoCo;
import com.eibus.exception.BusException;
import com.eibus.services.activation.ControlStopMessage;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.activation.ServiceRefASM;
import com.eibus.services.activation.utils.ASMReply;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.AttributeNotSpecifiedException;
import com.eibus.services.directory.BusComponent;

public class ActivationServiceASM
implements IActivationService {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ActivationServiceASM");
    public static final String TYPE = "asm";
    public static final String LOG_PREFIX = "asm: ";
    private static final String TYPE_IDENTIFICATION = "Baan Appication Services Manager";
    private static final String SERVER_IDENTIFICATION = "DedicatedOpenWorldServer";

    public synchronized BusComponent Activate(BusComponent busComponent, UserInfoCo userInfoCo) throws BusException {
        block10: {
            String string = "";
            int n = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = busComponent.getIdentifier();
            try {
                Object object;
                Activation activation = busComponent.getActivation();
                if (activation == null) {
                    s_logger.message("asm: BusComponent not configured for Activation, check BusComponent Configuration for '" + string5 + "'.");
                    return null;
                }
                if (!TYPE.equalsIgnoreCase(activation.getType())) break block10;
                String string6 = activation.getServiceReference();
                if (string6 == null) {
                    throw new BusException("serviceReference not correct cannot use ASM, check BusComponent Configuration for '" + string5 + "'.");
                }
                try {
                    object = new ServiceRefASM(string6);
                    string = ((ServiceRefASM)object).getHost();
                    n = ((ServiceRefASM)object).getPort();
                    string2 = ((ServiceRefASM)object).getEnv();
                }
                catch (Exception exception) {
                    throw new BusException(exception.getMessage() + ", check BusComponent Configuration for '" + string5 + "'.");
                }
                string3 = userInfoCo.getUsername(false);
                string4 = userInfoCo.getPassword();
                object = new AsmClientAPI();
                int n2 = ((AsmClientAPI)object).ASM_OpenConnection(string, n);
                if (0 == n2) {
                    StringBuffer stringBuffer = new StringBuffer();
                    s_logger.message("asm: Opened connection to ASM deamon, host=" + string + " port=" + n);
                    s_logger.message("asm: Trying to start OpenWorld server trough ASM deamon, env= '" + string2 + "', identification = '" + SERVER_IDENTIFICATION + "', buscId = '" + string5 + "', user = '" + string3 + "'");
                    int n3 = ((AsmClientAPI)object).ASM_StartServiceInstance(ASMReply.getActivationReplyTimeout(), string2, SERVER_IDENTIFICATION, string5, string3, string4, stringBuffer);
                    ((AsmClientAPI)object).ASM_CloseConnection();
                    if (n3 == 0) {
                        stringBuffer.setLength(stringBuffer.length() - 1);
                        String string7 = stringBuffer.toString();
                        if (string7.indexOf("><BusComponent><") != -1) {
                            s_logger.message("asm: Server started by ASM service received buscomponent : '" + stringBuffer.toString() + "'");
                            stringBuffer.setLength(stringBuffer.length() - 1);
                            return new BusComponent(string7);
                        }
                        s_logger.message("asm: Server returned an error : '" + string7 + "'");
                        throw new BusException("Backend not started, error : '" + string7 + "'");
                    }
                    s_logger.message("asm: Error in starting Server by ASM service, asm return code = " + n3 + "' " + ((AsmClientAPI)object).ASM_GiveErrorStringFromCode(n3));
                    s_logger.message("asm: ASM API returned : " + ((AsmClientAPI)object).ASM_GiveLastErrorString());
                    if (n3 == -4) {
                        throw new BusException("ASM service could not start backend (Check your Username/Password), ASM: '" + n3 + "' " + ((AsmClientAPI)object).ASM_GiveErrorStringFromCode(n3));
                    }
                    throw new BusException("Error in starting Backend, ASM service returned : '" + n3 + "' " + ((AsmClientAPI)object).ASM_GiveErrorStringFromCode(n3));
                }
                s_logger.message("asm: Cannot open connection to ASM deamon, host=" + string + " port=" + n);
                s_logger.message("asm: ASM error code: " + n2 + ", error string:" + ((AsmClientAPI)object).ASM_GiveErrorStringFromCode(n2));
                s_logger.message("asm: ASM API returned : " + ((AsmClientAPI)object).ASM_GiveLastErrorString());
                throw new BusException("Cannot open connection to ASM, host=" + string + " port=" + n);
            }
            catch (AttributeNotSpecifiedException attributeNotSpecifiedException) {
                s_logger.message("asm: BusComponent not configured for Activation, check BusComponent Configuration for '" + string5 + "'.");
                return null;
            }
        }
        return null;
    }

    public synchronized void Deactivate(Connection connection) throws BusException {
        ControlStopMessage.Send(connection);
    }

    public String ActivationServiceImplementation() {
        return TYPE_IDENTIFICATION;
    }
}

