/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.b3.boi1.BoiException;
import com.baan.b3.boi1.BoiToolkit;
import com.baan.b3.boi1.IUserSession;
import com.baan.b3.server.ServerActivationCallBack;
import com.baan.b3impl.connection.Connection;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.UserInfoCo;
import com.eibus.exception.BusException;
import com.eibus.services.activation.ControlStopMessage;
import com.eibus.services.activation.IActivationService;
import com.eibus.services.activation.aps_boi_proxy.APSManager;
import com.eibus.services.activation.aps_boi_proxy.activatereturn;
import com.eibus.services.activation.aps_boi_proxy.deactivatereturn;
import com.eibus.services.activation.utils.ActivationTimeout;
import com.eibus.services.directory.Activation;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.security.BlockEncryption;

public class ActivationServiceAPS
implements IActivationService {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ActivationServiceAPS");
    private static final long STANDARD_APS_TIMEOUT = 120000L;
    public static final String TYPE = "aps";
    private static final String TYPE_IDENTIFICATION = "OpenWorld Activation and Pooling Service";
    private static final String LIC_OVERRIDE = "E178BEEBD81547E0D54352CE95CBBDC9";
    private static final String KEY_USERPASS = "B25149AC9E975F30F59EBA40592746FCB25149AC9E975F30F59EBA40592746FC";

    public synchronized BusComponent Activate(BusComponent busComponent, UserInfoCo userInfoCo) throws BusException {
        String string = "";
        String string2 = "";
        String string3 = busComponent.getIdentifier();
        BusComponent busComponent2 = null;
        ServerActivationCallBack serverActivationCallBack = ServerActivationCallBack.getActivationCallBackINPROC();
        Activation activation = busComponent.getActivation();
        if (activation == null) {
            s_logger.message("ACTIVATION: BusComponent not configured for Activation '" + string3 + "'");
            throw new BusException("BusComponent not configured for Activation '" + string3 + "'");
        }
        String string4 = activation.getAPSBusComponent();
        if (string4 != null) {
            s_logger.message("ACTIVATION: Using APS Activation");
            s_logger.message("ACTIVATION: APS BusComponentId = " + string4);
            if (string4.equals(string3)) {
                s_logger.message("APS BusComponent & Backend BusComponent should be different, check your configuration");
                throw new BusException("APS BusComponent & Backend BusComponent should be different, check your configuration");
            }
            try {
                APSManager aPSManager = new APSManager();
                IUserSession iUserSession = BoiToolkit.getDefaultToolkit().createUserSession();
                iUserSession.enableLicenseOverride(LIC_OVERRIDE);
                iUserSession.addManager(aPSManager);
                aPSManager.initialize(string4);
                String string5 = ActivationServiceAPS.CryptUserNamePass(userInfoCo.getUsername(true), userInfoCo.getPassword());
                long l = ActivationTimeout.getSystemPropertyTimeout();
                if (l != -1L) {
                    s_logger.message("ACTIVATION: Using SystemProperty timeout: " + l + " (ms)");
                    aPSManager.setTimeOut(l);
                } else {
                    long l2 = 0L;
                    l2 = aPSManager.getTimeOut();
                    if (l2 != 0L && l2 > 120000L) {
                        s_logger.message("ACTIVATION: Using Adapter Client timeout: " + l2 + " (ms)");
                        aPSManager.setTimeOut(l2);
                    } else {
                        s_logger.message("ACTIVATION: Using standard APS Timeout: 120000 (ms)");
                        aPSManager.setTimeOut(120000L);
                    }
                }
                activatereturn activatereturn2 = aPSManager.activate(busComponent.getIdentifier(), string5, "");
                aPSManager.close();
                int n = activatereturn2.getActivate();
                if (n == 0) {
                    String string6 = activatereturn2.getSSerializedBC();
                    BusComponent busComponent3 = new BusComponent(string6);
                    s_logger.message("ACTIVATION: " + busComponent3.toString());
                    return busComponent3;
                }
                String string7 = activatereturn2.getSErrorString();
                s_logger.message("ACTIVATION: Error starting backend for '" + string3 + "' APS Service returned, " + string7);
                throw new BusException("Error starting '" + string3 + "' APS Service: " + string7);
            }
            catch (BoiException boiException) {
                s_logger.message("ACTIVATION: APS server could not be reached, " + boiException.getMessage());
                throw new BusException("Error, APS server could not be reached, " + boiException.getMessage());
            }
            catch (BusException busException) {
                throw new BusException(busException.getMessage());
            }
            catch (Exception exception) {
                s_logger.message("ACTIVATION: Error, some error occured in the APS activation of buscomponent '" + string3 + "' " + exception.getMessage());
                throw new BusException("Error starting '" + string3 + "': " + exception.toString());
            }
        }
        if (busComponent2 == null) {
            throw new BusException("APS Backend not started");
        }
        return busComponent2;
    }

    public synchronized void Deactivate(Connection connection) throws BusException {
        s_logger.message("ACTIVATION: APS Deactivate server for connection '" + connection.getServerComponentId() + "'");
        String string = connection.toString();
        int n = string.lastIndexOf("-");
        string = string.substring(0, n);
        try {
            APSManager aPSManager;
            Activation activation = connection.getServerComponent().getActivation();
            if (activation == null) {
                throw new Exception("BusComponent not configured for Activation");
            }
            String string2 = activation.getAPSBusComponent();
            if (string2 != null) {
                s_logger.message("ACTIVATION: APS BusComponentId = " + string2);
                IUserSession iUserSession = BoiToolkit.getDefaultToolkit().createUserSession();
                iUserSession.enableLicenseOverride(LIC_OVERRIDE);
                aPSManager = new APSManager();
                iUserSession.addManager(aPSManager);
                aPSManager.initialize(string2);
                deactivatereturn deactivatereturn2 = aPSManager.deactivate(string);
                int n2 = deactivatereturn2.getDeactivate();
                if (n2 != 0) {
                    String string3 = deactivatereturn2.getSErrorString();
                    s_logger.errorMessage("ACTIVATION: Error, APS deactivation of buscomponent '" + string + "', " + string3);
                    ControlStopMessage.Send(connection);
                }
            } else {
                throw new Exception("Invalid Activation Type");
            }
            aPSManager.close();
        }
        catch (Exception exception) {
            s_logger.message("ACTIVATION: Error, APS deactivation of buscomponent '" + string + "', " + exception.getMessage());
            ControlStopMessage.Send(connection);
        }
    }

    public static String CryptUserNamePass(String string, String string2) {
        return BlockEncryption.Encrypt(string + "#" + string2, KEY_USERPASS);
    }

    public String ActivationServiceImplementation() {
        return TYPE_IDENTIFICATION;
    }
}

