/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.services.activation;

import com.baan.asm.AsmClientAPI;
import com.baan.b3.server.ServerActivationCallBack;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.services.activation.IActivationCallBack;
import com.eibus.services.datatypes.XMLNode;
import com.eibus.services.directory.BusComponent;

public class ActivationCallBackASM
extends ServerActivationCallBack
implements IActivationCallBack {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.services.activation", "ActivationCallBackASM");
    public static final String TYPE = "asm";
    private static final String TYPE_IDENTIFICATION = "Baan Appication Services Manager";
    private static final String SERVER_IDENTIFICATION = "DedicatedOpenWorldServer";
    private static final int ACTIVATION_TIMEOUT = 60000;
    private static final String EMPTY_STRING = "";
    private String m_serializedBusComponent = null;
    private int m_asmPortNr = -1;
    private String m_errorString = "";

    public String getActivationType() {
        return TYPE;
    }

    public void setASMPortNr(int n) {
        this.m_asmPortNr = n;
    }

    public void setBusComponent(BusComponent busComponent) {
        this.m_serializedBusComponent = XMLNode.FromXmlNode2String(busComponent.toDOM());
    }

    public void returnActivationError() {
        if (this.m_asmPortNr != -1) {
            AsmClientAPI asmClientAPI = new AsmClientAPI();
            s_logger.message("ACTIVATION: Sending Error to ASM, portno: '" + this.m_asmPortNr + "', error:'" + this.m_errorString + "'");
            int n = asmClientAPI.ASM_PutInstanceID(this.m_asmPortNr, 0, this.m_errorString);
            if (n < 0) {
                String string = asmClientAPI.ASM_GiveErrorStringFromCode(n);
                s_logger.message("ACTIVATION: Error Sending reply message to ASM: '" + string + "'");
            } else {
                s_logger.message("ACTIVATION: Sending reply message to ASM = OK");
            }
            s_logger.message("ACTIVATION: Closing connection to ASM");
            asmClientAPI.ASM_CloseConnection();
            asmClientAPI = null;
        } else if (this.m_asmPortNr == -1) {
            s_logger.message("ACTIVATION: Error in sending back Activation Error, ASM portnr is not set");
        }
    }

    public BusComponent returnBusComponent() {
        if (this.m_serializedBusComponent != null && this.m_asmPortNr != -1) {
            AsmClientAPI asmClientAPI = new AsmClientAPI();
            s_logger.message("ACTIVATION: Sending BusComonent to ASM, portno: '" + this.m_asmPortNr + "', buscomp:'" + this.m_serializedBusComponent + "'");
            int n = asmClientAPI.ASM_PutInstanceID(this.m_asmPortNr, 0, this.m_serializedBusComponent);
            if (n < 0) {
                String string = asmClientAPI.ASM_GiveErrorStringFromCode(n);
                s_logger.message("ACTIVATION: Error Sending reply message to ASM: '" + string + "'");
            } else {
                s_logger.message("ACTIVATION: Sending reply message to ASM = OK");
            }
            s_logger.message("ACTIVATION: Closing connection to ASM");
            asmClientAPI.ASM_CloseConnection();
            asmClientAPI = null;
        } else {
            if (this.m_asmPortNr == -1) {
                s_logger.message("ACTIVATION: Error in sending back busComponent, ASM portnr is not set");
            }
            if (this.m_serializedBusComponent == null) {
                s_logger.message("ACTIVATION: Error in sending back busComponent, Buscomponent is null");
            }
        }
        return null;
    }

    public void stopServer() {
        try {
            s_logger.message("ACTIVATION: Waiting 10 seconds to give server time to stop");
            Thread.sleep(10000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_logger.message("ACTIVATION: Stopping java VM");
        System.exit(0);
    }

    public void setActivationError(String string) {
        this.m_errorString = string;
    }

    public String getActivationError() {
        return this.m_errorString;
    }

    public String getBackendReference() {
        return null;
    }
}

