/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.parse;

import com.baan.b3.xml.sax.InputSource;
import com.baan.b3.xml.sax.Parser;
import com.baan.b3.xml.sax.helpers.ParserFactory;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDoc;
import com.eibus.co.parser.EventDelegator;
import com.eibus.connection.Message;
import com.eibus.exception.BusException;
import com.eibus.parse.BusDocListener;
import com.eibus.parse.MessagePool;
import java.io.ByteArrayInputStream;

public class ParserThread
extends Thread {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.parse", "ParserThread");
    private static int threadInstance = 0;
    private MessagePool messagePool = null;
    private BusDocListener listener = null;
    private boolean tryToClose = false;
    private Parser saxEventGenerator = null;
    private EventDelegator saxEventHandler = null;

    public ParserThread(BusDocListener busDocListener, MessagePool messagePool) throws BusException {
        try {
            this.setName("Parser-" + threadInstance++);
            this.listener = busDocListener;
            this.messagePool = messagePool;
            this.resetParser();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new BusException(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BusException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new BusException(instantiationException);
        }
    }

    private void resetParser() throws InstantiationException, IllegalAccessException, ClassNotFoundException, BusException {
        this.saxEventGenerator = ParserFactory.makeParser();
        this.saxEventHandler = new EventDelegator();
        this.saxEventGenerator.setDocumentHandler(this.saxEventHandler);
    }

    public void run() {
        try {
            Message message = null;
            boolean bl = false;
            while (this.running()) {
                if (bl) {
                    try {
                        this.resetParser();
                        bl = false;
                    }
                    catch (Exception exception) {
                        s_logger.errorException(exception);
                        s_logger.message("Killing parser thread");
                        break;
                    }
                }
                if ((message = this.messagePool.retrieve()) == null) {
                    return;
                }
                if (message.HasMessageDigest()) {
                    s_logger.message("checking Message Digests ");
                    if (!message.CheckMessageDigest()) {
                        s_logger.errorMessage("Wrong Message Digest, message ignored !!");
                        return;
                    }
                }
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(message.getText());
                    InputSource inputSource = new InputSource(byteArrayInputStream);
                    this.saxEventGenerator.parse(inputSource);
                    BusDoc busDoc = this.saxEventHandler.getBusDoc();
                    if (busDoc != null) {
                        s_logger.message("Received the busdoc " + busDoc.getHeader().getCorrelationId());
                        try {
                            s_logger.Xml(busDoc);
                        }
                        catch (OutOfMemoryError outOfMemoryError) {
                            s_logger.errorMessage("Too much data to be logged");
                        }
                        if (this.listener != null) {
                            this.listener.onReceive(busDoc);
                            continue;
                        }
                        s_logger.errorMessage("Parsed a BusDoc, but no listener is registered for it");
                        continue;
                    }
                    s_logger.message("Parsed a message that did not contain busdoc");
                }
                catch (Exception exception) {
                    if (message != null) {
                        s_logger.errorMessage("Found (parse) exception in source: " + message);
                    }
                    s_logger.errorException(exception);
                    if (message != null) {
                        this.listener.onError(message.findBusDocMessageID(), "" + exception.getMessage());
                    }
                    bl = true;
                }
            }
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            s_logger.errorException(throwable);
        }
    }

    private synchronized boolean running() {
        return !this.tryToClose || this.messagePool.hasMoreElements();
    }

    public synchronized void close() {
        this.tryToClose = true;
        this.interrupt();
    }
}

