/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.parse;

import com.eibus.connection.BusListener;
import com.eibus.connection.Message;
import com.eibus.services.profiling.ITimer;
import com.eibus.util.Queue;

public class MessagePool
implements BusListener {
    private Queue messageQueue = new Queue(10);
    private static final int MAX_NUM_MESSAGES = 10;
    private ITimer m_timer = null;

    public void setITimer(ITimer iTimer) {
        this.m_timer = iTimer;
    }

    public ITimer getITimer() {
        return this.m_timer;
    }

    public synchronized void onReceive(Message message) {
        if (this.m_timer != null) {
            this.m_timer.split("reply received");
        }
        this.messageQueue.put(message);
    }

    Message retrieve() {
        return (Message)this.messageQueue.get();
    }

    void close() {
        this.messageQueue.blockForPutting();
    }

    boolean hasMoreElements() {
        return this.messageQueue.size() > 0;
    }
}

