/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.parse;

import com.baan.b3.dom.Document;
import com.baan.b3.xml.sax.AttributeList;
import com.baan.b3.xml.sax.SAXException;
import com.eibus.exception.BusException;
import com.eibus.parse.GenericXMLHandler;
import com.eibus.parse.SAXHandler;
import com.eibus.xml.dom.DocumentImpl;

public class GenericEventDelegator
extends SAXHandler {
    GenericXMLHandler genericHandler;
    Document document;
    int topPointer = -1;
    SAXHandler[] stack = new SAXHandler[256];

    public GenericEventDelegator() throws BusException {
        this.genericHandler = new GenericXMLHandler(this);
        this.activate(this.genericHandler);
        this.document = new DocumentImpl();
    }

    public Document getDocument() {
        return this.document;
    }

    public void startDocument() throws SAXException {
        this.genericHandler.context = 1;
    }

    public void reset() {
        this.clearStack();
        this.document = null;
        this.genericHandler.reset();
        this.activate(this.genericHandler);
    }

    public void endDocument() throws SAXException {
        if (this.document == null) {
            throw new SAXException("Failed to construct a Document tree, although document was parsed");
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.stack[this.topPointer].startElement(string, attributeList);
    }

    String printStackTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n <= this.topPointer) {
            stringBuffer.append("[" + n + "-" + this.stack[n] + "],");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void endElement(String string) throws SAXException {
        this.stack[this.topPointer].endElement(string);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.stack[this.topPointer].characters(cArray, n, n2);
    }

    private void push(SAXHandler sAXHandler) {
        if (this.topPointer >= this.stack.length) {
            this.enlarge();
        }
        ++this.topPointer;
        this.stack[this.topPointer] = sAXHandler;
    }

    private void pop() {
        this.topPointer = this.topPointer > 0 ? --this.topPointer : -1;
    }

    private void clearStack() {
        this.topPointer = -1;
    }

    private void enlarge() {
        SAXHandler[] sAXHandlerArray = this.stack;
        this.stack = new SAXHandler[sAXHandlerArray.length * 2];
        System.arraycopy(sAXHandlerArray, 0, this.stack, 0, this.stack.length);
    }

    public void activate(SAXHandler sAXHandler) {
        this.push(sAXHandler);
    }

    public void deActivate(SAXHandler sAXHandler) {
        if (this.stack[this.topPointer] == sAXHandler) {
            this.pop();
        }
    }
}

