/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.parse;

import com.baan.owimpl.fw.ccf.AdapterClientConfiguration;
import com.baan.owimpl.fw.ccf.AdapterClientContext;
import com.baan.owimpl.fw.ccf.OWConfigurationException;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.co.BusDoc;
import com.eibus.connection.IConnection;
import com.eibus.connection.Middleware;
import com.eibus.exception.BusException;
import com.eibus.exception.ExceptionGroup;
import com.eibus.parse.BusDocListener;
import com.eibus.parse.MessagePool;
import com.eibus.parse.ParserThread;
import com.eibus.services.directory.BusComponent;
import com.eibus.services.directory.ConnectionPoint;
import com.eibus.services.directory.URI;
import com.eibus.util.MRUCache;
import java.util.Dictionary;
import java.util.Vector;

public class Connector {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.parse", "Connector");
    private static final boolean PRINT_DEBUG_INFO = false;
    public static final int MAX_NUMBER_OF_XML_PARSERS = 12;
    private static final int INITIAL_NUM_PARSERS = 1;
    private BusComponent id;
    private BusDocListener listener;
    private MessagePool messagePool;
    private ParserThread[] parsers;
    private boolean open = false;
    private Middleware middleware;
    private Dictionary componentCache = new MRUCache(500);

    public Connector(BusComponent busComponent, BusDocListener busDocListener) throws BusException {
        this.initialize(busComponent, busDocListener);
    }

    public Connector() {
    }

    public void initialize(BusComponent busComponent, BusDocListener busDocListener) throws BusException {
        this.id = busComponent;
        this.listener = busDocListener;
        this.messagePool = new MessagePool();
        this.initializeParsers(busDocListener, this.messagePool);
        this.middleware = new Middleware(this.id, this.messagePool);
        this.setOpen();
    }

    /*
     * Unable to fully structure code
     */
    public void send(BusDoc var1_1) throws BusException {
        if (!this.isOpen()) {
            throw new BusException("Connector is not opened");
        }
        Connector.s_logger.message("About to send busdoc " + var1_1.getHeader().getCorrelationId());
        if (Connector.s_logger.isInfoEnabled()) {
            Connector.s_logger.flowXml(var1_1);
        }
        var2_2 = null;
        var3_3 = null;
        var4_4 = null;
        var5_5 = var1_1.toMessage();
        var6_6 = new Vector<BusException>();
        var7_7 = new Vector<URI>();
        try {
            var3_3 = var1_1.getHeader().getReceiver().getSentTo();
            Connector.s_logger.message("Trying to send message to " + var3_3);
            var2_2 = this.middleware.getConnected(var3_3);
            var5_5.setURI(var3_3);
            if (var5_5.HasMessageDigest()) {
                Connector.s_logger.flowMessage("Calculating & adding message digest");
                var5_5.addMessageDigest();
            }
            var2_2.send(var5_5);
            return;
        }
        catch (BusException var8_8) {
            if (var3_3 != null) {
                var7_7.addElement(var3_3);
            }
            var6_6.addElement(var8_8);
            Connector.s_logger.errorException(var8_8);
            var4_4 = var1_1.getHeader().getReceiver().getComponent();
            if (var4_4 == null) {
                throw new BusException("Cannot send busdoc. Specified address (" + var3_3 + ") is invalid, and receiving component is not specified");
            }
            Connector.s_logger.message("Trying to send message to component " + var4_4);
            var2_2 = (IConnection)this.componentCache.get(var4_4.getIdentifier());
            if (var2_2 != null) {
                Connector.s_logger.message("Using cached connection to send busdoc to " + var4_4);
                try {
                    var2_2.send(var5_5);
                    return;
                }
                catch (BusException var8_9) {
                    var6_6.addElement(var8_9);
                    this.componentCache.remove(var4_4.getIdentifier());
                    Connector.s_logger.errorException(var8_9);
                }
            }
            try {
                var8_10 = var4_4.getPreferredConnection();
                if (var8_10 != null) {
                    var3_3 = var8_10.getURI();
                    Connector.s_logger.flowMessage("Trying to send message via preferred connection " + var3_3);
                    if (!var7_7.contains(var3_3)) {
                        var2_2 = this.middleware.getConnected(var3_3);
                        var5_5.setURI(var3_3);
                        if (var5_5.HasMessageDigest()) {
                            Connector.s_logger.flowMessage("Adding message digest to busdoc");
                            var5_5.addMessageDigest();
                        }
                        var5_5.addMessageDigest();
                        var2_2.send(var5_5);
                        this.componentCache.put(var4_4.getIdentifier(), var2_2);
                        return;
                    }
                }
            }
            catch (BusException var8_11) {
                if (var3_3 != null) {
                    var7_7.addElement(var3_3);
                }
                var6_6.addElement(var8_11);
                Connector.s_logger.errorException(var8_11);
            }
            var8_10 = var4_4.getConnectionPoints();
            Connector.s_logger.flowMessage("Trying to send message via one of the other connection points");
            ** while (var8_10.hasMoreElements())
        }
lbl-1000:
        // 1 sources

        {
            try {
                var9_12 = (ConnectionPoint)var8_10.nextElement();
                var3_3 = var9_12.getURI();
                if (var7_7.contains(var3_3)) continue;
                Connector.s_logger.flowMessage("Using connection point " + var3_3);
                var2_2 = this.middleware.getConnected(var3_3);
                var5_5.setURI(var3_3);
                var2_2.send(var5_5);
                this.componentCache.put(var4_4.getIdentifier(), var2_2);
                return;
            }
            catch (BusException var9_13) {
                if (var3_3 != null) {
                    var7_7.addElement(var3_3);
                }
                var6_6.addElement(var9_13);
                Connector.s_logger.errorException(var9_13);
            }
            continue;
        }
lbl87:
        // 1 sources

        var9_12 = new Throwable[var6_6.size()];
        var6_6.copyInto(var9_12);
        throw new ExceptionGroup("Unable to establish a connection with receiver " + var4_4.getIdentifier(), (Throwable[])var9_12);
    }

    public void close() {
        block2: {
            if (!this.isOpen()) break block2;
            try {
                this.closeParsers();
                this.middleware.close();
                this.setClosed();
                s_logger.message("Closed the Connector");
            }
            catch (BusException busException) {
                s_logger.message("Failed to close connection to bus: " + busException);
            }
        }
    }

    public void startExtraParser() throws BusException {
        if (this.isOpen()) {
            throw new BusException("Functionality to start another parse thread is not yet implemented");
        }
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    private synchronized void setClosed() {
        this.open = false;
    }

    private synchronized void setOpen() {
        this.open = true;
    }

    private void initializeParsers(BusDocListener busDocListener, MessagePool messagePool) throws BusException {
        int n;
        int n2 = 1;
        try {
            AdapterClientConfiguration adapterClientConfiguration = AdapterClientContext.getCurrent();
            n = adapterClientConfiguration.getNumberOfParsers();
            if (n > 0 && n <= 12) {
                n2 = n;
            }
        }
        catch (OWConfigurationException oWConfigurationException) {
            // empty catch block
        }
        this.parsers = new ParserThread[n2];
        int n3 = 0;
        n = 0;
        while (n < this.parsers.length) {
            try {
                this.parsers[n] = new ParserThread(busDocListener, messagePool);
                this.parsers[n].start();
                ++n3;
            }
            catch (BusException busException) {
                s_logger.errorException(new BusException("Failed to construct ParserThread[" + n + "], due to: " + busException));
            }
            ++n;
        }
        if (n3 <= 0) {
            throw new BusException("Failed to start XML parsers. Cannot handle incoming messages.");
        }
    }

    private void closeParsers() {
        int n = 0;
        while (n < this.parsers.length) {
            if (this.parsers[n] != null) {
                this.parsers[n].close();
            }
            ++n;
        }
    }
}

