/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.java.james.classinfo;

import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.boi1.metadata.IBusinessObjectMetadata;
import com.baan.b3.boi1.metadata.IMemberMetadata;
import com.baan.b3.boi1.metadata.IObjectMetadata;
import com.baan.b3.boi1.metadata.IPrimalObjectMetadata;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.java.james.classinfo.BusinessObjectInfo;
import com.eibus.java.james.classinfo.ClassInfo;
import com.eibus.java.james.classinfo.ClassSignature;
import com.eibus.java.james.classinfo.Classes;
import com.eibus.java.james.classinfo.Description;
import com.eibus.java.james.classinfo.MemberInfo;
import com.eibus.java.james.classinfo.Members;
import com.eibus.java.james.classinfo.Parameter;
import com.eibus.java.james.classinfo.StaticMethodSignature;
import com.eibus.java.james.classinfo.StringArray;
import com.eibus.java.james.classinfo.SubPackages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassInfoImpl {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.java.james.classinfo", "ClassInfoImpl");
    static /* synthetic */ Class class$com$baan$b3$boi1$BusinessObject;

    public static int getClasses(String string, Classes classes) {
        String string2 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        s_logger.flowMessage("James Exporter: getClasses called, package name: '" + string + "'. classpath in use :'" + string2 + "'.");
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            Vector vector;
            String string3 = stringTokenizer.nextToken();
            File file2 = new File(string3);
            if (file2.isDirectory()) {
                if (!ClassInfoImpl.isPackageInDirectory(string, file2)) continue;
                s_logger.message("James Exporter: Found package '" + string + " in directory '" + file2.getAbsolutePath() + "'");
                vector = ClassInfoImpl.giveClassesInPackage(string, file2);
                if (vector.size() <= 0) continue;
                if (!bl) {
                    classes.setLocation(file2.getAbsolutePath());
                    classes.setFoundPackageOnMoreLocations(false);
                    n = 0;
                    while (n < vector.size()) {
                        classes.addClassName((String)vector.elementAt(n));
                        ++n;
                    }
                    continue;
                }
                classes.setFoundPackageOnMoreLocations(true);
                continue;
            }
            if (!string3.endsWith(".jar") && !string3.endsWith(".zip") || !ClassInfoImpl.isPackageInJarOrZip(string, file2)) continue;
            s_logger.message("James Exporter: Found package '" + string + " in file '" + file2.getAbsolutePath() + "'");
            vector = ClassInfoImpl.giveClassesInjarOrZip(string, file2);
            if (vector.size() <= 0) continue;
            if (!bl) {
                classes.setLocation(file2.getAbsolutePath());
                classes.setFoundPackageOnMoreLocations(false);
                n = 0;
                while (n < vector.size()) {
                    classes.addClassName((String)vector.elementAt(n));
                    ++n;
                }
                continue;
            }
            classes.setFoundPackageOnMoreLocations(true);
        }
        return 0;
    }

    public static int getClassInfo(String string, String string2, ClassInfo classInfo) {
        String string3 = string + "." + string2;
        Class<?> clazz = null;
        Class clazz2 = class$com$baan$b3$boi1$BusinessObject == null ? (class$com$baan$b3$boi1$BusinessObject = ClassInfoImpl.class$("com.baan.b3.boi1.BusinessObject")) : class$com$baan$b3$boi1$BusinessObject;
        ClassSignature classSignature = new ClassSignature();
        classSignature.setClassName(string3);
        classInfo.setClassSignature(classSignature);
        try {
            clazz = Class.forName(string3);
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = 0;
            while (n < methodArray.length) {
                block12: {
                    String string4;
                    StaticMethodSignature staticMethodSignature;
                    Class<?>[] classArray;
                    String string5;
                    block14: {
                        Class<?> clazz3;
                        block13: {
                            Method method = methodArray[n];
                            int n2 = method.getModifiers();
                            if (!Modifier.isPublic(n2) || !Modifier.isStatic(n2)) break block12;
                            string5 = method.getName();
                            clazz3 = method.getReturnType();
                            classArray = method.getParameterTypes();
                            staticMethodSignature = new StaticMethodSignature();
                            staticMethodSignature.setStaticMethodName(string5);
                            string4 = ClassInfoImpl.getDCDTypeFromJavaClass(clazz3);
                            staticMethodSignature.setComplex(string4 == null);
                            if (string4 == null) break block13;
                            staticMethodSignature.setDatatype(string4);
                            break block14;
                        }
                        if (!clazz2.isAssignableFrom(clazz3)) break block12;
                        staticMethodSignature.setDatatype(clazz3.getName());
                    }
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < classArray.length) {
                        Parameter parameter = new Parameter();
                        string4 = ClassInfoImpl.getDCDTypeFromJavaClass(classArray[n3]);
                        String string6 = ClassInfoImpl.getScopeFromJavaClass(classArray[n3]);
                        parameter.setComplex(string4 == null);
                        if (string4 != null) {
                            parameter.setDatatype(string4);
                            parameter.setScope(string6);
                            parameter.setParameterName(string5 + "_p" + (n3 + 1));
                        } else {
                            if (!clazz2.isAssignableFrom(classArray[n3])) {
                                bl = false;
                                break;
                            }
                            string4 = classArray[n3].getName();
                            parameter.setDatatype(string4);
                            parameter.setScope("InOut");
                            int n4 = string4.lastIndexOf(".");
                            if (n4 > 0) {
                                string4 = string4.substring(n4 + 1, string4.length());
                            }
                            parameter.setParameterName(string4);
                        }
                        staticMethodSignature.addParameter(parameter);
                        ++n3;
                    }
                    if (bl) {
                        classSignature.addStaticMethodSignature(staticMethodSignature);
                    }
                }
                ++n;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        clazz = null;
        return 0;
    }

    public static int getBusinessObjectInfo(String string, BusinessObjectInfo businessObjectInfo) {
        String string2;
        int n = 0;
        s_logger.message("James Exporter: getBusinessObjectInfo called, package+class name: '" + string + "'.");
        try {
            int n2;
            BusinessObject businessObject;
            Object object;
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{};
            Method method = clazz.getMethod("retrieveMetadata", classArray);
            Object obj = clazz.newInstance();
            IBusinessObjectMetadata iBusinessObjectMetadata = (IBusinessObjectMetadata)method.invoke(obj, new Object[0]);
            string2 = "no Error";
            businessObjectInfo.setTypeName(iBusinessObjectMetadata.getTypeName());
            businessObjectInfo.setXmlDataType(iBusinessObjectMetadata.getXmlDataType());
            String[] stringArray = iBusinessObjectMetadata.getDescription();
            if (stringArray != null && stringArray.length > 0) {
                object = new Description();
                businessObject = new StringArray();
                n2 = 0;
                while (n2 < stringArray.length) {
                    ((StringArray)businessObject).add_string(stringArray[n2]);
                    ++n2;
                }
                ((Description)object).setStringArray((StringArray)businessObject);
                businessObjectInfo.setDescription((Description)object);
            }
            if ((object = iBusinessObjectMetadata.getMembers()) != null && ((IMemberMetadata[])object).length > 0) {
                businessObject = new Members();
                n2 = 0;
                while (n2 < ((IMemberMetadata[])object).length) {
                    IObjectMetadata iObjectMetadata;
                    MemberInfo memberInfo = new MemberInfo();
                    memberInfo.setName(object[n2].getName());
                    memberInfo.setCardinalityMax(object[n2].getCardinalityMax());
                    memberInfo.setCardinalityMin(object[n2].getCardinalityMin());
                    memberInfo.setAttribute(object[n2].isAttribute());
                    memberInfo.setReadOnly(object[n2].isReadOnly());
                    IObjectMetadata iObjectMetadata2 = object[n2].getType();
                    boolean bl = iObjectMetadata2 instanceof IBusinessObjectMetadata;
                    memberInfo.setComplex(bl);
                    if (bl) {
                        iObjectMetadata = (IBusinessObjectMetadata)iObjectMetadata2;
                        memberInfo.setXmlDataType(iObjectMetadata.getXmlDataType());
                        memberInfo.setJavaDataType(iObjectMetadata.getTypeName());
                    } else {
                        iObjectMetadata = (IPrimalObjectMetadata)iObjectMetadata2;
                        memberInfo.setXmlDataType(iObjectMetadata.getXmlDataType());
                        memberInfo.setJavaDataType(iObjectMetadata.getTypeName());
                    }
                    ((Members)businessObject).addMemberInfo(memberInfo);
                    iObjectMetadata = object[n2].getDescription();
                    if (iObjectMetadata != null && ((IObjectMetadata)iObjectMetadata).length > 0) {
                        Description description = new Description();
                        StringArray stringArray2 = new StringArray();
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            stringArray2.add_string((String)((Object)iObjectMetadata[n3]));
                            ++n3;
                        }
                        description.setStringArray(stringArray2);
                        memberInfo.setDescription(description);
                    }
                    ++n2;
                }
                businessObjectInfo.setMembers((Members)businessObject);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            string2 = "BusinessObject Not Found in ClassPath : ClassNotFoundException";
            n = -1;
        }
        catch (InstantiationException instantiationException) {
            string2 = "Error : InstantiationException";
            n = -1;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            string2 = "Error : NoSuchMethodException";
            n = -1;
        }
        catch (IllegalAccessException illegalAccessException) {
            string2 = "Error : IllegalAccessException";
            n = -1;
        }
        catch (InvocationTargetException invocationTargetException) {
            string2 = "Error : InvocationTargetException";
            n = -1;
        }
        businessObjectInfo.setErrorString(string2);
        return n;
    }

    public static int getSubPackages(String string, SubPackages subPackages) {
        Vector vector = new Vector();
        Classes classes = new Classes();
        String string2 = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            File file2 = new File(string3);
            if (file2.isDirectory()) {
                if (!ClassInfoImpl.isPackageInDirectory(string, file2)) continue;
                ClassInfoImpl.givePackagesInPackage(string, file2, vector);
                continue;
            }
            if (!string3.endsWith(".jar") && !string3.endsWith(".zip") || !ClassInfoImpl.isPackageInJarOrZip(string, file2)) continue;
            ClassInfoImpl.givePackagesInjarOrZip(string, file2, vector);
        }
        ClassInfoImpl.quicksortVector(vector);
        int n = 0;
        while (n < vector.size()) {
            subPackages.addSubPackageName((String)vector.elementAt(n));
            ++n;
        }
        return 0;
    }

    private static Vector givePackagesInPackage(String string, File file2, Vector vector) {
        String string2;
        string = string.replace('.', File.separatorChar);
        try {
            string2 = file2.getCanonicalPath() + File.separator + string;
            file2 = new File(string2);
        }
        catch (IOException iOException) {
            return vector;
        }
        String[] stringArray = file2.list();
        int n = 0;
        while (n < stringArray.length) {
            File file3;
            String string3 = stringArray[n];
            if (!string3.endsWith(".class") && (file3 = new File(string2 + File.separator + string3)).isDirectory() && vector.indexOf(string3) < 0) {
                vector.addElement(string3);
            }
            ++n;
        }
        ClassInfoImpl.quicksortVector(vector);
        return vector;
    }

    private static Vector giveClassesInPackage(String string, File file2) {
        string = string.replace('.', File.separatorChar);
        Vector<String> vector = new Vector<String>();
        try {
            String string2 = file2.getCanonicalPath() + File.separator + string;
            file2 = new File(string2);
        }
        catch (IOException iOException) {
            return vector;
        }
        String[] stringArray = file2.list();
        int n = 0;
        while (n < stringArray.length) {
            String string3;
            String string4 = stringArray[n];
            if (string4.endsWith(".class") && vector.indexOf(string3 = string4.substring(0, string4.length() - 6)) < 0) {
                vector.addElement(string3);
            }
            ++n;
        }
        return vector;
    }

    private static boolean isPackageInDirectory(String string, File file2) {
        boolean bl = false;
        if (string.equals("")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String[] stringArray = file2.list();
            bl = false;
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string2)) {
                    bl = true;
                    try {
                        file2 = new File(file2.getCanonicalPath() + File.separator + string2);
                    }
                    catch (IOException iOException) {
                        break;
                    }
                }
                ++n;
            }
            if (!bl) break;
        }
        return bl;
    }

    private static boolean isPackageInJarOrZip(String string, File file2) {
        if ((string = string.replace('.', '/')).equals("")) {
            return true;
        }
        try {
            ZipFile zipFile = new ZipFile(file2);
            Enumeration<? extends ZipEntry> enumeration2 = zipFile.entries();
            while (enumeration2.hasMoreElements()) {
                ZipEntry zipEntry = enumeration2.nextElement();
                String string2 = zipEntry.getName();
                int n = string2.lastIndexOf("/");
                if (n == -1 || !(string2 = string2.substring(0, n)).equals(string)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            s_logger.errorException(exception);
        }
        return false;
    }

    private static Vector giveClassesInjarOrZip(String string, File file2) {
        string = string.replace('.', '/');
        Vector<String> vector = new Vector<String>();
        try {
            ZipFile zipFile = new ZipFile(file2);
            Enumeration<? extends ZipEntry> enumeration2 = zipFile.entries();
            while (enumeration2.hasMoreElements()) {
                String string2;
                ZipEntry zipEntry = enumeration2.nextElement();
                String string3 = zipEntry.getName();
                int n = string3.lastIndexOf("/");
                if (n == -1 && string.length() == 0) {
                    int n2 = 9;
                }
                if (n == -1 && string.length() != 0) continue;
                String string4 = "";
                string4 = n >= 0 ? string3.substring(0, n) : "";
                if (!string4.equals(string) || zipEntry.isDirectory() || !string3.endsWith(".class") || vector.indexOf(string2 = string3.substring(n + 1, string3.length() - 6)) >= 0) continue;
                vector.addElement(string2);
            }
        }
        catch (Exception exception) {}
        return vector;
    }

    private static Vector givePackagesInjarOrZip(String string, File file2, Vector vector) {
        string = string.replace('.', '/');
        try {
            ZipFile zipFile = new ZipFile(file2);
            Enumeration<? extends ZipEntry> enumeration2 = zipFile.entries();
            while (enumeration2.hasMoreElements()) {
                int n;
                String string2;
                ZipEntry zipEntry = enumeration2.nextElement();
                String string3 = zipEntry.getName();
                int n2 = string3.lastIndexOf("/");
                if (n2 == -1 || !(string2 = string3.substring(0, n2)).startsWith(string) || !zipEntry.isDirectory() || !(string3 = string2.substring(string.length())).startsWith("/") && string.length() != 0 || (n = string3.lastIndexOf("/")) >= 1) continue;
                if (string.length() != 0) {
                    string3 = string3.substring(1);
                }
                if (vector.indexOf(string3) >= 0) continue;
                vector.addElement(string3);
            }
        }
        catch (Exception exception) {
            ClassInfoImpl.quicksortVector(vector);
            return vector;
        }
        ClassInfoImpl.quicksortVector(vector);
        return vector;
    }

    private static boolean isJavaClassBasicType(Class clazz) {
        return ClassInfoImpl.getDCDTypeFromJavaClass(clazz) != null;
    }

    private static String getDCDTypeFromJavaClass(Class clazz) {
        String string = clazz.getName();
        if (string.equals("java.lang.String") || string.equals("com.eibus.util.StringHolder")) {
            return "string";
        }
        if (string.equals("java.lang.Long") || string.equals("long") || string.equals("com.eibus.util.LongHolder")) {
            return "i8";
        }
        if (string.equals("java.lang.Integer") || string.equals("int") || string.equals("com.eibus.util.IntHolder")) {
            return "i4";
        }
        if (string.equals("java.lang.Short") || string.equals("short") || string.equals("com.eibus.util.ShortHolder")) {
            return "i2";
        }
        if (string.equals("java.lang.Byte") || string.equals("byte") || string.equals("com.eibus.util.ByteHolder")) {
            return "i1";
        }
        if (string.equals("java.lang.Double") || string.equals("double") || string.equals("com.eibus.util.DoubleHolder")) {
            return "r8";
        }
        if (string.equals("java.lang.Float") || string.equals("float") || string.equals("com.eibus.util.FloatHolder")) {
            return "r4";
        }
        if (string.equals("java.lang.Boolean") || string.equals("boolean") || string.equals("com.eibus.util.BooleanHolder")) {
            return "boolean";
        }
        if (string.equals("java.math.BigDecimal")) {
            return "number";
        }
        if (string.equals("java.math.BigInteger")) {
            return "ui8";
        }
        if (string.equals("java.util.Date")) {
            return "dateTime";
        }
        if (string.equals("com.eibus.util.XMLNodeHolder") || string.equals("org.w3c.dom.Node")) {
            return "xml.node";
        }
        if (string.equals("com.eibus.util.ByteArrayHolder") || string.equals("[B")) {
            return "bin.base64";
        }
        if (string.equals("java.lang.Character") || string.equals("com.eibus.util.CharHolder")) {
            return "char";
        }
        if (string.equals("void")) {
            return "";
        }
        return null;
    }

    private static String getScopeFromJavaClass(Class clazz) {
        String string = clazz.getName();
        String string2 = "In";
        if (string.startsWith("com.eibus.util.") && string.endsWith("Holder")) {
            string2 = "InOut";
        }
        return string2;
    }

    private static String GiveXMLDataType(String string) {
        int n = string.indexOf("<");
        int n2 = string.indexOf(">");
        if (n > 0 && n2 > 0) {
            return string.substring(n + 1, n2);
        }
        return "";
    }

    private static String GiveJavaDataType(String string) {
        int n = string.indexOf("<");
        if (n > 0) {
            if (ClassInfoImpl.isComplex(string)) {
                return string.substring(15, n);
            }
            return string.substring(0, n);
        }
        return "";
    }

    private static boolean isComplex(String string) {
        return string.indexOf("BusinessObject") > 0;
    }

    private static void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        Object e2 = vector.elementAt(n2);
        vector.indexOf(e2, n2);
        vector.setElementAt(e2, n);
        vector.setElementAt(e, n2);
    }

    public static void quicksort(Vector vector, int n, int n2) {
        if (n >= n2) {
            return;
        }
        ClassInfoImpl.swap(vector, n, (n + n2) / 2);
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            String string;
            String string2 = (String)vector.elementAt(n4);
            if (string2.compareTo(string = (String)vector.elementAt(n)) <= 0) {
                ClassInfoImpl.swap(vector, ++n3, n4);
            }
            ++n4;
        }
        ClassInfoImpl.swap(vector, n, n3);
        ClassInfoImpl.quicksort(vector, n, n3 - 1);
        ClassInfoImpl.quicksort(vector, n3 + 1, n2);
    }

    public static void quicksortVector(Vector vector) {
        ClassInfoImpl.quicksort(vector, 0, vector.size() - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

