/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.java.james;

import com.baan.b3.boi1.BusinessObject;
import com.baan.b3.dom.Element;
import com.baan.b3.server.IParameter;
import com.baan.b3.server.IServerApplicationCallBack;
import com.baan.b3.server.ServerException;
import com.baan.b3.server.ServerRuntimeImpl;
import com.baan.b3impl.boi1.IBusinessElementAdapter;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.bdf.BusinessObjectRegistration;
import com.eibus.co.BusinessElement;
import com.eibus.java.james.DCDType;
import com.eibus.java.james.ElementObject;
import com.eibus.java.james.JamesDialog;
import com.eibus.java.james.registerSC;
import com.eibus.services.licensing.LicenseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JamesServerImpl
extends ServerRuntimeImpl {
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.java.james", "JamesServerImpl");
    private static final String COPYRIGHT = "Copyright (c) 2001-2004 SSA Global Technologies, Inc.";
    private static JamesDialog m_dialog = null;
    private registerSC m_ServerClasses = null;
    private DCDType map = null;

    JamesServerImpl(IServerApplicationCallBack iServerApplicationCallBack, JamesDialog jamesDialog, registerSC registerSC2) throws LicenseException {
        super(iServerApplicationCallBack, 7062, "Connector for Java", false);
        m_dialog = jamesDialog;
        this.m_ServerClasses = registerSC2;
        this.map = new DCDType();
    }

    public String dispatch(String string, String string2, IParameter[] iParameterArray, IParameter iParameter) throws ServerException {
        if (m_dialog != null) {
            m_dialog.dispatchstart();
        }
        try {
            Object object;
            Class[] classArray = null;
            Object[] objectArray = null;
            classArray = new Class[iParameterArray.length];
            objectArray = new Object[iParameterArray.length];
            this.setParameterTypes(iParameterArray, classArray);
            this.setParameterValues(iParameterArray, classArray, objectArray);
            Object object2 = null;
            try {
                object2 = this.invoke(string, string2, classArray, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                String string3 = invocationTargetException.getTargetException().toString();
                this.errorMessage(string3);
                return string3;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                String string4 = noSuchMethodException.toString();
                this.errorMessage(string4);
                return string4;
            }
            int n = 0;
            while (n < iParameterArray.length) {
                object = iParameterArray[n];
                if (object.getScope() != 1) {
                    ElementObject.Object2Parameter(objectArray[n], iParameterArray[n]);
                }
                ++n;
            }
            if (object2 != null) {
                if (iParameter == null) {
                    object = "Void function returned a value";
                    this.errorMessage((String)object);
                    throw new ServerException((String)object);
                }
                ElementObject.Object2Parameter(object2, iParameter);
            }
        }
        catch (Exception exception) {
            String string5 = exception.toString();
            this.errorMessage(string5);
            throw new ServerException(string5);
        }
        if (m_dialog != null) {
            m_dialog.SetStats(true);
            m_dialog.dispatchstop();
        }
        return null;
    }

    private void setParameterTypes(IParameter[] iParameterArray, Class[] classArray) throws Exception {
        int n = 0;
        while (n < iParameterArray.length) {
            Object object;
            IParameter iParameter = iParameterArray[n];
            int n2 = iParameter.getType();
            classArray[n] = null;
            if (n2 == 0) {
                object = iParameter.getValueElement();
                String string = object.getTagName();
                classArray[n] = BusinessObjectRegistration.getRegisteredClass(string);
            }
            if (classArray[n] == null) {
                if (iParameter.getScope() == 1) {
                    classArray[n] = this.map.InputClass(n2);
                } else if (iParameter.getScope() == 2 || iParameter.getScope() == 3) {
                    classArray[n] = this.map.OutputClass(n2);
                } else {
                    object = new Exception("Unknown scope attribute '" + iParameter.getScope() + "'");
                    s_logger.errorException((Throwable)object);
                    throw object;
                }
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setParameterValues(IParameter[] iParameterArray, Class[] classArray, Object[] objectArray) throws Exception {
        int n = 0;
        while (n < iParameterArray.length) {
            Object object;
            IParameter iParameter = iParameterArray[n];
            Element element = iParameter.getValueElement();
            int n2 = iParameter.getType();
            int n3 = iParameter.getScope();
            objectArray[n] = null;
            if (n2 == 0) {
                if (element instanceof IBusinessElementAdapter) {
                    object = (IBusinessElementAdapter)((Object)element);
                    BusinessObject businessObject = object.getBusinessObject();
                    objectArray[n] = businessObject;
                } else {
                    if (!(element instanceof BusinessElement)) {
                        object = new Exception("Internal error: illegal object type " + element.getClass().toString());
                        s_logger.errorException((Throwable)object);
                        throw object;
                    }
                    objectArray[n] = element;
                }
            } else {
                object = "";
                if (iParameter.getScope() != 2) {
                    object = iParameter.getValueString();
                }
                objectArray[n] = ElementObject.ValueObject(classArray[n], (String)object);
            }
            ++n;
        }
    }

    private Object invoke(String string, String string2, Class[] classArray, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, Exception {
        Object object;
        Class<?> clazz;
        Object object2 = null;
        String string3 = string;
        try {
            clazz = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            object = this.m_ServerClasses.getServerClass(string3);
            if (object == null) {
                ClassNotFoundException classNotFoundException2 = new ClassNotFoundException("The class '" + string3 + "' can not be found.");
                s_logger.errorException(classNotFoundException2);
                throw classNotFoundException2;
            }
            string3 = object;
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException3) {
                ClassNotFoundException classNotFoundException4 = new ClassNotFoundException("The class '" + string3 + "' can not be found.");
                s_logger.errorException(classNotFoundException4);
                throw classNotFoundException4;
            }
        }
        try {
            Method method = clazz.getMethod(string2, classArray);
            object2 = method.invoke(null, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            object = new NoSuchMethodException("Function not found: " + this.signature(string3, string2, classArray));
            s_logger.errorException((Throwable)object);
            throw object;
        }
        s_logger.message(this.signature(string3, string2, classArray));
        return object2;
    }

    private synchronized void errorMessage(String string) {
        s_logger.message("JAMES ERROR: " + string);
        if (m_dialog != null) {
            m_dialog.SetStats(false);
            m_dialog.dispatchstop();
        }
    }

    private String signature(String string, String string2, Class[] classArray) {
        String string3 = string + "." + string2 + "(";
        int n = classArray != null ? classArray.length : 0;
        int n2 = 0;
        while (n2 < n) {
            string3 = string3 + (n2 != 0 ? ", " : "");
            String string4 = classArray[n2].toString();
            int n3 = string4.indexOf("class ");
            if (n3 != -1 && (string4 = string4.substring(6)).equals("[B")) {
                string4 = "byte[]";
            }
            string3 = string3 + string4;
            ++n2;
        }
        return string3 + ")";
    }
}

