/*
 * Decompiled with CFR 0.152.
 */
package com.eibus.java.james;

import com.baan.b3.server.IServerApplicationCallBack;
import com.baan.b3.server.ServerActivationCallBack;
import com.baan.b3impl.about.AdapterComponentInfo;
import com.baan.owimpl.fw.log.ILogger;
import com.baan.owimpl.fw.log.LoggerFactory;
import com.eibus.java.james.JamesServerImpl;
import com.eibus.java.james.registerBO;
import com.eibus.java.james.registerSC;
import com.eibus.services.activation.IActivationCallBack;

public class James
implements IServerApplicationCallBack {
    private static final int S_INITIAL = 0;
    private static final int S_STARTED = 1;
    private static final int S_STOPPED = 2;
    private int m_state = 0;
    private JamesServerImpl m_server = null;
    private int m_connectionId = -1;
    private registerBO m_businessObjectRegister = new registerBO();
    private String m_serverComponentName = null;
    private ServerActivationCallBack m_activationCallBack = null;
    private static boolean m_EnableDeactivation = false;
    private static final ILogger s_logger = LoggerFactory.createLogger("com.eibus.java.james", "James");
    static /* synthetic */ Class class$com$eibus$java$james$James;

    public static String startBackend(String string) throws Exception {
        s_logger.message("JAMES: Strating James with programatic Activation");
        ServerActivationCallBack serverActivationCallBack = ServerActivationCallBack.getActivationCallBackPROG();
        try {
            new James(string, serverActivationCallBack);
            IActivationCallBack iActivationCallBack = (IActivationCallBack)((Object)serverActivationCallBack);
            return iActivationCallBack.getBackendReference();
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = string + " '" + stringArray[n] + "'";
            ++n;
        }
        s_logger.flowMessage("James arguments[" + stringArray.length + "]:" + string);
        System.out.println("James - Server for Java");
        System.out.println(new AdapterComponentInfo().getCopyrightMessage());
        System.out.println();
        if (stringArray.length == 1) {
            try {
                m_EnableDeactivation = true;
                new James(stringArray[0]);
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
                s_logger.errorException(exception);
            }
        } else if (stringArray.length == 3) {
            String string2 = null;
            String string3 = null;
            if (stringArray[0].charAt(0) == '-') {
                string2 = stringArray[1];
                string3 = stringArray[2];
            } else if (stringArray[1].charAt(0) == '-') {
                string2 = stringArray[2];
                string3 = stringArray[0];
            } else {
                James.displayUsage(1);
            }
            try {
                s_logger.message("JAMES: Strating James with Activation, using ASM Portno: '" + string2 + "'");
                ServerActivationCallBack serverActivationCallBack = ServerActivationCallBack.getActivationCallBackASM();
                serverActivationCallBack.setASMPortNr(Integer.parseInt(string2));
                new James(string3, serverActivationCallBack);
            }
            catch (Exception exception) {
                s_logger.errorException(exception);
                System.err.println("Exception: " + exception);
                LoggerFactory.exit(1);
            }
        } else {
            James.displayUsage(1);
        }
    }

    private static void displayUsage(int n) {
        System.out.println("Usage: java " + (class$com$eibus$java$james$James == null ? (class$com$eibus$java$james$James = James.class$("com.eibus.java.james.James")) : class$com$eibus$java$james$James).getName() + " <bus-component name> [-asmp <asm port number>]");
        System.out.println();
        System.out.println("Example: java " + (class$com$eibus$java$james$James == null ? (class$com$eibus$java$james$James = James.class$("com.eibus.java.james.James")) : class$com$eibus$java$james$James).getName() + " javaserver -asmp 7000 ");
        System.out.println();
        LoggerFactory.exit(n);
    }

    public James(String string) throws Exception {
        this(string, null);
    }

    public James(String string, boolean bl) throws Exception {
        this(string, null, bl);
    }

    public James(String string, ServerActivationCallBack serverActivationCallBack) throws Exception {
        this(string, serverActivationCallBack, true);
        if (serverActivationCallBack == null) {
            while (Thread.activeCount() > 1) {
                Thread.sleep(100000L);
            }
            this.stop();
        }
    }

    public James(String string, ServerActivationCallBack serverActivationCallBack, boolean bl) throws Exception {
        this.m_serverComponentName = string;
        this.m_activationCallBack = serverActivationCallBack;
        registerSC registerSC2 = new registerSC();
        registerSC2.readConfigFile();
        this.m_server = new JamesServerImpl(this, null, registerSC2);
        if (m_EnableDeactivation) {
            this.m_server.enableDeactivation();
        }
        this.m_businessObjectRegister.register(this.m_server);
        if (bl) {
            this.start();
        }
    }

    public void output(String string) {
        System.out.println(string);
    }

    public void error(String string) {
        System.out.println(string);
    }

    public synchronized void start() throws Exception {
        if (this.m_state != 0) {
            throw new Exception("Illegal attempt to start James object for a second time.");
        }
        if (this.m_activationCallBack == null) {
            this.m_connectionId = this.m_server.startComponent(this.m_serverComponentName);
            if (this.m_connectionId == -1) {
                s_logger.errorMessage("JAMES FATAL ERROR: Can not start bus component '" + this.m_serverComponentName + "'");
                throw new Exception("Can not start bus component '" + this.m_serverComponentName + "' by James");
            }
        } else {
            this.m_connectionId = this.m_server.startActivationComponent(this.m_serverComponentName, this.m_activationCallBack);
            if (this.m_connectionId == -1) {
                s_logger.errorMessage("JAMES FATAL ERROR: Can not start bus component '" + this.m_serverComponentName + " with Activation(" + this.m_activationCallBack.getActivationType() + ")");
                Exception exception = new Exception("Can not start bus component '" + this.m_serverComponentName + "' by James with Activation(" + this.m_activationCallBack.getActivationType() + ")");
                s_logger.errorException(exception);
                throw exception;
            }
        }
        this.m_state = 1;
    }

    public synchronized void stop() {
        switch (this.m_state) {
            case 0: {
                this.m_server.stopServerRuntime();
                this.m_state = 2;
                break;
            }
            case 1: {
                this.m_server.stopComponent(this.m_connectionId);
                this.m_server.stopServerRuntime();
                this.m_state = 2;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown James.m_state (" + this.m_state + ')');
            }
        }
    }

    public synchronized void finishInBackground() {
        switch (this.m_state) {
            case 0: {
                this.m_server.stopServerRuntime();
                this.m_state = 2;
                break;
            }
            case 1: {
                this.m_server.finishComponentInBackground(this.m_connectionId);
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        James.this.m_server.waitForFinish(James.this.m_connectionId, 0L);
                        James.this.m_server.stopServerRuntime();
                        James james = James.this;
                        synchronized (james) {
                            James.this.m_state = 2;
                        }
                    }
                };
                thread.start();
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown James.m_state (" + this.m_state + ')');
            }
        }
    }

    public void waitForFinish() {
        this.m_server.waitForFinish(this.m_connectionId, 0L);
    }

    public synchronized boolean isStopped() {
        return this.m_state == 2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        LoggerFactory.setApplicationName(LoggerFactory.APP_JAVA_SERVER);
    }
}

